/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandlerUtils;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.savelocation.DefaultSaveLocationManager;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;

public class DownloadManagerDefaultPaths
extends DownloadManagerMoveHandlerUtils {
    public static final DefaultSaveLocationManager DEFAULT_HANDLER;
    private static final MovementInformation COMPLETION_DETAILS;
    private static final MovementInformation REMOVAL_DETAILS;
    private static final MovementInformation[] UPDATE_FOR_MOVE_DETAILS;
    private static final TargetSpecification[] DEFAULT_DIRS;
    private static final String SUBDIR_PARAM = "File.move.subdir_is_default";

    static {
        MovementInformation mi_1;
        DEFAULT_HANDLER = new DefaultSaveLocationManager(){

            @Override
            public SaveLocationChange onInitialization(Download d, boolean for_move, boolean on_event) {
                if (on_event) {
                    return null;
                }
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                return DownloadManagerDefaultPaths.determinePaths(dm, UPDATE_FOR_MOVE_DETAILS[1], for_move, false);
            }

            @Override
            public SaveLocationChange onCompletion(Download d, boolean for_move, boolean on_event) {
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                MovementInformation mi = DownloadManagerDefaultPaths.getTagMovementInformation(dm, COMPLETION_DETAILS);
                return DownloadManagerDefaultPaths.determinePaths(dm, mi, for_move, false);
            }

            @Override
            public SaveLocationChange testOnCompletion(Download d, boolean for_move, boolean on_event) {
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                MovementInformation mi = DownloadManagerDefaultPaths.getTagMovementInformation(dm, COMPLETION_DETAILS);
                return DownloadManagerDefaultPaths.determinePaths(dm, mi, for_move, true);
            }

            @Override
            public SaveLocationChange onRemoval(Download d, boolean for_move, boolean on_event) {
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                return DownloadManagerDefaultPaths.determinePaths(dm, REMOVAL_DETAILS, for_move, false);
            }

            @Override
            public boolean isInDefaultSaveDir(Download d) {
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                return DownloadManagerDefaultPaths.isInDefaultDownloadDir(dm);
            }
        };
        DEFAULT_DIRS = new TargetSpecification[3];
        TargetSpecification dest = new TargetSpecification();
        dest.setBoolean("enabled", true);
        dest.setString("target", "Default save path");
        dest.setContext("default save dir");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[0] = dest;
        SourceSpecification source = new SourceSpecification();
        source.setBoolean("default dir", "Move Only When In Default Save Dir");
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("incomplete dl", false);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", "Move Completed When Done");
        dest.setString("target", "Completed Files Directory");
        dest.setContext("completed files dir");
        TransferSpecification trans = new TransferSpecification();
        trans.setBoolean("torrent", "Move Torrent When Done");
        trans.setString("torrent_path", "Move Torrent When Done Directory");
        COMPLETION_DETAILS = mi_1 = new MovementInformation(source, dest, trans, "Move on completion");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[1] = dest;
        source = new SourceSpecification();
        source.setBoolean("default dir", "File.move.download.removed.only_in_default");
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("incomplete dl", false);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", "File.move.download.removed.enabled");
        dest.setString("target", "File.move.download.removed.path");
        dest.setContext("removed files dir");
        trans = new TransferSpecification();
        trans.setBoolean("torrent", "File.move.download.removed.move_torrent");
        trans.setString("torrent_path", "File.move.download.removed.move_torrent_path");
        REMOVAL_DETAILS = mi_1 = new MovementInformation(source, dest, trans, "Move on removal");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[2] = dest;
        source = new SourceSpecification();
        source.updateSettings(DownloadManagerDefaultPaths.COMPLETION_DETAILS.source.getSettings());
        source.setBoolean("default dir", true);
        mi_1 = new MovementInformation(source, DownloadManagerDefaultPaths.COMPLETION_DETAILS.target, DownloadManagerDefaultPaths.COMPLETION_DETAILS.transfer, "Update completed download");
        source = new SourceSpecification();
        source.setBoolean("default dir", true);
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("incomplete dl", true);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", true);
        dest.setString("target", "Default save path");
        trans = new TransferSpecification();
        trans.setBoolean("torrent", false);
        MovementInformation mi_2 = new MovementInformation(source, dest, trans, "Update incomplete download");
        UPDATE_FOR_MOVE_DETAILS = new MovementInformation[]{mi_1, mi_2};
    }

    private static MovementInformation getTagMovementInformation(DownloadManager dm, MovementInformation def_mi) {
        Tag tag_target;
        TagFeatureFileLocation fl;
        File move_to;
        List<Tag> dm_tags = TagManagerFactory.getTagManager().getTagsForTaggable(dm);
        if (dm_tags == null || dm_tags.size() == 0) {
            return def_mi;
        }
        ArrayList<Tag> applicable_tags = new ArrayList<Tag>();
        for (Tag tag : dm_tags) {
            File move_to2;
            Object fl2;
            if (!tag.getTagType().hasTagTypeFeature(16L) || !(fl2 = (TagFeatureFileLocation)((Object)tag)).supportsTagMoveOnComplete() || (move_to2 = fl2.getTagMoveOnCompleteFolder()) == null) continue;
            if (!move_to2.exists()) {
                move_to2.mkdirs();
            }
            if (move_to2.isDirectory() && move_to2.canWrite()) {
                applicable_tags.add(tag);
                continue;
            }
            DownloadManagerDefaultPaths.logInfo("Ignoring invalid tag move-to location: " + move_to2, dm);
        }
        if (applicable_tags.size() == 0) {
            return def_mi;
        }
        if (applicable_tags.size() > 1) {
            Collections.sort(applicable_tags, new Comparator<Tag>(){

                @Override
                public int compare(Tag o1, Tag o2) {
                    return o1.getTagID() - o2.getTagID();
                }
            });
            String str = "";
            for (Tag tag : applicable_tags) {
                str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + tag.getTagName(true);
            }
            DownloadManagerDefaultPaths.logInfo("Multiple applicable tags found: " + str + " - selecting first", dm);
        }
        if ((move_to = (fl = (TagFeatureFileLocation)((Object)(tag_target = (Tag)applicable_tags.get(0)))).getTagMoveOnCompleteFolder()) != null) {
            SourceSpecification source = new SourceSpecification();
            source.setBoolean("default dir", "Move Only When In Default Save Dir");
            source.setBoolean("default subdir", SUBDIR_PARAM);
            source.setBoolean("incomplete dl", false);
            TargetSpecification dest = new TargetSpecification();
            dest.setBoolean("enabled", true);
            dest.setString("target_raw", move_to.getAbsolutePath());
            dest.setContext("Tag '" + tag_target.getTagName(true) + "' move-on-complete directory");
            TransferSpecification trans = new TransferSpecification();
            trans.setBoolean("torrent", "Move Torrent When Done");
            trans.setString("torrent_path", "Move Torrent When Done Directory");
            MovementInformation tag_mi = new MovementInformation(source, dest, trans, "Tag Move on Completion");
            return tag_mi;
        }
        return def_mi;
    }

    private static String normaliseRelativePathPart(String name) {
        if ((name = name.trim()).length() == 0) {
            return "";
        }
        if (name.equals(".") || name.equals("..")) {
            return null;
        }
        return FileUtil.convertOSSpecificChars(name, false).trim();
    }

    public static File normaliseRelativePath(File path) {
        if (path.isAbsolute()) {
            return null;
        }
        File parent = path.getParentFile();
        String child_name = DownloadManagerDefaultPaths.normaliseRelativePathPart(path.getName());
        if (child_name == null) {
            return null;
        }
        if (parent == null) {
            return new File(child_name);
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(child_name);
        String filepart = null;
        while (parent != null) {
            filepart = DownloadManagerDefaultPaths.normaliseRelativePathPart(parent.getName());
            if (filepart == null) {
                return null;
            }
            if (filepart.length() != 0) {
                parts.add(0, filepart);
            }
            parent = parent.getParentFile();
        }
        StringBuffer sb = new StringBuffer((String)parts.get(0));
        int i = 1;
        while (i < parts.size()) {
            sb.append(File.separatorChar);
            sb.append(parts.get(i));
            ++i;
        }
        return new File(sb.toString());
    }

    private static File[] getDefaultDirs() {
        ArrayList<File> results = new ArrayList<File>();
        File location = null;
        TargetSpecification ts = null;
        int i = 0;
        while (i < DEFAULT_DIRS.length) {
            ts = DEFAULT_DIRS[i];
            location = ts.getTarget(null, ts);
            if (location != null) {
                results.add(location);
            }
            ++i;
        }
        return results.toArray(new File[results.size()]);
    }

    private static SaveLocationChange determinePaths(DownloadManager dm, MovementInformation mi, boolean check_source, boolean is_test) {
        boolean proceed;
        boolean bl = proceed = !check_source || mi.source.matchesDownload(dm, mi, is_test);
        if (!proceed) {
            DownloadManagerDefaultPaths.logInfo("Cannot consider " + DownloadManagerDefaultPaths.describe(dm, mi) + " - does not match source criteria.", dm);
            return null;
        }
        File target_path = mi.target.getTarget(dm, mi);
        if (target_path == null) {
            DownloadManagerDefaultPaths.logInfo("Unable to determine an appropriate target for " + DownloadManagerDefaultPaths.describe(dm, mi) + ".", dm);
            return null;
        }
        DownloadManagerDefaultPaths.logInfo("Determined path for " + DownloadManagerDefaultPaths.describe(dm, mi) + ".", dm);
        return mi.transfer.getTransferDetails(dm, mi, target_path);
    }

    static boolean isInDefaultDownloadDir(DownloadManager dm) {
        SourceSpecification source = new SourceSpecification();
        source.setBoolean("default subdir", SUBDIR_PARAM);
        return source.checkDefaultDir(dm.getSaveLocation().getParentFile(), DownloadManagerDefaultPaths.getDefaultDirs());
    }

    public static File getCompletionDirectory(DownloadManager dm) {
        return DownloadManagerDefaultPaths.COMPLETION_DETAILS.target.getTarget(dm, null);
    }

    static String describe(DownloadManager dm, ContextDescriptor cs) {
        if (cs == null) {
            return DownloadManagerDefaultPaths.describe(dm);
        }
        if (dm == null) {
            return "\"" + cs.getContext() + "\"";
        }
        return "\"" + dm.getDisplayName() + "\" with regard to \"" + cs.getContext() + "\"";
    }

    private static interface ContextDescriptor {
        public String getContext();
    }

    private static class MovementInformation
    implements ContextDescriptor {
        final SourceSpecification source;
        final TargetSpecification target;
        final TransferSpecification transfer;
        final String title;

        MovementInformation(SourceSpecification source, TargetSpecification target, TransferSpecification transfer, String title) {
            this.source = source;
            this.target = target;
            this.transfer = transfer;
            this.title = title;
        }

        @Override
        public String getContext() {
            return this.title;
        }
    }

    private static abstract class ParameterHelper
    implements ContextDescriptor {
        private Map settings = new HashMap();
        private String context = null;

        private ParameterHelper() {
        }

        protected boolean getBoolean(String key) {
            Object result = this.settings.get(key);
            if (result == null) {
                throw new RuntimeException("bad key: " + key);
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return COConfigurationManager.getBooleanParameter((String)result);
        }

        protected void setBoolean(String key, boolean value) {
            this.settings.put(key, value);
        }

        protected void setBoolean(String key, String param) {
            this.settings.put(key, param);
        }

        protected void setString(String key, String param) {
            this.settings.put(key, param);
        }

        protected String getStringRaw(String key) {
            return (String)this.settings.get(key);
        }

        protected String getString(String key) {
            String result = (String)this.settings.get(key);
            if (result == null) {
                throw new RuntimeException("bad key: " + key);
            }
            return COConfigurationManager.getStringParameter(result);
        }

        public Map getSettings() {
            return this.settings;
        }

        public void updateSettings(Map settings) {
            this.settings.putAll(settings);
        }

        @Override
        public String getContext() {
            return this.context;
        }

        public void setContext(String context2) {
            this.context = context2;
        }
    }

    private static class SourceSpecification
    extends ParameterHelper {
        private SourceSpecification() {
        }

        public boolean matchesDownload(DownloadManager dm, ContextDescriptor context2, boolean ignore_completeness) {
            if (this.getBoolean("default dir")) {
                DownloadManagerDefaultPaths.logInfo("Checking if " + DownloadManagerDefaultPaths.describe(dm, context2) + " is inside default dirs.", dm);
                File[] default_dirs = DownloadManagerDefaultPaths.getDefaultDirs();
                File current_location = dm.getSaveLocation().getParentFile();
                if (current_location == null) {
                    DownloadManagerDefaultPaths.logWarn(String.valueOf(DownloadManagerDefaultPaths.describe(dm, context2)) + " appears to have a malformed save directory, skipping.", dm);
                    return false;
                }
                if (!this.checkDefaultDir(current_location, default_dirs)) {
                    DownloadManagerDefaultPaths.logWarn(String.valueOf(DownloadManagerDefaultPaths.describe(dm, context2)) + " doesn't exist in any of the following default directories" + " (current dir: " + current_location + ", subdirectories checked: " + this.getBoolean("default subdir") + ") - " + Arrays.asList(default_dirs), dm);
                    return false;
                }
                DownloadManagerDefaultPaths.logInfo(String.valueOf(DownloadManagerDefaultPaths.describe(dm, context2)) + " does exist inside default dirs.", dm);
            }
            if (!dm.isDownloadComplete(false)) {
                boolean can_move = ignore_completeness || this.getBoolean("incomplete dl");
                String log_message = String.valueOf(DownloadManagerDefaultPaths.describe(dm, context2)) + " is incomplete which is " + (can_move ? "" : "not ") + "an appropriate state.";
                if (!can_move) {
                    DownloadManagerDefaultPaths.logInfo(log_message, dm);
                    return false;
                }
            }
            return true;
        }

        public boolean checkDefaultDir(File location, File[] default_dirs) {
            location = FileUtil.canonise(location);
            boolean subdir = this.getBoolean("default subdir");
            int i = 0;
            while (i < default_dirs.length) {
                if (subdir ? FileUtil.isAncestorOf(default_dirs[i], location) : default_dirs[i].equals(location)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class TargetSpecification
    extends ParameterHelper {
        private TargetSpecification() {
        }

        public File getTarget(DownloadManager dm, ContextDescriptor cd) {
            if (!this.getBoolean("enabled")) {
                DownloadManagerDefaultPaths.logInfo("Target for " + DownloadManagerDefaultPaths.describe(dm, cd) + " is not enabled.", dm);
                return null;
            }
            String location = this.getStringRaw("target_raw");
            if (location == null) {
                location = this.getString("target").trim();
            }
            if (location.length() == 0) {
                DownloadManagerDefaultPaths.logInfo("No explicit target for " + DownloadManagerDefaultPaths.describe(dm, cd) + ".", dm);
                return null;
            }
            File target = new File(FileUtil.getCanonicalFileName(location));
            String relative_path = null;
            if (dm != null && dm.getDownloadState() != null) {
                relative_path = dm.getDownloadState().getRelativeSavePath();
            }
            if (relative_path != null && relative_path.length() > 0) {
                DownloadManagerDefaultPaths.logInfo("Consider relative save path: " + relative_path, dm);
                target = new File(String.valueOf(target.getPath()) + File.separator + relative_path);
            }
            return target;
        }
    }

    private static class TransferSpecification
    extends ParameterHelper {
        private TransferSpecification() {
        }

        public SaveLocationChange getTransferDetails(DownloadManager dm, ContextDescriptor cd, File target_path) {
            if (target_path == null) {
                throw new NullPointerException();
            }
            SaveLocationChange result = new SaveLocationChange();
            result.download_location = target_path;
            if (this.getBoolean("torrent")) {
                result.torrent_location = target_path;
                String torrent_path = this.getString("torrent_path");
                if (torrent_path != null && torrent_path.trim().length() > 0) {
                    File temp = new File(torrent_path);
                    if (temp.isDirectory()) {
                        result.torrent_location = temp;
                    } else if (!temp.exists() && temp.mkdirs()) {
                        result.torrent_location = temp;
                    }
                }
            }
            return result;
        }
    }
}

