/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.resume;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class RDResumeHandler {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final boolean TEST_RECHECK_FAILURE_HANDLING = false;
    private static final byte PIECE_NOT_DONE = 0;
    private static final byte PIECE_DONE = 1;
    private static final byte PIECE_RECHECK_REQUIRED = 2;
    private static final byte PIECE_STARTED = 3;
    private static boolean use_fast_resume;
    private static boolean use_fast_resume_recheck_all;
    private DiskManagerImpl disk_manager;
    private DMChecker checker;
    private volatile boolean started;
    private volatile boolean stopped;
    private volatile boolean stopped_for_close;
    private volatile boolean check_in_progress;
    private volatile boolean check_resume_was_valid;
    private volatile boolean check_is_full_check;
    private volatile boolean check_interrupted;
    private volatile int check_position;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Use Resume", "On Resume Recheck All"}, new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                use_fast_resume = COConfigurationManager.getBooleanParameter("Use Resume");
                use_fast_resume_recheck_all = COConfigurationManager.getBooleanParameter("On Resume Recheck All");
            }
        });
    }

    public RDResumeHandler(DiskManagerImpl _disk_manager, DMChecker _writer_and_checker) {
        this.disk_manager = _disk_manager;
        this.checker = _writer_and_checker;
    }

    public void start() {
        if (this.started) {
            Debug.out("RDResumeHandler: reuse not supported");
        }
        this.started = true;
    }

    public void stop(boolean closing) {
        this.stopped_for_close |= closing;
        if (this.check_in_progress) {
            this.check_interrupted = true;
        }
        this.stopped = true;
    }

    public void checkAllPieces(boolean newfiles) {
        block68: {
            DiskManagerRecheckInstance recheck_inst = this.disk_manager.getRecheckScheduler().register(this.disk_manager, false);
            final AESemaphore run_sem = new AESemaphore("RDResumeHandler::checkAllPieces:runsem", 2);
            final ArrayList failed_pieces = new ArrayList();
            try {
                try {
                    boolean resume_data_complete;
                    block67: {
                        resume_data_complete = false;
                        try {
                            int piece_size;
                            this.check_in_progress = true;
                            boolean resumeEnabled = use_fast_resume;
                            if (newfiles) {
                                resumeEnabled = false;
                            }
                            final AESemaphore pending_checks_sem = new AESemaphore("RD:PendingChecks");
                            int pending_check_num = 0;
                            DiskManagerPiece[] pieces = this.disk_manager.getPieces();
                            DiskManagerFileInfo[] files = this.disk_manager.getFiles();
                            HashMap<DiskManagerFileInfo, Long> file_sizes = new HashMap<DiskManagerFileInfo, Long>();
                            int i = 0;
                            while (i < files.length) {
                                try {
                                    Long len = new Long(((DiskManagerFileInfoImpl)files[i]).getCacheFile().getLength());
                                    file_sizes.put(files[i], len);
                                }
                                catch (CacheFileManagerException e) {
                                    Debug.printStackTrace(e);
                                }
                                ++i;
                            }
                            if (resumeEnabled) {
                                boolean resumeValid = false;
                                byte[] resume_pieces = null;
                                Map partialPieces = null;
                                Map resume_data = this.getResumeData();
                                if (resume_data != null) {
                                    try {
                                        resume_pieces = (byte[])resume_data.get("resume data");
                                        if (resume_pieces != null && resume_pieces.length != pieces.length) {
                                            Debug.out("Resume data array length mismatch: " + resume_pieces.length + "/" + pieces.length);
                                            resume_pieces = null;
                                        }
                                        partialPieces = (Map)resume_data.get("blocks");
                                        boolean bl = resumeValid = ((Long)resume_data.get("valid")).intValue() == 1;
                                        if (RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState(), resume_data)) {
                                            resume_data_complete = true;
                                        } else {
                                            resume_data.put("valid", new Long(0L));
                                            this.saveResumeData(resume_data);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (resume_pieces == null) {
                                    this.check_is_full_check = true;
                                    resumeValid = false;
                                    resume_pieces = new byte[pieces.length];
                                    Arrays.fill(resume_pieces, (byte)2);
                                }
                                this.check_resume_was_valid = resumeValid;
                                boolean recheck_all = use_fast_resume_recheck_all;
                                if (!recheck_all) {
                                    long total_not_done = 0L;
                                    piece_size = this.disk_manager.getPieceLength();
                                    int i2 = 0;
                                    while (i2 < pieces.length) {
                                        if (resume_pieces[i2] != 1) {
                                            total_not_done += (long)piece_size;
                                        }
                                        ++i2;
                                    }
                                    if (total_not_done < 0x4000000L) {
                                        recheck_all = true;
                                    }
                                }
                                if (Logger.isEnabled()) {
                                    int total_not_done = 0;
                                    int total_done = 0;
                                    int total_started = 0;
                                    int total_recheck = 0;
                                    int i3 = 0;
                                    while (i3 < pieces.length) {
                                        byte piece_state = resume_pieces[i3];
                                        if (piece_state == 0) {
                                            ++total_not_done;
                                        } else if (piece_state == 1) {
                                            ++total_done;
                                        } else if (piece_state == 3) {
                                            ++total_started;
                                        } else {
                                            ++total_recheck;
                                        }
                                        ++i3;
                                    }
                                    String str = "valid=" + resumeValid + ",not done=" + total_not_done + ",done=" + total_done + ",started=" + total_started + ",recheck=" + total_recheck + ",rc all=" + recheck_all + ",full=" + this.check_is_full_check;
                                    Logger.log(new LogEvent(this.disk_manager, LOGID, str));
                                }
                                int i4 = 0;
                                while (i4 < pieces.length) {
                                    this.check_position = i4;
                                    DiskManagerPiece dm_piece = pieces[i4];
                                    this.disk_manager.setPercentDone((i4 + 1) * 1000 / this.disk_manager.getNbPieces());
                                    boolean pieceCannotExist = false;
                                    byte piece_state = resume_pieces[i4];
                                    if (piece_state == 1 || !resumeValid || recheck_all) {
                                        DMPieceList list = this.disk_manager.getPieceList(i4);
                                        int j = 0;
                                        while (j < list.size()) {
                                            DMPieceMapEntry entry = list.get(j);
                                            Long file_size = (Long)file_sizes.get(entry.getFile());
                                            if (file_size == null) {
                                                piece_state = 0;
                                                pieceCannotExist = true;
                                                if (!Logger.isEnabled()) break;
                                                Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i4 + ": file is missing, " + "fails re-check."));
                                                break;
                                            }
                                            long expected_size = entry.getOffset() + (long)entry.getLength();
                                            if (file_size < expected_size) {
                                                piece_state = 0;
                                                pieceCannotExist = true;
                                                if (!Logger.isEnabled()) break;
                                                Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i4 + ": file is too small, fails re-check. File size = " + file_size + ", piece needs " + expected_size));
                                                break;
                                            }
                                            ++j;
                                        }
                                    }
                                    if (piece_state == 1) {
                                        dm_piece.setDone(true);
                                    } else if (piece_state != 0 || recheck_all) {
                                        if (pieceCannotExist) {
                                            dm_piece.setDone(false);
                                        } else if (piece_state == 2 || !resumeValid) {
                                            run_sem.reserve();
                                            while (!this.stopped) {
                                                if (recheck_inst.getPermission()) break;
                                            }
                                            if (this.stopped) break;
                                            try {
                                                DiskManagerCheckRequest request2 = this.disk_manager.createCheckRequest(i4, null);
                                                request2.setLowPriority(true);
                                                this.checker.enqueueCheckRequest(request2, new DiskManagerCheckRequestListener(){

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    @Override
                                                    public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                                        if (!passed) {
                                                            List list = failed_pieces;
                                                            synchronized (list) {
                                                                failed_pieces.add(request2);
                                                            }
                                                        }
                                                        this.complete();
                                                    }

                                                    @Override
                                                    public void checkCancelled(DiskManagerCheckRequest request2) {
                                                        this.complete();
                                                    }

                                                    @Override
                                                    public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                                        this.complete();
                                                    }

                                                    protected void complete() {
                                                        run_sem.release();
                                                        pending_checks_sem.release();
                                                    }
                                                });
                                                ++pending_check_num;
                                            }
                                            catch (Throwable e) {
                                                Debug.printStackTrace(e);
                                            }
                                        }
                                    }
                                    ++i4;
                                }
                                while (pending_check_num > 0) {
                                    pending_checks_sem.reserve();
                                    --pending_check_num;
                                }
                                if (partialPieces != null) {
                                    for (Map.Entry key : partialPieces.entrySet()) {
                                        int pieceNumber = Integer.parseInt((String)key.getKey());
                                        DiskManagerPiece dm_piece = pieces[pieceNumber];
                                        if (dm_piece.isDone()) continue;
                                        List blocks = (List)partialPieces.get(key.getKey());
                                        Iterator iterBlock = blocks.iterator();
                                        while (iterBlock.hasNext()) {
                                            dm_piece.setWritten(((Long)iterBlock.next()).intValue());
                                        }
                                    }
                                }
                            } else {
                                i = 0;
                                while (i < pieces.length) {
                                    this.check_position = i;
                                    this.disk_manager.setPercentDone((i + 1) * 1000 / this.disk_manager.getNbPieces());
                                    boolean pieceCannotExist = false;
                                    DMPieceList list = this.disk_manager.getPieceList(i);
                                    int j = 0;
                                    while (j < list.size()) {
                                        DMPieceMapEntry entry = list.get(j);
                                        Long file_size = (Long)file_sizes.get(entry.getFile());
                                        if (file_size == null) {
                                            pieceCannotExist = true;
                                            break;
                                        }
                                        long expected_size = entry.getOffset() + (long)entry.getLength();
                                        if (file_size < expected_size) {
                                            pieceCannotExist = true;
                                            break;
                                        }
                                        ++j;
                                    }
                                    if (pieceCannotExist) {
                                        this.disk_manager.getPiece(i).setDone(false);
                                    } else {
                                        run_sem.reserve();
                                        while (!this.stopped) {
                                            if (recheck_inst.getPermission()) break;
                                        }
                                        if (this.stopped) break;
                                        try {
                                            DiskManagerCheckRequest request3 = this.disk_manager.createCheckRequest(i, null);
                                            request3.setLowPriority(true);
                                            this.checker.enqueueCheckRequest(request3, new DiskManagerCheckRequestListener(){

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                                    if (!passed) {
                                                        List list = failed_pieces;
                                                        synchronized (list) {
                                                            failed_pieces.add(request2);
                                                        }
                                                    }
                                                    this.complete();
                                                }

                                                @Override
                                                public void checkCancelled(DiskManagerCheckRequest request2) {
                                                    this.complete();
                                                }

                                                @Override
                                                public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                                    this.complete();
                                                }

                                                protected void complete() {
                                                    run_sem.release();
                                                    pending_checks_sem.release();
                                                }
                                            });
                                            ++pending_check_num;
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                    ++i;
                                }
                                while (pending_check_num > 0) {
                                    pending_checks_sem.reserve();
                                    --pending_check_num;
                                }
                            }
                            if (failed_pieces.size() <= 0) break block67;
                            byte[][] piece_hashes = this.disk_manager.getTorrent().getPieces();
                            ByteArrayHashMap<Integer> hash_map = new ByteArrayHashMap<Integer>();
                            int i5 = 0;
                            while (i5 < piece_hashes.length) {
                                hash_map.put(piece_hashes[i5], i5);
                                ++i5;
                            }
                            for (DiskManagerCheckRequest request4 : failed_pieces) {
                                while (!this.stopped) {
                                    if (recheck_inst.getPermission()) break;
                                }
                                if (this.stopped) {
                                    break;
                                }
                                byte[] hash = request4.getHash();
                                if (hash == null) continue;
                                final Integer target_index = (Integer)hash_map.get(hash);
                                int current_index = request4.getPieceNumber();
                                piece_size = this.disk_manager.getPieceLength(current_index);
                                if (target_index == null || target_index == current_index || this.disk_manager.getPieceLength(target_index) != piece_size || this.disk_manager.isDone(target_index)) continue;
                                final AESemaphore sem = new AESemaphore("PieceReorder");
                                this.disk_manager.enqueueReadRequest(this.disk_manager.createReadRequest(current_index, 0, piece_size), new DiskManagerReadRequestListener(){

                                    @Override
                                    public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
                                        try {
                                            RDResumeHandler.this.disk_manager.enqueueWriteRequest(RDResumeHandler.this.disk_manager.createWriteRequest(target_index, 0, data, null), new DiskManagerWriteRequestListener(){

                                                @Override
                                                public void writeCompleted(DiskManagerWriteRequest request2) {
                                                    try {
                                                        DiskManagerCheckRequest check_request = RDResumeHandler.this.disk_manager.createCheckRequest(target_index, null);
                                                        check_request.setLowPriority(true);
                                                        RDResumeHandler.this.checker.enqueueCheckRequest(check_request, new DiskManagerCheckRequestListener(){

                                                            @Override
                                                            public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                                                sem.release();
                                                            }

                                                            @Override
                                                            public void checkCancelled(DiskManagerCheckRequest request2) {
                                                                sem.release();
                                                            }

                                                            @Override
                                                            public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                                                sem.release();
                                                            }
                                                        });
                                                    }
                                                    catch (Throwable e) {
                                                        sem.release();
                                                    }
                                                }

                                                @Override
                                                public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
                                                    sem.release();
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            sem.release();
                                        }
                                    }

                                    @Override
                                    public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
                                        sem.release();
                                    }

                                    @Override
                                    public int getPriority() {
                                        return -1;
                                    }

                                    @Override
                                    public void requestExecuted(long bytes) {
                                    }
                                });
                                sem.reserve();
                            }
                        }
                        finally {
                            this.check_in_progress = false;
                        }
                    }
                    if (this.stopped || resume_data_complete) break block68;
                    try {
                        this.saveResumeData(true);
                    }
                    catch (Exception e) {
                        Debug.out("Failed to dump initial resume data to disk");
                        Debug.printStackTrace(e);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    recheck_inst.unregister();
                }
            }
            finally {
                recheck_inst.unregister();
            }
        }
    }

    public void saveResumeData(boolean interim_save) throws Exception {
        if (this.check_in_progress && interim_save) {
            return;
        }
        DiskManagerFileInfo[] files = this.disk_manager.getFiles();
        if (!use_fast_resume) {
            int i = 0;
            while (i < files.length) {
                files[i].flushCache();
                ++i;
            }
            return;
        }
        boolean was_complete = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState());
        DiskManagerPiece[] pieces = this.disk_manager.getPieces();
        byte[] resume_pieces = new byte[pieces.length];
        int i = 0;
        while (i < resume_pieces.length) {
            DiskManagerPiece piece = pieces[i];
            resume_pieces[i] = this.stopped_for_close && this.check_interrupted && this.check_is_full_check && i >= this.check_position ? 2 : (piece.isDone() ? 1 : (piece.getNbWritten() > 0 ? 3 : 0));
            ++i;
        }
        HashMap<String, Object> resume_data = new HashMap<String, Object>();
        resume_data.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        int i2 = 0;
        while (i2 < pieces.length) {
            DiskManagerPiece piece = pieces[i2];
            boolean[] written = piece.getWritten();
            if (!piece.isDone() && piece.getNbWritten() > 0 && written != null) {
                boolean all_written = true;
                int j = 0;
                while (j < written.length) {
                    if (!written[j]) {
                        all_written = false;
                        break;
                    }
                    ++j;
                }
                if (all_written) {
                    resume_pieces[i2] = 2;
                } else {
                    ArrayList<Long> blocks = new ArrayList<Long>();
                    int j2 = 0;
                    while (j2 < written.length) {
                        if (written[j2]) {
                            blocks.add(new Long(j2));
                        }
                        ++j2;
                    }
                    partialPieces.put("" + i2, blocks);
                }
            }
            ++i2;
        }
        resume_data.put("blocks", partialPieces);
        long lValid = this.check_interrupted ? (long)(this.check_resume_was_valid ? 1 : 0) : (interim_save ? 0L : 1L);
        resume_data.put("valid", new Long(lValid));
        int i3 = 0;
        while (i3 < files.length) {
            files[i3].flushCache();
            ++i3;
        }
        boolean is_complete = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState(), resume_data);
        if (!was_complete || !is_complete) {
            this.saveResumeData(resume_data);
        }
    }

    protected Map getResumeData() {
        return RDResumeHandler.getResumeData(this.disk_manager.getDownloadManager());
    }

    protected static Map getResumeData(DownloadManager download_manager) {
        return RDResumeHandler.getResumeData(download_manager.getDownloadState());
    }

    protected static Map getResumeData(DownloadManagerState download_manager_state) {
        Map resume_map = download_manager_state.getResumeData();
        if (resume_map != null) {
            Map resume_data = (Map)resume_map.get("data");
            return resume_data;
        }
        return null;
    }

    protected void saveResumeData(Map resume_data) {
        RDResumeHandler.saveResumeData(this.disk_manager.getDownloadManager().getDownloadState(), resume_data);
    }

    protected static void saveResumeData(DownloadManagerState download_manager_state, Map resume_data) {
        HashMap<String, Map> resume_map = new HashMap<String, Map>();
        resume_map.put("data", resume_data);
        download_manager_state.setResumeData(resume_map);
    }

    public static void setTorrentResumeDataComplete(DownloadManagerState download_manager_state) {
        TOTorrent torrent = download_manager_state.getTorrent();
        int piece_count = torrent.getNumberOfPieces();
        byte[] resume_pieces = new byte[piece_count];
        Arrays.fill(resume_pieces, (byte)1);
        HashMap<String, Object> resume_data = new HashMap<String, Object>();
        resume_data.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        resume_data.put("blocks", partialPieces);
        resume_data.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(download_manager_state, resume_data);
    }

    protected static int clearResumeDataSupport(DownloadManager download_manager, DiskManagerFileInfo file, boolean recheck, boolean onlyClearUnsharedFirstLast) {
        Map partial_pieces;
        DownloadManagerState download_manager_state = download_manager.getDownloadState();
        Map resume_data = RDResumeHandler.getResumeData(download_manager);
        if (resume_data == null) {
            return 0;
        }
        int pieces_cleared = 0;
        byte[] resume_pieces = (byte[])resume_data.get("resume data");
        int firstPiece = file.getFirstPieceNumber();
        int lastPiece = file.getLastPieceNumber();
        if (onlyClearUnsharedFirstLast) {
            int firstFile;
            DiskManagerFileInfo[] files = download_manager.getDiskManagerFileInfo();
            boolean firstPieceShared = false;
            boolean lastPieceShared = false;
            int i = firstFile = RDResumeHandler.findFirstFileWithPieceN(firstPiece, files);
            while (i < files.length) {
                DiskManagerFileInfo currentFile = files[i];
                if (currentFile.getLastPieceNumber() >= firstPiece && currentFile.getIndex() != file.getIndex()) {
                    if (currentFile.getFirstPieceNumber() > lastPiece) break;
                    if (currentFile.getFirstPieceNumber() <= firstPiece && firstPiece <= currentFile.getLastPieceNumber()) {
                        firstPieceShared |= !currentFile.isSkipped();
                    }
                    if (currentFile.getFirstPieceNumber() <= lastPiece && lastPiece <= currentFile.getLastPieceNumber()) {
                        lastPieceShared |= !currentFile.isSkipped();
                    }
                }
                ++i;
            }
            if (firstPieceShared) {
                ++firstPiece;
            }
            if (lastPieceShared) {
                --lastPiece;
            }
        }
        if (resume_pieces != null) {
            int i = firstPiece;
            while (i <= lastPiece) {
                if (i >= resume_pieces.length) break;
                if (resume_pieces[i] == 1) {
                    ++pieces_cleared;
                }
                resume_pieces[i] = recheck ? 2 : 0;
                ++i;
            }
        }
        if ((partial_pieces = (Map)resume_data.get("blocks")) != null) {
            Iterator iter = partial_pieces.keySet().iterator();
            while (iter.hasNext()) {
                int piece_number = Integer.parseInt((String)iter.next());
                if (piece_number < firstPiece || piece_number > lastPiece) continue;
                iter.remove();
            }
        }
        resume_data.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(download_manager_state, resume_data);
        return pieces_cleared;
    }

    /*
     * Unable to fully structure code
     */
    private static int findFirstFileWithPieceN(int firstPiece, DiskManagerFileInfo[] files) {
        start = 0;
        end = files.length - 1;
        pivot = 0;
        while (start <= end) {
            pivot = start + end >>> 1;
            midVal = files[pivot].getLastPieceNumber();
            if (midVal < firstPiece) {
                start = pivot + 1;
                continue;
            }
            if (midVal <= firstPiece) ** GOTO lbl14
            end = pivot - 1;
            continue;
lbl-1000:
            // 1 sources

            {
                --pivot;
lbl14:
                // 2 sources

                ** while (pivot > 0 && files[pivot - 1].getLastPieceNumber() == firstPiece)
            }
lbl15:
            // 1 sources

            break;
        }
        return pivot;
    }

    public static boolean fileMustExist(DownloadManager download_manager, DiskManagerFileInfo file) {
        int firstFile;
        Map resumeData = RDResumeHandler.getResumeData(download_manager);
        byte[] resumePieces = resumeData != null ? (byte[])resumeData.get("resume data") : null;
        boolean sharesAnyNeededPieces = false;
        DiskManagerFileInfo[] files = download_manager.getDiskManagerFileInfo();
        int firstPiece = file.getFirstPieceNumber();
        int lastPiece = file.getLastPieceNumber();
        int i = firstFile = RDResumeHandler.findFirstFileWithPieceN(firstPiece, files);
        while (i < files.length && !sharesAnyNeededPieces) {
            DiskManagerFileInfo currentFile = files[i];
            if (currentFile.getLastPieceNumber() >= firstPiece) {
                if (currentFile.getIndex() == file.getIndex() && resumePieces != null && file.getStorageType() != 2 && file.getStorageType() != 4) {
                    int j = firstPiece;
                    while (j <= lastPiece && !sharesAnyNeededPieces) {
                        sharesAnyNeededPieces |= resumePieces[j] != 0;
                        ++j;
                    }
                }
                if (currentFile.getFirstPieceNumber() > lastPiece) break;
                if (currentFile.getFirstPieceNumber() <= firstPiece && firstPiece <= currentFile.getLastPieceNumber()) {
                    sharesAnyNeededPieces |= !currentFile.isSkipped();
                }
                if (currentFile.getFirstPieceNumber() <= lastPiece && lastPiece <= currentFile.getLastPieceNumber()) {
                    sharesAnyNeededPieces |= !currentFile.isSkipped();
                }
            }
            ++i;
        }
        return sharesAnyNeededPieces;
    }

    public static int storageTypeChanged(DownloadManager download_manager, DiskManagerFileInfo file) {
        return RDResumeHandler.clearResumeDataSupport(download_manager, file, false, true);
    }

    public static void clearResumeData(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.clearResumeDataSupport(download_manager, file, false, false);
    }

    public static void recheckFile(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.clearResumeDataSupport(download_manager, file, true, false);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState download_manager_state) {
        TOTorrent torrent = download_manager_state.getTorrent();
        long piece_count = torrent.getNumberOfPieces();
        byte[] resume_pieces = new byte[(int)piece_count];
        Arrays.fill(resume_pieces, (byte)1);
        int i = 0;
        while (i < 3) {
            int piece_num = (int)(Math.random() * (double)piece_count);
            resume_pieces[piece_num] = 2;
            ++i;
        }
        HashMap<String, Object> resumeMap = new HashMap<String, Object>();
        resumeMap.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        resumeMap.put("blocks", partialPieces);
        resumeMap.put("valid", new Long(0L));
        RDResumeHandler.saveResumeData(download_manager_state, resumeMap);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState dms) {
        Map resume_data = RDResumeHandler.getResumeData(dms);
        return RDResumeHandler.isTorrentResumeDataComplete(dms, resume_data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isTorrentResumeDataComplete(DownloadManagerState download_manager_state, Map resume_data) {
        try {
            boolean valid;
            int piece_count = download_manager_state.getTorrent().getNumberOfPieces();
            if (resume_data == null) return false;
            byte[] pieces = (byte[])resume_data.get("resume data");
            Map blocks = (Map)resume_data.get("blocks");
            boolean bl = valid = ((Long)resume_data.get("valid")).intValue() == 1;
            if (blocks == null || blocks.size() > 0) {
                return false;
            }
            if (!valid || pieces == null || pieces.length != piece_count) return false;
            int i = 0;
            while (true) {
                if (i >= pieces.length) {
                    return true;
                }
                if (pieces[i] != 1) {
                    return false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }
}

