/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.piecemapper.impl;

import java.util.List;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.PieceMapEntryImpl;

public class PieceListImpl
implements DMPieceList {
    private final PieceMapEntryImpl[] pieces;
    private final int[] cumulativeLengths;

    public static PieceListImpl convert(List pieceList2) {
        return new PieceListImpl(pieceList2.toArray(new PieceMapEntryImpl[pieceList2.size()]));
    }

    protected PieceListImpl(PieceMapEntryImpl[] _pieces) {
        this.pieces = _pieces;
        this.cumulativeLengths = new int[this.pieces.length];
        this.initializeCumulativeLengths();
    }

    private void initializeCumulativeLengths() {
        int runningLength = 0;
        int i = 0;
        while (i < this.pieces.length) {
            this.cumulativeLengths[i] = runningLength += this.pieces[i].getLength();
            ++i;
        }
    }

    @Override
    public int size() {
        return this.pieces.length;
    }

    @Override
    public DMPieceMapEntry get(int index) {
        return this.pieces[index];
    }

    @Override
    public int getCumulativeLengthToPiece(int index) {
        return this.cumulativeLengths[index];
    }
}

