/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.piecemapper.impl;

import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class DMPieceMapSimple
implements DMPieceMap {
    private final int piece_length;
    private final int piece_count;
    private final int last_piece_length;
    private final DiskManagerFileInfoImpl file;

    protected DMPieceMapSimple(TOTorrent torrent, DiskManagerFileInfoImpl _file) {
        this.piece_length = (int)torrent.getPieceLength();
        this.piece_count = torrent.getNumberOfPieces();
        int lpl = (int)(torrent.getSize() % (long)this.piece_length);
        if (lpl == 0) {
            lpl = this.piece_length;
        }
        this.last_piece_length = lpl;
        this.file = _file;
    }

    @Override
    public DMPieceList getPieceList(int piece_number) {
        return new pieceList(piece_number);
    }

    protected class pieceList
    implements DMPieceList,
    DMPieceMapEntry {
        private int piece_number;

        protected pieceList(int _piece_number) {
            this.piece_number = _piece_number;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public DMPieceMapEntry get(int index) {
            return this;
        }

        @Override
        public int getCumulativeLengthToPiece(int file_index) {
            return this.getLength();
        }

        @Override
        public DiskManagerFileInfoImpl getFile() {
            return DMPieceMapSimple.this.file;
        }

        @Override
        public long getOffset() {
            return (long)this.piece_number * (long)DMPieceMapSimple.this.piece_length;
        }

        @Override
        public int getLength() {
            if (this.piece_number == DMPieceMapSimple.this.piece_count - 1) {
                return DMPieceMapSimple.this.last_piece_length;
            }
            return DMPieceMapSimple.this.piece_length;
        }
    }
}

