/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.Key;

public class PackUtil {
    public static void PackBucketEntry(KBucketEntry e, byte[] buffer, int off, DHT.DHTtype type) {
        if (off + type.NODES_ENTRY_LENGTH > buffer.length) {
            throw new IllegalArgumentException("Not enough room in buffer");
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer, off, type.NODES_ENTRY_LENGTH);
        InetSocketAddress addr = e.getAddress();
        if (type == DHT.DHTtype.IPV6_DHT && addr.getAddress() instanceof Inet4Address) {
            throw new IllegalArgumentException("Attempting to serialize an IPv4 bucket entry into nodes6 buffer");
        }
        bb.put(e.getID().getHash());
        bb.put(addr.getAddress().getAddress());
        bb.putShort((short)addr.getPort());
    }

    public static KBucketEntry UnpackBucketEntry(byte[] buffer, int off, DHT.DHTtype type) {
        if (off + type.NODES_ENTRY_LENGTH > buffer.length) {
            throw new IllegalArgumentException("Not enough room in buffer");
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer, off, type.NODES_ENTRY_LENGTH);
        byte[] key = new byte[20];
        bb.get(key);
        byte[] inetaddr = new byte[type.NODES_ENTRY_LENGTH - 20 - 2];
        bb.get(inetaddr);
        InetSocketAddress addr = null;
        try {
            addr = new InetSocketAddress(InetAddress.getByAddress(inetaddr), bb.getShort() & 0xFFFF);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return new KBucketEntry(addr, new Key(key), 0L);
    }
}

