/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.utils;

import com.aelitis.azureus.core.util.NetUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.LinkedList;
import lbms.plugins.mldht.kad.PeerAddressDBItem;

public class AddressUtils {
    public static boolean isBogon(PeerAddressDBItem item) {
        return AddressUtils.isBogon(item.getInetAddress(), item.getPort());
    }

    public static boolean isBogon(InetSocketAddress addr) {
        return AddressUtils.isBogon(addr.getAddress(), addr.getPort());
    }

    public static boolean isBogon(InetAddress addr, int port) {
        return port <= 0 || port > 65535 || !AddressUtils.isGlobalUnicast(addr);
    }

    public static boolean isGlobalUnicast(InetAddress addr) {
        return !addr.isAnyLocalAddress() && !addr.isLinkLocalAddress() && !addr.isLoopbackAddress() && !addr.isMulticastAddress() && !addr.isSiteLocalAddress();
    }

    public static LinkedList<InetAddress> getAvailableAddrs(boolean multiHoming, Class<? extends InetAddress> type) {
        LinkedList<InetAddress> addrs = new LinkedList<InetAddress>();
        try {
            for (NetworkInterface iface : NetUtils.getNetworkInterfaces()) {
                try {
                    for (InterfaceAddress ifaceAddr : iface.getInterfaceAddresses()) {
                        InetAddress addr;
                        if (type == Inet6Address.class && ifaceAddr.getAddress() instanceof Inet6Address) {
                            addr = (Inet6Address)ifaceAddr.getAddress();
                            if (((Inet6Address)addr).isIPv4CompatibleAddress() || !AddressUtils.isGlobalUnicast(addr)) continue;
                            byte[] raw = ((Inet6Address)addr).getAddress();
                            if (raw[0] == 32 && raw[1] == 1 && raw[2] == 0 && raw[3] == 0) {
                                addrs.addLast(addr);
                            } else {
                                addrs.addFirst(addr);
                            }
                        }
                        if (type != Inet4Address.class || !(ifaceAddr.getAddress() instanceof Inet4Address)) continue;
                        addr = (Inet4Address)ifaceAddr.getAddress();
                        if (multiHoming && !AddressUtils.isGlobalUnicast(addr) || ((Inet4Address)addr).isLinkLocalAddress() || ((Inet4Address)addr).isLoopbackAddress()) continue;
                        addrs.add(addr);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (type == Inet4Address.class && !multiHoming) {
                addrs.addFirst(InetAddress.getByAddress(new byte[4]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!multiHoming) {
            addrs.retainAll(Collections.singleton(addrs.peekFirst()));
        }
        return addrs;
    }
}

