/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.tasks;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lbms.plugins.mldht.kad.DHTBase;
import lbms.plugins.mldht.kad.tasks.Task;

public class TaskManager {
    private Map<Integer, Task> tasks;
    private Deque<Task> queued;
    private AtomicInteger next_id = new AtomicInteger();

    public TaskManager() {
        this.tasks = new HashMap<Integer, Task>();
        this.queued = new LinkedList<Task>();
        this.next_id.set(1);
    }

    public void addTask(Task task2) {
        this.addTask(task2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task task2, boolean isPriority) {
        int id = this.next_id.incrementAndGet();
        task2.setTaskID(id);
        if (task2.isQueued()) {
            Deque<Task> deque = this.queued;
            synchronized (deque) {
                if (isPriority) {
                    this.queued.addFirst(task2);
                } else {
                    this.queued.addLast(task2);
                }
            }
        }
        Map<Integer, Task> map = this.tasks;
        synchronized (map) {
            this.tasks.put(id, task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinishedTasks(DHTBase dh_table) {
        Map<Integer, Task> map = this.tasks;
        synchronized (map) {
            ArrayList<Integer> rm = new ArrayList<Integer>(this.tasks.size());
            for (Task task2 : this.tasks.values()) {
                if (!task2.isFinished()) continue;
                rm.add(task2.getTaskID());
            }
            for (Integer i : rm) {
                this.tasks.remove(i);
            }
            Deque<Task> deque = this.queued;
            synchronized (deque) {
                Task t = null;
                while (this.queued.size() > 0 && dh_table.canStartTask(t = this.queued.peekFirst())) {
                    t = this.queued.removeFirst();
                    t.start();
                    this.tasks.put(t.getTaskID(), t);
                }
            }
        }
    }

    public int getNumTasks() {
        return this.tasks.size();
    }

    public int getNumQueuedTasks() {
        return this.queued.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] getActiveTasks() {
        Map<Integer, Task> map = this.tasks;
        synchronized (map) {
            return this.tasks.values().toArray(new Task[this.tasks.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] getQueuedTasks() {
        Deque<Task> deque = this.queued;
        synchronized (deque) {
            return this.queued.toArray(new Task[this.queued.size()]);
        }
    }
}

