/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.tasks;

import java.util.SortedSet;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucketEntryAndToken;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.messages.AnnounceRequest;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.tasks.Task;

public class AnnounceTask
extends Task {
    private int port;
    private boolean isSeed;

    public AnnounceTask(RPCServerBase rpc, Node node, Key info_hash, int port) {
        super(info_hash, rpc, node);
        this.port = port;
        DHT.logDebug("AnnounceTask started: " + this.getTaskID());
    }

    public void setSeed(boolean isSeed) {
        this.isSeed = isSeed;
    }

    @Override
    void callFinished(RPCCallBase c, MessageBase rsp) {
    }

    @Override
    void callTimeout(RPCCallBase c) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void update() {
        SortedSet sortedSet = this.todo;
        synchronized (sortedSet) {
            while (!this.todo.isEmpty() && this.canDoRequest()) {
                KBucketEntryAndToken e = (KBucketEntryAndToken)this.todo.first();
                this.todo.remove(e);
                if (this.visited.contains(e)) continue;
                AnnounceRequest anr = new AnnounceRequest(this.targetKey, this.port, e.getToken());
                anr.setDestination(e.getAddress());
                anr.setSeed(this.isSeed);
                this.rpcCall(anr, e.getID());
                this.visited.add(e);
            }
        }
        if (this.todo.isEmpty() && this.getNumOutstandingRequests() == 0 && !this.isFinished()) {
            this.done();
        } else if (this.getRecvResponses() == 8) {
            this.done();
        }
    }

    @Override
    boolean canDoRequest() {
        return this.getNumOutstandingRequests() < 8;
    }

    public Key getInfoHash() {
        return this.targetKey;
    }

    @Override
    public void start() {
        super.start();
    }
}

