/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.messages;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.TreeMap;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.DHTConstants;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.RPCServer;
import org.gudy.azureus2.core3.util.BEncoder;

public abstract class MessageBase {
    public static final String VERSION_KEY = "v";
    public static final String TRANSACTION_KEY = "t";
    protected byte[] mtid;
    protected Method method;
    protected Type type;
    protected Key id;
    protected InetSocketAddress origin;
    protected String version;
    protected RPCServer srv;

    public MessageBase(byte[] mtid, Method m, Type type) {
        this.mtid = mtid;
        this.method = m;
        this.type = type;
    }

    public void apply(DHT dh_table) {
    }

    public byte[] encode() throws IOException {
        return BEncoder.encode(this.getBase());
    }

    public Map<String, Object> getBase() {
        TreeMap<String, Object> base = new TreeMap<String, Object>();
        Map<String, Object> inner = this.getInnerMap();
        if (inner != null) {
            base.put(this.getType().innerKey(), inner);
        }
        base.put(TRANSACTION_KEY, this.mtid);
        base.put(VERSION_KEY, DHTConstants.getVersion());
        base.put("y", this.getType().getRPCTypeName());
        if (this.getType() == Type.REQ_MSG) {
            base.put(this.getType().getRPCTypeName(), this.getMethod().getRPCName());
        }
        return base;
    }

    public Map<String, Object> getInnerMap() {
        return null;
    }

    public void setOrigin(InetSocketAddress o) {
        this.origin = o;
    }

    public InetSocketAddress getOrigin() {
        return this.origin;
    }

    public void setDestination(InetSocketAddress o) {
        this.origin = o;
    }

    public InetSocketAddress getDestination() {
        return this.origin;
    }

    public byte[] getMTID() {
        return this.mtid;
    }

    public void setMTID(byte[] m) {
        this.mtid = m;
    }

    public void setMTID(short m) {
        this.mtid = new byte[]{(byte)(m >> 8), (byte)(m & 0xFF)};
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setServer(RPCServer srv) {
        this.srv = srv;
    }

    public RPCServer getServer() {
        return this.srv;
    }

    public void setID(Key id) {
        this.id = id;
    }

    public Key getID() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return " Method:" + (Object)((Object)this.method) + " Type:" + (Object)((Object)this.type) + " MessageID:" + new String(this.mtid) + (this.version != null ? " version:" + this.version : "") + "  ";
    }

    public static enum Method {
        PING,
        FIND_NODE,
        GET_PEERS,
        ANNOUNCE_PEER,
        NONE;


        String getRPCName() {
            return this.name().toLowerCase();
        }
    }

    public static enum Type {
        REQ_MSG{

            @Override
            String innerKey() {
                return "a";
            }

            @Override
            String getRPCTypeName() {
                return "q";
            }
        }
        ,
        RSP_MSG{

            @Override
            String innerKey() {
                return "r";
            }

            @Override
            String getRPCTypeName() {
                return "r";
            }
        }
        ,
        ERR_MSG{

            @Override
            String getRPCTypeName() {
                return "e";
            }

            @Override
            String innerKey() {
                return "e";
            }
        }
        ,
        INVALID;

        public static final String TYPE_KEY = "y";

        String innerKey() {
            return null;
        }

        String getRPCTypeName() {
            return null;
        }
    }
}

