/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.messages;

import java.util.Map;
import java.util.TreeMap;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.messages.GetPeersRequest;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.utils.Token;

public class AnnounceRequest
extends GetPeersRequest {
    protected int port;
    boolean isSeed;
    protected Token token;

    public AnnounceRequest(Key info_hash, int port, Token token) {
        super(info_hash);
        this.port = port;
        this.token = token;
        this.method = MessageBase.Method.ANNOUNCE_PEER;
    }

    public boolean isSeed() {
        return this.isSeed;
    }

    public void setSeed(boolean isSeed) {
        this.isSeed = isSeed;
    }

    @Override
    public void apply(DHT dh_table) {
        dh_table.announce(this);
    }

    @Override
    public Map<String, Object> getInnerMap() {
        TreeMap<String, Object> inner = new TreeMap<String, Object>();
        inner.put("id", this.id.getHash());
        inner.put("info_hash", this.target.getHash());
        inner.put("port", this.port);
        inner.put("token", this.token.getValue());
        inner.put("seed", Long.valueOf(this.isSeed ? 1 : 0));
        return inner;
    }

    public Token getToken() {
        return this.token;
    }

    public int getPort() {
        return this.port;
    }
}

