/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import lbms.plugins.mldht.kad.messages.MessageBase;

public class RPCStats {
    private long receivedBytes;
    private long sentBytes;
    private long tmpReceivedBytes;
    private long tmpSentBytes;
    private long receivedBytesPerSec;
    private long sentBytesPerSec;
    private long tmpReceivedTimestamp;
    private long tmpSentTimestamp;
    private int[][] sentMessages = new int[MessageBase.Method.values().length][MessageBase.Type.values().length];
    private int[][] receivedMessages = new int[MessageBase.Method.values().length][MessageBase.Type.values().length];
    private int[] timeoutMessages = new int[MessageBase.Method.values().length];

    protected RPCStats() {
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }

    public long getReceivedBytesPerSec() {
        long now = System.currentTimeMillis();
        long d = now - this.tmpReceivedTimestamp;
        if (d > 950L) {
            this.receivedBytesPerSec = (int)(this.tmpReceivedBytes * 1000L / d);
            this.tmpReceivedBytes = 0L;
            this.tmpReceivedTimestamp = now;
        }
        return this.receivedBytesPerSec;
    }

    public long getSentBytesPerSec() {
        long now = System.currentTimeMillis();
        long d = now - this.tmpSentTimestamp;
        if (d > 950L) {
            this.sentBytesPerSec = (int)(this.tmpSentBytes * 1000L / d);
            this.tmpSentBytes = 0L;
            this.tmpSentTimestamp = now;
        }
        return this.sentBytesPerSec;
    }

    public int getSentMessageCount(MessageBase.Method m, MessageBase.Type t) {
        return this.sentMessages[m.ordinal()][t.ordinal()];
    }

    public int getReceivedMessageCount(MessageBase.Method m, MessageBase.Type t) {
        return this.receivedMessages[m.ordinal()][t.ordinal()];
    }

    public int getTimeoutMessageCount(MessageBase.Method m) {
        return this.timeoutMessages[m.ordinal()];
    }

    protected void addReceivedBytes(long receivedBytes) {
        this.tmpReceivedBytes += receivedBytes;
        this.receivedBytes += receivedBytes;
    }

    protected void addSentBytes(long sentBytes) {
        this.tmpSentBytes += sentBytes;
        this.sentBytes += sentBytes;
    }

    protected void addSentMessageToCount(MessageBase msg) {
        int[] nArray = this.sentMessages[msg.getMethod().ordinal()];
        int n = msg.getType().ordinal();
        nArray[n] = nArray[n] + 1;
    }

    protected void addSentMessageToCount(MessageBase.Method m, MessageBase.Type t) {
        int[] nArray = this.sentMessages[m.ordinal()];
        int n = t.ordinal();
        nArray[n] = nArray[n] + 1;
    }

    protected void addReceivedMessageToCount(MessageBase msg) {
        int[] nArray = this.receivedMessages[msg.getMethod().ordinal()];
        int n = msg.getType().ordinal();
        nArray[n] = nArray[n] + 1;
    }

    protected void addReceivedMessageToCount(MessageBase.Method m, MessageBase.Type t) {
        int[] nArray = this.receivedMessages[m.ordinal()];
        int n = t.ordinal();
        nArray[n] = nArray[n] + 1;
    }

    protected void addTimeoutMessageToCount(MessageBase msg) {
        int n = msg.getMethod().ordinal();
        this.timeoutMessages[n] = this.timeoutMessages[n] + 1;
    }
}

