/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.RPCCall;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCCallListener;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.RPCServerListener;
import lbms.plugins.mldht.kad.RPCStats;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.messages.MessageDecoder;
import lbms.plugins.mldht.kad.messages.PingRequest;
import lbms.plugins.mldht.kad.utils.AddressUtils;
import lbms.plugins.mldht.kad.utils.ByteWrapper;
import lbms.plugins.mldht.kad.utils.ResponseTimeoutFilter;
import lbms.plugins.mldht.kad.utils.ThreadLocalUtils;
import org.gudy.azureus2.core3.util.BDecoder;

public class RPCServer
implements Runnable,
RPCServerBase {
    static Map<InetAddress, RPCServer> interfacesInUse = new HashMap<InetAddress, RPCServer>();
    private DatagramSocket sock;
    private RPCServerListener serverListener;
    private DHT dh_table;
    private ConcurrentMap<ByteWrapper, RPCCallBase> calls;
    private Queue<RPCCallBase> call_queue;
    private volatile boolean running;
    private Thread thread;
    private int numReceived;
    private int numSent;
    private int port;
    private RPCStats stats;
    private ResponseTimeoutFilter timeoutFilter;
    private Key derivedId;
    private final RPCCallListener rpcListener = new RPCCallListener(){

        @Override
        public void onTimeout(RPCCallBase c) {
            ByteWrapper w = new ByteWrapper(c.getRequest().getMTID());
            RPCServer.this.stats.addTimeoutMessageToCount(c.getRequest());
            RPCServer.this.calls.remove(w);
            RPCServer.this.dh_table.timeout(c);
            RPCServer.this.doQueuedCalls();
        }

        @Override
        public void onStall(RPCCallBase c) {
        }

        @Override
        public void onResponse(RPCCallBase c, MessageBase rsp) {
            RPCServer.this.serverListener.replyReceived(rsp.getOrigin());
        }
    };
    private BDecoder decoder = new BDecoder();

    public RPCServer(DHT dh_table, int port, RPCStats stats, RPCServerListener serverListener) {
        this.port = port;
        this.dh_table = dh_table;
        this.serverListener = serverListener;
        this.timeoutFilter = new ResponseTimeoutFilter();
        this.calls = new ConcurrentHashMap<ByteWrapper, RPCCallBase>(80, 0.75f, 3);
        this.call_queue = new ConcurrentLinkedQueue<RPCCallBase>();
        this.stats = stats;
        this.start();
    }

    @Override
    public DHT getDHT() {
        return this.dh_table;
    }

    @Override
    public boolean isRunning() {
        return this.dh_table.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createSocket() {
        if (this.sock != null) {
            this.sock.close();
        }
        Map<InetAddress, RPCServer> map = interfacesInUse;
        synchronized (map) {
            interfacesInUse.values().remove(this);
            InetAddress addr = null;
            try {
                LinkedList<InetAddress> addrs = AddressUtils.getAvailableAddrs(this.dh_table.getConfig().allowMultiHoming(), this.dh_table.getType().PREFERRED_ADDRESS_TYPE);
                addrs.removeAll(interfacesInUse.keySet());
                addr = addrs.peekFirst();
                this.timeoutFilter.reset();
                if (addr != null) {
                    this.sock = new DatagramSocket(null);
                    this.sock.setReuseAddress(true);
                    this.sock.bind(new InetSocketAddress(addr, this.port));
                    interfacesInUse.put(addr, this);
                    return true;
                }
                if (this.sock != null) {
                    this.sock.close();
                }
                this.destroy();
                return false;
            }
            catch (Exception e) {
                if (this.sock != null) {
                    this.sock.close();
                }
                this.destroy();
                return false;
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getPublicAddress() {
        if (this.sock.getLocalAddress() instanceof Inet6Address && !this.sock.getLocalAddress().isAnyLocalAddress()) {
            return this.sock.getLocalAddress();
        }
        return null;
    }

    @Override
    public void run() {
        try {
            int delay = 1;
            byte[] buffer = new byte[5120];
            while (this.running) {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                try {
                    if (this.sock.isClosed()) {
                        Thread.sleep(delay * 100);
                        if (delay < 256) {
                            delay <<= 1;
                        }
                        if (!this.createSocket()) break;
                        continue;
                    }
                    this.sock.receive(packet);
                }
                catch (Exception e) {
                    if (!this.running) continue;
                    if (delay != 1 || e.getMessage() == null || !e.getMessage().toLowerCase().contains("socket closed")) {
                        DHT.log(e, DHT.LogLevel.Error);
                    }
                    this.sock.close();
                    continue;
                }
                try {
                    this.handlePacket(packet);
                    if (delay <= 1) continue;
                    --delay;
                }
                catch (Exception e) {
                    if (!this.running) continue;
                    DHT.log(e, DHT.LogLevel.Error);
                }
            }
            this.destroy();
            DHT.logInfo("Stopped RPC Server");
        }
        catch (Throwable e) {
            DHT.log(e, DHT.LogLevel.Fatal);
        }
    }

    public Key getDerivedID() {
        return this.derivedId;
    }

    @Override
    public void start() {
        if (!this.createSocket()) {
            return;
        }
        this.running = true;
        DHT.logInfo("Starting RPC Server");
        this.derivedId = this.dh_table.getNode().registerServer(this);
        this.dh_table.addServer(this);
        this.thread = new Thread((Runnable)this, "mlDHT RPC Thread " + (Object)((Object)this.dh_table.getType()));
        this.thread.setPriority(1);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.running) {
            DHT.logInfo("Stopping RPC Server");
        }
        this.running = false;
        this.dh_table.removeServer(this);
        Node node = this.dh_table.getNode();
        if (node != null) {
            node.removeServer(this);
        }
        Map<InetAddress, RPCServer> map = interfacesInUse;
        synchronized (map) {
            interfacesInUse.values().remove(this);
        }
        if (this.sock != null) {
            this.sock.close();
        }
        this.thread = null;
    }

    @Override
    public RPCCall doCall(MessageBase msg) {
        RPCCall c;
        block1: {
            short mtid;
            c = new RPCCall(this, msg);
            do {
                if (this.calls.size() < 256) continue;
                DHT.logInfo("Queueing RPC call, no slots available at the moment");
                this.call_queue.add(c);
                break block1;
            } while (this.calls.putIfAbsent(new ByteWrapper(mtid = (short)ThreadLocalUtils.getThreadLocalRandom().nextInt()), c) != null);
            this.dispatchCall(c, mtid);
        }
        return c;
    }

    private void dispatchCall(RPCCallBase call, short mtid) {
        MessageBase msg = call.getRequest();
        msg.setMTID(mtid);
        this.sendMessage(msg);
        call.addListener(this.rpcListener);
        this.timeoutFilter.registerCall(call);
        call.start();
    }

    @Override
    public void ping(InetSocketAddress addr) {
        PingRequest pr = new PingRequest();
        pr.setID(this.derivedId);
        pr.setDestination(addr);
        this.doCall(pr);
    }

    @Override
    public RPCCallBase findCall(byte[] mtid) {
        return (RPCCallBase)this.calls.get(new ByteWrapper(mtid));
    }

    @Override
    public int getNumActiveRPCCalls() {
        return this.calls.size();
    }

    @Override
    public int getNumReceived() {
        return this.numReceived;
    }

    @Override
    public int getNumSent() {
        return this.numSent;
    }

    @Override
    public RPCStats getStats() {
        return this.stats;
    }

    private void handlePacket(DatagramPacket p) {
        ++this.numReceived;
        this.stats.addReceivedBytes(p.getLength() + this.dh_table.getType().HEADER_LENGTH);
        if (p.getPort() == 0) {
            return;
        }
        if (DHT.isLogLevelEnabled(DHT.LogLevel.Verbose)) {
            try {
                DHT.logVerbose(new String(p.getData(), 0, p.getLength(), "UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Map<String, Object> bedata = this.decoder.decodeByteArray(p.getData(), 0, p.getLength(), false);
            MessageBase msg = MessageDecoder.parseMessage(bedata, this);
            if (msg != null) {
                if (DHT.isLogLevelEnabled(DHT.LogLevel.Debug)) {
                    DHT.logDebug("RPC received message [" + p.getAddress().getHostAddress() + "] " + msg.toString());
                }
                this.stats.addReceivedMessageToCount(msg);
                msg.setOrigin(new InetSocketAddress(p.getAddress(), p.getPort()));
                msg.setServer(this);
                msg.apply(this.dh_table);
                if (msg.getType() == MessageBase.Type.RSP_MSG && this.calls.containsKey(new ByteWrapper(msg.getMTID()))) {
                    RPCCallBase c = (RPCCallBase)this.calls.get(new ByteWrapper(msg.getMTID()));
                    if (c.getRequest().getDestination().equals(msg.getOrigin())) {
                        c.response(msg);
                        this.calls.remove(new ByteWrapper(msg.getMTID()));
                        this.doQueuedCalls();
                    } else {
                        DHT.logInfo("Response source (" + msg.getOrigin() + ") mismatches request destination (" + c.getRequest().getDestination() + "); ignoring response");
                    }
                }
            } else {
                try {
                    DHT.logDebug("RPC received message [" + p.getAddress().getHostAddress() + "] Decode failed msg was:" + new String(p.getData(), 0, p.getLength(), "UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            DHT.log(e, DHT.LogLevel.Debug);
        }
    }

    @Override
    public void sendMessage(MessageBase msg) {
        try {
            if (msg.getID() == null) {
                msg.setID(this.getDerivedID());
            }
            this.stats.addSentMessageToCount(msg);
            this.send(msg.getDestination(), msg.encode());
            if (DHT.isLogLevelEnabled(DHT.LogLevel.Debug)) {
                DHT.logDebug("RPC send Message: [" + msg.getDestination().getAddress().getHostAddress() + "] " + msg.toString());
            }
        }
        catch (IOException e) {
            System.out.print(this.sock.getLocalAddress() + " -> " + msg.getDestination() + " ");
            e.printStackTrace();
        }
    }

    @Override
    public ResponseTimeoutFilter getTimeoutFilter() {
        return this.timeoutFilter;
    }

    private void send(InetSocketAddress addr, byte[] msg) throws IOException {
        if (!this.sock.isClosed()) {
            DatagramPacket p = new DatagramPacket(msg, msg.length);
            p.setSocketAddress(addr);
            try {
                this.sock.send(p);
            }
            catch (BindException e) {
                if (NetworkInterface.getByInetAddress(this.sock.getLocalAddress()) == null) {
                    this.createSocket();
                    this.sock.send(p);
                }
                throw e;
            }
            this.stats.addSentBytes(msg.length + this.dh_table.getType().HEADER_LENGTH);
            ++this.numSent;
        }
    }

    private void doQueuedCalls() {
        while (this.call_queue.peek() != null && this.calls.size() < 256) {
            RPCCallBase c = this.call_queue.poll();
            if (c == null) {
                return;
            }
            short mtid = 0;
            while (this.calls.putIfAbsent(new ByteWrapper(mtid = (short)ThreadLocalUtils.getThreadLocalRandom().nextInt()), c) != null) {
            }
            this.dispatchCall(c, mtid);
        }
    }
}

