/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCCallListener;
import lbms.plugins.mldht.kad.RPCServer;
import lbms.plugins.mldht.kad.messages.MessageBase;

public class RPCCall
implements RPCCallBase {
    private MessageBase msg;
    private RPCServer rpc;
    private boolean queued = true;
    private boolean stalled = false;
    private List<RPCCallListener> listeners;
    private ScheduledFuture<?> timeoutTimer;
    private long sentTime = -1L;
    private long responseTime = -1L;
    private Key expectedID;

    public RPCCall(RPCServer rpc, MessageBase msg) {
        this.rpc = rpc;
        this.msg = msg;
    }

    @Override
    public void setExpectedID(Key id) {
        this.expectedID = id;
    }

    @Override
    public boolean matchesExpectedID(Key id) {
        return this.expectedID == null || id.equals(this.expectedID);
    }

    @Override
    public Key getExpectedID() {
        return this.expectedID;
    }

    @Override
    public void start() {
        this.sentTime = System.currentTimeMillis();
        this.queued = false;
        this.startTimeout();
    }

    @Override
    public void response(MessageBase rsp) {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.cancel(false);
        }
        this.responseTime = System.currentTimeMillis();
        this.onCallResponse(rsp);
    }

    @Override
    public synchronized void addListener(RPCCallListener cl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<RPCCallListener>(1);
        }
        this.listeners.add(cl);
    }

    @Override
    public synchronized void removeListener(RPCCallListener cl) {
        if (this.listeners != null) {
            this.listeners.remove(cl);
        }
    }

    @Override
    public MessageBase.Method getMessageMethod() {
        return this.msg.getMethod();
    }

    @Override
    public MessageBase getRequest() {
        return this.msg;
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    private void startTimeout() {
        this.timeoutTimer = DHT.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                long elapsed = System.currentTimeMillis() - RPCCall.this.sentTime;
                long remaining = 10000L - elapsed;
                if (remaining > 0L) {
                    RPCCall.this.stalled = true;
                    RPCCall.this.onStall();
                    RPCCall.this.timeoutTimer = DHT.getScheduler().schedule(new Runnable(){

                        @Override
                        public void run() {
                            RPCCall.this.onCallTimeout();
                        }
                    }, remaining, TimeUnit.MILLISECONDS);
                } else {
                    RPCCall.this.onCallTimeout();
                }
            }
        }, this.rpc.getTimeoutFilter().getStallTimeout(), TimeUnit.MILLISECONDS);
    }

    private synchronized void onCallResponse(MessageBase rsp) {
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).onResponse(this, rsp);
                ++i;
            }
        }
    }

    private synchronized void onCallTimeout() {
        DHT.logDebug("RPCCall timed out ID: " + new String(this.msg.getMTID()));
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    this.listeners.get(i).onTimeout(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    private synchronized void onStall() {
        DHT.logDebug("RPCCall stalled ID: " + new String(this.msg.getMTID()));
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    this.listeners.get(i).onStall(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    @Override
    public long getRTT() {
        if (this.sentTime == -1L || this.responseTime == -1L) {
            return -1L;
        }
        return this.responseTime - this.sentTime;
    }

    @Override
    public boolean wasStalled() {
        return this.stalled;
    }
}

