/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lbms.plugins.mldht.kad.DBItem;
import lbms.plugins.mldht.kad.DHT;

public class PeerAddressDBItem
extends DBItem {
    boolean seed;

    public static PeerAddressDBItem createFromAddress(InetAddress addr, int port, boolean isSeed) {
        byte[] tdata = new byte[addr.getAddress().length + 2];
        ByteBuffer bb = ByteBuffer.wrap(tdata);
        bb.put(addr.getAddress());
        bb.putShort((short)port);
        return new PeerAddressDBItem(tdata, isSeed);
    }

    public PeerAddressDBItem(byte[] data, boolean isSeed) {
        super(data);
        if (data.length != DHT.DHTtype.IPV4_DHT.ADDRESS_ENTRY_LENGTH && data.length != DHT.DHTtype.IPV6_DHT.ADDRESS_ENTRY_LENGTH) {
            throw new IllegalArgumentException("byte array length does not match ipv4 or ipv6 raw InetAddress+Port length");
        }
        this.seed = isSeed;
    }

    public InetAddress getInetAddress() {
        try {
            if (this.item.length == DHT.DHTtype.IPV4_DHT.ADDRESS_ENTRY_LENGTH) {
                return InetAddress.getByAddress(Arrays.copyOf(this.item, 4));
            }
            if (this.item.length == DHT.DHTtype.IPV6_DHT.ADDRESS_ENTRY_LENGTH) {
                return InetAddress.getByAddress(Arrays.copyOf(this.item, 16));
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAddressAsString() {
        return this.getInetAddress().getHostAddress();
    }

    public Class<? extends InetAddress> getAddressType() {
        if (this.item.length == DHT.DHTtype.IPV4_DHT.ADDRESS_ENTRY_LENGTH) {
            return DHT.DHTtype.IPV4_DHT.PREFERRED_ADDRESS_TYPE;
        }
        if (this.item.length == DHT.DHTtype.IPV6_DHT.ADDRESS_ENTRY_LENGTH) {
            return DHT.DHTtype.IPV6_DHT.PREFERRED_ADDRESS_TYPE;
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PeerAddressDBItem) {
            PeerAddressDBItem other = (PeerAddressDBItem)obj;
            if (other.item.length != this.item.length) {
                return false;
            }
            int i = 0;
            while (i < this.item.length - 2) {
                if (other.item[i] != this.item[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(Arrays.copyOf(this.item, this.item.length - 2));
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " addr:" + new InetSocketAddress(this.getAddressAsString(), this.getPort()) + " seed:" + this.seed;
    }

    public int getPort() {
        if (this.item.length == DHT.DHTtype.IPV4_DHT.ADDRESS_ENTRY_LENGTH) {
            return (this.item[4] & 0xFF) << 8 | this.item[5] & 0xFF;
        }
        if (this.item.length == DHT.DHTtype.IPV6_DHT.ADDRESS_ENTRY_LENGTH) {
            return (this.item[16] & 0xFF) << 8 | this.item[17] & 0xFF;
        }
        return 0;
    }

    public boolean isSeed() {
        return this.seed;
    }
}

