/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import lbms.plugins.mldht.kad.Key;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class KBucketEntry
implements Serializable {
    public static final Comparator<KBucketEntry> LAST_SEEN_ORDER = new Comparator<KBucketEntry>(){

        @Override
        public int compare(KBucketEntry o1, KBucketEntry o2) {
            return Long.signum(o1.lastSeen - o2.lastSeen);
        }
    };
    public static final Comparator<KBucketEntry> AGE_ORDER = new Comparator<KBucketEntry>(){

        @Override
        public int compare(KBucketEntry o1, KBucketEntry o2) {
            return Long.signum(o1.timeCreated - o2.timeCreated);
        }
    };
    public static final Comparator<KBucketEntry> KEY_ORDER = new Comparator<KBucketEntry>(){

        @Override
        public int compare(KBucketEntry o1, KBucketEntry o2) {
            return o1.nodeID.compareTo(o2.nodeID);
        }
    };
    private static final long serialVersionUID = 3230342110307814047L;
    private InetSocketAddress addr;
    private Key nodeID;
    private long lastSeen;
    private int failedQueries = 0;
    private long timeCreated;
    private String version;

    public KBucketEntry() {
        this.timeCreated = this.lastSeen = System.currentTimeMillis();
    }

    public KBucketEntry(InetSocketAddress addr, Key id) {
        this.timeCreated = this.lastSeen = System.currentTimeMillis();
        this.addr = addr;
        this.nodeID = id;
    }

    public KBucketEntry(InetSocketAddress addr, Key id, long timestamp) {
        this.lastSeen = timestamp;
        this.timeCreated = timestamp;
        this.addr = addr;
        this.nodeID = id;
    }

    public KBucketEntry(KBucketEntry other) {
        this.addr = other.addr;
        this.nodeID = other.nodeID;
        this.lastSeen = other.lastSeen;
        this.failedQueries = other.failedQueries;
        this.timeCreated = other.timeCreated;
    }

    public InetSocketAddress getAddress() {
        return this.addr;
    }

    public boolean equals(Object o) {
        if (o instanceof KBucketEntry) {
            return this.equals((KBucketEntry)o);
        }
        return this == o;
    }

    public boolean equals(KBucketEntry other) {
        return this.nodeID.equals(other.nodeID) || this.addr.getAddress().equals(other.addr.getAddress());
    }

    public int hashCode() {
        new Exception("KBucketEntry hashCode should not be used").printStackTrace();
        return 0;
    }

    public Key getID() {
        return this.nodeID;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public long getCreationTime() {
        return this.timeCreated;
    }

    public int getFailedQueries() {
        return this.failedQueries;
    }

    public String toString() {
        long now = System.currentTimeMillis();
        return this.nodeID + "/" + this.addr + ";seen:" + TimeFormatter.format((now - this.lastSeen) / 1000L) + ";age:" + TimeFormatter.format((now - this.timeCreated) / 1000L) + (this.failedQueries > 0 ? ";fail:" + this.failedQueries : "");
    }

    public boolean isGood() {
        return !this.isQuestionable();
    }

    public boolean isQuestionable() {
        return System.currentTimeMillis() - this.lastSeen > 900000L || this.isBad();
    }

    public boolean isBad() {
        if (this.failedQueries >= 8) {
            return true;
        }
        return this.failedQueries > 2 && System.currentTimeMillis() - this.lastSeen > 900000L;
    }

    public void signalLastSeen() {
        this.lastSeen = System.currentTimeMillis();
    }

    public void mergeTimestamps(KBucketEntry entry) {
        if (!this.equals(entry)) {
            return;
        }
        this.lastSeen = Math.max(this.lastSeen, entry.getLastSeen());
        this.timeCreated = Math.min(this.timeCreated, entry.getCreationTime());
    }

    public void signalResponse() {
        this.lastSeen = System.currentTimeMillis();
        this.failedQueries = 0;
    }

    public void signalRequestTimeout() {
        ++this.failedQueries;
    }

    public static final class BucketSet
    extends AbstractSet<KBucketEntry> {
        HashMap<Object, KBucketEntry> entries = new HashMap();

        @Override
        public boolean add(KBucketEntry e) {
            if (this.entries.containsKey(e.getID()) || this.entries.containsKey(e.getAddress().getAddress())) {
                return false;
            }
            this.entries.put(e.getID(), e);
            this.entries.put(e.getAddress().getAddress(), e);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof KBucketEntry) {
                return this.contains((KBucketEntry)o);
            }
            return false;
        }

        public boolean contains(KBucketEntry e) {
            return this.entries.containsKey(e.getID()) || this.entries.containsKey(e.getAddress().getAddress());
        }

        @Override
        public Iterator<KBucketEntry> iterator() {
            throw new UnsupportedOperationException("no iteration allowed");
        }

        @Override
        public int size() {
            return this.entries.size() / 2;
        }
    }

    public static final class DistanceOrder
    implements Comparator<KBucketEntry> {
        final Key target;

        public DistanceOrder(Key target) {
            this.target = target;
        }

        @Override
        public int compare(KBucketEntry o1, KBucketEntry o2) {
            return this.target.threeWayDistance(o1.getID(), o2.getID());
        }
    }
}

