/*
 * Decompiled with CFR 0.152.
 */
package com.vuze.client.plugins.utp.loc;

import com.vuze.client.plugins.utp.UTPProvider;
import com.vuze.client.plugins.utp.UTPProviderCallback;
import com.vuze.client.plugins.utp.UTPProviderException;
import com.vuze.client.plugins.utp.loc.UTPSocket;
import com.vuze.client.plugins.utp.loc.UTPTranslated;
import com.vuze.client.plugins.utp.loc.v2.UTPTranslatedV2;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

public class UTPProviderLocal
implements UTPProvider,
UTPTranslated.SendToProc,
UTPTranslated.UTPGotIncomingConnection,
UTPTranslated.UTPFunctionTable {
    private static final int version = 2;
    private boolean test_mode;
    private UTPTranslated impl;
    private UTPProviderCallback callback;
    private long socket_id_next;
    private Map<Long, UTPSocket> socket_map = new HashMap<Long, UTPSocket>();
    private Map<Integer, Integer> pending_options = new HashMap<Integer, Integer>();

    public UTPProviderLocal() {
        this(false);
    }

    public UTPProviderLocal(boolean _test_mode) {
        this.test_mode = _test_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(UTPProviderCallback _callback) {
        Map<Integer, Integer> map = this.pending_options;
        synchronized (map) {
            block6: {
                if (this.impl == null) break block6;
                Debug.out("Already loaded ");
                return false;
            }
            this.callback = _callback;
            this.impl = new UTPTranslatedV2(this.callback, this, this, this, this.test_mode);
            if (this.pending_options.size() > 0) {
                for (Map.Entry<Integer, Integer> entry : this.pending_options.entrySet()) {
                    this.setOption(entry.getKey(), entry.getValue());
                }
                this.pending_options.clear();
            }
            return true;
        }
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public boolean isValidPacket(byte[] data, int length) {
        return this.impl.isValidPacket(data, length);
    }

    @Override
    public void send_to_proc(Object user_data, byte[] data, InetSocketAddress addr) {
        this.callback.send(addr, data, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void got_incoming_connection(Object user_data, UTPSocket socket) {
        long socket_id;
        Map<Long, UTPSocket> map = this.socket_map;
        synchronized (map) {
            socket_id = this.socket_id_next++;
            this.socket_map.put(socket_id, socket);
        }
        InetSocketAddress[] addr_out = new InetSocketAddress[1];
        this.impl.UTP_GetPeerName(socket, addr_out);
        this.callback.incomingConnection(addr_out[0], socket_id, (long)this.impl.UTP_GetSocketConnectionID(socket) & 0xFFFFL);
        try {
            this.impl.UTP_SetUserData(socket, new Object[]{socket_id, socket});
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public void on_read(Object user_data, byte[] bytes, int count) {
        long socket_id = (Long)((Object[])user_data)[0];
        this.callback.read(socket_id, bytes);
    }

    @Override
    public void on_read(Object user_data, ByteBuffer bytes, int count) {
        long socket_id = (Long)((Object[])user_data)[0];
        this.callback.read(socket_id, bytes);
    }

    @Override
    public void on_write(Object user_data, byte[] bytes, int offset, int length) {
        long socket_id = (Long)((Object[])user_data)[0];
        this.callback.write(socket_id, bytes, offset, length);
    }

    @Override
    public int get_rb_size(Object user_data) {
        long socket_id = (Long)((Object[])user_data)[0];
        return this.callback.getReadBufferSize(socket_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void on_state(Object user_data, int state) {
        long socket_id = (Long)((Object[])user_data)[0];
        this.callback.setState(socket_id, state);
        if (state == 4) {
            Map<Long, UTPSocket> map = this.socket_map;
            synchronized (map) {
                this.socket_map.remove(socket_id);
            }
        }
    }

    @Override
    public void on_error(Object user_data, int errcode) {
        long socket_id = (Long)((Object[])user_data)[0];
        this.callback.error(socket_id, errcode);
    }

    @Override
    public void on_overhead(Object user_data, boolean send, int count, int type) {
        long socket_id = (Long)((Object[])user_data)[0];
        this.callback.overhead(socket_id, send, count, type);
    }

    @Override
    public void checkTimeouts() {
        this.impl.UTP_CheckTimeouts();
    }

    @Override
    public void incomingIdle() {
        this.impl.UTP_IncomingIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] connect(String to_address, int to_port) throws UTPProviderException {
        try {
            long socket_id;
            UTPSocket socket = this.impl.UTP_Create();
            if (socket == null) {
                throw new UTPProviderException("Failed to create socket");
            }
            Map<Long, UTPSocket> map = this.socket_map;
            synchronized (map) {
                socket_id = this.socket_id_next++;
                this.socket_map.put(socket_id, socket);
            }
            this.impl.UTP_SetUserData(socket, new Object[]{socket_id, socket});
            this.impl.UTP_Connect(socket, new InetSocketAddress(HostNameToIPResolver.syncResolve(to_address), to_port));
            return new long[]{socket_id, (long)this.impl.UTP_GetSocketConnectionID(socket) & 0xFFFFL};
        }
        catch (UTPProviderException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UTPProviderException("connect failed", e);
        }
    }

    @Override
    public boolean receive(String from_address, int from_port, byte[] data, int length) throws UTPProviderException {
        try {
            return this.impl.UTP_IsIncomingUTP(this, this, "", data, length, new InetSocketAddress(HostNameToIPResolver.syncResolve(from_address), from_port));
        }
        catch (Throwable e) {
            throw new UTPProviderException("receive failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(long utp_socket, int avail_bytes) throws UTPProviderException {
        UTPSocket socket;
        Map<Long, UTPSocket> map = this.socket_map;
        synchronized (map) {
            socket = this.socket_map.get(utp_socket);
        }
        if (socket != null) {
            return this.impl.UTP_Write(socket, avail_bytes);
        }
        throw new UTPProviderException("Unknown socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(long utp_socket, ByteBuffer[] buffers, int start, int len) throws UTPProviderException {
        UTPSocket socket;
        Map<Long, UTPSocket> map = this.socket_map;
        synchronized (map) {
            socket = this.socket_map.get(utp_socket);
        }
        if (socket != null) {
            return this.impl.UTP_Write(socket, buffers, start, len);
        }
        throw new UTPProviderException("Unknown socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveBufferDrained(long utp_socket) throws UTPProviderException {
        UTPSocket socket;
        Map<Long, UTPSocket> map = this.socket_map;
        synchronized (map) {
            socket = this.socket_map.get(utp_socket);
        }
        if (socket == null) {
            throw new UTPProviderException("Unknown socket");
        }
        this.impl.UTP_RBDrained(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long utp_socket) throws UTPProviderException {
        UTPSocket socket;
        Map<Long, UTPSocket> map = this.socket_map;
        synchronized (map) {
            socket = this.socket_map.remove(utp_socket);
        }
        if (socket != null) {
            this.impl.UTP_Close(socket);
        }
    }

    @Override
    public void setSocketOptions(long fd) throws UTPProviderException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(int option, int value) {
        Map<Integer, Integer> map = this.pending_options;
        synchronized (map) {
            if (this.impl == null) {
                this.pending_options.put(option, value);
            } else {
                this.impl.UTP_SetOption(option, value);
            }
        }
    }
}

