/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.plugins.rcmplugin;

import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.plugins.rcmplugin.RCMPatcher;
import com.aelitis.plugins.rcmplugin.RCM_SearchProvider;
import com.aelitis.plugins.rcmplugin.RelatedContentUI;
import com.aelitis.plugins.rcmplugin.SearchRelatedContent;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchResult;

public class RCMPlugin
implements UnloadablePlugin {
    private static final boolean IS_5101_PLUS = Constants.isCurrentVersionGE("5.1.0.1");
    protected static final int MIN_SEARCH_RANK_DEFAULT = 0;
    public static final String PARAM_SOURCES_LIST = "Plugin.aercm.sources.setlist";
    public static final String PARAM_FTUX_SHOWN = "rcm.ftux.shown2";
    public static final String POPULARITY_SEARCH_EXPR = "(.)";
    private PluginInterface plugin_interface;
    private RelatedContentUI ui;
    private SearchProvider search_provider;
    private boolean destroyed;
    List<String> source_map_defaults = new ArrayList<String>();
    private ByteArrayHashMap<Boolean> source_map;
    private boolean source_map_wildcard;
    private byte[] source_vhdn;
    private Object json_rpc_server;
    private Map<String, SearchInstance> mapSearchInstances;
    private Map<String, Map> mapSearchResults;

    static {
        COConfigurationManager.setParameter("rcm.persist", true);
        new RCMPatcher();
    }

    public RCMPlugin() {
        this.source_map_defaults.add("vhdn.vuze.com");
        this.source_map_defaults.add("tracker.vodo.net");
        this.source_map_defaults.add("bt.archive.org");
        this.source_map_defaults.add("tracker.legaltorrents.com");
        this.source_map_defaults.add("tracker.mininova.org");
        this.source_map = new ByteArrayHashMap();
        this.source_vhdn = this.compressDomain("vhdn.vuze.com");
        this.mapSearchInstances = new HashMap<String, SearchInstance>();
        this.mapSearchResults = new HashMap<String, Map>();
    }

    private byte[] compressDomain(String host) {
        String[] bits = host.split("\\.");
        int len = bits.length;
        if (len < 2) {
            bits = new String[]{bits[0], "com"};
        }
        String end = bits[len - 1];
        String dom = String.valueOf(bits[len - 2]) + "." + end;
        int hash = dom.hashCode();
        byte[] bytes = new byte[]{(byte)(hash >> 24), (byte)(hash >> 16), (byte)(hash >> 8), (byte)hash};
        return bytes;
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        this.plugin_interface = _plugin_interface;
        COConfigurationManager.addAndFireParameterListener(PARAM_SOURCES_LIST, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                RCMPlugin.this.updateSourcesList();
            }
        });
        LocaleUtilities loc_utils = this.plugin_interface.getUtilities().getLocaleUtilities();
        loc_utils.integrateLocalisedMessageBundle("com.aelitis.plugins.rcmplugin.internat.Messages");
        this.hookSearch();
        this.updatePluginInfo();
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void UIAttached(UIInstance instance) {
                if (instance.getUIType() == 1) {
                    RCMPlugin rCMPlugin = RCMPlugin.this;
                    synchronized (rCMPlugin) {
                        if (RCMPlugin.this.destroyed) {
                            return;
                        }
                        try {
                            Class<?> cla = Class.forName("com.aelitis.plugins.rcmplugin.RelatedContentUISWT");
                            RCMPlugin.this.ui = (RelatedContentUI)cla.getMethod("getSingleton", PluginInterface.class, UIInstance.class, RCMPlugin.class).invoke(null, RCMPlugin.this.plugin_interface, instance, RCMPlugin.this);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
        if (IS_5101_PLUS) {
            this.json_rpc_server = new Utilities.JSONServer(){
                private List<String> methods = new ArrayList<String>();
                {
                    this.methods.add("rcm-is-enabled");
                    this.methods.add("rcm-get-list");
                    this.methods.add("rcm-lookup-start");
                    this.methods.add("rcm-lookup-remove");
                    this.methods.add("rcm-lookup-get-results");
                    this.methods.add("rcm-set-enabled");
                }

                @Override
                public String getName() {
                    return "SwarmDiscoveries";
                }

                @Override
                public List<String> getSupportedMethods() {
                    return this.methods;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Map call(String method, Map args) throws PluginException {
                    if (RCMPlugin.this.destroyed) {
                        throw new PluginException("Plugin unloaded");
                    }
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    if (method.equals("rcm-is-enabled")) {
                        result.put("enabled", RCMPlugin.this.isRCMEnabled());
                        result.put("sources", RCMPlugin.this.getSourcesList());
                        result.put("is-all-sources", RCMPlugin.this.isAllSources());
                        result.put("ui-enabled", RCMPlugin.this.isUIEnabled());
                        return result;
                    } else if (method.equals("rcm-get-list")) {
                        if (!RCMPlugin.this.isRCMEnabled() || !RCMPlugin.this.isUIEnabled()) throw new PluginException("RCM not enabled");
                        RCMPlugin.this.rpcGetList(result, args);
                        return result;
                    } else if (method.equals("rcm-set-enabled")) {
                        boolean enable = MapUtils.getMapBoolean(args, "enable", false);
                        boolean all = MapUtils.getMapBoolean(args, "all-sources", false);
                        if (enable) {
                            RCMPlugin.this.setRCMEnabled(enable);
                        }
                        RCMPlugin.this.setSearchEnabled(enable);
                        RCMPlugin.this.setUIEnabled(enable);
                        RCMPlugin.this.setFTUXBeenShown(true);
                        if (all) {
                            RCMPlugin.this.setToAllSources();
                            return result;
                        } else {
                            RCMPlugin.this.setToDefaultSourcesList();
                        }
                        return result;
                    } else if (method.equals("rcm-lookup-start")) {
                        if (!RCMPlugin.this.isRCMEnabled() || !RCMPlugin.this.isUIEnabled()) throw new PluginException("RCM not enabled");
                        RCMPlugin.this.rpcLookupStart(result, args);
                        return result;
                    } else if (method.equals("rcm-lookup-remove")) {
                        if (!RCMPlugin.this.isRCMEnabled() || !RCMPlugin.this.isUIEnabled()) throw new PluginException("RCM not enabled");
                        RCMPlugin.this.rpcLookupRemove(result, args);
                        return result;
                    } else {
                        if (!method.equals("rcm-lookup-get-results")) throw new PluginException("Unsupported method");
                        if (!RCMPlugin.this.isRCMEnabled() || !RCMPlugin.this.isUIEnabled()) throw new PluginException("RCM not enabled");
                        RCMPlugin.this.rpcLookupGetResults(result, args);
                    }
                    return result;
                }
            };
            this.plugin_interface.getUtilities().registerJSONRPCServer((Utilities.JSONServer)this.json_rpc_server);
        }
    }

    protected void rpcLookupStart(Map result, Map args) throws PluginException {
        block9: {
            String searchTerm = MapUtils.getMapString(args, "search-term", null);
            String lookupByTorrent = MapUtils.getMapString(args, "torrent-hash", null);
            long lookupBySize = MapUtils.getMapLong(args, "file-size", 0L);
            String[] networks = new String[]{"Public"};
            String net_str = RCMPlugin.getNetworkString(networks);
            try {
                RelatedContentManager manager = RelatedContentManager.getSingleton();
                if (searchTerm != null) {
                    final String lookupID = Integer.toHexString((String.valueOf(searchTerm) + net_str).hashCode());
                    result.put("lid", lookupID);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("s", searchTerm);
                    HashMap<String, Constable> map = this.mapSearchResults.get(lookupID);
                    if (map == null) {
                        map = new HashMap<String, Constable>();
                        this.mapSearchResults.put(lookupID, map);
                    }
                    int activeSearches = MapUtils.getMapInt(map, "active-searches", 0);
                    map.put("active-searches", Integer.valueOf(++activeSearches));
                    map.put("complete", Boolean.valueOf(activeSearches <= 0));
                    SearchInstance searchInstance = manager.searchRCM(parameters, new SearchObserver(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void resultReceived(SearchInstance search, SearchResult result) {
                            Map map = RCMPlugin.this.mapSearchResults;
                            synchronized (map) {
                                Map map2 = (Map)RCMPlugin.this.mapSearchResults.get(lookupID);
                                if (map2 == null) {
                                    return;
                                }
                                ArrayList<Map> list = MapUtils.getMapList(map2, "results", null);
                                if (list == null) {
                                    list = new ArrayList<Map>();
                                    map2.put("results", list);
                                }
                                SearchRelatedContent src = new SearchRelatedContent(result);
                                Map mapResult = RCMPlugin.this.relatedContentToMap(src);
                                list.add(mapResult);
                            }
                        }

                        @Override
                        public Object getProperty(int property) {
                            return null;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void complete() {
                            Map map = RCMPlugin.this.mapSearchResults;
                            synchronized (map) {
                                Map map2 = (Map)RCMPlugin.this.mapSearchResults.get(lookupID);
                                if (map2 == null) {
                                    return;
                                }
                                int activeSearches = MapUtils.getMapInt(map2, "active-searches", 0);
                                if (activeSearches > 0) {
                                    --activeSearches;
                                }
                                map2.put("active-searches", activeSearches);
                                map2.put("complete", activeSearches <= 0);
                            }
                        }

                        @Override
                        public void cancelled() {
                            this.complete();
                        }
                    });
                    break block9;
                }
                if (lookupByTorrent != null || lookupBySize > 0L) {
                    final String lookupID = lookupByTorrent != null ? lookupByTorrent : Integer.toHexString((String.valueOf(String.valueOf(lookupBySize)) + net_str).hashCode());
                    result.put("lid", lookupID);
                    HashMap<String, Constable> map = this.mapSearchResults.get(lookupID);
                    if (map == null) {
                        map = new HashMap<String, Constable>();
                        this.mapSearchResults.put(lookupID, map);
                    }
                    int activeSearches = MapUtils.getMapInt(map, "active-searches", 0);
                    map.put("active-searches", Integer.valueOf(++activeSearches));
                    map.put("complete", Boolean.valueOf(activeSearches <= 0));
                    RelatedContentLookupListener l = new RelatedContentLookupListener(){

                        @Override
                        public void lookupStart() {
                        }

                        @Override
                        public void lookupFailed(ContentException error) {
                            this.lookupComplete();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void lookupComplete() {
                            Map map = RCMPlugin.this.mapSearchResults;
                            synchronized (map) {
                                Map map2 = (Map)RCMPlugin.this.mapSearchResults.get(lookupID);
                                if (map2 == null) {
                                    return;
                                }
                                int activeSearches = MapUtils.getMapInt(map2, "active-searches", 0);
                                if (activeSearches > 0) {
                                    --activeSearches;
                                }
                                map2.put("active-searches", activeSearches);
                                map2.put("complete", activeSearches <= 0);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void contentFound(RelatedContent[] content2) {
                            Map map = RCMPlugin.this.mapSearchResults;
                            synchronized (map) {
                                Map map2 = (Map)RCMPlugin.this.mapSearchResults.get(lookupID);
                                if (map2 == null) {
                                    return;
                                }
                                ArrayList<Map> list = MapUtils.getMapList(map2, "results", null);
                                if (list == null) {
                                    list = new ArrayList<Map>();
                                    map2.put("results", list);
                                }
                                RelatedContent[] relatedContentArray = content2;
                                int n = content2.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    RelatedContent item = relatedContentArray[n2];
                                    Map mapResult = RCMPlugin.this.relatedContentToMap(item);
                                    list.add(mapResult);
                                    ++n2;
                                }
                            }
                        }
                    };
                    if (lookupByTorrent != null) {
                        byte[] hash = ByteFormatter.decodeString(lookupByTorrent);
                        manager.lookupContent(hash, networks, l);
                    } else if (lookupBySize > 0L) {
                        manager.lookupContent(lookupBySize, l);
                    }
                    break block9;
                }
                throw new PluginException("No search-term, torrent-hash or file-size");
            }
            catch (Exception e) {
                throw new PluginException(e);
            }
        }
    }

    protected void rpcLookupRemove(Map result, Map args) throws PluginException {
        String lid = MapUtils.getMapString(args, "lid", null);
        if (lid == null) {
            throw new PluginException("No Lookup ID");
        }
        this.mapSearchInstances.remove(lid);
        this.mapSearchResults.remove(lid);
    }

    protected void rpcLookupGetResults(Map result, Map args) throws PluginException {
        long since = MapUtils.getMapLong(args, "since", 0L);
        Map map = this.mapSearchResults.get(MapUtils.getMapString(args, "lid", null));
        if (map == null) {
            throw new PluginException("No results for Lookup ID");
        }
        result.putAll(map);
    }

    protected void rpcGetList(Map result, Map args) throws PluginException {
        long since = MapUtils.getMapLong(args, "since", 0L);
        long until = 0L;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        result.put("related", list);
        try {
            RelatedContent[] relatedContent;
            RelatedContentManager manager = RelatedContentManager.getSingleton();
            RelatedContent[] relatedContentArray = relatedContent = manager.getRelatedContent();
            int n = relatedContent.length;
            int n2 = 0;
            while (n2 < n) {
                long changedLocallyOn;
                RelatedContent item = relatedContentArray[n2];
                if (this.isVisible(item) && (changedLocallyOn = item.getChangedLocallyOn()) >= since) {
                    if (changedLocallyOn > until) {
                        until = changedLocallyOn;
                    }
                    Map<String, Object> map = this.relatedContentToMap(item);
                    list.add(map);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
        result.put("until", until);
    }

    private Map<String, Object> relatedContentToMap(RelatedContent item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long changedLocallyOn = item.getChangedLocallyOn();
        map.put("changedOn", changedLocallyOn);
        map.put("contentNetwork", item.getContentNetwork());
        map.put("hash", ByteFormatter.encodeString(item.getHash()));
        map.put("lastSeenSecs", item.getLastSeenSecs());
        map.put("peers", item.getLeechers());
        map.put("level", item.getLevel());
        map.put("publishDate", item.getPublishDate());
        map.put("rank", item.getRank());
        map.put("relatedToHash", ByteFormatter.encodeString(item.getRelatedToHash()));
        map.put("seeds", item.getSeeds());
        map.put("size", item.getSize());
        map.put("tags", item.getTags());
        map.put("title", item.getTitle());
        map.put("tracker", item.getTracker());
        map.put("unread", item.isUnread());
        return map;
    }

    protected void updatePluginInfo() {
        String plugin_info = !this.hasFTUXBeenShown() ? "f" : (this.isRCMEnabled() ? "e" : "d");
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        if (!pc.getPluginStringParameter("plugin.info", "").equals(plugin_info)) {
            pc.setPluginParameter("plugin.info", plugin_info);
            COConfigurationManager.save();
        }
    }

    protected boolean isRCMEnabled() {
        return COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true);
    }

    protected boolean setRCMEnabled(boolean enabled) {
        if (this.isRCMEnabled() != enabled) {
            COConfigurationManager.setParameter("rcm.overall.enabled", enabled);
            this.hookSearch();
            this.updatePluginInfo();
            return true;
        }
        return false;
    }

    protected boolean hasFTUXBeenShown() {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter(PARAM_FTUX_SHOWN, false);
    }

    protected void setFTUXBeenShown(boolean b) {
        this.plugin_interface.getPluginconfig().setPluginParameter(PARAM_FTUX_SHOWN, b);
        this.hookSearch();
        this.updatePluginInfo();
    }

    protected boolean isUIEnabled() {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter("rcm.ui.enable", false);
    }

    protected void setUIEnabled(boolean b) {
        this.plugin_interface.getPluginconfig().setPluginParameter("rcm.ui.enable", b);
    }

    protected boolean isSearchEnabled() {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter("rcm.search.enable", false);
    }

    protected void setSearchEnabled(boolean b) {
        this.plugin_interface.getPluginconfig().setPluginParameter("rcm.search.enable", b);
    }

    protected int getMinuumSearchRank() {
        return this.plugin_interface.getPluginconfig().getPluginIntParameter("rcm.search.min_rank", 0);
    }

    public SearchProvider getSearchProvider() {
        return this.search_provider;
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected void hookSearch() {
        boolean enable = this.isRCMEnabled() && this.isSearchEnabled() && this.hasFTUXBeenShown();
        try {
            Utilities utilities = this.plugin_interface.getUtilities();
            if (enable) {
                if (this.search_provider == null) {
                    this.search_provider = new RCM_SearchProvider(this);
                    utilities.registerSearchProvider(this.search_provider);
                }
            } else if (this.search_provider != null) {
                utilities.unregisterSearchProvider(this.search_provider);
                this.search_provider = null;
            }
        }
        catch (Throwable e) {
            Debug.out("Failed to register/unregister search provider", e);
        }
    }

    private void updateSourcesList() {
        List<String> list = this.getSourcesList();
        this.source_map.clear();
        this.source_map_wildcard = false;
        for (String host : list) {
            if (host.equals("*")) {
                this.source_map_wildcard = true;
                continue;
            }
            this.source_map.put(this.compressDomain(host), Boolean.TRUE);
        }
    }

    public List<String> getSourcesList() {
        List original_list = COConfigurationManager.getListParameter(PARAM_SOURCES_LIST, this.source_map_defaults);
        List list = BDecoder.decodeStrings(BEncoder.cloneList(original_list));
        return list;
    }

    public void setToDefaultSourcesList() {
        COConfigurationManager.setParameter(PARAM_SOURCES_LIST, this.source_map_defaults);
    }

    public void setToAllSources() {
        COConfigurationManager.setParameter(PARAM_SOURCES_LIST, Arrays.asList("*"));
    }

    public boolean isAllSources() {
        return this.source_map_wildcard;
    }

    public boolean isVisible(long cnet) {
        if (cnet == 3L) {
            return this.isVisible(this.source_vhdn);
        }
        return false;
    }

    public boolean isVisible(byte[] key_list) {
        if (this.source_map_wildcard) {
            return true;
        }
        if (key_list != null) {
            int i = 0;
            while (i < key_list.length) {
                Boolean b = this.source_map.get(key_list, i, 4);
                if (b != null && b.booleanValue()) {
                    return true;
                }
                i += 4;
            }
        }
        return false;
    }

    public boolean isVisible(RelatedContent related_content) {
        if (this.source_map_wildcard) {
            return true;
        }
        long cnet = related_content.getContentNetwork();
        byte[] tracker_keys = cnet == 3L ? this.source_vhdn : related_content.getTrackerKeys();
        if (this.isVisible(tracker_keys)) {
            return true;
        }
        byte[] ws_keys = related_content.getWebSeedKeys();
        return this.isVisible(ws_keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() throws PluginException {
        RCMPlugin rCMPlugin = this;
        synchronized (rCMPlugin) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        if (this.ui != null) {
            this.ui.destroy();
            this.ui = null;
        }
        if (this.search_provider != null) {
            try {
                this.plugin_interface.getUtilities().unregisterSearchProvider(this.search_provider);
                this.search_provider = null;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (this.json_rpc_server != null) {
            this.plugin_interface.getUtilities().unregisterJSONRPCServer((Utilities.JSONServer)this.json_rpc_server);
            this.json_rpc_server = null;
        }
        if (this.mapSearchResults != null) {
            this.mapSearchResults.clear();
        }
        if (this.mapSearchInstances != null) {
            for (SearchInstance si : this.mapSearchInstances.values()) {
                try {
                    si.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.mapSearchInstances.clear();
        }
    }

    public void lookupByDownload(final Download download) throws IPCException {
        RelatedContentUI current_ui = this.ui;
        if (current_ui == null) {
            throw new IPCException("UI not bound");
        }
        if (!this.hasFTUXBeenShown() || !this.isRCMEnabled()) {
            current_ui.showFTUX(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    RelatedContentUI current_ui;
                    if (RCMPlugin.this.isRCMEnabled() && (current_ui = RCMPlugin.this.ui) != null) {
                        current_ui.setUIEnabled(true);
                        current_ui.addSearch(download);
                    }
                }
            });
        } else {
            current_ui.setUIEnabled(true);
            current_ui.addSearch(download);
        }
    }

    public void lookupBySize(long size) throws IPCException {
        this.lookupBySize(size, new String[]{"Public"});
    }

    public void lookupBySize(final long size, final String[] networks) throws IPCException {
        RelatedContentUI current_ui = this.ui;
        if (current_ui == null) {
            throw new IPCException("UI not bound");
        }
        if (!this.hasFTUXBeenShown() || !this.isRCMEnabled()) {
            current_ui.showFTUX(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    RelatedContentUI current_ui;
                    if (RCMPlugin.this.isRCMEnabled() && (current_ui = RCMPlugin.this.ui) != null) {
                        current_ui.setUIEnabled(true);
                        current_ui.addSearch(size, networks);
                    }
                }
            });
        } else {
            current_ui.setUIEnabled(true);
            current_ui.addSearch(size, networks);
        }
    }

    public void lookupByExpression(String expression) throws IPCException {
        this.lookupByExpression(expression, new String[]{"Public"});
    }

    public void lookupByExpression(final String expression, final String[] networks) throws IPCException {
        RelatedContentUI current_ui = this.ui;
        if (current_ui == null) {
            throw new IPCException("UI not bound");
        }
        if (!this.hasFTUXBeenShown() || !this.isRCMEnabled()) {
            current_ui.showFTUX(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    RelatedContentUI current_ui;
                    if (RCMPlugin.this.isRCMEnabled() && (current_ui = RCMPlugin.this.ui) != null) {
                        current_ui.setUIEnabled(true);
                        current_ui.addSearch(expression, networks);
                    }
                }
            });
        } else {
            current_ui.setUIEnabled(true);
            current_ui.addSearch(expression, networks);
        }
    }

    public void lookupByHash(byte[] hash, String name) throws IPCException {
        this.lookupByHash(hash, new String[]{"Public"}, name);
    }

    public void lookupByHash(final byte[] hash, final String[] networks, final String name) throws IPCException {
        RelatedContentUI current_ui = this.ui;
        if (current_ui == null) {
            throw new IPCException("UI not bound");
        }
        if (!this.hasFTUXBeenShown() || !this.isRCMEnabled()) {
            current_ui.showFTUX(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    RelatedContentUI current_ui;
                    if (RCMPlugin.this.isRCMEnabled() && (current_ui = RCMPlugin.this.ui) != null) {
                        current_ui.setUIEnabled(true);
                        current_ui.addSearch(hash, networks, name);
                    }
                }
            });
        } else {
            current_ui.setUIEnabled(true);
            current_ui.addSearch(hash, networks, name);
        }
    }

    public static String getNetworkString(String[] networks) {
        if (networks == null || networks.length == 0) {
            return "";
        }
        if (networks.length == 1) {
            if (networks[0] != "Public") {
                return " [" + networks[0] + "]";
            }
            return "";
        }
        String str = "";
        String[] stringArray = networks;
        int n = networks.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + net;
            ++n2;
        }
        return " [" + str + "]";
    }

    public static String getMagnetURI(RelatedContent rc) {
        String uri = UrlUtils.getMagnetURI(rc.getHash(), rc.getTitle(), rc.getNetworks());
        String[] tags = rc.getTags();
        if (tags != null) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                uri = String.valueOf(uri) + "&tag=" + UrlUtils.encode(tag);
                ++n2;
            }
        }
        return uri;
    }
}

