/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.plugins.rcmplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;

public class RCMPatcher {
    protected RCMPatcher() {
        this.applyPatches();
    }

    private void applyPatches() {
        try {
            this.applyPatch1();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.applyPatch2();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void applyPatch1() {
        String key;
        if (Constants.isOSX && ("5.7.3.1_CVS".startsWith("4.8.0.0") || "5.7.3.1_CVS".startsWith("4.8.0.1")) && !COConfigurationManager.doesParameterNonDefaultExist(key = "Default save path")) {
            String docPath = SystemProperties.getDocPath();
            File f = new File(docPath, "Azureus Downloads");
            if (!f.exists()) {
                f = new File(docPath, "Vuze Downloads");
            }
            Debug.out("Hack: Updating default save path from '" + COConfigurationManager.getParameter(key) + "' to '" + f.getAbsolutePath() + "'");
            COConfigurationManager.setParameter(key, f.getAbsolutePath());
            COConfigurationManager.save();
        }
    }

    private void applyPatch2() {
        block32: {
            if (Constants.isCurrentVersionLT("4.9.0.2 ")) {
                try {
                    if (COConfigurationManager.getBooleanParameter("rcmplugin.patcher.2.done.2", false)) {
                        return;
                    }
                    try {
                        InputStream is;
                        String truststore_name;
                        boolean copy_certs;
                        String KEYSTORE_TYPE;
                        block31: {
                            KEYSTORE_TYPE = null;
                            String[] types = new String[]{"JKS", "GKR", "BKS"};
                            int i = 0;
                            while (i < types.length) {
                                try {
                                    KeyStore.getInstance(types[i]);
                                    KEYSTORE_TYPE = types[i];
                                    break;
                                }
                                catch (Throwable throwable) {
                                    ++i;
                                }
                            }
                            if (KEYSTORE_TYPE == null) {
                                KEYSTORE_TYPE = "JKS";
                            }
                            copy_certs = false;
                            KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
                            truststore_name = FileUtil.getUserFile(".certs").getAbsolutePath();
                            File truststore_file = new File(truststore_name);
                            if (!truststore_file.exists() || truststore_file.length() < 512L) {
                                copy_certs = true;
                            } else {
                                try {
                                    FileInputStream in = null;
                                    try {
                                        in = new FileInputStream(truststore_name);
                                        keystore.load(in, "changeit".toCharArray());
                                    }
                                    finally {
                                        if (in != null) {
                                            in.close();
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    copy_certs = true;
                                }
                            }
                            if (!copy_certs) {
                                try {
                                    new URL("https://pair.vuze.com/pairing").openConnection().getInputStream();
                                }
                                catch (Throwable e) {
                                    String str = Debug.getNestedExceptionMessage(e);
                                    System.err.println(str);
                                    e.printStackTrace();
                                    if (!str.contains("CertificateParsingException") && !str.contains("NoSuchAlgorithmException") && !str.contains("InvalidAlgorithm")) break block31;
                                    copy_certs = true;
                                }
                            }
                        }
                        if (!copy_certs || (is = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/plugins/rcmplugin/resources/cacerts.def")) == null) break block32;
                        try {
                            FileUtil.copyFile(is, new File(truststore_name));
                            KeyStore new_keystore = KeyStore.getInstance(KEYSTORE_TYPE);
                            FileInputStream in = null;
                            try {
                                in = new FileInputStream(truststore_name);
                                new_keystore.load(in, "changeit".toCharArray());
                                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                                tmf.init(new_keystore);
                                SSLContext ctx = SSLContext.getInstance("SSL");
                                ctx.init(null, tmf.getTrustManagers(), null);
                                SSLSocketFactory factory = ctx.getSocketFactory();
                                HttpsURLConnection.setDefaultSSLSocketFactory(factory);
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
                finally {
                    COConfigurationManager.setParameter("rcmplugin.patcher.2.done.2", true);
                }
            }
        }
    }
}

