/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.services;

import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.UPnPStateVariable;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import com.aelitis.net.upnp.impl.services.UPnPActionImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSOfflineDownloaderImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANCommonInterfaceConfigImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANIPConnectionImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANPPPConnectionImpl;
import com.aelitis.net.upnp.impl.services.UPnPStateVariableImpl;
import com.aelitis.net.upnp.services.UPnPSpecificService;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPServiceImpl
implements UPnPService {
    private final UPnPDeviceImpl device;
    private String service_type;
    private String local_desc_url;
    private String local_control_url;
    private List actions;
    private List state_vars;
    private boolean direct_invoke;
    private URL preferred_control_url;

    public UPnPServiceImpl(UPnPDeviceImpl _device, String indent, SimpleXMLParserDocumentNode service_node) {
        this.device = _device;
        this.service_type = service_node.getChild("ServiceType").getValue().trim();
        this.local_desc_url = service_node.getChild("SCPDURL").getValue();
        this.local_control_url = service_node.getChild("controlURL").getValue();
        this.device.getUPnP().log(String.valueOf(indent) + this.service_type + ":desc=" + this.device.getAbsoluteURL(this.local_desc_url) + ", control=" + this.device.getAbsoluteURL(this.local_control_url));
    }

    @Override
    public UPnPDevice getDevice() {
        return this.device;
    }

    @Override
    public String getServiceType() {
        return this.service_type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isConnectable() {
        try {
            List<URL> urls = this.getControlURLs();
            Iterator<URL> iterator = urls.iterator();
            if (!iterator.hasNext()) return false;
            URL url = iterator.next();
            Socket socket = new Socket();
            try {
                int port = url.getPort();
                if (port <= 0) {
                    port = url.getDefaultPort();
                }
                socket.connect(new InetSocketAddress(url.getHost(), port), 5000);
                if (this.getPreferredControlURL() != null) return true;
                this.setPreferredControlURL(url);
                return true;
            }
            finally {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable3) {
            // empty catch block
        }
        return false;
    }

    @Override
    public UPnPAction[] getActions() throws UPnPException {
        if (this.actions == null) {
            this.loadDescription();
        }
        UPnPAction[] res = new UPnPAction[this.actions.size()];
        this.actions.toArray(res);
        return res;
    }

    @Override
    public UPnPAction getAction(String name) throws UPnPException {
        UPnPAction[] my_actions = this.getActions();
        int i = 0;
        while (i < my_actions.length) {
            if (my_actions[i].getName().equalsIgnoreCase(name)) {
                return my_actions[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public UPnPStateVariable[] getStateVariables() throws UPnPException {
        if (this.state_vars == null) {
            this.loadDescription();
        }
        UPnPStateVariable[] res = new UPnPStateVariable[this.state_vars.size()];
        this.state_vars.toArray(res);
        return res;
    }

    @Override
    public UPnPStateVariable getStateVariable(String name) throws UPnPException {
        UPnPStateVariable[] vars = this.getStateVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equalsIgnoreCase(name)) {
                return vars[i];
            }
            ++i;
        }
        return null;
    }

    public URL getDescriptionURL() throws UPnPException {
        return this.getURL(this.device.getAbsoluteURL(this.local_desc_url));
    }

    @Override
    public List<URL> getControlURLs() throws UPnPException {
        ArrayList<URL> result = new ArrayList<URL>();
        String control_url = this.device.getAbsoluteURL(this.local_control_url);
        URL main_url = this.getURL(control_url);
        result.add(main_url);
        List<URL> alt_locs = this.device.getRootDevice().getAlternativeLocations();
        if (alt_locs.size() > 0) {
            for (URL alt_loc : alt_locs) {
                URL alt_url = main_url;
                alt_url = UrlUtils.setHost(alt_url, alt_loc.getHost());
                alt_url = UrlUtils.setPort(alt_url, alt_loc.getPort());
                result.add(alt_url);
            }
        }
        if (result.size() > 1 && this.preferred_control_url != null && !((URL)result.get(0)).equals(this.preferred_control_url) && result.contains(this.preferred_control_url)) {
            result.remove(this.preferred_control_url);
            result.add(0, this.preferred_control_url);
        }
        return result;
    }

    @Override
    public void setPreferredControlURL(URL url) {
        this.preferred_control_url = url;
    }

    protected URL getPreferredControlURL() {
        return this.preferred_control_url;
    }

    protected URL getURL(String basis) throws UPnPException {
        try {
            URL target;
            String lc_basis = basis.toLowerCase();
            if (lc_basis.startsWith("http") || lc_basis.startsWith("https")) {
                target = new URL(basis);
            } else {
                URL root_location = this.device.getRootDevice().getLocation();
                target = new URL(String.valueOf(root_location.getProtocol()) + "://" + root_location.getHost() + (root_location.getPort() == -1 ? "" : ":" + root_location.getPort()) + (basis.startsWith("/") ? "" : "/") + basis);
            }
            return target;
        }
        catch (MalformedURLException e) {
            throw new UPnPException("Malformed URL", e);
        }
    }

    protected void loadDescription() throws UPnPException {
        SimpleXMLParserDocument doc = this.device.getUPnP().downloadXML(this.device, this.getDescriptionURL());
        this.parseActions(doc.getChild("ActionList"));
        this.parseStateVars(doc.getChild("ServiceStateTable"));
    }

    protected void parseActions(SimpleXMLParserDocumentNode action_list) {
        this.actions = new ArrayList();
        SimpleXMLParserDocumentNode[] kids = action_list.getChildren();
        int i = 0;
        while (i < kids.length) {
            this.actions.add(new UPnPActionImpl(this, kids[i]));
            ++i;
        }
    }

    protected void parseStateVars(SimpleXMLParserDocumentNode action_list) {
        this.state_vars = new ArrayList();
        SimpleXMLParserDocumentNode[] kids = action_list.getChildren();
        int i = 0;
        while (i < kids.length) {
            this.state_vars.add(new UPnPStateVariableImpl(this, kids[i]));
            ++i;
        }
    }

    @Override
    public UPnPSpecificService getSpecificService() {
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1")) {
            return new UPnPSSWANIPConnectionImpl(this);
        }
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
            return new UPnPSSWANPPPConnectionImpl(this);
        }
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1")) {
            return new UPnPSSWANCommonInterfaceConfigImpl(this);
        }
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:VuzeOfflineDownloaderService:1")) {
            return new UPnPSSOfflineDownloaderImpl(this);
        }
        return null;
    }

    @Override
    public boolean getDirectInvocations() {
        return this.direct_invoke;
    }

    @Override
    public void setDirectInvocations(boolean force) {
        this.direct_invoke = force;
    }
}

