/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.natpmp.upnp.impl;

import com.aelitis.net.natpmp.NatPMPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NatPMPImpl {
    private NatPMPDevice natDevice;
    private List mappings = new ArrayList();

    public NatPMPImpl(NatPMPDevice device) throws UPnPException {
        try {
            this.natDevice = device;
        }
        catch (Exception e) {
            throw new UPnPException("Error in getting NatPMP Service!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortMapping(boolean tcp, int port, String description) throws UPnPException {
        try {
            this.natDevice.addPortMapping(tcp, port, port);
        }
        catch (Exception e) {
            throw new UPnPException("addPortMapping failed", e);
        }
        NatPMPImpl natPMPImpl = this;
        synchronized (natPMPImpl) {
            Iterator it = this.mappings.iterator();
            while (it.hasNext()) {
                portMapping m = (portMapping)it.next();
                if (m.getExternalPort() != port || m.isTCP() != tcp) continue;
                it.remove();
            }
            this.mappings.add(new portMapping(port, tcp, this.natDevice.getLocalAddress().getHostAddress(), description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePortMapping(boolean tcp, int port) throws UPnPException {
        try {
            this.natDevice.deletePortMapping(tcp, port, port);
        }
        catch (Exception e) {
            throw new UPnPException("deletePortMapping failed", e);
        }
        NatPMPImpl natPMPImpl = this;
        synchronized (natPMPImpl) {
            Iterator it = this.mappings.iterator();
            while (it.hasNext()) {
                portMapping m = (portMapping)it.next();
                if (m.getExternalPort() != port || m.isTCP() != tcp) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
        NatPMPImpl natPMPImpl = this;
        synchronized (natPMPImpl) {
            UPnPWANConnectionPortMapping[] res2 = new UPnPWANConnectionPortMapping[this.mappings.size()];
            this.mappings.toArray(res2);
            return res2;
        }
    }

    public String[] getStatusInfo() throws UPnPException {
        Object connection_status = null;
        Object connection_error = null;
        String uptime = null;
        uptime = "" + this.natDevice.getEpoch();
        return new String[]{connection_status, connection_error, uptime};
    }

    public String getExternalIPAddress() {
        return this.natDevice.getExternalIPAddress();
    }

    private static class portMapping
    implements UPnPWANConnectionPortMapping {
        protected int external_port;
        protected boolean tcp;
        protected String internal_host;
        protected String description;

        protected portMapping(int _external_port, boolean _tcp, String _internal_host, String _description) {
            this.external_port = _external_port;
            this.tcp = _tcp;
            this.internal_host = _internal_host;
            this.description = _description;
        }

        @Override
        public boolean isTCP() {
            return this.tcp;
        }

        @Override
        public int getExternalPort() {
            return this.external_port;
        }

        @Override
        public String getInternalHost() {
            return this.internal_host;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        protected String getString() {
            return String.valueOf(this.getDescription()) + " [" + this.getExternalPort() + ":" + (this.isTCP() ? "TCP" : "UDP") + "]";
        }
    }
}

