/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.util.MapUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.bouncycastle.util.encoders.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JSONUtils {
    public static Map decodeJSON(String json) {
        try {
            Object object = JSONValue.parse(json);
            if (object instanceof Map) {
                return (Map)object;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", object);
            return map;
        }
        catch (Throwable t) {
            Debug.out("Warning: Bad JSON String: " + json, t);
            return null;
        }
    }

    public static JSONObject encodeToJSONObject(Map map) {
        JSONObject newMap = new JSONObject((int)((double)map.size() * 1.5));
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof byte[]) {
                key = String.valueOf(key) + ".B64";
                value = Base64.encode((byte[])value);
            }
            value = JSONUtils.coerce(value);
            newMap.put(key, value);
        }
        return newMap;
    }

    public static String encodeToJSON(Map map) {
        JSONObject jobj = JSONUtils.encodeToJSONObject(map);
        StringBuilder sb = new StringBuilder(8192);
        jobj.toString(sb);
        return sb.toString();
    }

    public static String encodeToJSON(Collection list) {
        return JSONUtils.encodeToJSONArray(list).toString();
    }

    private static Object coerce(Object value) {
        if (value instanceof Map) {
            value = JSONUtils.encodeToJSONObject((Map)value);
        } else if (value instanceof List) {
            value = JSONUtils.encodeToJSONArray((List)value);
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            value = JSONUtils.encodeToJSONArray(Arrays.asList(array));
        } else if (value instanceof byte[]) {
            try {
                value = new String((byte[])value, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }

    private static JSONArray encodeToJSONArray(Collection list) {
        JSONArray newList = new JSONArray(list.size());
        for (Object value : list) {
            newList.add(JSONUtils.coerce(value));
        }
        return newList;
    }

    public static void main(String[] args) {
        HashMap<String, byte[]> mapBefore = new HashMap<String, byte[]>();
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] b = byArray;
        mapBefore.put("Hi", b);
        String jsonByteArray = JSONUtils.encodeToJSON(mapBefore);
        System.out.println(jsonByteArray);
        Map mapAfter = JSONUtils.decodeJSON(jsonByteArray);
        b = MapUtils.getMapByteArray(mapAfter, "Hi", null);
        System.out.println(b.length);
        int i = 0;
        while (i < b.length) {
            byte c = b[i];
            System.out.println("--" + c);
            ++i;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Test", "TestValue");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("Test2", "test2value");
        map.put("TestMap", map2);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Long(5L));
        list.add("five");
        map2.put("ListTest", list);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("Test3", "test3value");
        list.add(map3);
        System.out.println(JSONUtils.encodeToJSON(map));
        System.out.println(JSONUtils.encodeToJSON(list));
    }
}

