/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.DeviceOfflineDownload;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class DataSourceUtils {
    public static org.gudy.azureus2.core3.disk.DiskManagerFileInfo getFileInfo(Object ds) {
        try {
            if (ds instanceof DiskManagerFileInfo) {
                return PluginCoreUtils.unwrap((DiskManagerFileInfo)ds);
            }
            if (ds instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
                return (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)ds;
            }
            if (ds instanceof ISelectedContent && ((ISelectedContent)ds).getFileIndex() >= 0) {
                ISelectedContent sc = (ISelectedContent)ds;
                int idx = sc.getFileIndex();
                DownloadManager dm = sc.getDownloadManager();
                return dm.getDiskManagerFileInfoSet().getFiles()[idx];
            }
            if (ds instanceof TranscodeJob) {
                TranscodeJob tj = (TranscodeJob)ds;
                try {
                    return PluginCoreUtils.unwrap(tj.getFile());
                }
                catch (DownloadException idx) {
                }
            } else if (ds instanceof TranscodeFile) {
                TranscodeFile tf = (TranscodeFile)ds;
                try {
                    DiskManagerFileInfo file = tf.getSourceFile();
                    return PluginCoreUtils.unwrap(file);
                }
                catch (DownloadException downloadException) {}
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static DownloadManager getDM(Object ds) {
        try {
            org.gudy.azureus2.core3.disk.DiskManagerFileInfo fileInfo2;
            if (ds instanceof DownloadManager) {
                return (DownloadManager)ds;
            }
            if (ds instanceof VuzeActivitiesEntry) {
                String assetHash;
                VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
                DownloadManager dm = entry.getDownloadManger();
                if (dm == null && (assetHash = entry.getAssetHash()) != null && AzureusCoreFactory.isCoreRunning()) {
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    dm = gm.getDownloadManager(new HashWrapper(Base32.decode(assetHash)));
                    entry.setDownloadManager(dm);
                }
                return dm;
            }
            if (ds instanceof TOTorrent && AzureusCoreFactory.isCoreRunning()) {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                return gm.getDownloadManager((TOTorrent)ds);
            }
            if (ds instanceof ISelectedContent) {
                return DataSourceUtils.getDM(((ISelectedContent)ds).getDownloadManager());
            }
            if (ds instanceof TranscodeJob) {
                TranscodeJob tj = (TranscodeJob)ds;
                try {
                    Download download;
                    DiskManagerFileInfo file = tj.getFile();
                    if (file != null && (download = tj.getFile().getDownload()) != null) {
                        return PluginCoreUtils.unwrap(download);
                    }
                }
                catch (DownloadException file) {}
            } else if (ds instanceof TranscodeFile) {
                TranscodeFile tf = (TranscodeFile)ds;
                try {
                    Download download;
                    DiskManagerFileInfo file = tf.getSourceFile();
                    if (file != null && (download = file.getDownload()) != null) {
                        return PluginCoreUtils.unwrap(download);
                    }
                }
                catch (DownloadException file) {}
            } else {
                Object hash;
                if (ds instanceof DeviceOfflineDownload) {
                    return PluginCoreUtils.unwrap(((DeviceOfflineDownload)ds).getDownload());
                }
                if (ds instanceof Download) {
                    return PluginCoreUtils.unwrap((Download)ds);
                }
                if (ds instanceof byte[]) {
                    hash = (byte[])ds;
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    DownloadManager dm = gm.getDownloadManager(new HashWrapper((byte[])hash));
                    if (dm != null) {
                        return dm;
                    }
                } else {
                    if (ds instanceof Object[]) {
                        Object[] o = (Object[])ds;
                        return DataSourceUtils.getDM(o[0]);
                    }
                    if (ds instanceof String && AzureusCoreFactory.isCoreRunning()) {
                        hash = (String)ds;
                        try {
                            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                            DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode((String)hash)));
                            if (dm != null) {
                                return dm;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if ((fileInfo2 = DataSourceUtils.getFileInfo(ds)) != null) {
                return fileInfo2.getDownloadManager();
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static TOTorrent getTorrent(Object ds) {
        DownloadManager dm;
        Torrent torrent;
        Download download;
        DiskManagerFileInfo file2;
        Object torrent2;
        if (ds instanceof TOTorrent) {
            return (TOTorrent)ds;
        }
        if (ds instanceof DownloadManager && (torrent2 = ((DownloadManager)ds).getTorrent()) != null) {
            return torrent2;
        }
        if (ds instanceof VuzeActivitiesEntry) {
            DownloadManager dm2;
            torrent2 = ((VuzeActivitiesEntry)ds).getTorrent();
            if (torrent2 == null && (dm2 = DataSourceUtils.getDM(ds)) != null) {
                torrent2 = dm2.getTorrent();
            }
            return torrent2;
        }
        if (ds instanceof TranscodeFile) {
            TranscodeFile tf = (TranscodeFile)ds;
            try {
                file2 = tf.getSourceFile();
                if (file2 != null && (download = file2.getDownload()) != null && (torrent = download.getTorrent()) != null) {
                    return PluginCoreUtils.unwrap(torrent);
                }
            }
            catch (Throwable file2) {
                // empty catch block
            }
        }
        if (ds instanceof TranscodeJob) {
            TranscodeJob tj = (TranscodeJob)ds;
            try {
                file2 = tj.getFile();
                if (file2 != null && (download = tj.getFile().getDownload()) != null && (torrent = download.getTorrent()) != null) {
                    return PluginCoreUtils.unwrap(torrent);
                }
            }
            catch (DownloadException file3) {
                // empty catch block
            }
        }
        if (ds instanceof DeviceOfflineDownload && (torrent2 = ((DeviceOfflineDownload)ds).getDownload().getTorrent()) != null) {
            return PluginCoreUtils.unwrap((Torrent)torrent2);
        }
        if (ds instanceof ISelectedContent) {
            return ((ISelectedContent)ds).getTorrent();
        }
        if (ds instanceof String) {
            String hash = (String)ds;
            try {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                DownloadManager dm3 = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                if (dm3 != null) {
                    return dm3.getTorrent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((dm = DataSourceUtils.getDM(ds)) != null) {
            return dm.getTorrent();
        }
        return null;
    }

    public static boolean isPlatformContent(Object ds) {
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent != null) {
            return PlatformTorrentUtils.isContent(torrent, true);
        }
        return ds instanceof VuzeActivitiesEntry;
    }

    public static String getHash(Object ds) {
        try {
            if (ds instanceof VuzeActivitiesEntry) {
                VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
                return entry.getAssetHash();
            }
            if (ds instanceof ISelectedContent) {
                return ((ISelectedContent)ds).getHash();
            }
            if (ds instanceof byte[]) {
                return Base32.encode((byte[])ds);
            }
            if (ds instanceof String) {
                return (String)ds;
            }
            TOTorrent torrent = DataSourceUtils.getTorrent(ds);
            if (torrent != null) {
                return torrent.getHashWrapper().toBase32String();
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static DownloadUrlInfo getDownloadInfo(Object ds) {
        if (ds instanceof ISelectedContent) {
            return ((ISelectedContent)ds).getDownloadInfo();
        }
        return null;
    }
}

