/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.rpc;

import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientException;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientTunnel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.gudy.azureus2.core3.util.SystemTime;
import org.json.simple.JSONObject;

public class XMRPCClientTunnelHandler
implements XMRPCClient {
    private String tunnel_server;
    private String access_code;
    private String tunnel_user;
    private String tunnel_password;
    private XMRPCClientTunnel current_tunnel;
    private AtomicInteger active_calls = new AtomicInteger();
    private boolean destroyed;
    private long wait_until;
    private int consecutive_fails;
    private XMRPCClientException last_error;
    private long last_create;

    public XMRPCClientTunnelHandler(String _tunnel_server, String _access_code, String _tunnel_user, String _tunnel_password) {
        this.tunnel_server = _tunnel_server;
        this.access_code = _access_code;
        this.tunnel_user = _tunnel_user;
        this.tunnel_password = _tunnel_password;
        this.createTunnel();
    }

    private void createTunnel() {
        if (this.current_tunnel != null) {
            this.current_tunnel.destroy();
        }
        this.last_create = SystemTime.getMonotonousTime();
        this.current_tunnel = new XMRPCClientTunnel(this.tunnel_server, this.access_code, this.tunnel_user, this.tunnel_password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOK() {
        XMRPCClientTunnelHandler xMRPCClientTunnelHandler = this;
        synchronized (xMRPCClientTunnelHandler) {
            this.wait_until = 0L;
            this.consecutive_fails = 0;
            this.last_error = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callFailed(XMRPCClientException exception) {
        XMRPCClientTunnelHandler xMRPCClientTunnelHandler = this;
        synchronized (xMRPCClientTunnelHandler) {
            long now;
            block13: {
                block12: {
                    block11: {
                        int type;
                        block10: {
                            ++this.consecutive_fails;
                            this.last_error = exception;
                            now = SystemTime.getCurrentTime();
                            type = exception.getType();
                            if (type != 5) break block10;
                            return false;
                        }
                        if (type != 2 && type != 3) break block11;
                        int delay = this.consecutive_fails * 30 * 1000;
                        if (delay > 120000) {
                            delay = 120000;
                        }
                        this.wait_until = now + (long)delay;
                        this.createTunnel();
                        return false;
                    }
                    if (this.consecutive_fails >= 2) break block12;
                    return true;
                }
                if (this.consecutive_fails != 2) break block13;
                this.createTunnel();
                return true;
            }
            int delay = 1000;
            int i = 1;
            while (i < this.consecutive_fails) {
                if ((delay <<= 2) > 120000) {
                    delay = 120000;
                    break;
                }
                ++i;
            }
            this.wait_until = now + (long)delay;
            this.createTunnel();
            return this.consecutive_fails == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isCallPermitted() throws XMRPCClientException {
        XMRPCClientTunnelHandler xMRPCClientTunnelHandler = this;
        synchronized (xMRPCClientTunnelHandler) {
            long now = SystemTime.getCurrentTime();
            long rem = this.wait_until - now;
            if (rem > 0L) {
                if ((rem /= 1000L) == 0L) {
                    rem = 1L;
                }
                throw new XMRPCClientException("Tunnel unavailable for a further " + rem + "s due to failure", this.last_error);
            }
            if (this.consecutive_fails > 5 && this.active_calls.get() > 0) {
                throw new XMRPCClientException("Tunnel under construction - request refused", this.last_error);
            }
        }
    }

    @Override
    public JSONObject call(JSONObject request2) throws XMRPCClientException {
        while (true) {
            this.isCallPermitted();
            try {
                this.active_calls.incrementAndGet();
                JSONObject result = this.current_tunnel.call(request2);
                this.callOK();
                JSONObject jSONObject = result;
                return jSONObject;
            }
            catch (XMRPCClientException e) {
                if (this.callFailed(e)) continue;
                throw e;
            }
            finally {
                this.active_calls.decrementAndGet();
                continue;
            }
            break;
        }
    }

    @Override
    public XMRPCClient.HTTPResponse call(String method, String url, Map<String, String> headers, byte[] data) throws XMRPCClientException {
        while (true) {
            this.isCallPermitted();
            try {
                this.active_calls.incrementAndGet();
                XMRPCClient.HTTPResponse result = this.current_tunnel.call(method, url, headers, data);
                this.callOK();
                XMRPCClient.HTTPResponse hTTPResponse = result;
                return hTTPResponse;
            }
            catch (XMRPCClientException e) {
                if (this.callFailed(e)) continue;
                throw e;
            }
            finally {
                this.active_calls.decrementAndGet();
                continue;
            }
            break;
        }
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.current_tunnel != null) {
            this.current_tunnel.destroy();
            this.current_tunnel = null;
        }
    }
}

