/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.rpc;

import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientException;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.bouncycastle.crypto.agreement.srp.SRP6Client;
import org.gudy.bouncycastle.crypto.digests.SHA256Digest;
import org.gudy.bouncycastle.util.encoders.Hex;
import org.json.simple.JSONObject;

public class XMRPCClientTunnel
implements XMRPCClient {
    private static final BigInteger N_3072 = XMRPCClientTunnel.fromHex("FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 29024E088A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD EF9519B3 CD3A431B302B0A6D F25F1437 4FE1356D 6D51C245 E485B576 625E7EC6 F44C42E9A637ED6B 0BFF5CB6 F406B7ED EE386BFB 5A899FA5 AE9F2411 7C4B1FE649286651 ECE45B3D C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8FD24CF5F 83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B E39E772C180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9 DE2BCBF6 955817183995497C EA956AE5 15D22618 98FA0510 15728E5A 8AAAC42D AD33170D04507A33 A85521AB DF1CBA64 ECFB8504 58DBEF0A 8AEA7157 5D060C7DB3970F85 A6E1E4C7 ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D2261AD2EE6B F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200CBBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31 43DB5BFCE0FD108E 4B82D120 A93AD2CA FFFFFFFF FFFFFFFF");
    private static final BigInteger G_3072 = BigInteger.valueOf(5L);
    private static SecureRandom rand = new SecureRandom();
    private XMRPCClientUtils utils = new XMRPCClientUtils();
    private String tunnel_server;
    private String basic_user = "vuze";
    private String access_code;
    private String username;
    private String password;
    private final long my_tunnel_id = rand.nextLong();
    private SecretKeySpec _secret;
    private String _tunnel_url;
    private int calls_ok;
    private boolean destroyed;
    private int calls_active;

    private static BigInteger fromHex(String hex) {
        return new BigInteger(1, Hex.decode(hex.replaceAll(" ", "")));
    }

    public XMRPCClientTunnel(String ts, String ac, String tunnel_user, String tunnel_password) {
        this.tunnel_server = ts;
        this.access_code = ac;
        this.username = tunnel_user;
        this.password = tunnel_password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] getCurrentTunnel(boolean for_destroy) throws XMRPCClientException {
        XMRPCClientTunnel xMRPCClientTunnel = this;
        synchronized (xMRPCClientTunnel) {
            if (for_destroy) {
                this.destroyed = true;
                if (this._tunnel_url == null) {
                    return null;
                }
                Object[] result = new Object[]{this._tunnel_url, this._secret};
                this._secret = null;
                this._tunnel_url = null;
                return result;
            }
            if (this.destroyed) {
                throw new XMRPCClientException("Tunnel has been destroyed");
            }
            if (this._tunnel_url == null) {
                try {
                    byte[] I = this.username.getBytes("UTF-8");
                    byte[] P = this.password.getBytes("UTF-8");
                    String str = this.utils.getFromURL(String.valueOf(this.tunnel_server) + "pairing/tunnel/create?ac=" + this.access_code + "&sid=" + "xmwebui");
                    System.out.println("create result: " + str);
                    JSONObject map = (JSONObject)JSONUtils.decodeJSON(str);
                    JSONObject error = (JSONObject)map.get("error");
                    if (error != null) {
                        long code = (Long)error.get("code");
                        String msg = (String)error.get("msg");
                        if (code == 1L) {
                            throw new XMRPCClientException(2, msg);
                        }
                        if (code == 2L || code == 3L) {
                            throw new XMRPCClientException(3, msg);
                        }
                        if (code == 5L) {
                            throw new XMRPCClientException(5, msg);
                        }
                        throw new XMRPCClientException("Uknown error creating tunnel: " + str);
                    }
                    JSONObject result1 = (JSONObject)map.get("result");
                    byte[] salt = Base32.decode((String)result1.get("srp_salt"));
                    BigInteger B = new BigInteger(Base32.decode((String)result1.get("srp_b")));
                    String url = (String)result1.get("url");
                    SRP6Client client = new SRP6Client();
                    client.init(N_3072, G_3072, new SHA256Digest(), rand);
                    BigInteger A = client.generateClientCredentials(salt, I, P);
                    BigInteger client_secret = client.calculateSecret(B);
                    byte[] key = new byte[16];
                    System.arraycopy(client_secret.toByteArray(), 0, key, 0, 16);
                    this._secret = new SecretKeySpec(key, "AES");
                    this._tunnel_url = url;
                    Cipher encipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    encipher.init(1, this._secret);
                    AlgorithmParameters params = encipher.getParameters();
                    byte[] IV = params.getParameterSpec(IvParameterSpec.class).getIV();
                    JSONObject activate = new JSONObject();
                    activate.put("url", url);
                    activate.put("endpoint", "/transmission/rpc?tunnel_format=h");
                    activate.put("rnd", (Object)rand.nextLong());
                    byte[] activate_bytes = JSONUtils.encodeToJSON(activate).getBytes("UTF-8");
                    byte[] enc = encipher.doFinal(activate_bytes);
                    String str2 = this.utils.getFromURL(String.valueOf(url) + "?srp_a=" + Base32.encode(A.toByteArray()) + "&enc_data=" + Base32.encode(enc) + "&enc_iv=" + Base32.encode(IV) + "&ac=" + this.access_code);
                    JSONObject map2 = (JSONObject)JSONUtils.decodeJSON(str2);
                    JSONObject error2 = (JSONObject)map2.get("error");
                    if (error2 != null) {
                        String msg = (String)error2.get("msg");
                        XMRPCClientException e = new XMRPCClientException("Authentication failed: " + msg);
                        e.setType(4);
                        throw e;
                    }
                    JSONObject result2 = (JSONObject)map2.get("result");
                    System.out.println(result2);
                }
                catch (XMRPCClientException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new XMRPCClientException("Failed to create tunnel", e);
                }
            }
            return new Object[]{this._tunnel_url, this._secret};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject call(JSONObject request2) throws XMRPCClientException {
        XMRPCClientTunnel xMRPCClientTunnel;
        JSONObject jSONObject;
        String method = (String)request2.get("method");
        Map args = (Map)request2.get("arguments");
        try {
            String reply_str;
            int reply_bytes_length;
            long start_time;
            block18: {
                XMRPCClientTunnel xMRPCClientTunnel2 = this;
                synchronized (xMRPCClientTunnel2) {
                    ++this.calls_active;
                }
                String json = JSONUtils.encodeToJSON(request2);
                start_time = SystemTime.getMonotonousTime();
                System.out.println(String.valueOf(TimeFormatter.milliStamp()) + "-> " + method + (args == null ? "" : ": " + args) + " (len=" + json.length() + ", active=" + this.calls_active + ")");
                byte[] req_bytes = json.getBytes("UTF-8");
                JSONObject request_headers = new JSONObject();
                request_headers.put("Accept-Encoding", "gzip");
                CallResult temp = this.call(request_headers, req_bytes);
                JSONObject reply_headers = temp.getHeaders();
                byte[] reply_bytes = temp.getBytes();
                int reply_bytes_offset = temp.getBytesOffset();
                reply_bytes_length = temp.getBytesLength();
                String http_status = (String)reply_headers.get("HTTP-Status");
                if (http_status != null && !http_status.equals("200")) {
                    throw new XMRPCClientException("Request failed: HTTP status " + http_status);
                }
                String encoding = (String)reply_headers.get("Content-Encoding");
                if (encoding != null && encoding.equals("gzip")) {
                    GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(reply_bytes, reply_bytes_offset, reply_bytes_length));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(reply_bytes_length);
                    byte[] buffer = new byte[131072];
                    while (true) {
                        int len;
                        if ((len = gis.read(buffer)) <= 0) {
                            reply_str = new String(baos.toByteArray(), "UTF-8");
                            break block18;
                        }
                        baos.write(buffer, 0, len);
                    }
                }
                reply_str = new String(reply_bytes, reply_bytes_offset, reply_bytes_length, "UTF-8");
            }
            int reply_len = reply_str.length();
            JSONObject reply = new JSONObject();
            reply.putAll(JSONUtils.decodeJSON(reply_str));
            System.out.println(String.valueOf(TimeFormatter.milliStamp()) + "<- " + method + " (len=" + reply_bytes_length + "/" + reply_len + ", elapsed=" + (SystemTime.getMonotonousTime() - start_time) + ")");
            jSONObject = reply;
            xMRPCClientTunnel = this;
        }
        catch (XMRPCClientException e) {
            try {
                System.out.println("<- " + method + ": " + Debug.getNestedExceptionMessage(e));
                throw e;
                catch (Throwable e2) {
                    System.out.println("<- " + method + ": " + Debug.getNestedExceptionMessage(e2));
                    throw new XMRPCClientException("Failed to use tunnel", e2);
                }
            }
            catch (Throwable throwable) {
                XMRPCClientTunnel xMRPCClientTunnel3 = this;
                synchronized (xMRPCClientTunnel3) {
                    --this.calls_active;
                    throw throwable;
                }
            }
        }
        synchronized (xMRPCClientTunnel) {
            --this.calls_active;
            return jSONObject;
        }
    }

    private CallResult call(JSONObject request_headers, byte[] request2) throws XMRPCClientException {
        if (request2 == null) {
            request2 = new byte[]{};
        }
        Object[] tunnel = this.getCurrentTunnel(false);
        String url = (String)tunnel[0];
        SecretKeySpec secret = (SecretKeySpec)tunnel[1];
        try {
            byte[] decrypted;
            request_headers.put("X-XMRPC-Tunnel-ID", String.valueOf(this.my_tunnel_id));
            String header_json = JSONUtils.encodeToJSON(request_headers);
            byte[] header_bytes = header_json.getBytes("UTF-8");
            int header_len = header_bytes.length;
            byte[] header_len_bytes = new byte[]{(byte)(header_len >> 8), (byte)header_len};
            Cipher encipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            encipher.init(1, secret);
            AlgorithmParameters params = encipher.getParameters();
            byte[] IV = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[][] enc_buffers = new byte[][]{encipher.update(header_len_bytes), encipher.update(header_bytes), encipher.doFinal(request2)};
            int enc_len = 0;
            byte[][] byArrayArray = enc_buffers;
            int n = enc_buffers.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] b = byArrayArray[n2];
                if (b != null) {
                    enc_len += b.length;
                }
                ++n2;
            }
            byte[] encrypted = new byte[IV.length + enc_len];
            System.arraycopy(IV, 0, encrypted, 0, IV.length);
            int enc_pos = IV.length;
            byte[][] byArrayArray2 = enc_buffers;
            int n3 = enc_buffers.length;
            n = 0;
            while (n < n3) {
                byte[] b = byArrayArray2[n];
                if (b != null) {
                    System.arraycopy(b, 0, encrypted, enc_pos, b.length);
                    enc_pos += b.length;
                }
                ++n;
            }
            byte[] reply_bytes = this.utils.postToURL(String.valueOf(url) + "?client=true", encrypted, this.basic_user, this.access_code);
            try {
                IV = new byte[16];
                System.arraycopy(reply_bytes, 0, IV, 0, IV.length);
                Cipher decipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                decipher.init(2, (Key)secret, new IvParameterSpec(IV));
                decrypted = decipher.doFinal(reply_bytes, 16, reply_bytes.length - 16);
            }
            catch (Throwable e) {
                XMRPCClientException error = new XMRPCClientException("decrypt failed: " + new String(reply_bytes, 0, reply_bytes.length > 256 ? 256 : reply_bytes.length), e);
                error.setType(4);
                throw error;
            }
            ++this.calls_ok;
            int reply_header_len = decrypted[0] << 8 & 0xFF00 | decrypted[1] & 0xFF;
            String reply_json_str = new String(decrypted, 2, reply_header_len, "UTF-8");
            JSONObject reply_headers = new JSONObject();
            reply_headers.putAll(JSONUtils.decodeJSON(reply_json_str));
            return new CallResult(reply_headers, decrypted, reply_header_len + 2);
        }
        catch (XMRPCClientException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new XMRPCClientException("Failed to use tunnel", e);
        }
    }

    @Override
    public XMRPCClient.HTTPResponse call(String method, String url, Map<String, String> headers, byte[] data) throws XMRPCClientException {
        System.out.println("Sending request: " + method + url + ": " + headers + " - " + data);
        try {
            int reply_data_offset;
            byte[] reply_data;
            JSONObject request_headers = new JSONObject();
            request_headers.putAll(headers);
            request_headers.put("HTTP-Method", method);
            request_headers.put("HTTP-URL", url);
            request_headers.put("Accept-Encoding", "gzip");
            CallResult temp = this.call(request_headers, data);
            JSONObject reply_headers = temp.getHeaders();
            byte[] reply_bytes = temp.getBytes();
            int reply_bytes_offset = temp.getBytesOffset();
            int reply_bytes_length = temp.getBytesLength();
            String http_status = (String)reply_headers.get("HTTP-Status");
            if (http_status != null && !http_status.equals("200")) {
                throw new XMRPCClientException("Request failed: HTTP status " + http_status);
            }
            String encoding = (String)reply_headers.get("Content-Encoding");
            if (encoding != null && encoding.equals("gzip")) {
                int len;
                GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(reply_bytes, reply_bytes_offset, reply_bytes_length));
                ByteArrayOutputStream baos = new ByteArrayOutputStream(reply_bytes_length);
                byte[] buffer = new byte[131072];
                while ((len = gis.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                reply_data = baos.toByteArray();
                reply_data_offset = 0;
            } else {
                reply_data = reply_bytes;
                reply_data_offset = reply_bytes_offset;
            }
            System.out.println("Received reply: " + reply_headers);
            return this.utils.createHTTPResponse(reply_headers, reply_data, reply_data_offset);
        }
        catch (XMRPCClientException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new XMRPCClientException("Failed to use tunnel", e);
        }
    }

    @Override
    public void destroy() {
        try {
            Object[] tunnel = this.getCurrentTunnel(true);
            if (tunnel != null) {
                this.utils.postToURL(String.valueOf((String)tunnel[0]) + "?client=true&close=true", new byte[0], this.basic_user, this.access_code);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class CallResult {
        private JSONObject headers;
        private byte[] buffer;
        private int offset;

        private CallResult(JSONObject _headers, byte[] _bytes, int _offset) {
            this.headers = _headers;
            this.buffer = _bytes;
            this.offset = _offset;
        }

        private JSONObject getHeaders() {
            return this.headers;
        }

        private byte[] getBytes() {
            return this.buffer;
        }

        private int getBytesOffset() {
            return this.offset;
        }

        private int getBytesLength() {
            return this.buffer.length - this.offset;
        }
    }
}

