/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.rpc;

import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientCached;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientDirect;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientIndirect;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientTunnelHandler;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class XMRPCClientFactory {
    static {
        try {
            if (System.getProperty("az.xmwebui.skip.ssl.hack", "false").equals("false")) {
                System.out.println("XMRPCClientFactory: installing SSL trust manager");
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory factory = sc.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(factory);
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String host, SSLSession session) {
                        return true;
                    }
                });
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static XMRPCClient createDirect(boolean http, String host, int port, String username, String password) {
        return new XMRPCClientDirect(http, host, port, username, password);
    }

    public static XMRPCClient createIndirect(String pair_server, String access_code) {
        return new XMRPCClientIndirect(pair_server, access_code);
    }

    public static XMRPCClient createTunnel(String tunnel_server, String access_code, String tunnel_user, String tunnel_password) {
        return new XMRPCClientTunnelHandler(tunnel_server, access_code, tunnel_user, tunnel_password);
    }

    public static XMRPCClient createCached(XMRPCClient base, int cache_millis) {
        return new XMRPCClientCached(base, cache_millis);
    }
}

