/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.rpc;

import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientException;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class XMRPCClientDirect
implements XMRPCClient {
    private XMRPCClientUtils utils = new XMRPCClientUtils();
    private boolean http;
    private String host;
    private int port;
    private String username;
    private String password;

    public XMRPCClientDirect(boolean _http, String _host, int _port, String _username, String _password) {
        this.http = _http;
        this.host = _host;
        this.port = _port;
        this.username = _username;
        this.password = _password;
    }

    @Override
    public JSONObject call(JSONObject request2) throws XMRPCClientException {
        try {
            String url = String.valueOf(this.http ? "http" : "https") + "://" + this.host + ":" + this.port + "/transmission/rpc";
            String json = JSONUtils.encodeToJSON(request2);
            byte[] reply = this.utils.postToURL(url, json.getBytes("UTF-8"), this.username, this.password);
            Map m = JSONUtils.decodeJSON(new String(reply, "UTF-8"));
            JSONObject result = new JSONObject();
            result.putAll(m);
            return result;
        }
        catch (IOException e) {
            throw new XMRPCClientException("unexpected");
        }
    }

    @Override
    public XMRPCClient.HTTPResponse call(String method, String url, Map<String, String> headers_in, byte[] input_data) throws XMRPCClientException {
        if (method.equals("GET")) {
            url = String.valueOf(this.http ? "http" : "https") + "://" + this.host + ":" + this.port + url;
            HashMap<String, String> headers_out = new HashMap<String, String>();
            byte[] output_data = this.utils.getFromURL(url, headers_in, headers_out, this.username, this.password);
            return this.utils.createHTTPResponse(headers_out, output_data, 0);
        }
        throw new XMRPCClientException("Not supported");
    }

    @Override
    public void destroy() {
    }
}

