/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.proxy;

import com.aelitis.azureus.core.util.HTTPUtils;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientFactory;
import com.aelitis.azureus.util.JSONUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessorFactory;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.json.simple.JSONObject;

public class XMClientProxy {
    private final File resource_dir;
    private final XMRPCClient rpc;
    private TRNonBlockingServer server;

    public XMClientProxy(File _resource_dir, XMRPCClient _rpc) throws IOException {
        this.resource_dir = _resource_dir.getCanonicalFile();
        this.rpc = _rpc;
        int port = 0;
        try {
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.socket().bind(new InetSocketAddress("127.0.0.1", 0), 4);
            port = ssc.socket().getLocalPort();
            ssc.close();
        }
        catch (Throwable ssc) {
            // empty catch block
        }
        if (port == 0) {
            throw new IOException("Failed to allocate a local port");
        }
        try {
            this.server = new TRNonBlockingServer("XMClientProxy", port, InetAddress.getByName("127.0.0.1"), false, new TRNonBlockingServerProcessorFactory(){

                @Override
                public TRNonBlockingServerProcessor create(TRTrackerServerTCP _server, SocketChannel _socket) {
                    return new NonBlockingProcessor(_server, _socket);
                }
            });
        }
        catch (Throwable e) {
            throw new IOException("Failed to create proxy server: " + Debug.getNestedExceptionMessage(e));
        }
    }

    public String getHostName() {
        return "127.0.0.1";
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void destroy() {
        this.server.close();
    }

    public static void main(String[] args) {
        File rd = new File("C:\\Projects\\Development\\xmwebui\\transmission\\web");
        try {
            XMRPCClient rpc = XMRPCClientFactory.createTunnel("http://127.0.0.1:9091/", args[0], "vuze", args[1]);
            new XMClientProxy(rd, rpc);
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    private class NonBlockingProcessor
    extends TRNonBlockingServerProcessor {
        protected NonBlockingProcessor(TRTrackerServerTCP _server, SocketChannel _socket) {
            super(_server, _socket);
        }

        @Override
        protected ByteArrayOutputStream process(String input_header, String lowercase_input_header, String url_path, InetSocketAddress client_address, boolean announce_and_scrape_only, InputStream is, AsyncController async) throws IOException {
            ByteArrayOutputStream result = new ByteArrayOutputStream(1024);
            String[] lines = input_header.split("\n");
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                int pos = (line = line.trim()).indexOf(58);
                if (pos != -1) {
                    headers.put(line.substring(0, pos).trim().toLowerCase(), line.substring(pos + 1).trim());
                }
                ++n2;
            }
            String content_type = "application/octet-stream";
            try {
                ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
                HashMap<String, String> output_headers = new HashMap<String, String>();
                boolean no_cache = true;
                if (url_path.startsWith("/transmission/rpc")) {
                    JSONObject rcp_request = new JSONObject();
                    rcp_request.putAll(JSONUtils.decodeJSON(new String(this.getPostData(), "UTF-8")));
                    JSONObject rpc_reply = XMClientProxy.this.rpc.call(rcp_request);
                    data.write(JSONUtils.encodeToJSON(rpc_reply).getBytes("UTF-8"));
                    content_type = "application/json; charset=UTF-8";
                } else if (url_path.startsWith("/psearch/")) {
                    XMRPCClient.HTTPResponse resp = XMClientProxy.this.rpc.call("GET", url_path, headers, null);
                    byte[] reply_data = resp.getDataBuffer();
                    data.write(reply_data, resp.getDataBufferOffset(), reply_data.length - resp.getDataBufferOffset());
                    content_type = resp.getHeaders().get("Content-Type");
                } else {
                    no_cache = false;
                    if (url_path.equals("/")) {
                        url_path = "/index.html";
                    }
                    if (url_path.endsWith("/isServicePaired")) {
                        data.write("{ 'servicepaired': false }".getBytes("UTF-8"));
                        content_type = "application/json; charset=UTF-8";
                    } else {
                        File file = new File(XMClientProxy.this.resource_dir, url_path.substring(1).replace("/", File.separator));
                        if (!(file = file.getCanonicalFile()).getAbsolutePath().startsWith(XMClientProxy.this.resource_dir.getAbsolutePath())) {
                            throw new IOException("Invalid resource file location: " + file);
                        }
                        data.write(FileUtil.readFileAsByteArray(file));
                        String formatted_date = TimeFormatter.getHTTPDate(file.lastModified());
                        output_headers.put("Last-Modified", formatted_date);
                        String name = file.getName();
                        int pos = name.lastIndexOf(".");
                        if (pos != -1) {
                            content_type = HTTPUtils.guessContentTypeFromFileType(name.substring(pos + 1));
                        }
                    }
                }
                byte[] bytes = data.toByteArray();
                output_headers.put("Content-Type", content_type);
                output_headers.put("Content-length", String.valueOf(bytes.length));
                if (no_cache) {
                    output_headers.put("Cache-Control", "no-cache, no-store, must-revalidate");
                    output_headers.put("Pragma", "no-cache");
                    output_headers.put("Expires", "0");
                }
                String header_str = "HTTP/1.1 200 OK\r\n";
                for (Map.Entry entry : output_headers.entrySet()) {
                    header_str = String.valueOf(header_str) + (String)entry.getKey() + ": " + (String)entry.getValue() + "\r\n";
                }
                header_str = String.valueOf(header_str) + "\r\n";
                result.write(header_str.getBytes("UTF-8"));
                result.write(bytes);
            }
            catch (Throwable e) {
                e.printStackTrace();
                result.write("HTTP/1.1 404 Not Found\r\nContent-length: 0\r\n\r\n".getBytes());
            }
            String ka = (String)headers.get("keep-alive");
            this.setKeepAlive(ka == null || !ka.equalsIgnoreCase("close"));
            return result;
        }
    }
}

