/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearch;
import com.aelitis.azureus.core.metasearch.MetaSearchManager;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.pairing.PairingManager;
import com.aelitis.azureus.core.pairing.PairingManagerFactory;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginPageGenerator;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginPageGeneratorAdaptor;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginSearch;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import com.aelitis.azureus.plugins.xmwebui.SearchInstance;
import com.aelitis.azureus.plugins.xmwebui.TagSearchInstance;
import com.aelitis.azureus.plugins.xmwebui.TextualException;
import com.aelitis.azureus.plugins.xmwebui.TransmissionVars;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.PlayUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginAdapter;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.config.ConfigParameter;
import org.gudy.azureus2.plugins.config.ConfigParameterListener;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.download.DownloadStubEvent;
import org.gudy.azureus2.plugins.download.DownloadStubListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.webplugin.WebPlugin;
import org.gudy.bouncycastle.util.encoders.Base64;
import org.json.simple.JSONObject;

public class XMWebUIPlugin
extends WebPlugin
implements UnloadablePlugin,
DownloadManagerListener {
    private static final boolean IS_5101_PLUS = Constants.isCurrentVersionGE("5.1.0.1");
    private static final int VUZE_RPC_VERSION = 5;
    public static final int DEFAULT_PORT = 9091;
    private static Properties defaults = new Properties();
    private static final String SEARCH_PREFIX = "/psearch";
    private static final int SEARCH_TIMEOUT = 60000;
    protected static final long SEARCH_AUTOREMOVE_TIMEOUT = 3600000L;
    private boolean view_mode;
    BooleanParameter trace_param;
    private BooleanParameter hide_ln_param;
    private TorrentAttribute t_id;
    private Map<Long, RecentlyRemovedData> recently_removed = new HashMap<Long, RecentlyRemovedData>();
    private Set<Long> stubbifying = new HashSet<Long>();
    private Map<String, String> ip_to_session_id = new HashMap<String, String>();
    private RemSearchPluginPageGenerator search_handler;
    private TimerEventPeriodic search_timer;
    private String az_mode;
    private boolean check_ids_outstanding = true;
    private Map<String, Map<Long, String>> session_torrent_info_cache = new HashMap<String, Map<Long, String>>();
    private Map<String, SearchInstance> active_searches = new HashMap<String, SearchInstance>();
    private Map<String, TagSearchInstance> active_tagsearches = new HashMap<String, TagSearchInstance>();
    private Object lifecycle_lock = new Object();
    private int lifecycle_state = 0;
    private boolean update_in_progress;
    private List<MagnetDownload> magnet_downloads = new ArrayList<MagnetDownload>();
    private Object json_rpc_client;
    private Object json_server_method_lock = new Object();
    private transient Map<String, Object> json_server_methods = new HashMap<String, Object>();
    private BooleanParameter logtofile_param;
    private LoggerChannel log;
    private long lastVerserverCheck;
    private static Object add_torrent_lock;
    private static final int RT_THUMBNAIL = 0;

    static {
        System.setProperty("az.xmwebui.skip.ssl.hack", "true");
        defaults.put("Disablable", new Boolean(true));
        defaults.put("Enable", new Boolean(true));
        defaults.put("Port", new Integer(9091));
        defaults.put("Root Dir", "transmission/web");
        defaults.put("DefaultEnableKeepAlive", new Boolean(true));
        defaults.put("DefaultHideResourceConfig", new Boolean(true));
        defaults.put("PairingSID", "xmwebui");
        add_torrent_lock = new Object();
    }

    private static Download destubbify(DownloadStub stub) throws DownloadException {
        if (IS_5101_PLUS) {
            return stub.destubbify();
        }
        if (stub.isStub()) {
            return stub.destubbify();
        }
        return (Download)stub;
    }

    public XMWebUIPlugin() {
        super(defaults);
        this.search_handler = new RemSearchPluginPageGenerator(new RemSearchPluginPageGeneratorAdaptor(){

            @Override
            public void searchReceived(String originator) throws IOException {
            }

            @Override
            public void searchCreated(RemSearchPluginSearch search) {
            }

            @Override
            public void log(String str) {
                XMWebUIPlugin.this.log(str);
            }

            @Override
            public void log(String str, Throwable e) {
                XMWebUIPlugin.this.log(str, e);
            }
        }, SEARCH_PREFIX, null, 16, 100, false);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getChannel("xmwebui");
        defaults.put("DefaultLoggerChannel", this.log);
        super.initialize(_plugin_interface);
        this.plugin_interface.getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle("com.aelitis.azureus.plugins.xmwebui.internat.Messages");
        this.t_id = this.plugin_interface.getTorrentManager().getPluginAttribute("xmui.dl.id");
        BasicPluginConfigModel config = this.getConfigModel();
        int port = this.plugin_interface.getPluginconfig().getPluginIntParameter("Port", this.CONFIG_PORT_DEFAULT);
        config.addLabelParameter2("xmwebui.blank");
        config.addHyperlinkParameter2("xmwebui.openui", "http://127.0.0.1:" + port + "/");
        config.addLabelParameter2("xmwebui.blank");
        this.hide_ln_param = config.addBooleanParameter2("xmwebui.hidelownoise", "xmwebui.hidelownoise", true);
        this.trace_param = config.addBooleanParameter2("xmwebui.trace", "xmwebui.trace", false);
        this.logtofile_param = config.addBooleanParameter2("xmwebui.logtofile", "xmwebui.logtofile", false);
        this.changeLogToFile(this.logtofile_param.getValue());
        this.logtofile_param.addConfigParameterListener(new ConfigParameterListener(){

            @Override
            public void configParameterChanged(ConfigParameter param) {
                XMWebUIPlugin.this.changeLogToFile(XMWebUIPlugin.this.logtofile_param.getValue());
            }
        });
        ConfigParameter mode_parameter = this.plugin_interface.getPluginconfig().getPluginParameter("Mode");
        if (mode_parameter == null) {
            this.view_mode = true;
            this.checkViewMode();
        } else {
            mode_parameter.addConfigParameterListener(new ConfigParameterListener(){

                @Override
                public void configParameterChanged(ConfigParameter param) {
                    XMWebUIPlugin.this.setViewMode();
                }
            });
            this.setViewMode();
        }
        this.plugin_interface.getDownloadManager().addListener(this);
        this.plugin_interface.getDownloadManager().addDownloadStubListener(new DownloadStubListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void downloadStubEventOccurred(DownloadStubEvent event2) throws DownloadException {
                int event_type = event2.getEventType();
                List<DownloadStub> stubs = event2.getDownloadStubs();
                Map map = XMWebUIPlugin.this.recently_removed;
                synchronized (map) {
                    if (event_type == 3) {
                        for (DownloadStub stub : stubs) {
                            try {
                                long id = XMWebUIPlugin.destubbify(stub).getLongAttribute(XMWebUIPlugin.this.t_id);
                                XMWebUIPlugin.this.stubbifying.add(id);
                                stub.setLongAttribute(XMWebUIPlugin.this.t_id, id);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    } else if (event_type == 1 || event_type == 4) {
                        for (DownloadStub stub : stubs) {
                            long id = stub.getLongAttribute(XMWebUIPlugin.this.t_id);
                            XMWebUIPlugin.this.stubbifying.remove(id);
                        }
                    }
                }
            }
        }, false);
        this.search_timer = SimpleTimer.addPeriodicEvent("XMSearchTimeout", 30000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                Map<String, RemSearchPluginSearch> searches = XMWebUIPlugin.this.search_handler.getSearches();
                for (RemSearchPluginSearch search : searches.values()) {
                    if (search.getAge() <= 60000L) continue;
                    XMWebUIPlugin.this.log("Timeout: " + search.getString());
                    search.destroy();
                }
                Map map = XMWebUIPlugin.this.active_searches;
                synchronized (map) {
                    Iterator it2 = XMWebUIPlugin.this.active_searches.values().iterator();
                    while (it2.hasNext()) {
                        SearchInstance search = (SearchInstance)it2.next();
                        if (search.isComplete() && search.getLastResultsAgo() > 3600000L) {
                            it2.remove();
                        }
                        if (search.isComplete() || search.getAge() <= 60000L) continue;
                        XMWebUIPlugin.this.log("Timeout: " + search.getString());
                        search.failWithTimeout();
                    }
                }
            }
        });
        this.plugin_interface.addListener(new PluginAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializationComplete() {
                Object object = XMWebUIPlugin.this.lifecycle_lock;
                synchronized (object) {
                    if (XMWebUIPlugin.this.lifecycle_state == 0) {
                        XMWebUIPlugin.this.lifecycle_state = 1;
                    }
                }
            }
        });
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (instance.getUIType() == 1) {
                    try {
                        Class.forName("com.aelitis.azureus.plugins.xmwebui.swt.XMWebUIPluginView").getConstructor(XMWebUIPlugin.class, UIInstance.class).newInstance(XMWebUIPlugin.this, instance);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
        if (IS_5101_PLUS) {
            this.json_rpc_client = new Utilities.JSONClient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void serverRegistered(Utilities.JSONServer server) {
                    List<String> methods = server.getSupportedMethods();
                    Object object = XMWebUIPlugin.this.json_server_method_lock;
                    synchronized (object) {
                        HashMap<String, Utilities.JSONServer> new_methods = new HashMap<String, Utilities.JSONServer>(XMWebUIPlugin.this.json_server_methods);
                        for (String method : methods) {
                            new_methods.put(method, server);
                        }
                        XMWebUIPlugin.this.json_server_methods = new_methods;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void serverUnregistered(Utilities.JSONServer server) {
                    List<String> methods = server.getSupportedMethods();
                    Object object = XMWebUIPlugin.this.json_server_method_lock;
                    synchronized (object) {
                        HashMap new_methods = new HashMap(XMWebUIPlugin.this.json_server_methods);
                        for (String method : methods) {
                            new_methods.remove(method);
                        }
                        XMWebUIPlugin.this.json_server_methods = new_methods;
                    }
                }
            };
            this.plugin_interface.getUtilities().registerJSONRPCClient((Utilities.JSONClient)this.json_rpc_client);
        }
    }

    protected void changeLogToFile(boolean logToFile) {
        if (this.log != null && logToFile) {
            this.log.setDiagnostic(0x100000L, true);
        }
    }

    private void checkViewMode() {
        File dir;
        if (this.view_mode) {
            return;
        }
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        String data_dir = pc.getCoreStringParameter("Default save path");
        boolean data_bad = false;
        if (data_dir == null || data_dir.length() == 0) {
            data_bad = true;
        } else {
            dir = new File(data_dir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            boolean bl = data_bad = !dir.canWrite();
        }
        if (data_bad) {
            Logger.log(new LogAlert(true, 3, MessageText.getString("xmwebui.error.data_path")));
        }
        if (!pc.getUnsafeBooleanParameter("Save Torrent Files")) {
            Logger.log(new LogAlert(true, 3, MessageText.getString("xmwebui.error.torrent_path")));
        } else {
            String torrent_dir = pc.getUnsafeStringParameter("General_sDefaultTorrent_Directory");
            boolean torrent_bad = false;
            if (torrent_dir == null || torrent_dir.length() == 0) {
                torrent_bad = true;
            } else {
                dir = new File(torrent_dir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                boolean bl = torrent_bad = !dir.canWrite();
            }
            if (torrent_bad) {
                Logger.log(new LogAlert(true, 3, MessageText.getString("xmwebui.error.torrent_path")));
            }
        }
    }

    @Override
    protected void setupServer() {
        PluginManager pm = this.plugin_interface.getPluginManager();
        if (pm.isInitialized()) {
            super.setupServer();
        } else {
            this.plugin_interface.addEventListener(new PluginEventListener(){

                @Override
                public void handleEvent(PluginEvent ev) {
                    if (ev.getType() == 7) {
                        XMWebUIPlugin.this.plugin_interface.removeEventListener(this);
                        XMWebUIPlugin.super.setupServer();
                    }
                }
            });
        }
    }

    @Override
    public void unload() throws PluginException {
        if (this.search_timer != null) {
            this.search_timer.cancel();
            this.search_timer = null;
        }
        this.plugin_interface.getDownloadManager().removeListener(this);
        if (IS_5101_PLUS) {
            if (this.json_rpc_client != null) {
                this.plugin_interface.getUtilities().unregisterJSONRPCClient((Utilities.JSONClient)this.json_rpc_client);
                this.json_rpc_client = null;
            }
            this.json_server_methods.clear();
        }
        super.unloadPlugin();
    }

    protected void setViewMode() {
        String mode_str = this.plugin_interface.getPluginconfig().getPluginStringParameter("Mode", "full");
        this.view_mode = !mode_str.equalsIgnoreCase("full");
        this.checkViewMode();
    }

    public File getResourceDir() {
        return new File(this.plugin_interface.getPluginDirectoryName(), "transmission" + File.separator + "web");
    }

    @Override
    public void downloadAdded(Download download) {
    }

    @Override
    public void downloadRemoved(Download download) {
        this.addRecentlyRemoved(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecentlyRemoved(DownloadStub download) {
        Map<Long, RecentlyRemovedData> map = this.recently_removed;
        synchronized (map) {
            long id = this.getID(download, false);
            if (id > 0L && !this.stubbifying.contains(id) && !this.recently_removed.containsKey(id)) {
                this.recently_removed.put(id, new RecentlyRemovedData(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRecentlyRemoved(String session_id, Map args, Map result) {
        Object ids = args.get("ids");
        if (ids != null && ids instanceof String && ((String)ids).equals("recently-active")) {
            Map<Long, RecentlyRemovedData> map = this.recently_removed;
            synchronized (map) {
                if (this.recently_removed.size() > 0) {
                    long now = SystemTime.getMonotonousTime();
                    Iterator<RecentlyRemovedData> it = this.recently_removed.values().iterator();
                    ArrayList<Long> removed = new ArrayList<Long>();
                    while (it.hasNext()) {
                        RecentlyRemovedData rrd = it.next();
                        if (!rrd.hasSession(session_id)) {
                            removed.add(rrd.getID());
                        }
                        if (now - rrd.getCreateTime() <= 60000L) continue;
                        it.remove();
                    }
                    if (removed.size() > 0) {
                        result.put("removed", removed);
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean generateSupport(TrackerWebPageRequest request, TrackerWebPageResponse response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getCookie(String cookies, String cookie_id) {
        String[] cookie_list;
        if (cookies == null) {
            return null;
        }
        String[] stringArray = cookie_list = cookies.split(";");
        int n = cookie_list.length;
        int n2 = 0;
        while (n2 < n) {
            String cookie = stringArray[n2];
            String[] bits = cookie.split("=");
            if (bits.length == 2 && bits[0].trim().equals(cookie_id)) {
                return bits[1].trim();
            }
            ++n2;
        }
        return null;
    }

    private boolean isSessionValid(TrackerWebPageRequest request2) {
        if (!request2.getURL().startsWith("/transmission/")) {
            return true;
        }
        Map headers = request2.getHeaders();
        String tunnel = (String)headers.get("x-vuze-is-tunnel");
        if (tunnel != null && tunnel.equalsIgnoreCase("true")) {
            return true;
        }
        String session_id = this.getSessionID(request2);
        String header_session_id = (String)headers.get("X-Transmission-Session-Id");
        if (header_session_id == null) {
            header_session_id = (String)headers.get("x-transmission-session-id");
        }
        if (header_session_id == null) {
            header_session_id = this.getCookie((String)headers.get("cookie"), "X-Transmission-Session-Id");
        }
        if (header_session_id == null) {
            return false;
        }
        return header_session_id.equals(session_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionID(TrackerWebPageRequest request2) {
        String clientAddress = request2.getClientAddress();
        Map<String, String> map = this.ip_to_session_id;
        synchronized (map) {
            String session_id = this.ip_to_session_id.get(clientAddress);
            if (session_id == null) {
                session_id = Double.toHexString(Math.random());
                this.ip_to_session_id.put(clientAddress, session_id);
            }
            return session_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Download addTorrent(final Torrent torrent, File download_dir, boolean add_stopped, final DownloadWillBeAddedListener listener) throws DownloadException {
        Object object = add_torrent_lock;
        synchronized (object) {
            final org.gudy.azureus2.plugins.download.DownloadManager dm = this.plugin_interface.getDownloadManager();
            Download download = dm.getDownload(torrent);
            if (download == null) {
                if (listener != null) {
                    dm.addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

                        @Override
                        public void initialised(Download dlAdding) {
                            boolean b = Arrays.equals(dlAdding.getTorrent().getHash(), torrent.getHash());
                            if (b) {
                                dm.removeDownloadWillBeAddedListener(this);
                                listener.initialised(dlAdding);
                            }
                        }
                    });
                }
                download = add_stopped ? dm.addDownloadStopped(torrent, null, download_dir) : dm.addDownload(torrent, null, download_dir);
                AzureusCoreFactory.getSingleton().saveState();
            }
            return download;
        }
    }

    protected void checkUpdatePermissions() throws IOException {
        if (this.view_mode) {
            this.log("permission denied");
            throw new PermissionDeniedException();
        }
    }

    protected Map processRequest(TrackerWebPageRequest wp_request, String session_id, Map request2) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (request2 == null) {
            response.put("result", "error: Bad or missing JSON string");
            return response;
        }
        String method = (String)request2.get("method");
        if (method == null) {
            throw new IOException("'method' missing");
        }
        HashMap args = (HashMap)request2.get("arguments");
        if (args == null) {
            args = new HashMap();
        }
        try {
            HashMap result = this.processRequest(wp_request, session_id, method, args);
            if (result == null) {
                result = new HashMap();
            }
            response.put("arguments", result);
            response.put("result", "success");
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (TextualException e) {
            response.put("result", e.getMessage());
        }
        catch (Throwable e) {
            this.log("processRequest", e);
            response.put("result", "error: " + Debug.getNestedExceptionMessage(e));
        }
        Object tag = request2.get("tag");
        if (tag != null) {
            response.put("tag", tag);
        }
        return response;
    }

    static Number getNumber(Object val) {
        return XMWebUIPlugin.getNumber(val, 0);
    }

    static Number getNumber(Object val, Number defaultNumber) {
        if (val instanceof Number) {
            return (Number)val;
        }
        if (val instanceof String) {
            NumberFormat format = NumberFormat.getInstance();
            try {
                Number number = format.parse((String)val);
                return number;
            }
            catch (ParseException e) {
                return defaultNumber;
            }
        }
        return defaultNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map processRequest(TrackerWebPageRequest request2, String session_id, String method, Map args) throws Exception {
        boolean save_core_state = false;
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (method.equals("session-set")) {
                try {
                    this.method_Session_Set(args, result);
                }
                finally {
                    COConfigurationManager.save();
                }
            } else if (method.equals("session-get")) {
                this.method_Session_Get(args, result);
            } else if (method.equals("session-stats")) {
                this.method_Session_Stats(args, result);
            } else if (method.equals("torrent-add")) {
                String agent = MapUtils.getMapString(request2.getHeaders(), "User-Agent", "");
                boolean xmlEscape = agent.startsWith("Mozilla/");
                this.method_Torrent_Add(args, result, xmlEscape);
            } else if (method.equals("torrent-start-all")) {
                this.checkUpdatePermissions();
                this.plugin_interface.getDownloadManager().startAllDownloads();
                save_core_state = true;
            } else if (method.equals("torrent-stop-all")) {
                this.checkUpdatePermissions();
                this.plugin_interface.getDownloadManager().stopAllDownloads();
                save_core_state = true;
            } else if (method.equals("torrent-start")) {
                this.method_Torrent_Start(args, result);
                save_core_state = true;
            } else if (method.equals("torrent-start-now")) {
                this.method_Torrent_Start_Now(args, result);
                save_core_state = true;
            } else if (method.equals("torrent-stop")) {
                this.method_Torrent_Stop(args, result);
                save_core_state = true;
            } else if (method.equals("torrent-verify")) {
                this.method_Torrent_Verify(args, result);
            } else if (method.equals("torrent-remove")) {
                this.method_Torrent_Remove(args, result);
                save_core_state = true;
            } else if (method.equals("torrent-set")) {
                this.method_Torrent_Set(session_id, args, result);
            } else if (method.equals("torrent-get")) {
                this.method_Torrent_Get(request2, session_id, args, result);
            } else if (method.equals("torrent-reannounce")) {
                this.method_Torrent_Reannounce(args, result);
            } else if (method.equals("torrent-set-location")) {
                this.method_Torrent_Set_Location(args, result);
            } else if (method.equals("blocklist-update")) {
                this.method_Blocklist_Update(args, result);
            } else if (!method.equals("session-close")) {
                if (method.equals("queue-move-top")) {
                    this.method_Queue_Move_Top(args, result);
                } else if (method.equals("queue-move-up")) {
                    this.method_Queue_Move_Up(args, result);
                } else if (method.equals("queue-move-down")) {
                    this.method_Queue_Move_Down(args, result);
                } else if (method.equals("queue-move-bottom")) {
                    this.method_Queue_Move_Bottom(args, result);
                } else if (method.equals("free-space")) {
                    this.method_Free_Space(args, result);
                } else if (method.equals("torrent-rename-path")) {
                    this.method_Torrent_Rename_Path(args, result);
                } else if (method.equals("tags-get-list")) {
                    this.method_Tags_Get_List(args, result);
                } else if (method.equals("tags-lookup-start")) {
                    this.method_Tags_Lookup_Start(args, result);
                } else if (method.equals("tags-lookup-get-results")) {
                    this.method_Tags_Lookup_Get_Results(args, result);
                } else if (method.equals("subscription-get")) {
                    this.method_Subscription_Get(args, result);
                } else if (method.equals("subscription-add")) {
                    this.method_Subscription_Add(args, result);
                } else if (method.equals("subscription-remove")) {
                    this.method_Subscription_Remove(args, result);
                } else if (method.equals("vuze-search-start")) {
                    this.method_Vuze_Search_Start(args, result);
                } else if (method.equals("vuze-search-get-results")) {
                    this.method_Vuze_Search_Get_Results(args, result);
                } else if (method.equals("vuze-lifecycle")) {
                    this.processVuzeLifecycle(args, result);
                } else if (method.equals("vuze-pairing")) {
                    if (!IS_5101_PLUS) throw new IOException("Client version too old!");
                    this.processVuzePairing(args, result);
                } else if (method.equals("vuze-torrent-get")) {
                    this.processVuzeTorrentGet(request2, args, result);
                } else if (method.equals("vuze-file-add")) {
                    this.processVuzeFileAdd(args, result);
                } else {
                    Utilities.JSONServer server;
                    if (IS_5101_PLUS && (server = (Utilities.JSONServer)this.json_server_methods.get(method)) != null) {
                        Map map = server.call(method, args);
                        return map;
                    }
                    if (this.trace_param.getValue()) {
                        this.log("unhandled method: " + method + " - " + args);
                    }
                }
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (save_core_state) {
                AzureusCoreFactory.getSingleton().saveState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method_Tags_Lookup_Start(Map args, Map result) {
        Object ids = args.get("ids");
        TagSearchInstance tagSearchInstance = new TagSearchInstance();
        try {
            ArrayList<String> listDefaultNetworks = new ArrayList<String>();
            int i = 0;
            while (i < AENetworkClassifier.AT_NETWORKS.length) {
                String nn = AENetworkClassifier.AT_NETWORKS[i];
                String config_name = "Network Selection Default." + nn;
                boolean enabled = COConfigurationManager.getBooleanParameter(config_name, false);
                if (enabled) {
                    listDefaultNetworks.add(nn);
                }
                ++i;
            }
            org.gudy.azureus2.plugins.download.DownloadManager dlm = this.plugin_interface.getDownloadManager();
            if (ids instanceof List) {
                List idList = (List)ids;
                for (Object id : idList) {
                    if (!(id instanceof String)) continue;
                    String hash = (String)id;
                    byte[] hashBytes = ByteFormatter.decodeString(hash);
                    Download download = dlm.getDownload(hashBytes);
                    DownloadManager dm = PluginCoreUtils.unwrap(download);
                    String[] networks = dm != null ? dm.getDownloadState().getNetworks() : listDefaultNetworks.toArray(new String[0]);
                    tagSearchInstance.addSearch(hash, hashBytes, networks);
                    Map<String, TagSearchInstance> map = this.active_tagsearches;
                    synchronized (map) {
                        this.active_tagsearches.put(tagSearchInstance.getID(), tagSearchInstance);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        result.put("id", tagSearchInstance.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method_Tags_Lookup_Get_Results(Map args, Map result) throws IOException {
        String id = (String)args.get("id");
        if (id == null) {
            throw new IOException("ID missing");
        }
        Map<String, TagSearchInstance> map = this.active_tagsearches;
        synchronized (map) {
            TagSearchInstance search_instance = this.active_tagsearches.get(id);
            if (search_instance != null) {
                if (search_instance.getResults(result)) {
                    this.active_tagsearches.remove(id);
                }
            } else {
                throw new IOException("ID not found - already complete?");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method_Vuze_Search_Get_Results(Map args, Map result) throws IOException {
        String sid = (String)args.get("sid");
        if (sid == null) {
            throw new IOException("SID missing");
        }
        Map<String, SearchInstance> map = this.active_searches;
        synchronized (map) {
            SearchInstance search_instance = this.active_searches.get(sid);
            if (search_instance != null) {
                if (search_instance.getResults(result)) {
                    this.active_searches.remove(sid);
                }
            } else {
                throw new IOException("SID not found - already complete?");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method_Vuze_Search_Start(Map args, Map result) throws IOException {
        String expression = (String)args.get("expression");
        if (expression == null) {
            throw new IOException("Search expression missing");
        }
        MetaSearchManager ms_manager = MetaSearchManagerFactory.getSingleton();
        MetaSearch ms = ms_manager.getMetaSearch();
        ArrayList<SearchParameter> sps = new ArrayList<SearchParameter>();
        sps.add(new SearchParameter("s", expression));
        SearchParameter[] parameters = sps.toArray(new SearchParameter[sps.size()]);
        HashMap<String, String> context2 = new HashMap<String, String>();
        context2.put("azsrc", "xmwebui");
        context2.put("remove_dup_hash", "true");
        Engine[] engines = ms_manager.getMetaSearch().getEngines(true, true);
        if (engines.length == 0) {
            throw new IOException("No search templates available");
        }
        SearchInstance search_instance = new SearchInstance(this, engines);
        if ((engines = ms.search(engines, search_instance, parameters, null, context2, 100)).length == 0) {
            throw new IOException("No search templates available");
        }
        Map<String, SearchInstance> map = this.active_searches;
        synchronized (map) {
            this.active_searches.put(search_instance.getSID(), search_instance);
        }
        search_instance.setEngines(engines);
        result.put("sid", search_instance.getSID());
        ArrayList<JSONObject> l_engines = new ArrayList<JSONObject>();
        result.put("engines", l_engines);
        Engine[] engineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            Engine engine = engineArray[n2];
            JSONObject map2 = new JSONObject();
            l_engines.add(map2);
            map2.put("name", engine.getName());
            map2.put("id", engine.getUID());
            map2.put("favicon", engine.getIcon());
            map2.put("dl_link_css", engine.getDownloadLinkCSS());
            map2.put("selected", Engine.SEL_STATE_STRINGS[engine.getSelectionState()]);
            map2.put("type", Engine.ENGINE_SOURCE_STRS[engine.getSource()]);
            ++n2;
        }
    }

    private void method_Subscription_Add(Map args, Map result) throws MalformedURLException, SubscriptionException {
        String url = MapUtils.getMapString(args, "rss-url", null);
        String name = MapUtils.getMapString(args, "name", "Subscription " + DateFormat.getInstance().toString());
        boolean anonymous = MapUtils.getMapBoolean(args, "anonymous", false);
        if (url != null) {
            Subscription subRSS = SubscriptionManagerFactory.getSingleton().createRSS(name, new URL(url), 120, anonymous, null);
            result.put("subscription", subRSS.getJSON());
        }
    }

    private void method_Subscription_Remove(Map args, Map result) throws IOException {
        Object oID = args.get("ids");
        if (oID == null) {
            throw new IOException("ID missing");
        }
        String[] ids = new String[]{};
        if (oID instanceof String) {
            ids = new String[]{(String)oID};
        } else if (oID instanceof List) {
            ids = ((List)oID).toArray(new String[0]);
        } else if (oID instanceof Object[]) {
            Object[] oIDS = (Object[])oID;
            ids = new String[oIDS.length];
            int i = 0;
            while (i < oIDS.length) {
                ids[i] = oIDS[i].toString();
                ++i;
            }
        }
        SubscriptionManager subMan = SubscriptionManagerFactory.getSingleton();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Subscription subs = subMan.getSubscriptionByID(id);
            if (subs == null) {
                result.put(id, "Error: Not Found");
            } else {
                subs.setSubscribed(false);
                result.put(id, "Unsubscribed");
            }
            ++n2;
        }
    }

    private void method_Subscription_Get(Map args, Map result) throws IOException {
        int n;
        Subscription[] subscriptions;
        boolean all;
        boolean subscribedOnly = MapUtils.getMapBoolean(args, "subscribed-only", true);
        Object oID = args.get("ids");
        String[] ids = new String[]{};
        if (oID instanceof String) {
            ids = new String[]{(String)oID};
        } else if (oID instanceof List) {
            ids = ((List)oID).toArray(new String[0]);
        } else if (oID instanceof Object[]) {
            Object[] oIDS = (Object[])oID;
            ids = new String[oIDS.length];
            int i = 0;
            while (i < oIDS.length) {
                ids[i] = oIDS[i].toString();
                ++i;
            }
        }
        List fields = (List)args.get("fields");
        List fieldsResults = null;
        boolean bl = all = fields == null || fields.size() == 0;
        if (!all) {
            Object oResults;
            Collections.sort(fields);
            int i = Collections.binarySearch(fields, "results");
            if (i >= 0 && (oResults = fields.get(0)) instanceof List) {
                fieldsResults = (List)oResults;
            }
        }
        boolean allResultFields = fieldsResults == null || fieldsResults.size() == 0;
        HashMap<String, Map> mapSubcriptions = new HashMap<String, Map>();
        SubscriptionManager subMan = SubscriptionManagerFactory.getSingleton();
        if (ids.length == 0) {
            subscriptions = subMan.getSubscriptions(subscribedOnly);
        } else {
            ArrayList<Subscription> list = new ArrayList<Subscription>();
            String[] stringArray = ids;
            int n2 = ids.length;
            n = 0;
            while (n < n2) {
                String id = stringArray[n];
                Subscription subscriptionByID = subMan.getSubscriptionByID(id);
                if (subscriptionByID == null) {
                    mapSubcriptions.put(id, Collections.EMPTY_MAP);
                } else {
                    list.add(subscriptionByID);
                }
                ++n;
            }
            subscriptions = list.toArray(new Subscription[0]);
        }
        Subscription[] subscriptionArray = subscriptions;
        n = subscriptions.length;
        int n3 = 0;
        while (n3 < n) {
            Subscription sub = subscriptionArray[n3];
            HashMap<String, Object> map = new HashMap<String, Object>();
            mapSubcriptions.put(sub.getID(), map);
            if (all || Collections.binarySearch(fields, "name") >= 0) {
                map.put("name", sub.getName());
            }
            if (all || Collections.binarySearch(fields, "addedDate") >= 0) {
                map.put("addedDate", sub.getAddTime());
            }
            if (all || Collections.binarySearch(fields, "associationCount") >= 0) {
                map.put("associationCount", sub.getAssociationCount());
            }
            if (all || Collections.binarySearch(fields, "popularity") >= 0) {
                map.put("popularity", sub.getCachedPopularity());
            }
            if (all || Collections.binarySearch(fields, "category") >= 0) {
                map.put("category", sub.getCategory());
            }
            if (all || Collections.binarySearch(fields, "creator") >= 0) {
                map.put("creator", sub.getCreatorRef());
            }
            try {
                Engine engine = sub.getEngine();
                if (engine != null) {
                    if (all || Collections.binarySearch(fields, "engineName") >= 0) {
                        map.put("engineName", engine.getName());
                    }
                    if (all || Collections.binarySearch(fields, "engineType") >= 0) {
                        map.put("engineType", engine.getType());
                    }
                }
            }
            catch (SubscriptionException engine) {
                // empty catch block
            }
            if (all || Collections.binarySearch(fields, "highestVersion") >= 0) {
                map.put("highestVersion", sub.getHighestVersion());
            }
            if (all || Collections.binarySearch(fields, "nameEx") >= 0) {
                map.put("nameEx", sub.getNameEx());
            }
            if (all || Collections.binarySearch(fields, "queryKey") >= 0) {
                map.put("queryKey", sub.getQueryKey());
            }
            if (all || Collections.binarySearch(fields, "referer") >= 0) {
                map.put("referer", sub.getReferer());
            }
            if (all || Collections.binarySearch(fields, "tagUID") >= 0) {
                map.put("tagUID", sub.getTagID());
            }
            if (all || Collections.binarySearch(fields, "uri") >= 0) {
                map.put("uri", sub.getURI());
            }
            if (all || Collections.binarySearch(fields, "anonymous") >= 0) {
                map.put("anonymous", sub.isAnonymous());
            }
            if (all || Collections.binarySearch(fields, "autoDLSupported") >= 0) {
                map.put("autoDLSupported", sub.isAutoDownloadSupported());
            }
            if (all || Collections.binarySearch(fields, "mine") >= 0) {
                map.put("mine", sub.isMine());
            }
            if (all || Collections.binarySearch(fields, "public") >= 0) {
                map.put("public", sub.isPublic());
            }
            if (all || Collections.binarySearch(fields, "isSearchTemplate") >= 0) {
                map.put("isSearchTemplate", sub.isSearchTemplate());
            }
            if (all || Collections.binarySearch(fields, "subscribed") >= 0) {
                map.put("subscribed", sub.isSubscribed());
            }
            if (all || Collections.binarySearch(fields, "updateable") >= 0) {
                map.put("updateable", sub.isUpdateable());
            }
            if (all || Collections.binarySearch(fields, "shareable") >= 0) {
                map.put("shareable", sub.isShareable());
            }
            if (all || Collections.binarySearch(fields, "resultsCount") >= 0) {
                map.put("resultsCount", sub.getResults(false).length);
            }
            if (fields != null && Collections.binarySearch(fields, "results") >= 0) {
                ArrayList<Map> listResults = new ArrayList<Map>();
                map.put("results", listResults);
                SubscriptionResult[] results = sub.getHistory().getResults(false);
                int i = 0;
                while (i < results.length) {
                    SubscriptionResult r = results[i];
                    listResults.add(r.toJSONMap());
                    ++i;
                }
            }
            ++n3;
        }
        result.put("subscriptions", mapSubcriptions);
    }

    private void method_Tags_Get_List(Map args, Map result) {
        ArrayList listTags = new ArrayList();
        TagManager tm = TagManagerFactory.getTagManager();
        List<TagType> tagTypes = tm.getTagTypes();
        for (TagType tagType : tagTypes) {
            List<Tag> tags = tagType.getTags();
            for (Tag tag : tags) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", tag.getTagName(true));
                map.put("count", tag.getTaggedCount());
                map.put("type", tag.getTagType().getTagType());
                map.put("type-name", tag.getTagType().getTagTypeName(true));
                if (tag instanceof Category) {
                    map.put("category-type", ((Category)tag).getType());
                }
                map.put("uid", tag.getTagUID());
                int[] color = tag.getColor();
                if (color != null) {
                    String hexColor = "#";
                    int[] nArray = color;
                    int n = color.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int c = nArray[n2];
                        if (c < 16) {
                            hexColor = String.valueOf(hexColor) + "0";
                        }
                        hexColor = String.valueOf(hexColor) + Integer.toHexString(c);
                        ++n2;
                    }
                    map.put("color", hexColor);
                }
                map.put("canBePublic", tag.canBePublic());
                map.put("public", tag.isPublic());
                map.put("visible", tag.isVisible());
                map.put("group", tag.getGroup());
                map.put("auto", tag.isTagAuto());
                listTags.add(map);
            }
        }
        result.put("tags", listTags);
    }

    private void method_Free_Space(Map args, Map result) {
        Object oPath = args.get("path");
        if (!(oPath instanceof String)) {
            return;
        }
        File file = new File((String)oPath);
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        if (file == null) {
            result.put("path", oPath);
            result.put("size-bytes", 0);
            return;
        }
        long space = FileUtil.getUsableSpace(file);
        result.put("path", oPath);
        result.put("size-bytes", space);
    }

    private void method_Queue_Move_Bottom(Map args, Map result) {
        Object ids = args.get("ids");
        AzureusCore core = AzureusCoreFactory.getSingleton();
        GlobalManager gm = core.getGlobalManager();
        List<DownloadManager> dms = this.getDownloadManagerListFromIDs(gm, ids);
        gm.moveEnd(dms.toArray(new DownloadManager[0]));
    }

    private void method_Queue_Move_Down(Map args, Map result) {
        Object ids = args.get("ids");
        AzureusCore core = AzureusCoreFactory.getSingleton();
        GlobalManager gm = core.getGlobalManager();
        List<DownloadManager> dms = this.getDownloadManagerListFromIDs(gm, ids);
        Collections.sort(dms, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager a, DownloadManager b) {
                return b.getPosition() - a.getPosition();
            }
        });
        for (DownloadManager dm : dms) {
            gm.moveDown(dm);
        }
    }

    private void method_Queue_Move_Up(Map args, Map result) {
        Object ids = args.get("ids");
        AzureusCore core = AzureusCoreFactory.getSingleton();
        GlobalManager gm = core.getGlobalManager();
        List<DownloadManager> dms = this.getDownloadManagerListFromIDs(gm, ids);
        Collections.sort(dms, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager a, DownloadManager b) {
                return a.getPosition() - b.getPosition();
            }
        });
        for (DownloadManager dm : dms) {
            gm.moveUp(dm);
        }
    }

    private void method_Queue_Move_Top(Map args, Map result) {
        Object ids = args.get("ids");
        AzureusCore core = AzureusCoreFactory.getSingleton();
        GlobalManager gm = core.getGlobalManager();
        List<DownloadManager> dms = this.getDownloadManagerListFromIDs(gm, ids);
        gm.moveTop(dms.toArray(new DownloadManager[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method_Session_Get(Map args, Map result) {
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        String save_dir = pc.getCoreStringParameter("Default save path");
        int tcp_port = pc.getCoreIntParameter("Incoming TCP Port");
        int up_limit = pc.getCoreIntParameter(TransferSpeedValidator.getActiveUploadParameter(AzureusCoreFactory.getSingleton().getGlobalManager()));
        int down_limit = pc.getCoreIntParameter("Max Download Speed KBs");
        int glob_con = pc.getCoreIntParameter("Max Connections Global");
        int tor_con = pc.getCoreIntParameter("Max Connections Per Torrent");
        boolean require_enc = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require");
        float stop_ratio = COConfigurationManager.getFloatParameter("Stop Ratio");
        String az_mode = this.getAZMode();
        IpFilter ipFilter = IpFilterManagerFactory.getSingleton().getIPFilter();
        String filter_url = COConfigurationManager.getStringParameter("Ip Filter Autoload File", "");
        PluginInterface dht_pi = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        DHTPlugin dht = (DHTPlugin)dht_pi.getPlugin();
        PluginInterface piUTP = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azutp");
        boolean hasUTP = piUTP != null && piUTP.getPluginState().isOperational() && piUTP.getPluginconfig().getPluginBooleanParameter("utp.enabled", true);
        result.put("blocklist-enabled", ipFilter.isEnabled());
        result.put("blocklist-url", filter_url);
        result.put("blocklist-size", ipFilter.getNbRanges());
        result.put("cache-size-mb", 0);
        result.put("dht-enabled", dht.isInitialising() || dht.isEnabled());
        result.put("utp-enabled", hasUTP);
        result.put("lpd-enabled", false);
        result.put("download-dir", save_dir);
        result.put("download-dir-free-space", -1);
        result.put("speed-limit-down", down_limit > 0 ? down_limit : pc.getUnsafeIntParameter("config.ui.speed.partitions.manual.download.last"));
        result.put("speed-limit-down-enabled", down_limit != 0);
        result.put("encryption", require_enc ? "required" : "preferred");
        result.put("idle-seeding-limit", 30);
        result.put("idle-seeding-limit-enabled", false);
        result.put("incomplete-dir", save_dir);
        result.put("incomplete-dir-enabled", false);
        result.put("download-queue-size", 5);
        result.put("download-queue-enabled", true);
        result.put("peer-limit-global", glob_con);
        result.put("peer-limit-per-torrent", tor_con);
        result.put("peer-port", tcp_port);
        result.put("peer-port-random-on-start", false);
        result.put("peer-port-random-low", 49152);
        result.put("peer-port-random-high", 65535);
        result.put("pex-enabled", true);
        result.put("port-forwarding-enabled", false);
        result.put("queue-stalled-enabled", true);
        result.put("queue-stalled-minutes", 30);
        result.put("ratio-limit", 2.0);
        result.put("ratio-limit-enabled", false);
        result.put("rename-partial-files", true);
        result.put("rpc-authentication-required", false);
        result.put("rpc-bind-address", "0.0.0.0");
        result.put("rpc-enabled", false);
        result.put("rpc-password", "");
        result.put("rpc-username", "");
        result.put("rpc-whitelist-enabled", true);
        result.put("scrape-paused-torrents-enabled", true);
        result.put("script-torrent-done-filename", "");
        result.put("script-torrent-done-enabled", false);
        result.put("seed-queue-size", 10);
        result.put("seed-queue-enabled", false);
        result.put("alt-speed-enabled", false);
        result.put("alt-speed-up", 50);
        result.put("alt-speed-down", 50);
        result.put("alt-speed-time-begin", 540);
        result.put("alt-speed-time-enabled", false);
        result.put("alt-speed-time-end", 1020);
        result.put("alt-speed-time-day", 127L);
        result.put("speed-limit-up", up_limit > 0 ? up_limit : pc.getUnsafeIntParameter("config.ui.speed.partitions.manual.upload.last"));
        result.put("speed-limit-up-enabled", up_limit != 0);
        result.put("umask", 18);
        result.put("upload-slots-per-torrent", 14);
        result.put("config-dir", "");
        boolean startStopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
        result.put("start-added-torrents", !startStopped);
        boolean renamePartial = COConfigurationManager.getBooleanParameter("Rename Incomplete Files");
        result.put("rename-partial-files", renamePartial);
        result.put("trash-original-torrent-files", false);
        String az_version = "5.7.3.1_CVS";
        try {
            az_version = Constants.getCurrentVersion();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        result.put("port", new Long(tcp_port));
        result.put("rpc-version", new Long(14L));
        result.put("rpc-version-minimum", new Long(6L));
        result.put("seedRatioLimit", new Double(stop_ratio));
        result.put("seedRatioLimited", stop_ratio > 0.0f);
        String version = this.plugin_interface.getPluginVersion();
        result.put("version", version == null ? "Source" : version);
        result.put("az-rpc-version", 5);
        result.put("az-version", az_version);
        result.put("az-mode", az_mode);
        ArrayList<String> listSupports = new ArrayList<String>();
        Collections.addAll(listSupports, "rpc:receive-gzip", "field:files-hc", "method:tags-get-list", "field:torrent-set-name", "method:subscription-get", "method:subscription-add", "method:subscription-remove");
        Object object = this.json_server_method_lock;
        synchronized (object) {
            for (String key : this.json_server_methods.keySet()) {
                listSupports.add("method:" + key);
            }
        }
        result.put("rpc-supports", listSupports);
        if (this.lastVerserverCheck == 0L || SystemTime.getCurrentTime() - this.lastVerserverCheck > 864000L) {
            this.lastVerserverCheck = SystemTime.getCurrentTime();
            Map decoded = VersionCheckClient.getSingleton().getVersionCheckInfo("xmw");
            String userMessage = this.getUserMessage(decoded);
            if (userMessage != null) {
                result.put("az-message", userMessage);
            }
        }
    }

    private String getUserMessage(Map reply) {
        byte[] signature;
        String message;
        block10: {
            byte[] message_bytes;
            block9: {
                try {
                    message_bytes = MapUtils.getMapByteArray(reply, "xmwebui_message", null);
                    if (message_bytes != null && message_bytes.length != 0) break block9;
                    return null;
                }
                catch (Throwable e) {
                    this.log("Failed get message", e);
                    Debug.printStackTrace(e);
                    return null;
                }
            }
            try {
                message = new String(message_bytes, "UTF-8");
            }
            catch (Throwable e) {
                message = new String(message_bytes);
            }
            signature = MapUtils.getMapByteArray(reply, "xmwebui_message_sig", null);
            if (signature != null) break block10;
            this.log("Signature missing from message");
            return null;
        }
        try {
            AEVerifier.verifyData(message, signature);
        }
        catch (Throwable e) {
            this.log("Message signature check failed", e);
            return null;
        }
        return message;
    }

    private void method_Session_Set(Map args, Map result) throws IOException {
        this.checkUpdatePermissions();
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        for (Map.Entry arg : args.entrySet()) {
            String key = (String)arg.getKey();
            Object val = arg.getValue();
            try {
                if (key.startsWith("alt-speed")) continue;
                if (key.equals("blocklist-url")) {
                    IpFilter ipFilter = IpFilterManagerFactory.getSingleton().getIPFilter();
                    COConfigurationManager.setParameter("Ip Filter Autoload File", (String)val);
                    COConfigurationManager.setParameter("Ip Filter Autoload Last Date", 0);
                    try {
                        ipFilter.reload();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (key.equals("blocklist-enabled")) {
                    this.plugin_interface.getIPFilter().setEnabled(this.getBoolean(val));
                    continue;
                }
                if (key.equals("cache-size-mb")) continue;
                if (key.equals("download-dir")) {
                    String dir = (String)val;
                    String save_dir = pc.getCoreStringParameter("Default save path");
                    if (save_dir.equals(dir)) continue;
                    save_dir = dir;
                    pc.setCoreStringParameter("Default save path", dir);
                    continue;
                }
                if (key.equals("") || key.equals("") || key.equals("") || key.equals("") || key.equals("") || key.equals("") || key.equals("")) continue;
                if (key.equals("start-added-torrents")) {
                    COConfigurationManager.setParameter("Default Start Torrents Stopped", !this.getBoolean(val));
                    continue;
                }
                if (key.equals("rename-partial-files")) {
                    COConfigurationManager.setParameter("Rename Incomplete Files", this.getBoolean(val));
                    continue;
                }
                if (key.equals("speed-limit-down-enabled") || key.equals("downloadLimited")) {
                    int down_limit = pc.getCoreIntParameter("Max Download Speed KBs");
                    boolean enable = this.getBoolean(val);
                    if (!enable && down_limit != 0) {
                        down_limit = 0;
                        pc.setCoreIntParameter("Max Download Speed KBs", down_limit);
                        continue;
                    }
                    if (!enable || down_limit != 0) continue;
                    int lastRate = pc.getUnsafeIntParameter("config.ui.speed.partitions.manual.download.last");
                    if (lastRate <= 0) {
                        lastRate = 10;
                    }
                    pc.setCoreIntParameter("Max Download Speed KBs", lastRate);
                    continue;
                }
                if (key.equals("speed-limit-down") || key.equals("downloadLimit")) {
                    int down_limit = pc.getCoreIntParameter("Max Download Speed KBs");
                    int limit = XMWebUIPlugin.getNumber(val).intValue();
                    if (limit == down_limit) continue;
                    down_limit = limit;
                    pc.setCoreIntParameter("Max Download Speed KBs", limit);
                    continue;
                }
                if (key.equals("speed-limit-up-enabled") || key.equals("uploadLimited")) {
                    boolean enable = this.getBoolean(val);
                    pc.setCoreBooleanParameter("Auto Upload Speed Enabled", false);
                    pc.setCoreBooleanParameter("Auto Upload Speed Seeding Enabled", false);
                    int up_limit = pc.getCoreIntParameter("Max Upload Speed KBs");
                    int up_limit_seeding = pc.getCoreIntParameter("Max Upload Speed When Only Seeding KBs");
                    if (!enable) {
                        pc.setCoreIntParameter("Max Upload Speed KBs", 0);
                        pc.setCoreIntParameter("Max Upload Speed When Only Seeding KBs", 0);
                        continue;
                    }
                    if (!enable || up_limit != 0 && up_limit_seeding != 0) continue;
                    int lastRate = pc.getUnsafeIntParameter("config.ui.speed.partitions.manual.upload.last");
                    if (lastRate <= 0) {
                        lastRate = 10;
                    }
                    pc.setCoreIntParameter("Max Upload Speed KBs", lastRate);
                    pc.setCoreIntParameter("Max Upload Speed When Only Seeding KBs", lastRate);
                    continue;
                }
                if (key.equals("speed-limit-up") || key.equals("uploadLimit")) {
                    pc.setCoreBooleanParameter("Auto Upload Speed Enabled", false);
                    pc.setCoreBooleanParameter("Auto Upload Speed Seeding Enabled", false);
                    int limit = XMWebUIPlugin.getNumber(val).intValue();
                    pc.setCoreIntParameter("Max Upload Speed KBs", limit);
                    pc.setCoreIntParameter("Max Upload Speed When Only Seeding KBs", limit);
                    continue;
                }
                if (key.equals("peer-port") || key.equals("port")) {
                    int port = XMWebUIPlugin.getNumber(val).intValue();
                    pc.setCoreIntParameter("Incoming TCP Port", port);
                    continue;
                }
                if (key.equals("encryption")) {
                    String value = (String)val;
                    boolean required = value.equals("required");
                    COConfigurationManager.setParameter("network.transport.encrypted.require", required);
                    continue;
                }
                if (key.equals("seedRatioLimit")) {
                    float ratio = XMWebUIPlugin.getNumber(val).floatValue();
                    COConfigurationManager.setParameter("Stop Ratio", ratio);
                    continue;
                }
                if (key.equals("seedRatioLimited")) {
                    boolean limit = this.getBoolean(val);
                    float ratio = limit ? (args.containsKey("seedRatioLimit") ? XMWebUIPlugin.getNumber(args.get("seedRatioLimit"), Float.valueOf(2.0f)).floatValue() : 2.0f) : 0.0f;
                    COConfigurationManager.setParameter("Stop Ratio", ratio);
                    continue;
                }
                if (!this.trace_param.getValue()) continue;
                this.log("Unhandled session-set field: " + key);
            }
            catch (Throwable t) {
                Debug.out(String.valueOf(key) + ":" + val, t);
            }
        }
    }

    private void method_Blocklist_Update(Map args, Map result) {
        this.log("blocklist-update not supported");
    }

    private void method_Torrent_Rename_Path(Map args, Map result) {
        if (this.trace_param.getValue()) {
            this.log("unhandled method: torrent-rename-path - " + args);
        }
    }

    private void method_Torrent_Set_Location(Map args, Map result) throws IOException, DownloadException {
        this.checkUpdatePermissions();
        Object ids = args.get("ids");
        boolean moveData = this.getBoolean(args.get("move"));
        String sSavePath = (String)args.get("location");
        List<DownloadStub> downloads = this.getDownloads(ids, false);
        File fSavePath = new File(sSavePath);
        for (DownloadStub download_stub : downloads) {
            String parentPath;
            Download download = XMWebUIPlugin.destubbify(download_stub);
            if (moveData) {
                Torrent torrent = download.getTorrent();
                if (torrent == null || torrent.isSimpleTorrent() || fSavePath.getParentFile() == null) {
                    download.moveDataFiles(fSavePath);
                    continue;
                }
                download.moveDataFiles(fSavePath.getParentFile(), fSavePath.getName());
                continue;
            }
            DownloadManager dm = PluginCoreUtils.unwrap(download);
            int state = dm.getState();
            if (state == 70 && !dm.filesExist(true)) {
                state = 100;
            }
            if (state != 100) continue;
            dm.setTorrentSaveDir(sSavePath);
            boolean found = dm.filesExist(true);
            if (!found && dm.getTorrent() != null && !dm.getTorrent().isSimpleTorrent() && (parentPath = fSavePath.getParent()) != null) {
                dm.setTorrentSaveDir(parentPath);
                found = dm.filesExist(true);
                if (!found) {
                    dm.setTorrentSaveDir(sSavePath);
                }
            }
            if (!found) continue;
            dm.stopIt(70, false, false);
            dm.setStateQueued();
        }
    }

    private void method_Session_Stats(Map args, Map result) {
        Tag tag;
        boolean all;
        List fields = (List)args.get("fields");
        boolean bl = all = fields == null || fields.size() == 0;
        if (!all) {
            Collections.sort(fields);
        }
        AzureusCore core = AzureusCoreFactory.getSingleton();
        GlobalManager gm = core.getGlobalManager();
        GlobalManagerStats stats = gm.getStats();
        TagManager tm = TagManagerFactory.getTagManager();
        if (all || Collections.binarySearch(fields, "activeTorrentCount") >= 0) {
            tag = tm.getTagType(2).getTag(7);
            result.put("activeTorrentCount", tag == null ? 0 : tag.getTaggedCount());
        }
        if (all || Collections.binarySearch(fields, "downloadSpeed") >= 0) {
            result.put("downloadSpeed", stats.getDataAndProtocolReceiveRate());
        }
        if (all || Collections.binarySearch(fields, "pausedTorrentCount") >= 0) {
            tag = tm.getTagType(2).getTag(8);
            result.put("pausedTorrentCount", tag == null ? 0 : tag.getTaggedCount());
        }
        if (all || Collections.binarySearch(fields, "torrentCount") >= 0) {
            result.put("torrentCount", gm.getDownloadManagers().size());
        }
        if (all || Collections.binarySearch(fields, "uploadSpeed") >= 0) {
            result.put("uploadSpeed", stats.getDataAndProtocolSendRate());
        }
        if (all || Collections.binarySearch(fields, "current-stats") >= 0) {
            HashMap<String, Number> current_stats = new HashMap<String, Number>();
            result.put("current-stats", current_stats);
            current_stats.put("uploadedBytes", stats.getTotalDataBytesSent());
            current_stats.put("downloadedBytes", stats.getTotalDataBytesReceived());
            long sent = stats.getTotalDataBytesSent();
            long received = stats.getTotalDataBytesReceived();
            float ratio = received == 0L ? (sent == 0L ? 1.0f : Float.MAX_VALUE) : (float)sent / (float)received;
            current_stats.put("ratio", Float.valueOf(ratio));
            current_stats.put("secondsActive", 0);
        }
        if (all || Collections.binarySearch(fields, "cumulative-stats") >= 0) {
            HashMap<String, Integer> cumulative_stats = new HashMap<String, Integer>();
            result.put("cumulative-stats", cumulative_stats);
            cumulative_stats.put("uploadedBytes", 0);
            cumulative_stats.put("downloadedBytes", 0);
            cumulative_stats.put("ratio", 0);
            cumulative_stats.put("secondsActive", 0);
            cumulative_stats.put("sessionCount", 0);
        }
    }

    private void method_Torrent_Set(String session_id, Map args, Map result) {
        Object ids = args.get("ids");
        this.handleRecentlyRemoved(session_id, args, result);
        List<DownloadStub> downloads = this.getDownloads(ids, false);
        Number speed_limit_down = XMWebUIPlugin.getNumber(args.get("downloadLimit"), XMWebUIPlugin.getNumber(args.get("speed-limit-down"), XMWebUIPlugin.getNumber(args.get("speedLimitDownload"))));
        Boolean downloadLimited = this.getBoolean("downloadLimited", null);
        List files_wanted = (List)args.get("files-wanted");
        List files_unwanted = (List)args.get("files-unwanted");
        String location = (String)args.get("location");
        List priority_high = (List)args.get("priority-high");
        List priority_low = (List)args.get("priority-low");
        List priority_normal = (List)args.get("priority-normal");
        List file_infos = (List)args.get("files");
        Number queuePosition = XMWebUIPlugin.getNumber("queuePosition", null);
        List trackerAddList = (List)args.get("trackerAdd");
        Number speed_limit_up = XMWebUIPlugin.getNumber(args.get("uploadLimit"), XMWebUIPlugin.getNumber(args.get("speed-limit-up"), XMWebUIPlugin.getNumber(args.get("speedLimitUpload"))));
        Boolean uploadLimited = this.getBoolean("uploadLimited", null);
        List tagAddList = (List)args.get("tagAdd");
        List tagRemoveList = (List)args.get("tagRemove");
        Long l_uploaded_ever = (Long)args.get("uploadedEver");
        Long l_downloaded_ever = (Long)args.get("downloadedEver");
        long uploaded_ever = l_uploaded_ever == null ? -1L : l_uploaded_ever;
        long downloaded_ever = l_downloaded_ever == null ? -1L : l_downloaded_ever;
        String name = (String)args.get("name");
        for (DownloadStub download_stub : downloads) {
            try {
                TagManager tm;
                File file;
                Download download = XMWebUIPlugin.destubbify(download_stub);
                Torrent t = download.getTorrent();
                if (t == null) continue;
                if (location != null && !(file = new File(location)).isFile()) {
                    try {
                        download.moveDataFiles(file);
                    }
                    catch (DownloadException e) {
                        Debug.out(e);
                    }
                }
                if (name != null) {
                    DownloadManager core_download = PluginCoreUtils.unwrap(download);
                    core_download.getDownloadState().setDisplayName(name);
                }
                if (queuePosition != null) {
                    download.moveTo(queuePosition.intValue());
                }
                if (trackerAddList != null) {
                    for (Object oTracker : trackerAddList) {
                        if (!(oTracker instanceof String)) continue;
                        String aTracker = (String)oTracker;
                        TorrentUtils.announceGroupsInsertFirst(PluginCoreUtils.unwrap(t), aTracker);
                    }
                }
                if (speed_limit_down != null && Boolean.TRUE.equals(downloadLimited)) {
                    download.setDownloadRateLimitBytesPerSecond(speed_limit_down.intValue());
                } else if (Boolean.FALSE.equals(downloadLimited)) {
                    download.setDownloadRateLimitBytesPerSecond(0);
                }
                if (speed_limit_up != null && Boolean.TRUE.equals(uploadLimited)) {
                    download.setUploadRateLimitBytesPerSecond(speed_limit_up.intValue());
                } else if (Boolean.FALSE.equals(uploadLimited)) {
                    download.setUploadRateLimitBytesPerSecond(0);
                }
                if (tagAddList != null && (tm = TagManagerFactory.getTagManager()).isEnabled()) {
                    TagType tt = tm.getTagType(3);
                    for (Object oTagToAdd : tagAddList) {
                        if (oTagToAdd == null) continue;
                        this.addTagToDownload(download, oTagToAdd, tt);
                    }
                }
                if (tagRemoveList != null && (tm = TagManagerFactory.getTagManager()).isEnabled()) {
                    TagType ttManual = tm.getTagType(3);
                    TagType ttCategory = tm.getTagType(1);
                    for (Object oTagToAdd : tagRemoveList) {
                        if (oTagToAdd instanceof String) {
                            Tag tag = ttManual.getTag((String)oTagToAdd, true);
                            if (tag != null) {
                                tag.removeTaggable(PluginCoreUtils.unwrap(download));
                            }
                            if ((tag = ttCategory.getTag((String)oTagToAdd, true)) == null) continue;
                            tag.removeTaggable(PluginCoreUtils.unwrap(download));
                            continue;
                        }
                        if (!(oTagToAdd instanceof Number)) continue;
                        int uid = ((Number)oTagToAdd).intValue();
                        Tag tag = ttManual.getTag(uid);
                        if (tag != null) {
                            tag.removeTaggable(PluginCoreUtils.unwrap(download));
                        }
                        if ((tag = ttCategory.getTag(uid)) == null) continue;
                        tag.removeTaggable(PluginCoreUtils.unwrap(download));
                    }
                }
                DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
                if (files_unwanted != null) {
                    int i = 0;
                    while (i < files_unwanted.size()) {
                        int index = ((Long)files_unwanted.get(i)).intValue();
                        if (index >= 0 && index <= files.length) {
                            files[index].setSkipped(true);
                        }
                        ++i;
                    }
                }
                if (files_wanted != null) {
                    int i = 0;
                    while (i < files_wanted.size()) {
                        int index = ((Long)files_wanted.get(i)).intValue();
                        if (index >= 0 && index <= files.length) {
                            files[index].setSkipped(false);
                        }
                        ++i;
                    }
                }
                if (priority_high != null) {
                    int i = 0;
                    while (i < priority_high.size()) {
                        int index = ((Long)priority_high.get(i)).intValue();
                        if (index >= 0 && index <= files.length) {
                            files[index].setNumericPriority(1);
                        }
                        ++i;
                    }
                }
                if (priority_normal != null) {
                    int i = 0;
                    while (i < priority_normal.size()) {
                        int index = ((Long)priority_normal.get(i)).intValue();
                        if (index >= 0 && index <= files.length) {
                            files[index].setNumericPriority(0);
                        }
                        ++i;
                    }
                }
                if (priority_low != null) {
                    int i = 0;
                    while (i < priority_low.size()) {
                        int index = ((Long)priority_low.get(i)).intValue();
                        if (index >= 0 && index <= files.length) {
                            files[index].setNumericPriority(-1);
                        }
                        ++i;
                    }
                }
                if (uploaded_ever != -1L || downloaded_ever != -1L) {
                    try {
                        download.getStats().resetUploadedDownloaded(uploaded_ever, downloaded_ever);
                    }
                    catch (Throwable i) {
                        // empty catch block
                    }
                }
                if (file_infos == null) continue;
                boolean paused_it = false;
                try {
                    int i = 0;
                    while (i < file_infos.size()) {
                        Map file_info = (Map)file_infos.get(i);
                        int index = ((Number)file_info.get("index")).intValue();
                        if (index < 0 || index >= files.length) {
                            throw new IOException("File index '" + index + "' invalid for '" + download.getName() + "'");
                        }
                        String new_name = (String)file_info.get("name");
                        if (new_name == null || new_name.trim().length() == 0) {
                            throw new IOException("'name' is mandatory");
                        }
                        new_name = new_name.trim();
                        DiskManagerFileInfo file2 = files[index];
                        File existing = file2.getFile(true);
                        if (!existing.getName().equals(new_name)) {
                            File new_file;
                            if (!download.isPaused()) {
                                download.pause();
                                paused_it = true;
                            }
                            if ((new_file = new File(existing.getParentFile(), new_name)).exists()) {
                                throw new IOException("new file '" + new_file + "' already exists");
                            }
                            file2.setLink(new_file);
                        }
                        ++i;
                    }
                }
                finally {
                    if (paused_it) {
                        download.resume();
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private void addTagToDownload(Download download, Object tagToAdd, TagType tt) {
        Tag tag = null;
        if (tagToAdd instanceof String) {
            String tagNameToAdd = (String)tagToAdd;
            tagToAdd = tagNameToAdd.trim();
            if (tagNameToAdd.length() == 0) {
                return;
            }
            tag = tt.getTag(tagNameToAdd, true);
            if (tag == null) {
                try {
                    tag = tt.createTag(tagNameToAdd, true);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        } else if (tagToAdd instanceof Number) {
            tag = tt.getTag(((Number)tagToAdd).intValue());
        }
        if (tag != null) {
            tag.addTaggable(PluginCoreUtils.unwrap(download));
        }
    }

    private void method_Torrent_Reannounce(Map args, Map result) throws IOException {
        this.checkUpdatePermissions();
        Object ids = args.get("ids");
        List<DownloadStub> downloads = this.getDownloads(ids, false);
        for (DownloadStub download_stub : downloads) {
            try {
                XMWebUIPlugin.destubbify(download_stub).requestTrackerAnnounce();
            }
            catch (Throwable e) {
                Debug.out("Failed to reannounce '" + download_stub.getName() + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method_Torrent_Remove(Map args, Map result) throws IOException {
        this.checkUpdatePermissions();
        Object ids = args.get("ids");
        boolean delete_data = this.getBoolean(args.get("delete-local-data"));
        List<DownloadStub> downloads = this.getDownloads(ids, true);
        for (DownloadStub download_stub : downloads) {
            try {
                if (download_stub instanceof MagnetDownload) {
                    List<MagnetDownload> list = this.magnet_downloads;
                    synchronized (list) {
                        this.magnet_downloads.remove(download_stub);
                    }
                    this.addRecentlyRemoved(download_stub);
                    continue;
                }
                Download download = XMWebUIPlugin.destubbify(download_stub);
                int state = download.getState();
                if (state != 7) {
                    download.stop();
                }
                if (delete_data) {
                    download.remove(true, true);
                } else {
                    download.remove();
                }
                this.addRecentlyRemoved(download);
            }
            catch (Throwable e) {
                Debug.out("Failed to remove download '" + download_stub.getName() + "'", e);
            }
        }
    }

    private void method_Torrent_Verify(Map args, Map result) throws IOException {
        this.checkUpdatePermissions();
        Object ids = args.get("ids");
        List<DownloadStub> downloads = this.getDownloads(ids, false);
        for (DownloadStub download_stub : downloads) {
            try {
                Download download = XMWebUIPlugin.destubbify(download_stub);
                int state = download.getState();
                if (state != 7) {
                    download.stop();
                }
                download.recheckData();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void method_Torrent_Stop(Map args, Map result) throws IOException {
        this.checkUpdatePermissions();
        Object ids = args.get("ids");
        List<DownloadStub> downloads = this.getDownloads(ids, false);
        for (DownloadStub download_stub : downloads) {
            if (download_stub.isStub()) continue;
            try {
                Download download = XMWebUIPlugin.destubbify(download_stub);
                int state = download.getState();
                if (state == 7) continue;
                download.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void method_Torrent_Start(Map args, Map result) throws IOException {
        this.checkUpdatePermissions();
        Object ids = args.get("ids");
        List<DownloadStub> downloads = this.getDownloads(ids, false);
        for (DownloadStub download_stub : downloads) {
            try {
                Download download = XMWebUIPlugin.destubbify(download_stub);
                int state = download.getState();
                if (state == 4 || state == 5) continue;
                download.restart();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void method_Torrent_Start_Now(Map args, Map result) throws IOException {
        this.checkUpdatePermissions();
        Object ids = args.get("ids");
        List<DownloadStub> downloads = this.getDownloads(ids, false);
        for (DownloadStub download_stub : downloads) {
            try {
                Download download = XMWebUIPlugin.destubbify(download_stub);
                download.startDownload(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void processVuzeFileAdd(Map args, Map result) throws IOException, TextualException {
        String added_templates;
        Throwable last_error;
        VuzeFile vf;
        VuzeFileHandler vfh;
        block20: {
            this.checkUpdatePermissions();
            vfh = VuzeFileHandler.getSingleton();
            vf = null;
            String url = (String)args.get("filename");
            last_error = null;
            if (url != null) {
                try {
                    File f = new File(new URI(url));
                    if (f.exists() && (vf = vfh.loadVuzeFile(f)) == null) {
                        throw new TextualException("Decode failed - invalid Vuze file");
                    }
                }
                catch (Throwable e) {
                    last_error = e;
                }
                if (vf == null && last_error == null) {
                    try {
                        vf = vfh.loadVuzeFile(new ResourceDownloaderFactoryImpl().create(new URL(url)).download());
                    }
                    catch (Throwable e) {
                        last_error = e;
                    }
                }
            }
            if (vf == null && last_error == null) {
                try {
                    String metainfoString = (String)args.get("metainfo");
                    byte[] metainfoBytes = null;
                    if (metainfoString != null) {
                        metainfoBytes = Base64.decode(metainfoString.replaceAll("[\r\n]+", ""));
                        vf = vfh.loadVuzeFile(metainfoBytes);
                        if (vf == null) {
                            throw new TextualException("Decode failed - invalid Vuze file");
                        }
                        break block20;
                    }
                    throw new TextualException("Missing parameter");
                }
                catch (Throwable e) {
                    last_error = e;
                }
            }
        }
        if (vf != null) {
            VuzeFileComponent[] comps;
            VuzeFileComponent[] vuzeFileComponentArray = comps = vf.getComponents();
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                VuzeFileComponent comp2 = vuzeFileComponentArray[n2];
                if (comp2.getType() != 1) {
                    throw new TextualException("Unsupported Vuze File component type: " + comp2.getTypeName());
                }
                ++n2;
            }
            vfh.handleFiles(new VuzeFile[]{vf}, 1);
            added_templates = "";
            VuzeFileComponent[] vuzeFileComponentArray2 = comps;
            int n3 = comps.length;
            n = 0;
            while (n < n3) {
                Engine e;
                VuzeFileComponent comp3 = vuzeFileComponentArray2[n];
                if (comp3.isProcessed() && (e = (Engine)comp3.getData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY)) != null) {
                    added_templates = String.valueOf(added_templates) + (added_templates == "" ? "" : ", ") + e.getName();
                }
                ++n;
            }
        } else {
            if (last_error == null) {
                throw new TextualException("Unspecified error occurred");
            }
            if (last_error instanceof TextualException) {
                throw (TextualException)last_error;
            }
            throw new TextualException("Vuze file addition failed: " + Debug.getNestedExceptionMessage(last_error));
        }
        result.put("msg", "Search templates added: " + added_templates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void method_Torrent_Add(final Map args, Map result, boolean xmlEscape) throws IOException, DownloadException, TextualException {
        this.checkUpdatePermissions();
        metainfoString = (String)args.get("metainfo");
        metainfoBytes = null;
        if (metainfoString != null) {
            metainfoBytes = Base64.decode(metainfoString.replaceAll("[\r\n]+", ""));
            vfh = VuzeFileHandler.getSingleton();
            if (vfh != null && (vf = vfh.loadVuzeFile(metainfoBytes)) != null) {
                var12_10 = comps = vf.getComponents();
                var11_13 = comps.length;
                var10_15 = 0;
                while (var10_15 < var11_13) {
                    comp = var12_10[var10_15];
                    if (comp.getType() != 1) {
                        throw new TextualException("Unsupported Vuze File component type: " + comp.getTypeName());
                    }
                    ++var10_15;
                }
                vfh.handleFiles(new VuzeFile[]{vf}, 1);
                added_templates = "";
                var13_20 = comps;
                var12_11 = comps.length;
                var11_13 = 0;
                while (var11_13 < var12_11) {
                    comp = var13_20[var11_13];
                    if (comp.isProcessed() && (e = (Engine)comp.getData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY)) != null) {
                        added_templates = String.valueOf(added_templates) + (added_templates == "" ? "" : ", ") + e.getName();
                    }
                    ++var11_13;
                }
                if (added_templates.length() == 0) {
                    throw new TextualException("No search template(s) added");
                }
                throw new TextualException("Installed search template(s): " + added_templates);
            }
        }
        download /* !! */  = null;
        url = (String)args.get("filename");
        add_stopped = this.getBoolean(args.get("paused"));
        download_dir = (String)args.get("download-dir");
        file_Download_dir = download_dir == null ? null : new File(download_dir);
        add_listener = new DownloadWillBeAddedListener(){

            @Override
            public void initialised(Download download) {
                int idx;
                int numFiles = download.getDiskManagerFileCount();
                List files_wanted = XMWebUIPlugin.this.getList(args.get("files-wanted"));
                List files_unwanted = XMWebUIPlugin.this.getList(args.get("files-unwanted"));
                boolean[] toDelete = new boolean[numFiles];
                int numWanted = files_wanted.size();
                if (numWanted != 0 && numWanted != numFiles) {
                    Arrays.fill(toDelete, true);
                    for (Object oWanted : files_wanted) {
                        idx = XMWebUIPlugin.getNumber(oWanted, -1).intValue();
                        if (idx < 0 || idx >= numFiles) continue;
                        toDelete[idx] = false;
                    }
                }
                for (Object oUnwanted : files_unwanted) {
                    idx = XMWebUIPlugin.getNumber(oUnwanted, -1).intValue();
                    if (idx < 0 || idx >= numFiles) continue;
                    toDelete[idx] = true;
                }
                int i = 0;
                while (i < toDelete.length) {
                    if (toDelete[i]) {
                        download.getDiskManagerFileInfo(i).setDeleted(true);
                    }
                    ++i;
                }
                List priority_high = XMWebUIPlugin.this.getList(args.get("priority-high"));
                for (Object oHighPriority : priority_high) {
                    int idx2 = XMWebUIPlugin.getNumber(oHighPriority, -1).intValue();
                    if (idx2 < 0 || idx2 >= numFiles) continue;
                    download.getDiskManagerFileInfo(idx2).setNumericPriority(1);
                }
                List priority_low = XMWebUIPlugin.this.getList(args.get("priority-low"));
                for (Object oLowPriority : priority_low) {
                    int idx3 = XMWebUIPlugin.getNumber(oLowPriority, -1).intValue();
                    if (idx3 < 0 || idx3 >= numFiles) continue;
                    download.getDiskManagerFileInfo(idx3).setNumericPriority(-1);
                }
                try {
                    TagManager tm;
                    List vuze_tags;
                    String vuze_category = (String)args.get("vuze_category");
                    if (vuze_category != null && (vuze_category = vuze_category.trim()).length() > 0) {
                        TorrentAttribute ta_category = XMWebUIPlugin.this.plugin_interface.getTorrentManager().getAttribute("Category");
                        download.setAttribute(ta_category, vuze_category);
                    }
                    if ((vuze_tags = (List)args.get("vuze_tags")) != null && (tm = TagManagerFactory.getTagManager()).isEnabled()) {
                        TagType tt = tm.getTagType(3);
                        for (String tag_name : vuze_tags) {
                            XMWebUIPlugin.this.addTagToDownload(download, tag_name, tt);
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        torrentManager = this.plugin_interface.getTorrentManager();
        if (metainfoBytes != null) {
            try {
                torrent = torrentManager.createFromBEncodedData(metainfoBytes);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new IOException("torrent download failed: " + Debug.getNestedExceptionMessage(e));
            }
        }
        if (url == null) {
            throw new IOException("url missing");
        }
        lc_url = (url = url.trim().replaceAll(" ", "%20")).toLowerCase(Locale.US);
        if (lc_url.startsWith("magnet:")) {
            url = String.valueOf(url) + "&dummy_param=1";
        } else if (!lc_url.startsWith("http")) {
            url = UrlUtils.parseTextForURL(url, true, true);
        }
        try {
            torrent_url = new URL(url);
        }
        catch (MalformedURLException mue) {
            throw new TextualException("The torrent URI was not valid");
        }
        try {
            dl = torrentManager.getURLDownloader(torrent_url, null, null);
            cookies = args.get("cookies");
            if (cookies != null) {
                dl.setRequestProperty("URL_Cookie", cookies);
            }
            if (is_magnet = torrent_url.getProtocol().equalsIgnoreCase("magnet")) {
                magnet_event = null;
                f_result = new Object[1];
                try {
                    sem = new AESemaphore("magnetsem");
                    f_torrent_url = torrent_url;
                    f_name = (String)args.get("name");
                    magnet_event = SimpleTimer.addEvent("magnetcheck", SystemTime.getOffsetTime(10000L), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            Object[] objectArray = f_result;
                            synchronized (f_result) {
                                if (f_result[0] != null) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return;
                                }
                                MagnetDownload magnet_download = new MagnetDownload(f_torrent_url, f_name);
                                byte[] hash = magnet_download.getTorrentHash();
                                List list = XMWebUIPlugin.this.magnet_downloads;
                                synchronized (list) {
                                    boolean duplicate = false;
                                    Iterator it = XMWebUIPlugin.this.magnet_downloads.iterator();
                                    while (it.hasNext()) {
                                        MagnetDownload md = (MagnetDownload)it.next();
                                        if (hash.length <= 0 || !Arrays.equals(hash, md.getTorrentHash())) continue;
                                        if (md.getError() == null) {
                                            duplicate = true;
                                            magnet_download = md;
                                            break;
                                        }
                                        it.remove();
                                        XMWebUIPlugin.this.addRecentlyRemoved(md);
                                    }
                                    if (!duplicate) {
                                        XMWebUIPlugin.this.magnet_downloads.add(magnet_download);
                                    }
                                }
                                f_result[0] = magnet_download;
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                sem.release();
                                return;
                            }
                        }
                    });
                    new AEThread2("magnetasync"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            try {
                                try {
                                    Torrent torrent = dl.download("UTF8");
                                    Object[] objectArray = f_result;
                                    synchronized (f_result) {
                                        if (f_result[0] == null) {
                                            f_result[0] = torrent;
                                        } else {
                                            boolean already_removed;
                                            MagnetDownload md = (MagnetDownload)f_result[0];
                                            List list = XMWebUIPlugin.this.magnet_downloads;
                                            synchronized (list) {
                                                already_removed = !XMWebUIPlugin.this.magnet_downloads.remove(md);
                                            }
                                            if (already_removed) return;
                                            XMWebUIPlugin.this.addRecentlyRemoved(md);
                                            XMWebUIPlugin.this.addTorrent(torrent, file_Download_dir, add_stopped, add_listener);
                                        }
                                        // ** MonitorExit[var2_3] (shouldn't be in output)
                                        return;
                                    }
                                }
                                catch (Throwable e) {
                                    Object[] objectArray = f_result;
                                    synchronized (f_result) {
                                        if (f_result[0] == null) {
                                            f_result[0] = e;
                                        } else {
                                            MagnetDownload md = (MagnetDownload)f_result[0];
                                            md.setError(e);
                                        }
                                        // ** MonitorExit[var2_4] (shouldn't be in output)
                                        sem.release();
                                        return;
                                    }
                                }
                            }
                            finally {
                                sem.release();
                            }
                        }
                    }.start();
                    sem.reserve();
                    var25_36 = f_result;
                    synchronized (f_result) {
                        res = f_result[0];
                        // ** MonitorExit[var25_36] (shouldn't be in output)
                        if (res instanceof Torrent) {
                            torrent = (Torrent)res;
                        } else {
                            if (res instanceof Throwable) {
                                throw (Throwable)res;
                            }
                            download /* !! */  = (MagnetDownload)res;
                            torrent = null;
                        }
                        ** break block31
                    }
                }
                finally {
                    if (magnet_event != null) {
                        magnet_event.cancel();
                    }
                }
            }
            torrent = dl.download("UTF8");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
lbl-1000:
        // 4 sources

        {
            if (download /* !! */  == null) {
                download /* !! */  = this.addTorrent(torrent, file_Download_dir, add_stopped, add_listener);
            }
            torrent_details = new HashMap<String, Object>();
            torrent_details.put("id", new Long(this.getID(download /* !! */ , true)));
            torrent_details.put("name", xmlEscape != false ? this.escapeXML(download /* !! */ .getName()) : download /* !! */ .getName());
            torrent_details.put("hashString", ByteFormatter.encodeString(download /* !! */ .getTorrentHash()));
            result.put("torrent-added", torrent_details);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map method_Torrent_Get(TrackerWebPageRequest request2, String session_id, Map args, Map result) {
        ArrayList<String> fields = (ArrayList<String>)args.get("fields");
        if (fields == null) {
            fields = new ArrayList<String>();
        }
        Object ids = args.get("ids");
        boolean is_recently_active = this.handleRecentlyRemoved(session_id, args, result);
        List<DownloadStub> downloads = this.getDownloads(ids, true);
        List file_fields = (List)args.get("file-fields");
        if (file_fields != null) {
            Collections.sort(file_fields);
        }
        LinkedHashMap<Long, Map> torrent_info = new LinkedHashMap<Long, Map>();
        String agent = MapUtils.getMapString(request2.getHeaders(), "User-Agent", "");
        boolean xmlEscape = agent.startsWith("Mozilla/");
        for (DownloadStub downloadStub : downloads) {
            if (downloadStub.isStub()) {
                this.method_Torrent_Get_Stub(request2, args, fields, torrent_info, downloadStub, file_fields, xmlEscape);
                continue;
            }
            this.method_Torrent_Get_NonStub(request2, args, fields, torrent_info, (Download)downloadStub, file_fields, xmlEscape);
        }
        if (is_recently_active) {
            Map<String, Map<Long, String>> map = this.session_torrent_info_cache;
            synchronized (map) {
                Map<Long, String> torrent_info_cache;
                if (this.session_torrent_info_cache.size() > 8) {
                    this.session_torrent_info_cache.clear();
                }
                if ((torrent_info_cache = this.session_torrent_info_cache.get(session_id)) == null) {
                    torrent_info_cache = new HashMap<Long, String>();
                    this.session_torrent_info_cache.put(session_id, torrent_info_cache);
                }
                ArrayList<Long> same = new ArrayList<Long>();
                for (Map.Entry entry : torrent_info.entrySet()) {
                    long id = (Long)entry.getKey();
                    Map torrent = (Map)entry.getValue();
                    String current = JSONUtils.encodeToJSON(torrent);
                    String prev = torrent_info_cache.get(id);
                    if (prev != null && prev.equals(current)) {
                        same.add(id);
                        continue;
                    }
                    torrent_info_cache.put(id, current);
                }
                if (same.size() > 0) {
                    Iterator iterator = same.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        torrent_info.remove(id);
                    }
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        result.put("torrents", arrayList);
        arrayList.addAll(torrent_info.values());
        return result;
    }

    private void method_Torrent_Get_NonStub(TrackerWebPageRequest request2, Map args, List<String> fields, Map<Long, Map> torrent_info, Download download, List<String> file_fields, boolean xmlEscape) {
        Torrent t = download.getTorrent();
        if (t == null) {
            return;
        }
        long download_id = this.getID(download, true);
        DownloadManager core_download = PluginCoreUtils.unwrap(download);
        PEPeerManager pm = core_download.getPeerManager();
        DownloadStats stats = download.getStats();
        HashMap torrent = new HashMap(fields.size() + 8);
        torrent_info.put(download_id, torrent);
        int peers_from_us = 0;
        int peers_to_us = 0;
        if (pm != null) {
            List<PEPeer> peers = pm.getPeers();
            for (PEPeer peer : peers) {
                PEPeerStats pstats = peer.getStats();
                if (pstats.getDataReceiveRate() > 0L) {
                    ++peers_to_us;
                }
                if (pstats.getDataSendRate() <= 0L) continue;
                ++peers_from_us;
            }
        }
        for (String field : fields) {
            Object value = null;
            if (field.equals("activityDate")) {
                value = this.torrentGet_activityDate(core_download, false);
            } else if (field.equals("activityDateRelative")) {
                value = this.torrentGet_activityDate(core_download, true);
            } else if (field.equals("addedDate")) {
                value = core_download.getDownloadState().getLongParameter("stats.download.added.time") / 1000L;
            } else if (field.equals("announceURL")) {
                value = t.getAnnounceURL().toExternalForm();
            } else if (field.equals("bandwidthPriority")) {
                value = 0L;
            } else if (field.equals("comment")) {
                value = t.getComment();
            } else if (field.equals("corruptEver")) {
                value = stats.getDiscarded() + stats.getHashFails();
            } else if (field.equals("creator")) {
                value = t.getCreatedBy();
            } else if (field.equals("dateCreated")) {
                value = t.getCreationDate();
            } else if (field.equals("desiredAvailable")) {
                value = core_download.getStats().getRemainingExcludingDND();
            } else if (field.equals("doneDate")) {
                value = core_download.isDownloadComplete(false) ? (Number)(core_download.getDownloadState().getLongParameter("stats.download.completed.time") / 1000L) : (Number)0;
            } else if (field.equals("downloadDir")) {
                value = t.isSimpleTorrent() ? new File(download.getSavePath()).getParent() : download.getSavePath();
            } else if (field.equals("downloadedEver")) {
                value = stats.getDownloaded();
            } else if (field.equals("downloadLimit") || field.equals("speed-limit-down")) {
                value = download.getMaximumDownloadKBPerSecond();
            } else if (field.equals("downloadLimited") || field.equals("speed-limit-down-enabled")) {
                value = download.getDownloadRateLimitBytesPerSecond() > 0;
            } else if (field.equals("error")) {
                value = this.torrentGet_error(core_download, download);
            } else if (field.equals("errorString")) {
                value = this.torrentGet_errorString(core_download, download);
            } else if (field.equals("eta")) {
                value = this.torrentGet_eta(core_download, download, stats);
            } else if (field.equals("etaIdle")) {
                value = -2L;
            } else if (field.equals("files")) {
                String host = (String)request2.getHeaders().get("host");
                value = this.torrentGet_files(host, download, download_id, file_fields, args);
            } else if (field.equals("fileStats")) {
                value = this.torrentGet_fileStats(download, file_fields, args);
            } else if (field.equals("hashString")) {
                value = ByteFormatter.encodeString(t.getHash());
            } else if (field.equals("haveUnchecked")) {
                value = 0;
            } else if (field.equals("haveValid")) {
                value = stats.getDownloaded();
            } else if (field.equals("honorsSessionLimits")) {
                value = false;
            } else if (field.equals("id")) {
                value = download_id;
            } else if (field.equals("isFinished")) {
                value = false;
            } else if (field.equals("isPrivate")) {
                value = t.isPrivate();
            } else if (field.equals("isStalled")) {
                value = this.torrentGet_isStalled(download);
            } else if (field.equals("leechers")) {
                value = pm == null ? 0 : pm.getNbPeers();
            } else if (field.equals("leftUntilDone")) {
                value = core_download.getStats().getRemainingExcludingDND();
            } else if (field.equals("magnetLink")) {
                value = UrlUtils.getMagnetURI(download);
            } else if (field.equals("manualAnnounceTime")) {
                value = this.torrentGet_manualAnnounceTime(core_download);
            } else if (!field.equals("maxConnectedPeers")) {
                TRTrackerAnnouncer trackerClient;
                DownloadScrapeResult scrape;
                if (field.equals("metadataPercentComplete")) {
                    value = Float.valueOf(1.0f);
                } else if (field.equals("name")) {
                    value = download.getName();
                } else if (field.equals("peer-limit")) {
                    value = -1;
                } else if (field.equals("peers")) {
                    value = this.torrentGet_peers(core_download);
                } else if (field.equals("peersConnected")) {
                    value = pm == null ? 0 : pm.getNbPeers() + pm.getNbSeeds();
                } else if (field.equals("peersFrom")) {
                    value = this.torrentGet_peersFrom(pm);
                } else if (field.equals("peersGettingFromUs")) {
                    value = peers_from_us;
                } else if (field.equals("peersSendingToUs")) {
                    value = peers_to_us;
                } else if (field.equals("percentDone")) {
                    value = Float.valueOf((float)core_download.getStats().getPercentDoneExcludingDND() / 1000.0f);
                } else if (field.equals("pieces")) {
                    value = this.torrentGet_pieces(core_download);
                } else if (field.equals("pieceCount")) {
                    value = t.getPieceCount();
                } else if (field.equals("pieceSize")) {
                    value = t.getPieceSize();
                } else if (field.equals("priorities")) {
                    value = this.torrentGet_priorities(download);
                } else if (field.equals("queuePosition")) {
                    value = core_download.getPosition();
                } else if (field.equals("rateDownload")) {
                    value = stats.getDownloadAverage();
                } else if (field.equals("rateUpload")) {
                    value = stats.getUploadAverage();
                } else if (field.equals("recheckProgress")) {
                    value = this.torrentGet_recheckProgress(core_download, stats);
                } else if (field.equals("secondsDownloading")) {
                    value = stats.getSecondsDownloading();
                } else if (field.equals("secondsSeeding")) {
                    value = stats.getSecondsOnlySeeding();
                } else if (field.equals("seedIdleLimit")) {
                    value = (int)stats.getSecondsSinceLastUpload() / 60;
                } else if (field.equals("seedIdleMode")) {
                    value = 0L;
                } else if (field.equals("seedRatioLimit")) {
                    value = Float.valueOf(COConfigurationManager.getFloatParameter("Stop Ratio"));
                } else if (field.equals("seedRatioMode")) {
                    value = 0L;
                } else if (field.equals("sizeWhenDone")) {
                    value = core_download.getStats().getSizeExcludingDND();
                } else if (field.equals("startDate")) {
                    value = stats.getTimeStarted() / 1000L;
                } else if (field.equals("status")) {
                    value = this.torrentGet_status(download);
                } else if (field.equals("trackers")) {
                    String agent = MapUtils.getMapString(request2.getHeaders(), "User-Agent", "");
                    boolean hack = agent.contains("httpok");
                    value = this.torrentGet_trackers(core_download, hack);
                } else if (field.equals("trackerStats")) {
                    value = this.torrentGet_trackerStats(core_download);
                } else if (field.equals("totalSize")) {
                    value = t.getSize();
                } else if (field.equals("torrentFile")) {
                    value = core_download.getTorrentFileName();
                } else if (field.equals("uploadedEver")) {
                    value = stats.getUploaded();
                } else if (field.equals("uploadLimit") || field.equals("speed-limit-up")) {
                    int bps = download.getUploadRateLimitBytesPerSecond();
                    value = bps <= 0 ? bps : (bps < 1024 ? 1 : bps / 1024);
                } else if (field.equals("uploadLimited") || field.equals("speed-limit-up-enabled")) {
                    value = download.getUploadRateLimitBytesPerSecond() > 0;
                } else if (field.equals("uploadRatio")) {
                    int shareRatio = stats.getShareRatio();
                    value = shareRatio <= 0 ? (double)shareRatio : (double)stats.getShareRatio() / 1000.0;
                } else if (field.equals("wanted")) {
                    value = this.torrentGet_wanted(download);
                } else if (field.equals("webseeds")) {
                    value = this.torrentGet_webSeeds(t);
                } else if (field.equals("webseedsSendingToUs")) {
                    value = this.torrentGet_webseedsSendingToUs(core_download);
                } else if (field.equals("trackerSeeds")) {
                    scrape = download.getLastScrapeResult();
                    value = new Long(scrape == null ? 0 : scrape.getSeedCount());
                } else if (field.equals("trackerLeechers")) {
                    scrape = download.getLastScrapeResult();
                    value = new Long(scrape == null ? 0 : scrape.getNonSeedCount());
                } else if (field.equals("speedLimitDownload")) {
                    value = new Long(download.getDownloadRateLimitBytesPerSecond());
                } else if (field.equals("speedLimitUpload")) {
                    value = new Long(download.getUploadRateLimitBytesPerSecond());
                } else if (field.equals("seeders")) {
                    value = pm == null ? -1 : pm.getNbSeeds();
                } else if (field.equals("swarmSpeed")) {
                    value = new Long(core_download.getStats().getTotalAveragePerPeer());
                } else if (field.equals("announceResponse")) {
                    trackerClient = core_download.getTrackerClient();
                    value = trackerClient != null ? trackerClient.getStatusString() : "";
                } else if (field.equals("lastScrapeTime")) {
                    value = core_download.getTrackerTime();
                } else if (field.equals("scrapeURL")) {
                    URL url;
                    value = "";
                    TRTrackerScraperResponse trackerScrapeResponse = core_download.getTrackerScrapeResponse();
                    if (trackerScrapeResponse != null && (url = trackerScrapeResponse.getURL()) != null) {
                        value = url.toString();
                    }
                } else if (field.equals("nextScrapeTime")) {
                    trackerClient = core_download.getTrackerClient();
                    value = trackerClient != null ? Integer.valueOf(trackerClient.getTimeUntilNextUpdate()) : Integer.valueOf(0);
                } else if (field.equals("nextAnnounceTime")) {
                    trackerClient = core_download.getTrackerClient();
                    value = trackerClient != null ? Integer.valueOf(trackerClient.getTimeUntilNextUpdate()) : Integer.valueOf(0);
                } else if (!(field.equals("downloadLimitMode") || field.equals("uploadLimitMode") || field.equals("downloaders") || field.equals("lastAnnounceTime") || field.equals("lastScrapeTime") || field.equals("scrapeResponse") || field.equals("timesCompleted") || field.equals("peersKnown"))) {
                    if (field.equals("fileCount")) {
                        value = core_download.getNumFileInfos();
                    } else if (field.equals("speedHistory")) {
                        DownloadManagerStats core_stats = core_download.getStats();
                        core_stats.setRecentHistoryRetention(true);
                        int[][] recentHistory = core_stats.getRecentHistory();
                        long now = SystemTime.getCurrentTime();
                        long sinceSecs = XMWebUIPlugin.getNumber(args.get("speedHistorySinceSecs"), 0).longValue();
                        long since = now - sinceSecs * 1000L;
                        long curEntryTime = now - (long)(recentHistory.length * 1000);
                        ArrayList<int[]> listHistory = new ArrayList<int[]>();
                        int i = 0;
                        while (i < recentHistory.length) {
                            if (curEntryTime > since) {
                                int[] entry = recentHistory[i];
                                HashMap<String, Integer> mapHistory = new HashMap<String, Integer>(3);
                                mapHistory.put("upload", entry[0]);
                                mapHistory.put("download", entry[1]);
                                mapHistory.put("swarm", entry[2]);
                                listHistory.add(entry);
                            }
                            curEntryTime += 1000L;
                            ++i;
                        }
                        value = listHistory;
                    } else if (field.equals("tag-uids")) {
                        ArrayList<Long> listTags = new ArrayList<Long>();
                        TagManager tm = TagManagerFactory.getTagManager();
                        List<Tag> tags = tm.getTagsForTaggable(core_download);
                        if (tags == null || tags.isEmpty()) {
                            Category catUncat;
                            Category catAll = CategoryManager.getCategory(1);
                            if (catAll != null) {
                                listTags.add(catAll.getTagUID());
                            }
                            if ((catUncat = CategoryManager.getCategory(2)) != null) {
                                listTags.add(catUncat.getTagUID());
                            }
                        } else {
                            for (Tag tag : tags) {
                                listTags.add(tag.getTagUID());
                            }
                        }
                        value = listTags;
                    } else if (this.trace_param.getValue()) {
                        this.log("Unhandled get-torrent field: " + field);
                    }
                }
            }
            if (value == null) continue;
            if (xmlEscape && value instanceof String) {
                value = this.escapeXML((String)value);
            }
            torrent.put(field, value);
        }
    }

    private void method_Torrent_Get_Stub(TrackerWebPageRequest request2, Map args, List<String> fields, Map<Long, Map> torrent_info, DownloadStub download_stub, List<String> file_fields, boolean xmlEscape) {
        Object listTags;
        int pos;
        HashMap<String, Object> torrent = new HashMap<String, Object>();
        long download_id = this.getID(download_stub, true);
        torrent_info.put(download_id, torrent);
        boolean is_magnet_download = download_stub instanceof MagnetDownload;
        long status = 0L;
        long error = 0L;
        String error_str = "";
        String created_by = "";
        long create_date = 0L;
        float md_comp = 1.0f;
        if (is_magnet_download) {
            MagnetDownload md = (MagnetDownload)download_stub;
            TagManager tm = TagManagerFactory.getTagManager();
            Throwable e = md.getError();
            if (e == null) {
                status = 4L;
                md_comp = 0.0f;
                if (fields.contains("tag-uids")) {
                    ArrayList<Long> listTags2 = new ArrayList<Long>();
                    Tag tag = this.getTagFromState(4, false);
                    if (tag != null) {
                        listTags2.add(tag.getTagUID());
                    }
                    if ((tag = tm.getTagType(2).getTag(7)) != null) {
                        listTags2.add(tag.getTagUID());
                    }
                    torrent.put("tag-uids", listTags2);
                }
            } else {
                String magnet_url;
                status = 0L;
                error = 3L;
                Throwable temp = e;
                while (temp.getCause() != null) {
                    temp = temp.getCause();
                }
                String last_msg = temp.getMessage();
                error_str = last_msg != null && last_msg.length() > 0 ? last_msg : Debug.getNestedExceptionMessage(e);
                pos = error_str.indexOf(magnet_url = md.getMagnetURL().toExternalForm());
                if (pos != -1) {
                    error_str = String.valueOf(error_str.substring(0, pos)) + error_str.substring(pos + magnet_url.length());
                }
                if ((pos = (error_str = error_str.trim()).indexOf("rror:")) != -1) {
                    error_str = error_str.substring(pos + 5).trim();
                }
                if (error_str.length() > 0) {
                    error_str = String.valueOf(Character.toUpperCase(error_str.charAt(0))) + error_str.substring(1);
                }
                if (!IS_5101_PLUS && error_str.contains("bad header")) {
                    error_str = "No sources found for torrent";
                }
                if (fields.contains("tag-uids")) {
                    listTags = new ArrayList();
                    Tag tag = this.getTagFromState(7, true);
                    if (tag != null) {
                        listTags.add(tag.getTagUID());
                    }
                    torrent.put("tag-uids", listTags);
                }
            }
            created_by = "Vuze";
            create_date = md.getCreateTime() / 1000L;
        }
        long size = 0L;
        if (IS_5101_PLUS) {
            size = download_stub.getTorrentSize();
        } else if (is_magnet_download) {
            size = 16384L;
        }
        Object[][] stub_defs = new Object[][]{{"activityDate", 0}, {"activityDateRelative", 0}, {"addedDate", is_magnet_download ? create_date : 0L}, {"comment", is_magnet_download ? "Metadata Download" : "Download Archived"}, {"corruptEver", 0}, {"creator", created_by}, {"dateCreated", create_date}, {"desiredAvailable", 0}, {"downloadedEver", 0}, {"error", error}, {"errorString", error_str}, {"eta", -1L}, {"haveUnchecked", 0}, {"isFinished", !is_magnet_download}, {"isPrivate", false}, {"isStalled", false}, {"leftUntilDone", is_magnet_download ? size : 0L}, {"metadataPercentComplete", Float.valueOf(md_comp)}, {"peers", new ArrayList()}, {"peersConnected", 0}, {"peersGettingFromUs", 0}, {"peersSendingToUs", ""}, {"percentDone", Float.valueOf(is_magnet_download ? 0.0f : 100.0f)}, {"pieceCount", 1}, {"pieceSize", size == 0L ? 1L : size}, {"queuePosition", 0}, {"rateDownload", 0}, {"rateUpload", 0}, {"recheckProgress", Float.valueOf(0.0f)}, {"seedRatioLimit", Float.valueOf(1.0f)}, {"seedRatioMode", 0L}, {"startDate", is_magnet_download ? create_date : 0L}, {"status", status}, {"trackerStats", new ArrayList()}, {"trackers", new ArrayList()}, {"uploadRatio", Float.valueOf(0.0f)}, {"uploadedEver", 0}, {"webseedsSendingToUs", 0}, {"torrentFile", ""}};
        HashMap<String, Object> stub_def_map = new HashMap<String, Object>();
        listTags = stub_defs;
        pos = stub_defs.length;
        int n = 0;
        while (n < pos) {
            Object[] d = listTags[n];
            stub_def_map.put((String)d[0], d[1]);
            ++n;
        }
        for (String field : fields) {
            Object value = stub_def_map.get(field);
            if (field.equals("id")) {
                value = download_id;
            } else if (field.equals("downloadDir")) {
                value = IS_5101_PLUS ? download_stub.getSavePath() : "";
            } else if (field.equals("files")) {
                String host = (String)request2.getHeaders().get("host");
                value = this.torrentGet_files_stub(host, download_stub, download_id, file_fields, args);
            } else if (field.equals("fileStats")) {
                value = this.torrentGet_fileStats_stub(download_stub, file_fields, args);
            } else if (field.equals("hashString")) {
                value = ByteFormatter.encodeString(download_stub.getTorrentHash());
            } else if (field.equals("haveValid")) {
                value = is_magnet_download ? 0L : size;
            } else if (field.equals("name")) {
                value = download_stub.getName();
            } else if (field.equals("sizeWhenDone")) {
                value = size;
            } else if (field.equals("totalSize")) {
                value = size;
            } else if (field.equals("tag-uids")) {
                Category catUncat;
                Category catAll;
                Tag tag;
                listTags = MapUtils.getMapList(torrent, field, new ArrayList());
                TagManager tm = TagManagerFactory.getTagManager();
                if (listTags.size() == 0) {
                    tag = this.getTagFromState(7, !is_magnet_download);
                    if (tag != null) {
                        listTags.add(tag.getTagUID());
                    }
                    if ((tag = tm.getTagType(2).getTag(9)) != null) {
                        listTags.add(tag.getTagUID());
                    }
                }
                if ((tag = tm.getTagType(2).getTag(is_magnet_download ? 11 : 10)) != null) {
                    listTags.add(tag.getTagUID());
                }
                if ((catAll = CategoryManager.getCategory(1)) != null) {
                    listTags.add(catAll.getTagUID());
                }
                if ((catUncat = CategoryManager.getCategory(2)) != null) {
                    listTags.add(catUncat.getTagUID());
                }
                value = listTags;
            }
            if (value != null) {
                if (xmlEscape && value instanceof String) {
                    value = this.escapeXML((String)value);
                }
                torrent.put(field, value);
                continue;
            }
            if (!this.trace_param.getValue()) continue;
            this.log("Unknown field: " + field);
        }
    }

    private Tag getTagFromState(int state, boolean complete) {
        int id = 0;
        switch (state) {
            case 4: {
                id = 1;
                break;
            }
            case 5: {
                id = 2;
                break;
            }
            case 9: {
                id = complete ? 4 : 3;
                break;
            }
            case 6: 
            case 7: {
                id = 5;
                break;
            }
            case 8: {
                id = 6;
            }
        }
        TagManager tm = TagManagerFactory.getTagManager();
        return tm.getTagType(2).getTag(id);
    }

    private Object torrentGet_webseedsSendingToUs(DownloadManager core_download) {
        PEPeerManager peerManager = core_download.getPeerManager();
        if (peerManager == null) {
            return 0;
        }
        int numWebSeedsConnected = 0;
        List<PEPeer> peers = peerManager.getPeers();
        for (PEPeer peer : peers) {
            if (!peer.getProtocol().toLowerCase().startsWith("http")) continue;
            ++numWebSeedsConnected;
        }
        return numWebSeedsConnected;
    }

    private Object torrentGet_webSeeds(Torrent t) {
        List getright = BDecoder.decodeStrings(this.getURLList(t, "url-list"));
        List webseeds = BDecoder.decodeStrings(this.getURLList(t, "httpseeds"));
        ArrayList list = new ArrayList();
        List[] listArray = new List[]{getright, webseeds};
        int n = listArray.length;
        int n2 = 0;
        while (n2 < n) {
            List l = listArray[n2];
            for (Object o : l) {
                if (!(o instanceof String)) continue;
                list.add(o);
            }
            ++n2;
        }
        return list;
    }

    private Object torrentGet_recheckProgress(DownloadManager core_download, DownloadStats stats) {
        DiskManager dm;
        double x = 1.0;
        if (core_download.getState() == 30 && (dm = core_download.getDiskManager()) != null) {
            x = (double)stats.getCompleted() / 1000.0;
        }
        return x;
    }

    private Object torrentGet_priorities(Download download) {
        DiskManagerFileInfo[] fileInfos;
        ArrayList<Long> list = new ArrayList<Long>();
        DiskManagerFileInfo[] diskManagerFileInfoArray = fileInfos = download.getDiskManagerFileInfo();
        int n = fileInfos.length;
        int n2 = 0;
        while (n2 < n) {
            DiskManagerFileInfo fileInfo2 = diskManagerFileInfoArray[n2];
            int priority = fileInfo2.getNumericPriorty();
            long newPriority = TransmissionVars.convertVuzePriority(priority);
            list.add(newPriority);
            ++n2;
        }
        return list;
    }

    private Object torrentGet_pieces(DownloadManager core_download) {
        String value = null;
        DiskManager dm = core_download.getDiskManager();
        if (dm != null) {
            DiskManagerPiece[] pieces = dm.getPieces();
            byte[] bits = new byte[(int)Math.ceil((float)pieces.length / 8.0f)];
            int pieceNo = 0;
            int bitPos = 0;
            while (pieceNo < pieces.length) {
                bits[bitPos] = 0;
                int i = 0;
                while (pieceNo < pieces.length && i < 8) {
                    boolean done = pieces[pieceNo].isDone();
                    if (done) {
                        int n = bitPos;
                        bits[n] = (byte)(bits[n] | (byte)(1 << i));
                    }
                    ++pieceNo;
                    ++i;
                }
                ++bitPos;
            }
            try {
                value = new String(Base64.encode(bits), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }

    private Object torrentGet_peersFrom(PEPeerManager pm) {
        HashMap<String, Long> mapPeersFrom = new HashMap<String, Long>();
        if (pm == null) {
            return mapPeersFrom;
        }
        List<PEPeer> peers = pm.getPeers();
        for (PEPeer peer : peers) {
            String peerSource = peer.getPeerSource();
            if (peerSource == null) continue;
            if (!mapPeersFrom.containsKey(peerSource = peerSource.equals("Tracker") ? "fromTracker" : (peerSource.equals("DHT") ? "fromDht" : (peerSource.equals("Incoming") ? "fromIncoming" : (peerSource.equals("PeerExchange") ? "fromPex" : (peerSource.equals("Plugin") ? "fromCache" : "fromCache")))))) {
                mapPeersFrom.put(peerSource, 1L);
                continue;
            }
            mapPeersFrom.put(peerSource, (Long)mapPeersFrom.get(peerSource) + 1L);
        }
        return mapPeersFrom;
    }

    private Object torrentGet_manualAnnounceTime(DownloadManager manager) {
        TRTrackerScraperResponse sr;
        TRTrackerAnnouncer trackerClient = manager.getTrackerClient();
        Number value = trackerClient != null ? (Number)Math.max(SystemTime.getCurrentTime() / 1000L, (long)(trackerClient.getLastUpdateTime() + 60)) : (Number)((sr = manager.getTrackerScrapeResponse()) == null ? (Number)0 : (Number)Math.max(SystemTime.getCurrentTime() / 1000L, sr.getScrapeStartTime() / 1000L + 120L));
        return value;
    }

    private Object torrentGet_eta(DownloadManager core_download, Download download, DownloadStats stats) {
        long eta_secs;
        int state = download.getState();
        Long value = state == 4 ? ((eta_secs = core_download.getStats().getSmoothedETA()) == -1L ? Long.valueOf(-1L) : (eta_secs >= 315360000000L ? Long.valueOf(-2L) : Long.valueOf(eta_secs))) : (state == 5 ? Long.valueOf(-1L) : Long.valueOf(-1L));
        return value;
    }

    private Object torrentGet_trackers(DownloadManager core_download, boolean hack) {
        ArrayList trackers = new ArrayList();
        List<TrackerPeerSource> trackerPeerSources = core_download.getTrackerPeerSources();
        if (trackerPeerSources == null) {
            return trackers;
        }
        for (TrackerPeerSource tps : trackerPeerSources) {
            String statusString = tps.getStatusString();
            if (statusString == null) {
                statusString = "";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String name = "";
            try {
                name = tps.getName();
            }
            catch (Exception e) {
                name = tps.getClass().getSimpleName();
            }
            if (hack && !name.contains("://")) {
                name = "://" + name;
            }
            map.put("id", tps.hashCode());
            map.put("announce", name);
            map.put("scrape", name);
            map.put("tier", 0);
            trackers.add(map);
        }
        return trackers;
    }

    private Object torrentGet_trackerStats(DownloadManager core_download) {
        ArrayList tracker_stats = new ArrayList();
        List<TrackerPeerSource> trackerPeerSources = core_download.getTrackerPeerSources();
        if (trackerPeerSources == null) {
            return tracker_stats;
        }
        for (TrackerPeerSource tps : trackerPeerSources) {
            String statusString = tps.getStatusString();
            if (statusString == null) {
                statusString = "";
            }
            HashMap<String, Object> map = new HashMap<String, Object>(64);
            map.put("downloadCount", -1);
            map.put("hasAnnounced", tps.getPeers() >= 0);
            map.put("hasScraped", false);
            String name = "";
            try {
                name = tps.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put("host", name);
            map.put("announce", name);
            map.put("scrape", name);
            map.put("isBackup", false);
            int status = tps.getStatus();
            int state = status == 7 || status == 5 ? 1 : (status == 4 ? 3 : (status == 3 ? 2 : 0));
            map.put("announceState", state);
            map.put("scrapeState", state);
            map.put("lastAnnouncePeerCount", tps.getPeers());
            if (statusString != null) {
                map.put("lastAnnounceResult", statusString);
            }
            map.put("lastAnnounceStartTime", 0);
            map.put("lastAnnounceSucceeded", tps.getPeers() >= 0);
            map.put("lastAnnounceTimedOut", false);
            map.put("lastAnnounceTime", 0);
            if (statusString != null) {
                map.put("lastScrapeResult", statusString);
            }
            map.put("lastScrapeStartTime", 0);
            map.put("lastScrapeSucceeded", tps.getPeers() >= 0);
            map.put("lastScrapeTimedOut", false);
            map.put("lastScrapeTime", 0);
            map.put("leecherCount", tps.getLeecherCount());
            map.put("nextAnnounceTime", 0);
            map.put("nextScrapeTime", 0);
            map.put("seederCount", tps.getSeedCount());
            map.put("tier", 0);
            map.put("id", tps.hashCode());
            tracker_stats.add(map);
        }
        return tracker_stats;
    }

    private Object torrentGet_status(Download download) {
        DownloadManager core_download;
        int ERROR;
        int SEEDING;
        int STOPPED;
        int QUEUED_COMPLETE;
        int QUEUED_INCOMPLETE;
        int DOWNLOADING;
        int CHECKING;
        int CHECK_WAIT;
        boolean RPC_14_OR_HIGHER = true;
        if (RPC_14_OR_HIGHER) {
            CHECK_WAIT = 1;
            CHECKING = 2;
            DOWNLOADING = 4;
            QUEUED_INCOMPLETE = 3;
            QUEUED_COMPLETE = 5;
            STOPPED = 0;
            SEEDING = 6;
            ERROR = STOPPED;
        } else {
            CHECK_WAIT = 1;
            CHECKING = 2;
            DOWNLOADING = 4;
            QUEUED_INCOMPLETE = 5;
            QUEUED_COMPLETE = 9;
            STOPPED = 16;
            SEEDING = 8;
            ERROR = 0;
        }
        int state = download.getState();
        int status_int = state == 4 ? DOWNLOADING : (state == 5 ? SEEDING : (state == 9 ? (download.isComplete() ? QUEUED_COMPLETE : QUEUED_INCOMPLETE) : (state == 7 || state == 6 ? STOPPED : (state == 8 ? ERROR : ((core_download = PluginCoreUtils.unwrap(download)).getState() == 30 ? CHECKING : CHECK_WAIT)))));
        return status_int;
    }

    private Object torrentGet_wanted(Download download) {
        DiskManagerFileInfo[] files;
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        DiskManagerFileInfo[] diskManagerFileInfoArray = files = download.getDiskManagerFileInfo();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
            list.add(!file.isSkipped());
            ++n2;
        }
        return list;
    }

    private Object torrentGet_fileStats(Download download, List<String> file_fields, Map args) {
        ArrayList stats_list = new ArrayList();
        DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
        int i = 0;
        while (i < files.length) {
            DiskManagerFileInfo file = files[i];
            TreeMap map = new TreeMap();
            stats_list.add(map);
            this.torrentGet_fileStats(map, file_fields, file);
            ++i;
        }
        return stats_list;
    }

    private void torrentGet_fileStats(Map map, List<String> sortedFields, DiskManagerFileInfo file) {
        boolean all;
        boolean bl = all = sortedFields == null || sortedFields.size() == 0;
        if (all || Collections.binarySearch(sortedFields, "bytesCompleted") >= 0) {
            map.put("bytesCompleted", file.getDownloaded());
        }
        if (all || Collections.binarySearch(sortedFields, "wanted") >= 0) {
            map.put("wanted", !file.isSkipped());
        }
        if (all || Collections.binarySearch(sortedFields, "priority") >= 0) {
            map.put("priority", TransmissionVars.convertVuzePriority(file.getNumericPriority()));
        }
    }

    private Object torrentGet_fileStats_stub(DownloadStub download_stub, List<String> file_fields, Map args) {
        DownloadStub.DownloadStubFile[] stubFiles = download_stub.getStubFiles();
        ArrayList stats_list = new ArrayList();
        int i = 0;
        while (i < stubFiles.length) {
            TreeMap map = new TreeMap();
            stats_list.add(map);
            DownloadStub.DownloadStubFile sf = stubFiles[i];
            this.torrentGet_fileStats_stub(map, null, sf);
            ++i;
        }
        return stats_list;
    }

    private void torrentGet_fileStats_stub(Map map, List<String> sortedFields, DownloadStub.DownloadStubFile sf) {
        boolean all;
        long len = sf.getLength();
        boolean bl = all = sortedFields == null || sortedFields.size() == 0;
        if (all || Collections.binarySearch(sortedFields, "bytesCompleted") >= 0) {
            long downloaded = len < 0L ? 0L : len;
            map.put("bytesCompleted", downloaded);
        }
        if (all || Collections.binarySearch(sortedFields, "wanted") >= 0) {
            map.put("wanted", len >= 0L);
        }
        if (all || Collections.binarySearch(sortedFields, "priority") >= 0) {
            map.put("priority", TransmissionVars.convertVuzePriority(0));
        }
    }

    private Object torrentGet_files(String host, Download download, long download_id, List<String> file_fields, Map args) {
        ArrayList<Map> file_list = new ArrayList<Map>();
        List listHCs = MapUtils.getMapList(args, "files-hc-" + download_id, null);
        DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
        int[] file_indexes = this.getFileIndexes(args, download_id);
        String baseURL = MapUtils.getMapString(args, "base-url", null);
        if (file_indexes == null || file_indexes.length == 0) {
            int i = 0;
            while (i < files.length) {
                DiskManagerFileInfo file = files[i];
                TreeMap<String, Integer> map = new TreeMap<String, Integer>();
                map.put("index", i);
                this.torrentGet_files(map, file_fields, host, baseURL, download, file);
                if (file_fields != null && file_fields.size() > 0) {
                    this.torrentGet_fileStats(map, file_fields, file);
                }
                this.hashAndAdd(map, file_list, listHCs, i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < file_indexes.length) {
                int file_index = file_indexes[i];
                if (file_index >= 0 && file_index < files.length) {
                    TreeMap<String, Integer> map = new TreeMap<String, Integer>();
                    map.put("index", file_index);
                    DiskManagerFileInfo fileInfo2 = files[file_index];
                    this.torrentGet_fileStats(map, file_fields, fileInfo2);
                    this.torrentGet_files(map, file_fields, host, baseURL, download, fileInfo2);
                    this.hashAndAdd(map, file_list, listHCs, i);
                }
                ++i;
            }
        }
        return file_list;
    }

    private void torrentGet_files(Map obj, List<String> sortedFields, String host, String baseURL, Download download, DiskManagerFileInfo file) {
        boolean all;
        boolean bl = all = sortedFields == null || sortedFields.size() == 0;
        if (all || Collections.binarySearch(sortedFields, "bytesCompleted") >= 0) {
            obj.put("bytesCompleted", file.getDownloaded());
        }
        if (all || Collections.binarySearch(sortedFields, "length") >= 0) {
            obj.put("length", file.getLength());
        }
        if (all || Collections.binarySearch(sortedFields, "name") >= 0) {
            boolean simpleTorrent;
            String absolutePath = file.getFile(true).getAbsolutePath();
            String savePath = download.getSavePath();
            Torrent torrent = download.getTorrent();
            boolean bl2 = simpleTorrent = torrent == null ? false : torrent.isSimpleTorrent();
            if (simpleTorrent) {
                obj.put("name", file.getFile().getName());
            } else if (absolutePath.startsWith(savePath)) {
                obj.put("name", absolutePath.substring(savePath.length() + 1));
            } else {
                obj.put("name", absolutePath);
            }
        }
        if (sortedFields != null) {
            URL f_stream_url;
            boolean showAllVuze;
            boolean bl3 = showAllVuze = sortedFields.size() == 0;
            if ((showAllVuze || Collections.binarySearch(sortedFields, "contentURL") >= 0) && (f_stream_url = PlayUtils.getMediaServerContentURL(file)) != null) {
                String s = this.adjustURL(host, f_stream_url);
                if (baseURL != null && s.startsWith(baseURL)) {
                    s = s.substring(baseURL.length(), s.length());
                }
                obj.put("contentURL", s);
            }
            if (showAllVuze || Collections.binarySearch(sortedFields, "fullPath") >= 0) {
                obj.put("fullPath", file.getFile().toString());
            }
        }
    }

    private Object torrentGet_files_stub(String host, DownloadStub download_stub, long download_id, List<String> file_fields, Map args) {
        DownloadStub.DownloadStubFile[] stubFiles = download_stub.getStubFiles();
        ArrayList<Map> file_list = new ArrayList<Map>();
        List listHCs = MapUtils.getMapList(args, "files-hc" + download_id, null);
        int[] file_indexes = this.getFileIndexes(args, download_id);
        if (file_indexes == null || file_indexes.length == 0) {
            int i = 0;
            while (i < stubFiles.length) {
                DownloadStub.DownloadStubFile sf = stubFiles[i];
                TreeMap<String, Integer> map = new TreeMap<String, Integer>();
                map.put("index", i);
                this.torrentGet_file_stub(map, file_fields, host, sf);
                if (file_fields != null && file_fields.size() > 0) {
                    this.torrentGet_fileStats_stub(map, file_fields, sf);
                }
                this.hashAndAdd(map, file_list, listHCs, i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < file_indexes.length) {
                int file_index = file_indexes[i];
                if (file_index >= 0 && file_index < stubFiles.length) {
                    TreeMap<String, Integer> map = new TreeMap<String, Integer>();
                    file_list.add(map);
                    map.put("index", file_index);
                    DownloadStub.DownloadStubFile file = stubFiles[file_index];
                    this.torrentGet_fileStats_stub(map, file_fields, file);
                    this.torrentGet_file_stub(map, file_fields, host, file);
                    this.hashAndAdd(map, file_list, listHCs, i);
                }
                ++i;
            }
        }
        return file_list;
    }

    private int[] getFileIndexes(Map args, long download_id) {
        Object file_ids = args.get("file-indexes-" + download_id);
        int[] file_indexes = null;
        if (file_ids instanceof Number) {
            file_indexes = new int[]{((Number)file_ids).intValue()};
        } else if (file_ids instanceof List) {
            List listFileIDs = (List)file_ids;
            file_indexes = new int[listFileIDs.size()];
            int i = 0;
            while (i < listFileIDs.size()) {
                Object o = listFileIDs.get(i);
                if (o instanceof Number) {
                    file_indexes[i] = ((Number)o).intValue();
                }
                ++i;
            }
        }
        return file_indexes;
    }

    private void torrentGet_file_stub(Map map, List<String> sortedFields, String host, DownloadStub.DownloadStubFile sf) {
        boolean all;
        long downloaded;
        long len = sf.getLength();
        if (len < 0L) {
            downloaded = 0L;
            len = -len;
        } else {
            downloaded = len;
        }
        boolean bl = all = sortedFields == null || sortedFields.size() == 0;
        if (all || Collections.binarySearch(sortedFields, "bytesCompleted") >= 0) {
            map.put("bytesCompleted", downloaded);
        }
        if (all || Collections.binarySearch(sortedFields, "length") >= 0) {
            map.put("length", len);
        }
        if (all || Collections.binarySearch(sortedFields, "name") >= 0) {
            map.put("name", sf.getFile().getName());
        }
        if (sortedFields != null && Collections.binarySearch(sortedFields, "fullPath") >= 0) {
            map.put("fullPath", sf.getFile().toString());
        }
    }

    private Object torrentGet_errorString(DownloadManager core_download, Download download) {
        String value;
        String str = download.getErrorStateDetails();
        if (str != null && str.length() > 0) {
            value = str;
        } else {
            value = "";
            TRTrackerAnnouncer tracker_client = core_download.getTrackerClient();
            if (tracker_client != null) {
                TRTrackerAnnouncerResponse x = tracker_client.getBestAnnouncer().getLastResponse();
                if (x != null && x.getStatus() == 1) {
                    value = x.getStatusString();
                }
            } else {
                DownloadScrapeResult x = download.getLastScrapeResult();
                if (x != null && x.getResponseType() == 2) {
                    value = x.getStatus();
                }
            }
        }
        return value;
    }

    private Object torrentGet_error(DownloadManager core_download, Download download) {
        Number value;
        String str = download.getErrorStateDetails();
        if (str != null && str.length() > 0) {
            value = 3L;
        } else {
            value = 0;
            TRTrackerAnnouncer tracker_client = core_download.getTrackerClient();
            if (tracker_client != null) {
                TRTrackerAnnouncerResponse x = tracker_client.getBestAnnouncer().getLastResponse();
                if (x != null && x.getStatus() == 1) {
                    value = 2L;
                }
            } else {
                String status;
                DownloadScrapeResult x = download.getLastScrapeResult();
                if (x != null && x.getResponseType() == 2 && (status = x.getStatus()) != null && status.length() > 0) {
                    value = 2L;
                }
            }
        }
        return value;
    }

    private Object torrentGet_activityDate(DownloadManager download, boolean relative) {
        int state = download.getState();
        if (state == 60 || state == 50) {
            int r = download.getStats().getTimeSinceLastDataReceivedInSeconds();
            int s = download.getStats().getTimeSinceLastDataSentInSeconds();
            long l = r > 0 && s > 0 ? (long)Math.min(r, s) : (r < 0 ? (long)s : (long)r);
            if (relative) {
                return -l;
            }
            return SystemTime.getCurrentTime() / 1000L - l;
        }
        return 0;
    }

    private Object torrentGet_isStalled(Download download) {
        DefaultRankCalculator calc;
        Boolean value = false;
        int state = download.getState();
        if ((state == 5 || state == 4) && (calc = StartStopRulesDefaultPlugin.getRankCalculator(download)) != null) {
            value = state == 5 && !calc.getActivelySeeding() || state == 4 && !calc.getActivelyDownloading();
        }
        return value;
    }

    private List torrentGet_peers(DownloadManager core_download) {
        ArrayList peers = new ArrayList();
        if (core_download == null) {
            return peers;
        }
        PEPeerManager pm = core_download.getPeerManager();
        if (pm == null) {
            return peers;
        }
        List<PEPeer> peerList = pm.getPeers();
        for (PEPeer peer : peerList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            peers.add(map);
            boolean isDownloadingFrom = peer.isDownloadPossible() && peer.getStats().getDataReceiveRate() > 0L;
            map.put("address", peer.getIp());
            map.put("clientName", peer.getClient());
            map.put("clientIsChoked", peer.isChokedByMe());
            map.put("clientIsInterested", peer.isInterested());
            StringBuffer flagStr = new StringBuffer();
            if (isDownloadingFrom) {
                flagStr.append('D');
            }
            map.put("flagStr", flagStr.toString());
            String[] countryDetails = PeerUtils.getCountryDetails(peer);
            if (countryDetails != null && countryDetails.length > 0) {
                map.put("cc", countryDetails[0]);
            }
            map.put("isDownloadingFrom", isDownloadingFrom);
            map.put("isEncrypted", !"None".equals(peer.getEncryption()));
            map.put("isIncoming", peer.isIncoming());
            map.put("isUploadingTo", peer.getStats().getDataSendRate() > 0L);
            map.put("isUTP", peer.getProtocol().equals("uTP"));
            map.put("peerIsChoked", peer.isChokingMe());
            map.put("peerIsInterested", peer.isInteresting());
            map.put("port", peer.getPort());
            map.put("progress", (double)peer.getPercentDoneInThousandNotation() / 1000.0);
            map.put("rateToClient", peer.getStats().getDataReceiveRate());
            map.put("rateToPeer", peer.getStats().getDataSendRate());
        }
        return peers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DownloadStub> getAllDownloads(boolean include_magnet_dowloads) {
        MagnetDownload[] downloads3;
        Download[] downloads1 = this.plugin_interface.getDownloadManager().getDownloads();
        DownloadStub[] downloads2 = this.plugin_interface.getDownloadManager().getDownloadStubs();
        if (include_magnet_dowloads) {
            List<MagnetDownload> list = this.magnet_downloads;
            synchronized (list) {
                downloads3 = this.magnet_downloads.toArray(new MagnetDownload[this.magnet_downloads.size()]);
            }
        } else {
            downloads3 = new MagnetDownload[]{};
        }
        ArrayList<DownloadStub> result = new ArrayList<DownloadStub>(downloads1.length + downloads2.length + downloads3.length);
        result.addAll(Arrays.asList(downloads1));
        result.addAll(Arrays.asList(downloads2));
        result.addAll(Arrays.asList(downloads3));
        return result;
    }

    protected List<DownloadStub> getDownloads(Object ids, boolean include_magnet_dowloads) {
        ArrayList<DownloadStub> downloads = new ArrayList<DownloadStub>();
        List<DownloadStub> all_downloads = this.getAllDownloads(include_magnet_dowloads);
        ArrayList<Long> selected_ids = new ArrayList<Long>();
        ArrayList<String> selected_hashes = new ArrayList<String>();
        if (ids != null) {
            if (ids instanceof String) {
                ids = null;
            } else if (ids instanceof Number) {
                selected_ids.add(((Number)ids).longValue());
            } else if (ids instanceof List) {
                List l = (List)ids;
                for (DownloadStub o : l) {
                    if (o instanceof Number) {
                        selected_ids.add(((Number)((Object)o)).longValue());
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    selected_hashes.add((String)((Object)o));
                }
            }
        }
        boolean hide_ln = this.hide_ln_param.getValue();
        for (DownloadStub download_stub : all_downloads) {
            if (download_stub.isStub()) {
                if (ids == null) {
                    downloads.add(download_stub);
                    continue;
                }
                long id = this.getID(download_stub, true);
                if (selected_ids.contains(id)) {
                    downloads.add(download_stub);
                    continue;
                }
                if (!selected_hashes.contains(ByteFormatter.encodeString(download_stub.getTorrentHash()))) continue;
                downloads.add(download_stub);
                continue;
            }
            try {
                Download download = XMWebUIPlugin.destubbify(download_stub);
                if (hide_ln && download.getFlag(16L) || download.getFlag(512L)) continue;
                if (ids == null) {
                    downloads.add(download);
                    continue;
                }
                long id = this.getID(download, true);
                if (selected_ids.contains(id)) {
                    downloads.add(download);
                    continue;
                }
                Torrent t = download.getTorrent();
                if (t == null || !selected_hashes.contains(ByteFormatter.encodeString(t.getHash()))) continue;
                downloads.add(download);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        Collections.sort(downloads, new Comparator<DownloadStub>(){

            @Override
            public int compare(DownloadStub arg0, DownloadStub arg1) {
                long res = XMWebUIPlugin.this.getID(arg0, true) - XMWebUIPlugin.this.getID(arg1, true);
                if (res < 0L) {
                    return -1;
                }
                if (res > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        return downloads;
    }

    public List<DownloadManager> getDownloadManagerListFromIDs(GlobalManager gm, Object ids) {
        List<DownloadStub> downloads = this.getDownloads(ids, false);
        ArrayList<DownloadManager> list = new ArrayList<DownloadManager>(downloads.size());
        for (DownloadStub downloadStub : downloads) {
            try {
                DownloadManager dm;
                Download download = XMWebUIPlugin.destubbify(downloadStub);
                if (download == null || (dm = PluginCoreUtils.unwrap(download)) == null) continue;
                list.add(dm);
            }
            catch (Throwable e) {
                Debug.out("Failed to get dm '" + downloadStub.getName() + "'", e);
            }
        }
        return list;
    }

    protected List getList(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        return new ArrayList();
    }

    protected boolean getBoolean(Object o) {
        return this.getBoolean(o, false);
    }

    protected Boolean getBoolean(Object o, Boolean defaultVal) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return ((String)o).equalsIgnoreCase("true");
        }
        if (o instanceof Number) {
            if (((Number)o).intValue() != 0) {
                return true;
            }
            return false;
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getID(DownloadStub download_stub, boolean allocate_if_new) {
        XMWebUIPlugin xMWebUIPlugin = this;
        synchronized (xMWebUIPlugin) {
            if (this.check_ids_outstanding) {
                this.check_ids_outstanding = false;
                List<DownloadStub> all_downloads = this.getAllDownloads(true);
                HashSet<Long> all_ids = new HashSet<Long>();
                ArrayList<DownloadStub> dups = new ArrayList<DownloadStub>();
                long max_id = 0L;
                for (DownloadStub d : all_downloads) {
                    long id = this.getID(d, false);
                    if (id <= 0L) continue;
                    max_id = Math.max(max_id, id);
                    if (all_ids.contains(id)) {
                        dups.add(d);
                        continue;
                    }
                    all_ids.add(id);
                }
                PluginConfig config = this.plugin_interface.getPluginconfig();
                long next_id = max_id + 1L;
                for (DownloadStub d : dups) {
                    d.setLongAttribute(this.t_id, next_id++);
                }
                config.setPluginParameter("xmui.next.id", next_id);
            }
        }
        long id = download_stub.getLongAttribute(this.t_id);
        if (id == 0L && allocate_if_new) {
            XMWebUIPlugin xMWebUIPlugin2 = this;
            synchronized (xMWebUIPlugin2) {
                PluginConfig config = this.plugin_interface.getPluginconfig();
                id = config.getPluginLongParameter("xmui.next.id", 1L);
                config.setPluginParameter("xmui.next.id", id + 1L);
            }
            download_stub.setLongAttribute(this.t_id, id);
        }
        return id;
    }

    private String getAZMode() {
        if (this.az_mode == null) {
            this.az_mode = this.plugin_interface.getUtilities().getFeatureManager().isFeatureInstalled("core") ? "plus" : "trial";
        }
        return this.az_mode;
    }

    private void processVuzeTorrentGet(TrackerWebPageRequest request2, Map args, Map result) {
        Object ids = args.get("ids");
        List<DownloadStub> downloads = this.getDownloads(ids, true);
        ArrayList torrents = new ArrayList(downloads.size());
        result.put("torrents", torrents);
        List requested_files = (List)args.get("files");
        String host = (String)request2.getHeaders().get("host");
        for (DownloadStub download_stub : downloads) {
            HashMap<String, Object> torrent = new HashMap<String, Object>();
            torrents.add(torrent);
            long id = this.getID(download_stub, true);
            torrent.put("id", id);
            if (download_stub.isStub()) continue;
            try {
                URL f_stream_url;
                HashMap<String, Object> f_map;
                TOTorrent to_torrent;
                Download download = download_stub.destubbify();
                DownloadManager dm = PluginCoreUtils.unwrap(download);
                if (dm == null) continue;
                DiskManagerFileInfo file = null;
                try {
                    file = PluginCoreUtils.wrap(dm.getDownloadState().getPrimaryFile());
                }
                catch (DownloadException e) {
                    continue;
                }
                if (file == null) continue;
                URL stream_url = PlayUtils.getMediaServerContentURL(file);
                if (stream_url != null) {
                    torrent.put("contentURL", this.adjustURL(host, stream_url));
                }
                if ((to_torrent = dm.getTorrent()) != null) {
                    String url = PlatformTorrentUtils.getContentThumbnailUrl(to_torrent);
                    if (url != null) {
                        torrent.put("thumbnailURL", url);
                    } else {
                        byte[] data = PlatformTorrentUtils.getContentThumbnail(to_torrent);
                        if (data != null) {
                            torrent.put("thumbnailURL", this.getThumbnailResourceURL(id));
                        }
                    }
                }
                if (requested_files == null) continue;
                ArrayList file_info = new ArrayList();
                torrent.put("files", file_info);
                DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
                if (requested_files.size() == 0) {
                    DiskManagerFileInfo[] diskManagerFileInfoArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DiskManagerFileInfo f = diskManagerFileInfoArray[n2];
                        f_map = new HashMap<String, Object>();
                        file_info.add(f_map);
                        f_map.put("index", f.getIndex());
                        f_stream_url = PlayUtils.getMediaServerContentURL(f);
                        if (f_stream_url != null) {
                            f_map.put("contentURL", this.adjustURL(host, f_stream_url));
                        }
                        ++n2;
                    }
                    continue;
                }
                for (Number num : requested_files) {
                    int index = num.intValue();
                    if (index < 0 || index >= files.length) continue;
                    DiskManagerFileInfo f = files[index];
                    f_map = new HashMap();
                    file_info.add(f_map);
                    f_map.put("index", f.getIndex());
                    f_stream_url = PlayUtils.getMediaServerContentURL(f);
                    if (f_stream_url == null) continue;
                    f_map.put("contentURL", this.adjustURL(host, f_stream_url));
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private String getThumbnailResourceURL(long id) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("type", 0);
        map.put("id", id);
        String json = JSONUtils.encodeToJSON(map);
        return "/vuze/resource?json=" + UrlUtils.encode(json);
    }

    private boolean processResourceRequest(TrackerWebPageRequest request2, TrackerWebPageResponse response, Map request_json) throws IOException {
        int type = ((Number)request_json.get("type")).intValue();
        if (type == 0) {
            long id = ((Number)request_json.get("id")).longValue();
            List<DownloadStub> list = this.getDownloads(id, false);
            if (list == null || list.size() != 1) {
                throw new IOException("Unknown download id: " + id);
            }
            try {
                Download download = list.get(0).destubbify();
                Torrent torrent = download.getTorrent();
                byte[] data = PlatformTorrentUtils.getContentThumbnail(PluginCoreUtils.unwrap(torrent));
                response.setContentType("image/jpeg");
                response.getOutputStream().write(data);
            }
            catch (Throwable e) {
                throw new IOException("Failed to get thumbnail: " + Debug.getNestedExceptionMessage(e));
            }
            return true;
        }
        throw new IOException("Unknown resource type: " + type);
    }

    private String adjustURL(String host, URL url) {
        if (host == null || host.length() == 0) {
            return url.toExternalForm();
        }
        int pos = host.indexOf(58);
        if (pos != -1) {
            host = host.substring(0, pos).trim();
        }
        return UrlUtils.setHost(url, host).toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVuzeLifecycle(Map<String, Object> args, Map<String, Object> result) throws IOException {
        block46: {
            this.checkUpdatePermissions();
            String cmd = (String)args.get("cmd");
            if (cmd == null) {
                throw new IOException("cmd missing");
            }
            try {
                if (cmd.equals("status")) {
                    Object object = this.lifecycle_lock;
                    synchronized (object) {
                        result.put("state", this.lifecycle_state);
                        break block46;
                    }
                }
                if (cmd.equals("close")) {
                    Object object = this.lifecycle_lock;
                    synchronized (object) {
                        if (this.lifecycle_state >= 2) {
                            return;
                        }
                        this.lifecycle_state = 2;
                    }
                    PluginManager.stopAzureus();
                    break block46;
                }
                if (cmd.equals("restart")) {
                    Object object = this.lifecycle_lock;
                    synchronized (object) {
                        if (this.lifecycle_state >= 2) {
                            return;
                        }
                        this.lifecycle_state = 3;
                    }
                    PluginManager.restartAzureus();
                    break block46;
                }
                if (cmd.equals("update-check")) {
                    Object object = this.lifecycle_lock;
                    synchronized (object) {
                        if (this.lifecycle_state != 1) {
                            throw new IOException("update check can't currently be performed");
                        }
                        if (this.update_in_progress) {
                            throw new IOException("update operation in progress");
                        }
                        this.update_in_progress = true;
                    }
                    try {
                        UpdateManager update_manager = this.plugin_interface.getUpdateManager();
                        final UpdateCheckInstance checker = update_manager.createUpdateCheckInstance();
                        final ArrayList l_updates = new ArrayList();
                        final AESemaphore sem = new AESemaphore("uc-wait");
                        checker.addListener(new UpdateCheckInstanceListener(){

                            @Override
                            public void cancelled(UpdateCheckInstance instance) {
                                sem.release();
                            }

                            @Override
                            public void complete(UpdateCheckInstance instance) {
                                try {
                                    Update[] updates = instance.getUpdates();
                                    int i = 0;
                                    while (i < updates.length) {
                                        Update update = updates[i];
                                        l_updates.add("Update available for '" + update.getName() + "', new version = " + update.getNewVersion());
                                        ++i;
                                    }
                                    checker.cancel();
                                }
                                finally {
                                    sem.release();
                                }
                            }
                        });
                        checker.start();
                        sem.reserve();
                        result.put("updates", l_updates);
                    }
                    catch (Throwable throwable) {
                        Object object2 = this.lifecycle_lock;
                        synchronized (object2) {
                            this.update_in_progress = false;
                        }
                        throw throwable;
                    }
                    Object object3 = this.lifecycle_lock;
                    synchronized (object3) {
                        this.update_in_progress = false;
                        break block46;
                    }
                }
                if (cmd.equals("update-apply")) {
                    Object update_manager = this.lifecycle_lock;
                    synchronized (update_manager) {
                        if (this.lifecycle_state != 1) {
                            throw new IOException("update check can't currently be performed");
                        }
                        if (this.update_in_progress) {
                            throw new IOException("update operation in progress");
                        }
                        this.update_in_progress = true;
                    }
                    try {
                        update_manager = this.plugin_interface.getUpdateManager();
                        UpdateCheckInstance checker = update_manager.createUpdateCheckInstance();
                        final AESemaphore sem = new AESemaphore("uc-wait");
                        final Throwable[] error = new Throwable[1];
                        final boolean[] restarting = new boolean[1];
                        checker.addListener(new UpdateCheckInstanceListener(){

                            @Override
                            public void cancelled(UpdateCheckInstance instance) {
                                sem.release();
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Loose catch block
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Override
                            public void complete(UpdateCheckInstance instance) {
                                Update[] updates = instance.getUpdates();
                                try {
                                    Update[] updateArray = updates;
                                    int n = updates.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Update update = updateArray[n2];
                                        ResourceDownloader[] resourceDownloaderArray = update.getDownloaders();
                                        int n3 = resourceDownloaderArray.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            ResourceDownloader rd = resourceDownloaderArray[n4];
                                            rd.addListener(new ResourceDownloaderAdapter(){

                                                @Override
                                                public void reportActivity(ResourceDownloader downloader, String activity) {
                                                }

                                                @Override
                                                public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                                                }
                                            });
                                            rd.download();
                                            ++n4;
                                        }
                                        ++n2;
                                    }
                                    boolean restart_required = false;
                                    int i = 0;
                                    while (i < updates.length) {
                                        if (updates[i].getRestartRequired() == 2) {
                                            restart_required = true;
                                        }
                                        ++i;
                                    }
                                    if (!restart_required) return;
                                    Object object = XMWebUIPlugin.this.lifecycle_lock;
                                    synchronized (object) {
                                        block14: {
                                            if (XMWebUIPlugin.this.lifecycle_state >= 2) return;
                                            XMWebUIPlugin.this.lifecycle_state = 3;
                                            break block14;
                                            {
                                                catch (Throwable throwable) {
                                                    throw throwable;
                                                }
                                            }
                                        }
                                        try {
                                            // MONITOREXIT @DISABLED, blocks:[0, 3, 4, 5] lbl38 : MonitorExitStatement: MONITOREXIT : var4_6
                                            PluginManager.restartAzureus();
                                            restarting[0] = true;
                                            return;
                                        }
                                        catch (Throwable e) {
                                            error[0] = e;
                                        }
                                        return;
                                    }
                                }
                                finally {
                                    sem.release();
                                }
                            }
                        });
                        checker.start();
                        sem.reserve();
                        if (error[0] != null) {
                            throw new IOException("Failed to apply updates: " + Debug.getNestedExceptionMessage(error[0]));
                        }
                        result.put("restarting", restarting[0]);
                    }
                    catch (Throwable throwable) {
                        Object object = this.lifecycle_lock;
                        synchronized (object) {
                            this.update_in_progress = false;
                        }
                        throw throwable;
                    }
                    Object object = this.lifecycle_lock;
                    synchronized (object) {
                        this.update_in_progress = false;
                        break block46;
                    }
                }
                throw new IOException("Unknown cmd: " + cmd);
            }
            catch (PluginException e) {
                throw new IOException("Lifecycle command failed: " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    private void processVuzePairing(Map<String, Object> args, Map<String, Object> result) throws IOException {
        block13: {
            this.checkUpdatePermissions();
            String cmd = (String)args.get("cmd");
            if (cmd == null) {
                throw new IOException("cmd missing");
            }
            PairingManager pm = PairingManagerFactory.getSingleton();
            if (cmd.equals("status")) {
                result.put("status", pm.getStatus());
                boolean enabled = pm.isEnabled();
                result.put("enabled", enabled);
                if (enabled) {
                    result.put("access_code", pm.peekAccessCode());
                }
                boolean srp_enabled = pm.isSRPEnabled();
                result.put("srp_enabled", srp_enabled);
                if (srp_enabled) {
                    result.put("srp_status", pm.getSRPStatus());
                }
                break block13;
            }
            if (cmd.equals("set-enabled")) {
                boolean enabled = (Boolean)args.get("enabled");
                if (enabled != pm.isEnabled()) {
                    pm.setEnabled(enabled);
                }
                break block13;
            }
            if (cmd.equals("set-srp-enabled")) {
                boolean enabled = (Boolean)args.get("enabled");
                if (enabled != pm.isSRPEnabled()) {
                    if (enabled) {
                        String pw = (String)args.get("password");
                        if (pw == null) {
                            throw new IOException("Password required when enabling SRP");
                        }
                        pm.setSRPEnabled(true);
                        pm.setSRPPassword(pw.toCharArray());
                    } else {
                        pm.setSRPEnabled(false);
                    }
                }
                break block13;
            }
            throw new IOException("Unknown cmd: " + cmd);
        }
    }

    protected String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("--", "&#45;&#45;");
        return str;
    }

    private Number getTrackerID(TrackerPeerSource source) {
        return (long)((source.getName().hashCode() << 4) + source.getType());
    }

    protected List getURLList(Torrent torrent, String key) {
        Object obj = torrent.getAdditionalProperty(key);
        if (obj instanceof byte[]) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(obj);
            return l;
        }
        if (obj instanceof List) {
            return (List)BEncoder.clone(obj);
        }
        return new ArrayList();
    }

    private void hashAndAdd(SortedMap map, List<Map> addToList, List hcMatchList, int i) {
        boolean remove;
        long hashCode = this.longHashSimpleMap(map);
        String hc = Long.toHexString(hashCode);
        boolean bl = remove = hcMatchList != null && i < hcMatchList.size() && hc.equals(hcMatchList.get(i));
        if (!remove) {
            map.put("hc", hc);
            addToList.add(map);
        }
    }

    private long longHashSimpleMap(SortedMap<?, ?> map) {
        long hash = 0L;
        Object hc = map.get("hc");
        if (hc instanceof String) {
            return Long.parseLong((String)hc, 16);
        }
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            hash = hash * 31L + XMWebUIPlugin.hash(key.toString());
            if (value instanceof String) {
                hash = hash * 31L + XMWebUIPlugin.hash((String)value);
                continue;
            }
            if (value instanceof Number) {
                hash = hash * 31L + (long)((Number)value).hashCode();
                continue;
            }
            if (value instanceof SortedMap) {
                hash = hash * 31L + this.longHashSimpleMap((SortedMap)value);
                continue;
            }
            if (value instanceof Collection) {
                hash = hash * 31L + this.longHashSimpleList((List)value);
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            hash = hash * 31L + (long)((Boolean)value != false ? 1231 : 1237);
        }
        return hash;
    }

    private long longHashSimpleList(Collection<?> list) {
        long hash = 0L;
        for (Object value : list) {
            if (value instanceof String) {
                hash = hash * 31L + XMWebUIPlugin.hash((String)value);
                continue;
            }
            if (value instanceof Number) {
                hash = hash * 31L + (long)((Number)value).hashCode();
                continue;
            }
            if (value instanceof SortedMap) {
                hash = hash * 31L + this.longHashSimpleMap((SortedMap)value);
                continue;
            }
            if (value instanceof Collection) {
                hash = hash * 31L + this.longHashSimpleList((Collection)value);
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            hash = hash * 31L + (long)((Boolean)value != false ? 1231 : 1237);
        }
        return hash;
    }

    public static long hash(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        int i = 0;
        while (i < len) {
            h = 31L * h + (long)string.charAt(i);
            ++i;
        }
        return h;
    }

    @Override
    protected void log(String str) {
        super.log(str);
    }

    private class MagnetDownload
    implements DownloadStub {
        private URL magnet_url;
        private String name;
        private byte[] hash;
        private long create_time;
        private Map<TorrentAttribute, Long> attributes = new HashMap<TorrentAttribute, Long>();
        private String temp_dir = AETemporaryFileHandler.getTempDirectory().getAbsolutePath();
        private Throwable error;

        private MagnetDownload(URL _magnet, String friendlyName) {
            this.create_time = SystemTime.getCurrentTime();
            this.magnet_url = _magnet;
            String str = this.magnet_url.toExternalForm();
            int pos = str.indexOf(63);
            if (pos != -1) {
                str = str.substring(pos + 1);
            }
            String[] args = str.split("&");
            HashMap<String, String> arg_map = new HashMap<String, String>();
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                String[] bits = arg.split("=");
                if (bits.length == 2) {
                    try {
                        String lhs = bits[0].trim().toLowerCase(Locale.US);
                        String rhs = URLDecoder.decode(bits[1].trim(), "UTF8");
                        if (lhs.equals("xt")) {
                            if (rhs.toLowerCase(Locale.US).startsWith("urn:btih:")) {
                                arg_map.put(lhs, rhs);
                            } else {
                                String existing = (String)arg_map.get("xt");
                                if (existing == null || !existing.toLowerCase(Locale.US).startsWith("urn:btih:") && rhs.startsWith("urn:sha1:")) {
                                    arg_map.put(lhs, rhs);
                                }
                            }
                        } else {
                            arg_map.put(lhs, rhs);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            this.hash = new byte[0];
            String hash_str = (String)arg_map.get("xt");
            if (hash_str != null && ((hash_str = hash_str.toLowerCase(Locale.US)).startsWith("urn:btih:") || hash_str.startsWith("urn:sha1"))) {
                this.hash = UrlUtils.decodeSHA1Hash(hash_str.substring(9));
            }
            this.name = (String)arg_map.get("dn");
            if (this.name == null) {
                this.name = friendlyName != null ? friendlyName : (this.hash == null ? this.magnet_url.toExternalForm() : Base32.encode(this.hash));
            }
            this.name = "Magnet download for '" + this.name + "'";
            XMWebUIPlugin.this.getID(this, true);
        }

        private long getCreateTime() {
            return this.create_time;
        }

        private URL getMagnetURL() {
            return this.magnet_url;
        }

        @Override
        public boolean isStub() {
            return true;
        }

        @Override
        public Download destubbify() throws DownloadException {
            throw new DownloadException("Not supported");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public byte[] getTorrentHash() {
            return this.hash;
        }

        @Override
        public Torrent getTorrent() {
            return null;
        }

        @Override
        public long getTorrentSize() {
            return 16384L;
        }

        @Override
        public String getSavePath() {
            return this.temp_dir;
        }

        private void setError(Throwable e) {
            this.error = e;
        }

        private Throwable getError() {
            return this.error;
        }

        @Override
        public DownloadStub.DownloadStubFile[] getStubFiles() {
            return new DownloadStub.DownloadStubFile[0];
        }

        @Override
        public long getLongAttribute(TorrentAttribute attribute) {
            Long l = this.attributes.get(attribute);
            return l == null ? 0L : l;
        }

        @Override
        public void setLongAttribute(TorrentAttribute attribute, long value) {
            this.attributes.put(attribute, value);
        }

        @Override
        public void remove() throws DownloadException, DownloadRemovalVetoException {
        }
    }

    protected class PermissionDeniedException
    extends IOException {
        private static final long serialVersionUID = -344396020759893604L;

        protected PermissionDeniedException() {
        }
    }

    private class RecentlyRemovedData {
        private final long id;
        private final long create_time = SystemTime.getMonotonousTime();

        private RecentlyRemovedData(long _id) {
            this.id = _id;
        }

        private long getID() {
            return this.id;
        }

        private long getCreateTime() {
            return this.create_time;
        }

        private boolean hasSession(String session) {
            return false;
        }
    }
}

