/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnpmediaserver;

import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaRenderer;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServer;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServerContentDirectory;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServerErrorListener;
import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class UPnPMediaRendererRemote
implements UPnPMediaRenderer,
UPnPRootDeviceListener {
    private UPnPMediaServer plugin;
    private UPnPRootDevice root;
    private UPnPService rendering_control;
    private UPnPService connection_manager;
    private UPnPService av_transport;
    private String current_connection_id;
    private String current_av_id;
    private AESemaphore action_sem = new AESemaphore("UPnPMediaRenderer:action", 1);
    private String[] sinkProtocols;

    protected UPnPMediaRendererRemote(UPnPMediaServer _plugin, UPnPRootDevice _root) {
        this.plugin = _plugin;
        this.root = _root;
        this.log("Found " + this.root.getDevice().getFriendlyName());
        UPnPService[] services = this.root.getDevice().getServices();
        int i = 0;
        while (i < services.length) {
            UPnPService service = services[i];
            service.setDirectInvocations(true);
            String service_type = service.getServiceType();
            if (service_type.equals("urn:schemas-upnp-org:service:RenderingControl:1")) {
                this.log("    found RenderingControl");
                this.rendering_control = service;
            } else if (service_type.equals("urn:schemas-upnp-org:service:ConnectionManager:1")) {
                this.log("    found ConnectionManager");
                this.connection_manager = service;
                this.fillSinkProtocolList();
            } else if (service_type.equals("urn:schemas-upnp-org:service:AVTransport:1")) {
                this.log("    found AVTransport");
                this.av_transport = service;
            }
            ++i;
        }
        this.root.addListener(this);
    }

    private void fillSinkProtocolList() {
        try {
            try {
                this.action_sem.reserve();
                UPnPAction info = this.connection_manager.getAction("GetProtocolInfo");
                UPnPActionInvocation invoke = info.getInvocation();
                Map res = invoke.invoke2();
                String sink = (String)res.get("Sink");
                this.sinkProtocols = sink.split(",");
            }
            catch (Throwable e) {
                this.sinkProtocols = new String[0];
                this.log("getSupportedSourceProtocols failed: " + e.getMessage());
                Debug.printStackTrace(e);
                this.action_sem.release();
            }
        }
        finally {
            this.action_sem.release();
        }
    }

    protected UPnPRootDevice getDevice() {
        return this.root;
    }

    @Override
    public void lost(UPnPRootDevice root, boolean replaced) {
        this.destroy();
    }

    @Override
    public void play(UPnPMediaServerContentDirectory.contentItem item, int stream_id) {
        this.play(item, stream_id, null);
    }

    @Override
    public void play(final UPnPMediaServerContentDirectory.contentItem item, final int stream_id, final UPnPMediaServerErrorListener error_listener) {
        new AEThread("UPnPMediaRenderer:play", true){

            @Override
            public void runSupport() {
                block2: {
                    try {
                        UPnPMediaRendererRemote.this.playSupport(item, stream_id);
                    }
                    catch (UPnPException e) {
                        if (error_listener == null) break block2;
                        error_listener.upnpSoapException(e);
                    }
                }
            }
        }.start();
    }

    protected void playSupport(UPnPMediaServerContentDirectory.contentItem item, int stream_id) throws UPnPException {
        try {
            Map res;
            block26: {
                this.action_sem.reserve();
                if (this.current_connection_id != null) {
                    try {
                        UPnPActionInvocation invoke;
                        this.log("Getting status");
                        boolean stop_required = true;
                        try {
                            UPnPAction info = this.av_transport.getAction("GetTransportInfo");
                            invoke = info.getInvocation();
                            invoke.addArgument("InstanceID", this.current_av_id);
                            res = invoke.invoke2();
                            String state = (String)res.get("CurrentTransportState");
                            String status = (String)res.get("CurrentTransportStatus");
                            stop_required = !state.equals("STOPPED") && !state.equals("NO_MEDIA_PRESENT");
                            this.log("    state=" + state + ", status = " + status);
                        }
                        catch (Throwable info) {
                            // empty catch block
                        }
                        if (stop_required) {
                            this.log("Stopping previous play");
                            try {
                                UPnPAction stop = this.av_transport.getAction("Stop");
                                invoke = stop.getInvocation();
                                invoke.addArgument("InstanceID", this.current_av_id);
                                invoke.invoke();
                            }
                            catch (Throwable stop) {
                                // empty catch block
                            }
                        }
                        this.log("Completing previous connection");
                        try {
                            UPnPAction complete = this.connection_manager.getAction("ConnectionComplete");
                            if (complete != null) {
                                invoke = complete.getInvocation();
                                invoke.addArgument("ConnectionID", this.current_connection_id);
                                invoke.invoke();
                                break block26;
                            }
                            this.log("    No complete action available");
                        }
                        catch (Throwable complete) {}
                    }
                    finally {
                        this.current_connection_id = null;
                        this.current_av_id = null;
                    }
                }
            }
            String name = this.root.getDevice().getFriendlyName();
            if (this.connection_manager == null || this.av_transport == null) {
                this.log("Can't play on '" + name + "' as no connection manager or av transport");
                return;
            }
            try {
                String connection_ids;
                UPnPAction actionConnectionIDs;
                String[] contentTypes;
                String contentType;
                this.log("Preparing for connection to '" + name + "'");
                UPnPAction prepare = this.connection_manager.getAction("PrepareForConnection");
                if (prepare != null && (contentType = this.calculateContentType(contentTypes = item.getContentTypes())) != null) {
                    try {
                        UPnPActionInvocation invoke = prepare.getInvocation();
                        invoke.addArgument("RemoteProtocolInfo", item.getProtocolInfo(contentType, "*"));
                        invoke.addArgument("PeerConnectionManager", "");
                        invoke.addArgument("PeerConnectionID", "-1");
                        invoke.addArgument("Direction", "Input");
                        Map res2 = invoke.invoke2();
                        String connection_id = (String)res2.get("ConnectionID");
                        String av_id = (String)res2.get("AVTransportID");
                        String rcs_id = (String)res2.get("RcsID");
                        this.current_connection_id = connection_id;
                        this.current_av_id = av_id;
                    }
                    catch (Exception e) {
                        this.log(e.toString());
                    }
                }
                if (this.current_connection_id == null && (actionConnectionIDs = this.connection_manager.getAction("GetCurrentConnectionIDs")) != null && (connection_ids = (String)(res = actionConnectionIDs.getInvocation().invoke2()).get("ConnectionIDs")) != null) {
                    this.current_connection_id = connection_ids.split(",")[0];
                }
                if (this.current_connection_id == null) {
                    this.current_connection_id = "0";
                }
                if (this.current_av_id == null) {
                    this.current_av_id = "0";
                }
                this.log("Setting transport URI");
                UPnPAction set_uri = this.av_transport.getAction("SetAVTransportURI");
                UPnPActionInvocation invoke = set_uri.getInvocation();
                String host = this.root.getLocalAddress().getHostAddress();
                invoke.addArgument("InstanceID", this.current_av_id);
                invoke.addArgument("CurrentURI", item.getURI(host, -1));
                String didl = item.getDIDL(host, stream_id);
                invoke.addArgument("CurrentURIMetaData", "&lt;DIDL-Lite xmlns=&quot;urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/&quot; xmlns:dc=&quot;http://purl.org/dc/elements/1.1/&quot; xmlns:upnp=&quot;urn:schemas-upnp-org:metadata-1-0/upnp/&quot;&gt;&lt;item id=&quot;0&quot;&gt;" + this.plugin.escapeXML(didl) + "&lt;/item&gt;&lt;/DIDL-Lite&gt;");
                invoke.invoke();
                this.log("Queueing");
                UPnPAction play = this.av_transport.getAction("Play");
                invoke = play.getInvocation();
                invoke.addArgument("InstanceID", this.current_av_id);
                invoke.addArgument("Speed", "1");
                invoke.invoke();
                this.log("Playing");
            }
            catch (Throwable e) {
                this.log("Play operation failed: " + e.getMessage());
                Debug.printStackTrace(e);
                if (e instanceof UPnPException) {
                    throw (UPnPException)e;
                }
            }
        }
        finally {
            this.action_sem.release();
        }
    }

    public String[] getSupportedSourceProtocols() {
        if (this.sinkProtocols != null) {
            return this.sinkProtocols;
        }
        return new String[0];
    }

    @Override
    public boolean isBusy() {
        return this.action_sem.getValue() == 0;
    }

    @Override
    public void destroy() {
        this.root.removeListener(this);
        this.plugin.removeRenderer(this);
    }

    protected void log(String str) {
        this.plugin.log("Renderer: " + str);
    }

    public String calculateContentType(String[] contentTypes) {
        String[] protocols = this.getSupportedSourceProtocols();
        String[] stringArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String[] stringArray2 = protocols;
            int n3 = protocols.length;
            int n4 = 0;
            while (n4 < n3) {
                String protocol = stringArray2[n4];
                if (protocol.startsWith(type, 11)) {
                    return type;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

