/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.remsearch;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginEngine;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginPageGenerator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.json.simple.JSONObject;

public class RemSearchPluginSearch
implements ResultListener {
    private RemSearchPluginPageGenerator generator;
    private String request_headers;
    private String originator;
    private String expression;
    private boolean json_output;
    private String sid;
    private long create_time;
    private Map<String, engineResult> engine_results = new HashMap<String, engineResult>();
    private boolean destroyed;

    protected RemSearchPluginSearch(RemSearchPluginPageGenerator _generator, String _request_headers, String _originator, String _expression, boolean _json_output) {
        this.generator = _generator;
        this.request_headers = _request_headers;
        this.originator = _originator;
        this.expression = _expression;
        this.json_output = _json_output;
        byte[] bytes = new byte[16];
        RandomUtils.nextSecureBytes(bytes);
        this.sid = Base32.encode(bytes);
        this.create_time = SystemTime.getMonotonousTime();
    }

    public String getRequestHeaders() {
        return this.request_headers;
    }

    public String getOriginator() {
        return this.originator;
    }

    public String getExpression() {
        return this.expression;
    }

    public long getAge() {
        return SystemTime.getMonotonousTime() - this.create_time;
    }

    protected String getSID() {
        return this.sid;
    }

    protected void setEngines(RemSearchPluginEngine[] engines) {
        int i = 0;
        while (i < engines.length) {
            RemSearchPluginEngine engine = engines[i];
            this.getResult(engine).setEngine(engine);
            ++i;
        }
    }

    protected void handleResultReceiver(String eid, TrackerWebPageResponse request2) throws IOException {
        this.getResultByEID(eid).setResultReceiver(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected engineResult getResult(RemSearchPluginEngine engine) {
        Map<String, engineResult> map = this.engine_results;
        synchronized (map) {
            engineResult result = this.engine_results.get(engine.getUID());
            if (result == null) {
                result = new engineResult(engine);
                this.engine_results.put(engine.getUID(), result);
                if (this.destroyed) {
                    result.destroy();
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected engineResult getResultByEID(String eid) throws IOException {
        Map<String, engineResult> map = this.engine_results;
        synchronized (map) {
            engineResult result = this.engine_results.get(eid);
            if (result == null) {
                throw new IOException("Engine '" + eid + "' not found");
            }
            return result;
        }
    }

    @Override
    public void contentReceived(Engine engine, String content2) {
    }

    @Override
    public void matchFound(Engine engine, String[] fields) {
    }

    @Override
    public void engineFailed(Engine engine, Throwable e) {
        this.getResult(this.generator.getEngine(engine)).setFailed(e);
    }

    @Override
    public void engineRequiresLogin(Engine engine, Throwable e) {
        this.engineFailed(engine, e);
    }

    @Override
    public void resultsComplete(Engine engine) {
        this.getResult(this.generator.getEngine(engine)).setComplete();
    }

    @Override
    public void resultsReceived(Engine engine, Result[] results) {
        ResultWrapper[] rw = new ResultWrapper[results.length];
        int i = 0;
        while (i < results.length) {
            rw[i] = new ResultWrapper(results[i]);
            ++i;
        }
        this.getResult(this.generator.getEngine(engine)).addResults(rw);
    }

    public void resultsReceived(Engine engine, SubscriptionResult[] results) {
        ResultWrapper[] rw = new ResultWrapper[results.length];
        int i = 0;
        while (i < results.length) {
            rw[i] = new ResultWrapper(results[i]);
            ++i;
        }
        this.getResult(this.generator.getEngine(engine)).addResults(rw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCompleteness() {
        ArrayList<engineResult> ok = new ArrayList<engineResult>();
        ArrayList<engineResult> failed = new ArrayList<engineResult>();
        Map<String, engineResult> map = this.engine_results;
        synchronized (map) {
            for (engineResult result : this.engine_results.values()) {
                if (!result.isDone()) {
                    return;
                }
                if (result.succeeded()) {
                    ok.add(result);
                    continue;
                }
                failed.add(result);
            }
        }
        this.generator.complete(this, ok, failed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<engineResult> ok = new ArrayList<engineResult>();
        ArrayList<engineResult> failed = new ArrayList<engineResult>();
        Map<String, engineResult> map = this.engine_results;
        synchronized (map) {
            this.destroyed = true;
            for (engineResult result : this.engine_results.values()) {
                result.destroy();
                if (result.succeeded()) {
                    ok.add(result);
                    continue;
                }
                failed.add(result);
            }
        }
        this.generator.complete(this, ok, failed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        String e_str = "";
        Map<String, engineResult> map = this.engine_results;
        synchronized (map) {
            for (Map.Entry<String, engineResult> entry : this.engine_results.entrySet()) {
                e_str = String.valueOf(e_str) + (e_str.length() == 0 ? "" : ", ") + entry.getKey() + "=" + (entry.getValue().isDone() ? "Y" : "N");
            }
        }
        return String.valueOf(this.getSID()) + " - " + e_str;
    }

    private class ResultWrapper {
        private Map map;

        private ResultWrapper(Result result) {
            this.map = result.toJSONMap();
        }

        private ResultWrapper(SubscriptionResult result) {
            this.map = result.toJSONMap();
        }

        public Map toJSONMap() {
            return this.map;
        }
    }

    protected class engineResult {
        private RemSearchPluginEngine engine;
        private TrackerWebPageResponse receiver;
        private List<ResultWrapper> results = new ArrayList<ResultWrapper>();
        private Throwable failure;
        private boolean complete;
        private boolean done;
        private long mt_search_end = -1L;
        private AESemaphore wait_sem;
        private boolean can_go_async = true;
        private boolean went_async;

        protected engineResult(RemSearchPluginEngine _engine) {
            this.engine = _engine;
            if (!RemSearchPluginSearch.this.generator.supportsAsync()) {
                this.wait_sem = new AESemaphore("RSPS:waiter");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setEngine(RemSearchPluginEngine _engine) {
            engineResult engineResult2 = this;
            synchronized (engineResult2) {
                this.engine = _engine;
            }
            this.checkDone();
        }

        protected RemSearchPluginEngine getEngine() {
            return this.engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setResultReceiver(TrackerWebPageResponse _receiver) throws IOException {
            engineResult engineResult2 = this;
            synchronized (engineResult2) {
                if (this.receiver != null) {
                    throw new IOException("Results for engine already returned");
                }
                this.receiver = _receiver;
            }
            if (!this.checkDone()) {
                if (this.wait_sem != null) {
                    if (!this.wait_sem.reserve(60000L)) {
                        throw new IOException("timeout waiting for complete");
                    }
                } else {
                    engineResult2 = this;
                    synchronized (engineResult2) {
                        if (this.can_go_async) {
                            this.went_async = true;
                            this.receiver.setAsynchronous(true);
                        }
                    }
                }
            }
        }

        protected void addResults(ResultWrapper[] _results) {
            if (this.mt_search_end == -1L) {
                this.mt_search_end = SystemTime.getMonotonousTime();
            }
            this.results.addAll(Arrays.asList(_results));
        }

        protected long getSearchElapsedTime() {
            if (this.mt_search_end == -1L) {
                return -1L;
            }
            return this.mt_search_end - RemSearchPluginSearch.this.create_time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setFailed(Throwable e) {
            engineResult engineResult2 = this;
            synchronized (engineResult2) {
                this.failure = e;
            }
            this.checkDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setComplete() {
            engineResult engineResult2 = this;
            synchronized (engineResult2) {
                this.complete = true;
            }
            this.checkDone();
        }

        protected void destroy() {
            this.setFailed(new Throwable("Search destroyed"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        protected boolean checkDone() {
            block42: {
                engineResult engineResult2 = this;
                synchronized (engineResult2) {
                    if (this.done) {
                        return true;
                    }
                    if (this.engine == null || this.receiver == null) {
                        return false;
                    }
                    if (!this.complete && this.failure == null) {
                        return false;
                    }
                    this.done = true;
                }
                try {
                    try {
                        PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.receiver.getOutputStream(), "UTF-8"));
                        if (this.complete) {
                            JSONObject result_map = new JSONObject();
                            RemSearchPluginPageGenerator.getEngineDetails(this.engine, result_map);
                            result_map.put("sid", RemSearchPluginSearch.this.sid);
                            ArrayList<Map> result_list = new ArrayList<Map>(this.results.size());
                            for (ResultWrapper result : this.results) {
                                result_list.add(result.toJSONMap());
                            }
                            result_map.put("results", result_list);
                            JSONObject complete_map = new JSONObject();
                            RemSearchPluginPageGenerator.getEngineDetails(this.engine, complete_map);
                            complete_map.put("sid", RemSearchPluginSearch.this.sid);
                            if (RemSearchPluginSearch.this.json_output) {
                                result_map.putAll(complete_map);
                                pw.println(((Object)result_map).toString());
                            } else {
                                pw.println("webSearch.loadResults( " + ((Object)result_map).toString() + "); webSearch.engineCompleted(" + ((Object)complete_map).toString() + ")");
                            }
                        } else {
                            JSONObject error_map = new JSONObject();
                            RemSearchPluginPageGenerator.getEngineDetails(this.engine, error_map);
                            error_map.put("error", Debug.getNestedExceptionMessage(this.failure));
                            error_map.put("sid", RemSearchPluginSearch.this.sid);
                            if (RemSearchPluginSearch.this.json_output) {
                                pw.println(((Object)error_map).toString());
                            } else {
                                pw.println("webSearch.engineFailed(" + ((Object)error_map).toString() + ")");
                            }
                        }
                        pw.flush();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        if (this.wait_sem != null) {
                            this.wait_sem.releaseForever();
                        } else {
                            boolean async;
                            engineResult engineResult3 = this;
                            synchronized (engineResult3) {
                                this.can_go_async = false;
                                async = this.went_async;
                            }
                            if (async) {
                                try {
                                    this.receiver.setAsynchronous(false);
                                }
                                catch (Throwable e2) {
                                    Debug.printStackTrace(e2);
                                }
                            }
                        }
                        RemSearchPluginSearch.this.checkCompleteness();
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    if (this.wait_sem != null) {
                        this.wait_sem.releaseForever();
                    } else {
                        boolean async;
                        engineResult e2 = this;
                        synchronized (e2) {
                            this.can_go_async = false;
                            async = this.went_async;
                        }
                        if (async) {
                            try {
                                this.receiver.setAsynchronous(false);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    RemSearchPluginSearch.this.checkCompleteness();
                    throw throwable;
                }
                if (this.wait_sem != null) {
                    this.wait_sem.releaseForever();
                } else {
                    boolean async;
                    engineResult e = this;
                    synchronized (e) {
                        this.can_go_async = false;
                        async = this.went_async;
                    }
                    if (async) {
                        try {
                            this.receiver.setAsynchronous(false);
                        }
                        catch (Throwable e3) {
                            Debug.printStackTrace(e3);
                        }
                    }
                }
                RemSearchPluginSearch.this.checkCompleteness();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isDone() {
            engineResult engineResult2 = this;
            synchronized (engineResult2) {
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean succeeded() {
            engineResult engineResult2 = this;
            synchronized (engineResult2) {
                return this.complete;
            }
        }
    }
}

