/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.remsearch;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchManager;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginEngine;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginListener;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginPageGenerator;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginPageGeneratorAdaptor;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginSearch;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginStats;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class RemSearchPlugin
implements Plugin {
    private static final int PORT_DEFAULT = 8888;
    private static final int SEARCH_TIMEOUT_DEFAULT = 45000;
    private static final int MAX_SEARCHES_DEFAULT = 100;
    private static final int MAX_RESULTS_PER_ENGINE_DEFAULT = 50;
    private static final String URL_PREFIX_DEFAULT = "/psearch";
    private static final int TICK_PERIOD = 15000;
    private static final int HISTORY_CLEAR_PERIOD = 300000;
    private static final int HISTORY_CLEAR_PER_TICK = 5;
    private IntParameter search_timeout;
    private IntParameter max_searches;
    private IntParameter max_results_per_engine;
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private String url_prefix;
    private RemSearchPluginStats stats = new RemSearchPluginStats(this);
    private static final int STATS_PERIOD = 1000;
    private static final int STATS_DURATION_SECS = 30;
    private Average search_average = Average.getInstance(1000, 30);
    private static final int BLOOM_FILTER_SIZE = 262144;
    private static final int BLOOM_ROTATION_PERIOD = 30000;
    private static final int BLOOM_ROTATION_TICKS = 2;
    private static final int BLOOM_MAX_HITS_PER_PERIOD = 15;
    private Object bloom_lock = new Object();
    private BloomFilter bloom_one = BloomFilterFactory.createAddRemove8Bit(262144);
    private BloomFilter bloom_two = BloomFilterFactory.createAddRemove8Bit(262144);
    private String host_name = "relay";
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private RemSearchPluginPageGenerator generator;

    public void load(PluginInterface pi) {
        COConfigurationManager.setParameter("Tracker IP", "127.0.0.1");
        COConfigurationManager.setParameter("Tracker Port", COConfigurationManager.getIntParameter("Plugin.aeremsearch.aeremsearch.config.http_port", 8888));
        COConfigurationManager.setParameter("Tracker Port Enable", true);
        COConfigurationManager.setParameter("Tracker TCP NonBlocking", true);
        COConfigurationManager.setParameter("Tracker TCP NonBlocking Immediate Close", true);
        COConfigurationManager.setParameter("Tracker TCP NonBlocking Restrict Request Types", false);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        String host;
        this.plugin_interface = _plugin_interface;
        this.logger = this.plugin_interface.getLogger().getChannel("RemoteSearch");
        this.logger.setDiagnostic();
        LocaleUtilities loc_utils = this.plugin_interface.getUtilities().getLocaleUtilities();
        loc_utils.integrateLocalisedMessageBundle("com.aelitis.azureus.plugins.remsearch.internat.Messages");
        BasicPluginConfigModel config_model = this.plugin_interface.getUIManager().createBasicPluginConfigModel("aeremsearch.name");
        config_model.addIntParameter2("aeremsearch.config.http_port", "aeremsearch.config.http_port", 8888);
        this.search_timeout = config_model.addIntParameter2("aeremsearch.config.search_timeout", "aeremsearch.config.search_timeout", 45000);
        this.max_searches = config_model.addIntParameter2("aeremsearch.config.max_searches", "aeremsearch.config.max_searches", 100);
        this.max_results_per_engine = config_model.addIntParameter2("aeremsearch.config.max_results_per_engine", "aeremsearch.config.max_results_per_engine", 50);
        this.url_prefix = config_model.addStringParameter2("aeremsearch.config.url_prefix", "aeremsearch.config.url_prefix", URL_PREFIX_DEFAULT).getValue();
        if (this.url_prefix.endsWith("/")) {
            this.url_prefix = this.url_prefix.substring(0, this.url_prefix.length() - 1);
        }
        if ((host = System.getProperty("az.hostname")) != null && host.length() > 0) {
            this.host_name = host;
        }
        this.generator = new RemSearchPluginPageGenerator(new RemSearchPluginPageGeneratorAdaptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void searchReceived(String originator) throws IOException {
                byte[] bloom_key = originator.getBytes();
                Object object = RemSearchPlugin.this.bloom_lock;
                synchronized (object) {
                    RemSearchPlugin.this.bloom_two.add(bloom_key);
                    if (RemSearchPlugin.this.bloom_one.add(bloom_key) > 15) {
                        throw new IOException("Too many recent searches from " + originator);
                    }
                }
            }

            @Override
            public void searchCreated(RemSearchPluginSearch search) {
                Iterator it = RemSearchPlugin.this.listeners.iterator();
                while (it.hasNext()) {
                    try {
                        ((RemSearchPluginListener)it.next()).searchCreated(search);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void log(String str) {
                RemSearchPlugin.this.log(str);
            }

            @Override
            public void log(String str, Throwable e) {
                RemSearchPlugin.this.log(str, e);
            }
        }, this.url_prefix, this.host_name, this.max_searches.getValue(), this.max_results_per_engine.getValue(), true);
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                MetaSearchManager meta_search = MetaSearchManagerFactory.getSingleton();
                if (!meta_search.isAutoMode()) {
                    try {
                        meta_search.setSelectedEngines(new long[0], true);
                    }
                    catch (Throwable e) {
                        RemSearchPlugin.this.log("Failed to set auto-mode", e);
                    }
                }
                RemSearchPlugin.this.plugin_interface.getTracker().addPageGenerator(RemSearchPlugin.this.generator);
                UTTimer timer = RemSearchPlugin.this.plugin_interface.getUtilities().createTimer("Search timer", true);
                timer.addPeriodicEvent(1000L, new UTTimerEventPerformer(){
                    private long last_total_searches;

                    @Override
                    public void perform(UTTimerEvent event2) {
                        long ts = RemSearchPlugin.this.generator.getTotalSearches();
                        RemSearchPlugin.this.search_average.addValue(ts - this.last_total_searches);
                        this.last_total_searches = ts;
                    }
                });
                timer.addPeriodicEvent(15000L, new UTTimerEventPerformer(){
                    private int tick_count;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(UTTimerEvent event2) {
                        ++this.tick_count;
                        int timeout = RemSearchPlugin.this.search_timeout.getValue();
                        Map<String, RemSearchPluginSearch> searches = RemSearchPlugin.this.generator.getSearches();
                        for (RemSearchPluginSearch search : searches.values()) {
                            if (search.getAge() <= (long)timeout) continue;
                            RemSearchPlugin.this.log("Timeout: " + search.getString());
                            search.destroy();
                        }
                        String history_str = "";
                        Map<Engine, RemSearchPluginEngine> engine_map = RemSearchPlugin.this.generator.getEngineMap();
                        for (Map.Entry<Engine, RemSearchPluginEngine> entry : engine_map.entrySet()) {
                            Engine engine = entry.getKey();
                            RemSearchPluginEngine p_engine = entry.getValue();
                            LinkedList<Boolean> history = p_engine.getHistory();
                            int good = 0;
                            int first_good = -1;
                            int bad = 0;
                            int first_bad = -1;
                            int pos = 0;
                            Iterator iterator = history.iterator();
                            while (iterator.hasNext()) {
                                boolean success = (Boolean)iterator.next();
                                ++pos;
                                if (success) {
                                    ++good;
                                    if (first_good != -1) continue;
                                    first_good = pos;
                                    continue;
                                }
                                ++bad;
                                if (first_bad != -1) continue;
                                first_bad = pos;
                            }
                            history_str = String.valueOf(history_str) + (history_str.length() == 0 ? "" : "; ");
                            history_str = String.valueOf(history_str) + engine.getName() + "={h:" + history.size() + ",g=" + good + ",b=" + bad + ",fg=" + first_good + ",fb=" + first_bad + ",rta=" + p_engine.getResponseTimeAverage() + "}";
                            if (history.size() <= 5) {
                                history.clear();
                                continue;
                            }
                            int i = 0;
                            while (i < 5) {
                                history.removeLast();
                                ++i;
                            }
                        }
                        RemSearchPlugin.this.log("History: search/sec=" + RemSearchPlugin.this.search_average.getDoubleAverageAsString(3) + ", " + history_str);
                        if (this.tick_count % 2 == 0) {
                            Object object = RemSearchPlugin.this.bloom_lock;
                            synchronized (object) {
                                RemSearchPlugin.this.log("Bloom rotate: one=" + RemSearchPlugin.this.bloom_one.getEntryCount() + ", two=" + RemSearchPlugin.this.bloom_two.getEntryCount());
                                RemSearchPlugin.this.bloom_one = RemSearchPlugin.this.bloom_two;
                                RemSearchPlugin.this.bloom_two = BloomFilterFactory.createAddRemove8Bit(262144);
                            }
                        }
                    }
                });
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    public RemSearchPluginEngine[] getEngines() {
        return this.generator.getEngines();
    }

    public RemSearchPluginStats getStats() {
        return this.stats;
    }

    public long getTotalSearches() {
        return this.generator.getTotalSearches();
    }

    public long getTotalSearchesFailed() {
        return this.generator.getTotalSearchesFailed();
    }

    public long getTotalEnginesFailed() {
        return this.generator.getTotalEnginesFailed();
    }

    public void addListener(RemSearchPluginListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RemSearchPluginListener listener) {
        this.listeners.remove(listener);
    }

    protected void log(String str) {
        this.logger.log(str);
    }

    protected void log(String str, Throwable e) {
        this.logger.log(str, e);
    }
}

