/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginManager;

public class I2PHelpers {
    private static final Object i2p_install_lock = new Object();
    private static boolean i2p_installing = false;

    public static boolean isI2PInstalled() {
        if (I2PHelpers.isInstallingI2PHelper()) {
            return true;
        }
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        return pm.getPluginInterfaceByID("azneti2phelper") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstallingI2PHelper() {
        Object object = i2p_install_lock;
        synchronized (object) {
            return i2p_installing;
        }
    }

    public static boolean installI2PHelper(String remember_id, boolean[] install_outcome, Runnable callback) {
        return I2PHelpers.installI2PHelper(null, remember_id, install_outcome, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installI2PHelper(String extra_text, String remember_id, final boolean[] install_outcome, final Runnable callback) {
        boolean bl;
        block24: {
            boolean install;
            UIFunctions uif;
            boolean installing;
            block22: {
                block23: {
                    Object object;
                    Object object2 = i2p_install_lock;
                    synchronized (object2) {
                        block21: {
                            if (!i2p_installing) break block21;
                            Debug.out("I2P Helper already installing");
                            return false;
                        }
                        i2p_installing = true;
                    }
                    installing = false;
                    try {
                        uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) break block22;
                        Debug.out("UIFunctions unavailable - can't install plugin");
                        if (installing) break block23;
                        object = i2p_install_lock;
                    }
                    catch (Throwable throwable) {
                        if (!installing) {
                            Object object3 = i2p_install_lock;
                            synchronized (object3) {
                                i2p_installing = false;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        i2p_installing = false;
                    }
                }
                return false;
            }
            String title = MessageText.getString("azneti2phelper.install");
            String text = "";
            if (extra_text != null) {
                text = String.valueOf(extra_text) + "\n\n";
            }
            text = String.valueOf(text) + MessageText.getString("azneti2phelper.install.text");
            UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
            if (remember_id != null) {
                prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            }
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            boolean bl2 = install = prompter.waitUntilClosed() == 0;
            if (install) {
                installing = true;
                uif.installPlugin("azneti2phelper", "azneti2phelper.install", new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionComplete(Object result) {
                        try {
                            if (callback != null) {
                                if (result instanceof Boolean) {
                                    install_outcome[0] = (Boolean)result;
                                }
                                callback.run();
                            }
                        }
                        catch (Throwable throwable) {
                            Object object = i2p_install_lock;
                            synchronized (object) {
                                i2p_installing = false;
                            }
                            throw throwable;
                        }
                        Object object = i2p_install_lock;
                        synchronized (object) {
                            i2p_installing = false;
                        }
                    }
                });
            } else {
                Debug.out("I2P Helper install declined (either user reply or auto-remembered)");
            }
            bl = install;
            if (installing) break block24;
            Object object = i2p_install_lock;
            synchronized (object) {
                i2p_installing = false;
            }
        }
        return bl;
    }
}

