/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.vuzefile;

import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;

public class VuzeFileMerger {
    protected VuzeFileMerger(String[] args) {
        File input_dir;
        if (args.length != 1) {
            this.usage();
        }
        if (!(input_dir = new File(args[0])).isDirectory()) {
            this.usage();
        }
        try {
            File output_file = new File(String.valueOf(args[0]) + ".vuze");
            File[] files = input_dir.listFiles();
            VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
            VuzeFile target = vfh.create();
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (!f.isDirectory() && f.getName().endsWith(".vuze")) {
                    VuzeFile vf = vfh.loadVuzeFile(f.getAbsolutePath());
                    System.out.println("Read " + f);
                    VuzeFileComponent[] comps = vf.getComponents();
                    int j = 0;
                    while (j < comps.length) {
                        VuzeFileComponent comp2 = comps[j];
                        target.addComponent(comp2.getType(), comp2.getContent());
                        System.out.println("    added component: " + comp2.getType());
                        ++j;
                    }
                }
                ++i;
            }
            target.write(output_file);
            System.out.println("Wrote " + output_file);
        }
        catch (Throwable e) {
            System.err.print("Failed to merge vuze files");
            e.printStackTrace();
        }
    }

    protected void usage() {
        System.err.println("Usage: <dir_of_vuze_files_to_merge>");
        System.exit(1);
    }

    public static void main(String[] args) {
        new VuzeFileMerger(args);
    }
}

