/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gudy.azureus2.core3.util.Debug;

public class DeleteFileOnCloseInputStream
extends InputStream {
    private InputStream in;
    private File file;
    private boolean closed;
    private long pos;
    private long mark;

    public DeleteFileOnCloseInputStream(File _file) throws IOException {
        this.file = _file;
        this.in = new BufferedInputStream(new FileInputStream(this.file), 131072);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.in.close();
        }
        finally {
            if (!this.file.delete()) {
                Debug.out("Failed to delete file '" + this.file + "'");
            }
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        ++this.pos;
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int res = this.read(b, 0, b.length);
        if (res > 0) {
            this.pos += (long)res;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = this.in.read(b, off, len);
        if (res > 0) {
            this.pos += (long)res;
        }
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        long res = this.in.skip(n);
        this.pos += res;
        return res;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.close();
        this.in = new FileInputStream(this.file);
        this.in.skip(this.mark);
        this.pos = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public File getFile() {
        return this.file;
    }
}

