/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeAdapter;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableLifecycleAdapter;
import com.aelitis.azureus.core.tag.impl.TagManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TagPropertyTrackerHandler
implements TagFeatureProperties.TagPropertyListener {
    private AzureusCore azureus_core;
    private TagManagerImpl tag_manager;
    private Map<String, List<Tag>> tracker_host_map = new HashMap<String, List<Tag>>();

    protected TagPropertyTrackerHandler(AzureusCore _core, TagManagerImpl _tm) {
        this.azureus_core = _core;
        this.tag_manager = _tm;
        this.tag_manager.addTaggableLifecycleListener(2L, new TaggableLifecycleAdapter(){

            @Override
            public void initialised(List<Taggable> current_taggables) {
                TagType tt = TagPropertyTrackerHandler.this.tag_manager.getTagType(3);
                tt.addTagTypeListener(new TagTypeAdapter(){

                    @Override
                    public void tagAdded(Tag tag) {
                        TagFeatureProperties.TagProperty[] props;
                        TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
                        TagFeatureProperties.TagProperty[] tagPropertyArray = props = tfp.getSupportedProperties();
                        int n = props.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TagFeatureProperties.TagProperty prop = tagPropertyArray[n2];
                            if (prop.getName(false).equals("trackers")) {
                                TagPropertyTrackerHandler.this.hookTagProperty(prop);
                                break;
                            }
                            ++n2;
                        }
                    }
                }, true);
            }

            @Override
            public void taggableCreated(Taggable taggable) {
                TagPropertyTrackerHandler.this.handleDownload((DownloadManager)taggable);
            }
        });
    }

    private void hookTagProperty(TagFeatureProperties.TagProperty property) {
        property.addListener(this);
        this.handleProperty(property, true);
    }

    @Override
    public void propertyChanged(TagFeatureProperties.TagProperty property) {
        this.handleProperty(property, false);
    }

    @Override
    public void propertySync(TagFeatureProperties.TagProperty property) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProperty(TagFeatureProperties.TagProperty property, boolean start_of_day) {
        boolean hit;
        Set<String> hosts;
        String[] trackers = property.getStringList();
        HashSet<String> tag_hosts = new HashSet<String>(Arrays.asList(trackers));
        Tag tag = property.getTag();
        Map<String, List<Tag>> map = this.tracker_host_map;
        synchronized (map) {
            List<Tag> tags;
            for (Map.Entry<String, List<Tag>> entry : this.tracker_host_map.entrySet()) {
                tags = entry.getValue();
                if (!tags.contains(tag) || tag_hosts.contains(entry.getKey())) continue;
                tags.remove(tag);
            }
            for (String host : tag_hosts) {
                tags = this.tracker_host_map.get(host);
                if (tags == null) {
                    tags = new ArrayList<Tag>();
                    this.tracker_host_map.put(host, tags);
                } else if (tags.contains(tag)) continue;
                tags.add(tag);
            }
        }
        if (start_of_day) {
            return;
        }
        Set<Taggable> tag_dls = tag.getTagged();
        for (Taggable tag_dl : tag_dls) {
            DownloadManager dm = (DownloadManager)tag_dl;
            hosts = this.getAugmentedHosts(dm);
            hit = false;
            for (String host : hosts) {
                if (!tag_hosts.contains(host)) continue;
                hit = true;
                break;
            }
            if (hit) continue;
            tag.removeTaggable(tag_dl);
        }
        List<DownloadManager> managers = this.azureus_core.getGlobalManager().getDownloadManagers();
        for (DownloadManager dm : managers) {
            if (!dm.isPersistent() || tag.hasTaggable(dm)) continue;
            hosts = this.getAugmentedHosts(dm);
            hit = false;
            for (String host : hosts) {
                if (!tag_hosts.contains(host)) continue;
                hit = true;
                break;
            }
            if (!hit) continue;
            tag.addTaggable(dm);
        }
    }

    private Set<String> getAugmentedHosts(DownloadManager dm) {
        Set<String> hosts = TorrentUtils.getUniqueTrackerHosts(dm.getTorrent());
        HashSet<String> result = new HashSet<String>();
        for (String host : hosts) {
            result.add(host);
            String[] bits = host.split("\\.");
            String suffix = "";
            int i = bits.length - 1;
            while (i > 0) {
                String bit = bits[i];
                suffix = suffix == "" ? bit : String.valueOf(bit) + "." + suffix;
                result.add(suffix);
                --i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Tag> getTagsForDownload(DownloadManager dm) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        if (dm.isPersistent()) {
            Map<String, List<Tag>> map = this.tracker_host_map;
            synchronized (map) {
                if (this.tracker_host_map.size() > 0) {
                    Set<String> hosts = TorrentUtils.getUniqueTrackerHosts(dm.getTorrent());
                    for (String host : hosts) {
                        List<Tag> tags = this.tracker_host_map.get(host);
                        if (tags == null) continue;
                        result.addAll(tags);
                    }
                }
            }
        }
        return result;
    }

    private void handleDownload(DownloadManager dm) {
        List<Tag> applicable_tags = this.getTagsForDownload(dm);
        for (Tag tag : applicable_tags) {
            if (tag.hasTaggable(dm)) continue;
            tag.addTaggable(dm);
        }
    }
}

