/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class SubscriptionUtils {
    public static SubscriptionDownloadDetails[] getAllCachedDownloadDetails(AzureusCore core) {
        List<DownloadManager> dms = core.getGlobalManager().getDownloadManagers();
        ArrayList<SubscriptionDownloadDetails> result = new ArrayList<SubscriptionDownloadDetails>();
        SubscriptionManager sub_man = SubscriptionManagerFactory.getSingleton();
        int i = 0;
        while (i < dms.size()) {
            DownloadManager dm = dms.get(i);
            TOTorrent torrent = dm.getTorrent();
            if (torrent != null) {
                try {
                    Subscription[] subs = sub_man.getKnownSubscriptions(torrent.getHash());
                    if (subs != null && subs.length > 0) {
                        if (sub_man.hideSearchTemplates()) {
                            ArrayList<Subscription> filtered = new ArrayList<Subscription>();
                            Subscription[] subscriptionArray = subs;
                            int n = subs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Subscription s = subscriptionArray[n2];
                                if (!s.isSearchTemplate()) {
                                    filtered.add(s);
                                }
                                ++n2;
                            }
                            if (filtered.size() > 0) {
                                result.add(new SubscriptionDownloadDetails(dm, filtered.toArray(new Subscription[filtered.size()])));
                            }
                        } else {
                            result.add(new SubscriptionDownloadDetails(dm, subs));
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
        return result.toArray(new SubscriptionDownloadDetails[result.size()]);
    }

    public static String getSubscriptionChatKey(Subscription subs) {
        try {
            String key = null;
            Engine engine = subs.getEngine();
            if (engine instanceof WebEngine) {
                WebEngine web_engine = (WebEngine)subs.getEngine();
                key = web_engine.getSearchUrl(true);
            } else {
                key = subs.getQueryKey();
            }
            if (key != null) {
                key = "Subscription: " + key;
            }
            return key;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static class SubscriptionDownloadDetails {
        private DownloadManager download;
        private Subscription[] subscriptions;

        protected SubscriptionDownloadDetails(DownloadManager dm, Subscription[] subs) {
            this.download = dm;
            this.subscriptions = subs;
        }

        public DownloadManager getDownload() {
            return this.download;
        }

        public Subscription[] getSubscriptions() {
            return this.subscriptions;
        }
    }
}

