/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.PEPeer;

public class SeedingUnchoker
implements Unchoker {
    private static int priority_unchoke_retention_count;
    private ArrayList<PEPeer> chokes = new ArrayList();
    private ArrayList<PEPeer> unchokes = new ArrayList();

    static {
        COConfigurationManager.addAndFireParameterListener("Non-Public Peer Extra Slots Per Torrent", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                priority_unchoke_retention_count = COConfigurationManager.getIntParameter("Non-Public Peer Extra Slots Per Torrent");
            }
        });
    }

    protected SeedingUnchoker() {
    }

    @Override
    public boolean isSeedingUnchoker() {
        return true;
    }

    @Override
    public ArrayList<PEPeer> getImmediateUnchokes(int max_to_unchoke, ArrayList<PEPeer> all_peers) {
        int peer_count = all_peers.size();
        if (max_to_unchoke > peer_count) {
            max_to_unchoke = peer_count;
        }
        int num_unchoked = 0;
        int i = 0;
        while (i < all_peers.size()) {
            PEPeer peer = all_peers.get(i);
            if (!peer.isChokedByMe()) {
                ++num_unchoked;
            }
            ++i;
        }
        int needed = max_to_unchoke - num_unchoked;
        if (needed > 0) {
            ArrayList<PEPeer> to_unchoke = UnchokerUtil.getNextOptimisticPeers(all_peers, false, false, needed);
            if (to_unchoke == null) {
                return new ArrayList<PEPeer>(0);
            }
            int i2 = 0;
            while (i2 < to_unchoke.size()) {
                to_unchoke.get(i2).setOptimisticUnchoke(true);
                ++i2;
            }
            return to_unchoke;
        }
        return new ArrayList<PEPeer>(0);
    }

    @Override
    public void calculateUnchokes(int max_to_unchoke, ArrayList<PEPeer> all_peers, boolean force_refresh, boolean check_priority_connections, boolean do_high_latency_peers) {
        int max_optimistic = (max_to_unchoke - 1) / 5 + 1;
        int i = 0;
        while (i < all_peers.size()) {
            PEPeer peer = all_peers.get(i);
            if (!peer.isChokedByMe()) {
                if (UnchokerUtil.isUnchokable(peer, false)) {
                    this.unchokes.add(peer);
                } else {
                    this.chokes.add(peer);
                }
            }
            ++i;
        }
        while (this.unchokes.size() > max_to_unchoke) {
            this.chokes.add(this.unchokes.remove(this.unchokes.size() - 1));
        }
        if (force_refresh) {
            ArrayList peers_ordered_by_rate = new ArrayList();
            ArrayList peers_ordered_by_uploaded = new ArrayList();
            long[] rates = new long[this.unchokes.size()];
            long[] uploaded = new long[rates.length];
            int i2 = 0;
            while (i2 < this.unchokes.size()) {
                PEPeer peer = this.unchokes.get(i2);
                long rate = peer.getStats().getDataSendRate();
                if (rate > 256L) {
                    UnchokerUtil.updateLargestValueFirstSort(rate, rates, peer, peers_ordered_by_rate, 0);
                    UnchokerUtil.updateLargestValueFirstSort(peer.getStats().getTotalDataBytesSent(), uploaded, peer, peers_ordered_by_uploaded, 0);
                }
                ++i2;
            }
            Collections.reverse(peers_ordered_by_rate);
            ArrayList peers_ordered_by_rank = new ArrayList();
            long[] ranks = new long[peers_ordered_by_rate.size()];
            Arrays.fill(ranks, Long.MIN_VALUE);
            int i3 = 0;
            while (i3 < this.unchokes.size()) {
                PEPeer peer = this.unchokes.get(i3);
                long rate_factor = peers_ordered_by_rate.indexOf(peer);
                long uploaded_factor = peers_ordered_by_uploaded.indexOf(peer);
                if (rate_factor != -1L) {
                    long rank_factor = rate_factor + uploaded_factor;
                    UnchokerUtil.updateLargestValueFirstSort(rank_factor, ranks, peer, peers_ordered_by_rank, 0);
                }
                ++i3;
            }
            while (peers_ordered_by_rank.size() > max_to_unchoke - max_optimistic) {
                peers_ordered_by_rank.remove(peers_ordered_by_rank.size() - 1);
            }
            ArrayList<PEPeer> to_unchoke = new ArrayList<PEPeer>();
            Iterator<PEPeer> it = this.unchokes.iterator();
            while (it.hasNext()) {
                PEPeer optimistic_peer;
                PEPeer peer = it.next();
                peer.setOptimisticUnchoke(false);
                if (peers_ordered_by_rank.contains(peer) || (optimistic_peer = UnchokerUtil.getNextOptimisticPeer(all_peers, false, false)) == null) continue;
                this.chokes.add(peer);
                it.remove();
                to_unchoke.add(optimistic_peer);
                optimistic_peer.setOptimisticUnchoke(true);
            }
            int i4 = 0;
            while (i4 < to_unchoke.size()) {
                this.unchokes.add((PEPeer)to_unchoke.get(i4));
                ++i4;
            }
        }
        if (check_priority_connections) {
            this.setPriorityUnchokes(max_to_unchoke - max_optimistic, all_peers);
        }
        if (do_high_latency_peers) {
            UnchokerUtil.doHighLatencyPeers(this.chokes, this.unchokes, false);
        }
    }

    private void setPriorityUnchokes(int max_priority, ArrayList<PEPeer> all_peers) {
        if (this.unchokes.isEmpty()) {
            return;
        }
        ArrayList<PEPeer> priority_peers = new ArrayList<PEPeer>();
        int i = 0;
        while (i < all_peers.size()) {
            PEPeer peer = all_peers.get(i);
            if (peer.isPriorityConnection() && UnchokerUtil.isUnchokable(peer, true)) {
                priority_peers.add(peer);
            }
            ++i;
        }
        Collections.shuffle(priority_peers);
        int num_unchoked = 0;
        int num_non_priority_to_retain = priority_unchoke_retention_count;
        int max = max_priority > this.unchokes.size() ? this.unchokes.size() : max_priority;
        while (num_unchoked < max && !priority_peers.isEmpty()) {
            PEPeer peer = this.unchokes.remove(0);
            if (priority_peers.remove(peer)) {
                this.unchokes.add(peer);
            } else {
                if (num_non_priority_to_retain-- > 0) {
                    this.unchokes.add(peer);
                }
                PEPeer buddy = (PEPeer)priority_peers.remove(priority_peers.size() - 1);
                this.chokes.remove(buddy);
                this.unchokes.add(buddy);
            }
            ++num_unchoked;
        }
    }

    @Override
    public ArrayList<PEPeer> getChokes() {
        ArrayList<PEPeer> to_choke = this.chokes;
        this.chokes = new ArrayList();
        return to_choke;
    }

    @Override
    public ArrayList<PEPeer> getUnchokes() {
        ArrayList<PEPeer> to_unchoke = this.unchokes;
        this.unchokes = new ArrayList();
        return to_unchoke;
    }
}

