/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.gudy.azureus2.core3.peer.PEPeer;

public class DownloadingUnchoker
implements Unchoker {
    private ArrayList<PEPeer> chokes = new ArrayList();
    private ArrayList<PEPeer> unchokes = new ArrayList();

    protected DownloadingUnchoker() {
    }

    @Override
    public boolean isSeedingUnchoker() {
        return false;
    }

    @Override
    public ArrayList<PEPeer> getImmediateUnchokes(int max_to_unchoke, ArrayList<PEPeer> all_peers) {
        ArrayList<PEPeer> to_unchoke = new ArrayList<PEPeer>();
        int num_unchoked = 0;
        int i = 0;
        while (i < all_peers.size()) {
            PEPeer peer = all_peers.get(i);
            if (!peer.isChokedByMe()) {
                ++num_unchoked;
            }
            ++i;
        }
        int needed = max_to_unchoke - num_unchoked;
        if (needed > 0) {
            int i2 = 0;
            while (i2 < needed) {
                PEPeer peer = UnchokerUtil.getNextOptimisticPeer(all_peers, true, true);
                if (peer == null) break;
                to_unchoke.add(peer);
                peer.setOptimisticUnchoke(true);
                ++i2;
            }
        }
        return to_unchoke;
    }

    @Override
    public void calculateUnchokes(int max_to_unchoke, ArrayList<PEPeer> all_peers, boolean force_refresh, boolean check_priority_connections, boolean do_high_latency_peers) {
        PEPeer peer;
        PEPeer peer2;
        int max_optimistic = (max_to_unchoke - 1) / 10 + 1;
        ArrayList<PEPeer> optimistic_unchokes = new ArrayList<PEPeer>();
        ArrayList<PEPeer> best_peers = new ArrayList<PEPeer>();
        long[] bests = new long[max_to_unchoke];
        int i = 0;
        while (i < all_peers.size()) {
            peer2 = all_peers.get(i);
            if (!peer2.isChokedByMe()) {
                if (UnchokerUtil.isUnchokable(peer2, true)) {
                    this.unchokes.add(peer2);
                    if (peer2.isOptimisticUnchoke()) {
                        optimistic_unchokes.add(peer2);
                    }
                } else {
                    this.chokes.add(peer2);
                }
            }
            ++i;
        }
        if (!force_refresh) {
            i = 0;
            while (i < optimistic_unchokes.size()) {
                peer2 = (PEPeer)optimistic_unchokes.get(i);
                if (i < max_optimistic) {
                    best_peers.add(peer2);
                } else {
                    peer2.setOptimisticUnchoke(false);
                }
                ++i;
            }
        }
        int start_pos = best_peers.size();
        int i2 = 0;
        while (i2 < all_peers.size()) {
            long rate;
            peer = all_peers.get(i2);
            if (peer.isInteresting() && UnchokerUtil.isUnchokable(peer, false) && !best_peers.contains(peer) && (rate = peer.getStats().getSmoothDataReceiveRate()) > 256L) {
                UnchokerUtil.updateLargestValueFirstSort(rate, bests, peer, best_peers, start_pos);
            }
            ++i2;
        }
        if (best_peers.size() < max_to_unchoke) {
            start_pos = best_peers.size();
            i2 = 0;
            while (i2 < all_peers.size()) {
                long uploaded_ratio;
                peer = all_peers.get(i2);
                if (peer.isInteresting() && UnchokerUtil.isUnchokable(peer, false) && !best_peers.contains(peer) && (uploaded_ratio = peer.getStats().getTotalDataBytesSent() / (peer.getStats().getTotalDataBytesReceived() + 16383L)) < 3L) {
                    UnchokerUtil.updateLargestValueFirstSort(peer.getStats().getTotalDataBytesReceived(), bests, peer, best_peers, start_pos);
                }
                ++i2;
            }
        }
        if (force_refresh) {
            while (best_peers.size() > max_to_unchoke - max_optimistic) {
                best_peers.remove(best_peers.size() - 1);
            }
        }
        while (best_peers.size() < max_to_unchoke) {
            PEPeer peer3 = UnchokerUtil.getNextOptimisticPeer(all_peers, true, true);
            if (peer3 == null) break;
            if (!best_peers.contains(peer3)) {
                best_peers.add(peer3);
                peer3.setOptimisticUnchoke(true);
                continue;
            }
            peer3.sendUnChoke();
        }
        Iterator<PEPeer> it = this.unchokes.iterator();
        while (it.hasNext()) {
            peer = it.next();
            if (best_peers.contains(peer)) continue;
            if (best_peers.size() < max_to_unchoke) {
                best_peers.add(peer);
                continue;
            }
            this.chokes.add(peer);
            it.remove();
        }
        i = 0;
        while (i < best_peers.size()) {
            peer = (PEPeer)best_peers.get(i);
            if (!this.unchokes.contains(peer)) {
                this.unchokes.add(peer);
            }
            ++i;
        }
        if (do_high_latency_peers) {
            UnchokerUtil.doHighLatencyPeers(this.chokes, this.unchokes, true);
        }
    }

    @Override
    public ArrayList<PEPeer> getChokes() {
        ArrayList<PEPeer> to_choke = this.chokes;
        this.chokes = new ArrayList();
        return to_choke;
    }

    @Override
    public ArrayList<PEPeer> getUnchokes() {
        ArrayList<PEPeer> to_unchoke = this.unchokes;
        this.unchokes = new ArrayList();
        return to_unchoke;
    }
}

