/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.piecepicker.util;

import com.aelitis.azureus.core.util.HashCodeUtils;
import java.util.Arrays;

public class BitFlags
implements Cloneable {
    public int start;
    public int end;
    public int nbSet;
    public final boolean[] flags;

    public BitFlags(int count) {
        this.start = count;
        this.end = 0;
        this.nbSet = 0;
        this.flags = new boolean[count];
    }

    public BitFlags(boolean[] _flags) {
        this.start = _flags.length;
        this.flags = _flags;
        int i = 0;
        while (i < this.flags.length) {
            if (this.flags[i]) {
                ++this.nbSet;
                if (i < this.start) {
                    this.start = i;
                }
                this.end = i;
            }
            ++i;
        }
    }

    public BitFlags(BitFlags other) {
        this.start = other.start;
        this.end = other.end;
        this.nbSet = other.nbSet;
        this.flags = (boolean[])other.flags.clone();
    }

    public Object clone() {
        return new BitFlags(this);
    }

    public int hashCode() {
        int result = HashCodeUtils.hashMore(0, this.flags);
        result = HashCodeUtils.hashMore(result, this.nbSet);
        result = HashCodeUtils.hashMore(result, this.end);
        return HashCodeUtils.hashMore(result, this.start);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BitFlags)) {
            return false;
        }
        BitFlags other = (BitFlags)o;
        if (this.start != other.start) {
            return false;
        }
        if (this.end != other.end) {
            return false;
        }
        if (this.nbSet != other.nbSet) {
            return false;
        }
        if (this.flags == null && other.flags == null) {
            return true;
        }
        if (this.flags == null || other.flags == null) {
            return false;
        }
        if (this.flags.length != other.flags.length) {
            return false;
        }
        int i = 0;
        while (i < this.flags.length) {
            if (this.flags[i] ^ other.flags[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int size() {
        return this.flags.length;
    }

    public void clear() {
        Arrays.fill(this.flags, false);
        this.start = this.flags.length;
        this.end = 0;
        this.nbSet = 0;
    }

    public void setStart(int i) {
        this.flags[i] = true;
        ++this.nbSet;
        this.start = i;
    }

    public void set(int i) {
        if (!this.flags[i]) {
            this.flags[i] = true;
            ++this.nbSet;
            if (this.start > i) {
                this.start = i;
            }
            if (this.end < i) {
                this.end = i;
            }
        }
    }

    public void setEnd(int i) {
        this.flags[i] = true;
        ++this.nbSet;
        this.end = i;
    }

    public void setOnly(int i) {
        if (this.start < this.flags.length) {
            Arrays.fill(this.flags, this.start, this.end, false);
        }
        this.nbSet = 1;
        this.start = i;
        this.end = i;
        this.flags[i] = true;
    }

    public void setAll() {
        this.start = 0;
        this.end = this.flags.length - 1;
        Arrays.fill(this.flags, true);
        this.nbSet = this.flags.length;
    }

    public BitFlags and(BitFlags other) {
        BitFlags result = new BitFlags(this.flags.length);
        if (this.nbSet > 0 && other.nbSet > 0) {
            int i = this.start > other.start ? this.start : other.start;
            int endI = this.end < other.end ? this.end : other.end;
            while (i <= endI) {
                if (this.flags[i] && other.flags[i]) {
                    result.flags[i] = true;
                    ++result.nbSet;
                    result.start = i;
                    break;
                }
                ++i;
            }
            while (i <= endI) {
                if (this.flags[i] && other.flags[i]) {
                    result.flags[i] = true;
                    ++result.nbSet;
                    result.end = i;
                }
                ++i;
            }
            if (result.end < result.start) {
                result.end = result.start;
            }
        }
        return result;
    }
}

