/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZUTMetaData;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class UTMetaData
implements LTMessage,
AZUTMetaData {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private int msg_type;
    private int piece;
    private DirectByteBuffer metadata;
    private int total_size;

    public UTMetaData(int _piece, byte _version) {
        this.msg_type = 0;
        this.piece = _piece;
        this.version = _version;
    }

    public UTMetaData(int _piece, ByteBuffer _data, int _total_size, byte _version) {
        this.msg_type = _data == null ? 2 : 1;
        this.piece = _piece;
        this.total_size = _total_size;
        this.version = _version;
        if (_data != null) {
            this.metadata = new DirectByteBuffer(_data);
        }
    }

    public UTMetaData(Map map, DirectByteBuffer data, byte _version) {
        if (map != null) {
            this.msg_type = ((Long)map.get("msg_type")).intValue();
            this.piece = ((Long)map.get("piece")).intValue();
        }
        this.metadata = data;
        this.version = _version;
    }

    @Override
    public String getID() {
        return "ut_metadata";
    }

    @Override
    public byte[] getIDBytes() {
        return ID_UT_METADATA_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "LT1";
    }

    @Override
    public int getFeatureSubID() {
        return 3;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return "ut_metadata";
    }

    @Override
    public int getMessageType() {
        return this.msg_type;
    }

    @Override
    public int getPiece() {
        return this.piece;
    }

    @Override
    public DirectByteBuffer getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(DirectByteBuffer b) {
        this.metadata = b;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Number> payload_map = new HashMap<String, Number>();
            payload_map.put("msg_type", new Long(this.msg_type));
            payload_map.put("piece", new Long(this.piece));
            if (this.total_size > 0) {
                payload_map.put("total_size", this.total_size);
            }
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(payload_map, (byte)34);
        }
        if (this.msg_type == 1) {
            return new DirectByteBuffer[]{this.buffer, this.metadata};
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        int pos = data.position((byte)11);
        byte[] dict_bytes = new byte[Math.min(128, data.remaining((byte)11))];
        data.get((byte)11, dict_bytes);
        try {
            Map<String, Object> root = BDecoder.decode(dict_bytes);
            data.position((byte)11, pos + BEncoder.encode(root).length);
            return new UTMetaData(root, data, version);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new MessageException("decode failed", e);
        }
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
        if (this.metadata != null) {
            this.metadata.returnToPool();
        }
    }
}

