/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.pairing.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.pairing.PairedNode;
import com.aelitis.azureus.core.pairing.PairedService;
import com.aelitis.azureus.core.pairing.PairedServiceRequestHandler;
import com.aelitis.azureus.core.pairing.PairingConnectionData;
import com.aelitis.azureus.core.pairing.PairingException;
import com.aelitis.azureus.core.pairing.PairingManager;
import com.aelitis.azureus.core.pairing.PairingManagerListener;
import com.aelitis.azureus.core.pairing.PairingTest;
import com.aelitis.azureus.core.pairing.PairingTestListener;
import com.aelitis.azureus.core.pairing.impl.PairingManagerTunnelHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.net.upnp.UPnPRootDevice;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class PairingManagerImpl
implements PairingManager,
AEDiagnosticsEvidenceGenerator {
    private static final boolean DEBUG = false;
    private static final String SERVICE_URL;
    private static final PairingManagerImpl singleton;
    private static final int GLOBAL_UPDATE_PERIOD = 60000;
    private static final int CD_REFRESH_PERIOD = 82800000;
    private static final int CD_REFRESH_TICKS = 1380;
    private static final int CONNECT_TEST_PERIOD_MILLIS = 1800000;
    private AzureusCore azureus_core;
    private BooleanParameter param_enable;
    private InfoParameter param_ac_info;
    private InfoParameter param_status_info;
    private InfoParameter param_last_error;
    private HyperlinkParameter param_view;
    private BooleanParameter param_srp_enable;
    private LabelParameter param_srp_state;
    private BooleanParameter param_e_enable;
    private StringParameter param_public_ipv4;
    private StringParameter param_public_ipv6;
    private StringParameter param_host;
    private BooleanParameter param_net_enable;
    private StringParameter param_local_ipv4;
    private StringParameter param_local_ipv6;
    private BooleanParameter param_icon_enable;
    private Map<String, PairedServiceImpl> services = new HashMap<String, PairedServiceImpl>();
    private AESemaphore init_sem = new AESemaphore("PM:init");
    private TimerEventPeriodic global_update_event;
    private InetAddress current_v4;
    private InetAddress current_v6;
    private String local_v4 = "";
    private String local_v6 = "";
    private PairingManagerTunnelHandler tunnel_handler;
    private boolean update_outstanding;
    private boolean updates_enabled;
    private static final int MIN_UPDATE_PERIOD_DEFAULT = 10000;
    private static final int MAX_UPDATE_PERIOD_DEFAULT = 3600000;
    private int min_update_period = 10000;
    private int max_update_period = 3600000;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private boolean must_update_once;
    private boolean update_in_progress;
    private TimerEvent deferred_update_event;
    private long last_update_time = -1L;
    private int consec_update_fails;
    private long qr_version = COConfigurationManager.getLongParameter("pairing.qr.ver", 0L);
    private String last_message;
    private Map<String, Object[]> local_address_checks = new HashMap<String, Object[]>();
    private CopyOnWriteList<PairingManagerListener> listeners = new CopyOnWriteList();
    private UIAdapter ui;
    private int tests_in_progress = 0;

    static {
        String url = System.getProperty("az.pairing.url", "");
        SERVICE_URL = url.length() == 0 ? "https://pair.vuze.com/pairing" : url;
        singleton = new PairingManagerImpl();
    }

    public static PairingManager getSingleton() {
        return singleton;
    }

    protected PairingManagerImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
        try {
            this.ui = (UIAdapter)Class.forName("com.aelitis.azureus.core.pairing.impl.swt.PMSWTImpl").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.must_update_once = COConfigurationManager.getBooleanParameter("pairing.updateoutstanding");
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        final UIManager ui_manager = default_pi.getUIManager();
        BasicPluginConfigModel configModel = ui_manager.createBasicPluginConfigModel("server", "Pairing");
        configModel.addHyperlinkParameter2("ConfigView.label.please.visit.here", MessageText.getString("ConfigView.section.connection.pairing.url"));
        this.param_enable = configModel.addBooleanParameter2("pairing.enable", "pairing.enable", false);
        String access_code = this.readAccessCode();
        this.param_ac_info = configModel.addInfoParameter2("pairing.accesscode", access_code);
        this.param_status_info = configModel.addInfoParameter2("pairing.status.info", "");
        this.param_last_error = configModel.addInfoParameter2("pairing.last.error", "");
        this.param_view = configModel.addHyperlinkParameter2("pairing.view.registered", String.valueOf(SERVICE_URL) + "/web/view?ac=" + access_code);
        if (access_code.length() == 0) {
            this.param_view.setEnabled(false);
        }
        COConfigurationManager.registerExportedParameter("pairing.enable", this.param_enable.getConfigKeyName());
        COConfigurationManager.registerExportedParameter("pairing.access_code", this.param_ac_info.getConfigKeyName());
        final ActionParameter ap = configModel.addActionParameter2("pairing.ac.getnew", "pairing.ac.getnew.create");
        ap.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                try {
                    ap.setEnabled(false);
                    PairingManagerImpl.this.allocateAccessCode(false);
                    SimpleTimer.addEvent("PM:enabler", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            ap.setEnabled(true);
                        }
                    });
                }
                catch (Throwable e) {
                    ap.setEnabled(true);
                    String details = MessageText.getString("pairing.alloc.fail", new String[]{Debug.getNestedExceptionMessage(e)});
                    ui_manager.showMessageBox("pairing.op.fail", "!" + details + "!", 1L);
                }
            }
        });
        LabelParameter param_srp_info = configModel.addLabelParameter2("pairing.srp.info");
        HyperlinkParameter param_srp_link = configModel.addHyperlinkParameter2("label.more.info.here", MessageText.getString("ConfigView.section.connection.pairing.srp.url"));
        this.param_srp_enable = configModel.addBooleanParameter2("pairing.srp.enable", "pairing.srp.enable", false);
        COConfigurationManager.registerExportedParameter("pairing.srp_enable", this.param_srp_enable.getConfigKeyName());
        this.param_srp_state = configModel.addLabelParameter2("");
        this.updateSRPState();
        final ActionParameter param_srp_set = configModel.addActionParameter2("pairing.srp.setpw", "pairing.srp.setpw.doit");
        param_srp_set.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                param_srp_set.setEnabled(false);
                new AEThread2("getpw"){

                    @Override
                    public void run() {
                        try {
                            if (PairingManagerImpl.this.ui != null) {
                                char[] password = PairingManagerImpl.this.ui.getSRPPassword();
                                if (password != null) {
                                    PairingManagerImpl.this.tunnel_handler.setSRPPassword(password);
                                }
                            } else {
                                Debug.out("No UI available");
                            }
                        }
                        finally {
                            param_srp_set.setEnabled(true);
                        }
                    }
                }.start();
            }
        });
        this.param_srp_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                boolean active = PairingManagerImpl.this.param_srp_enable.getValue();
                PairingManagerImpl.this.tunnel_handler.setActive(active);
                PairingManagerImpl.this.updateSRPState();
            }
        });
        this.param_srp_enable.addEnabledOnSelection(this.param_srp_state);
        this.param_srp_enable.addEnabledOnSelection(param_srp_set);
        configModel.createGroup("pairing.group.srp", new Parameter[]{param_srp_info, param_srp_link, this.param_srp_enable, this.param_srp_state, param_srp_set});
        this.param_net_enable = configModel.addBooleanParameter2("pairing.nets.enable", "pairing.nets.enable", false);
        configModel.createGroup("pairing.group.optional", new Parameter[]{this.param_net_enable});
        LabelParameter param_e_info = configModel.addLabelParameter2("pairing.explicit.info");
        this.param_e_enable = configModel.addBooleanParameter2("pairing.explicit.enable", "pairing.explicit.enable", false);
        this.param_public_ipv4 = configModel.addStringParameter2("pairing.ipv4", "pairing.ipv4", "");
        this.param_public_ipv6 = configModel.addStringParameter2("pairing.ipv6", "pairing.ipv6", "");
        this.param_host = configModel.addStringParameter2("pairing.host", "pairing.host", "");
        LabelParameter spacer = configModel.addLabelParameter2("blank.resource");
        this.param_local_ipv4 = configModel.addStringParameter2("pairing.local.ipv4", "pairing.local.ipv4", "");
        this.param_local_ipv6 = configModel.addStringParameter2("pairing.local.ipv6", "pairing.local.ipv6", "");
        this.param_public_ipv4.setGenerateIntermediateEvents(false);
        this.param_public_ipv6.setGenerateIntermediateEvents(false);
        this.param_host.setGenerateIntermediateEvents(false);
        ParameterListener change_listener = new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                PairingManagerImpl.this.updateNeeded();
                if (param == PairingManagerImpl.this.param_enable) {
                    PairingManagerImpl.this.fireChanged();
                }
            }
        };
        this.param_enable.addListener(change_listener);
        this.param_e_enable.addListener(change_listener);
        this.param_public_ipv4.addListener(change_listener);
        this.param_public_ipv6.addListener(change_listener);
        this.param_local_ipv4.addListener(change_listener);
        this.param_local_ipv6.addListener(change_listener);
        this.param_host.addListener(change_listener);
        this.param_net_enable.addListener(change_listener);
        this.param_e_enable.addEnabledOnSelection(this.param_public_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_public_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_local_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_local_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_host);
        configModel.createGroup("pairing.group.explicit", new Parameter[]{param_e_info, this.param_e_enable, this.param_public_ipv4, this.param_public_ipv6, this.param_host, spacer, this.param_local_ipv4, this.param_local_ipv6});
        this.param_icon_enable = configModel.addBooleanParameter2("pairing.config.icon.show", "pairing.config.icon.show", true);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                PairingManagerImpl.this.initialise(core);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(AzureusCore _core) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.azureus_core = _core;
        }
        try {
            this.tunnel_handler = new PairingManagerTunnelHandler(this, this.azureus_core);
            PluginInterface default_pi = PluginInitializer.getDefaultInterface();
            DelayedTask dt = default_pi.getUtilities().createDelayedTask(new Runnable(){

                @Override
                public void run() {
                    new DelayedEvent("PM:delayinit", 10000L, new AERunnable(){

                        @Override
                        public void runSupport() {
                            PairingManagerImpl.this.enableUpdates();
                        }
                    });
                }
            });
            dt.queue();
            if (this.ui != null) {
                try {
                    this.ui.initialise(default_pi, this.param_icon_enable);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.init_sem.releaseForever();
            this.updateSRPState();
        }
    }

    protected void waitForInitialisation() throws PairingException {
        if (!this.init_sem.reserve(30000L)) {
            throw new PairingException("Timeout waiting for initialisation");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.param_enable.getValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.param_enable.setValue(enabled);
    }

    @Override
    public boolean isSRPEnabled() {
        return this.param_srp_enable.getValue();
    }

    @Override
    public void setSRPEnabled(boolean enabled) {
        this.param_srp_enable.setValue(enabled);
    }

    @Override
    public void setGroup(String group) {
        COConfigurationManager.setParameter("pairing.groupcode", group);
        this.updateNeeded();
    }

    @Override
    public String getGroup() {
        return COConfigurationManager.getStringParameter("pairing.groupcode", null);
    }

    @Override
    public List<PairedNode> listGroup() throws PairingException {
        try {
            URL url = new URL(String.valueOf(SERVICE_URL) + "/remote/listGroup?gc=" + this.getGroup());
            InputStream is = new ResourceDownloaderFactoryImpl().create(url).download();
            Map json = JSONUtils.decodeJSON(new String(FileUtil.readInputStreamAsByteArray(is), "UTF-8"));
            List list = (List)json.get("result");
            ArrayList<PairedNode> result = new ArrayList<PairedNode>();
            String my_ac = this.peekAccessCode();
            if (list != null) {
                for (Map m : list) {
                    PairedNodeImpl node = new PairedNodeImpl(m);
                    if (my_ac != null && my_ac.equals(node.getAccessCode())) continue;
                    result.add(node);
                }
            }
            return result;
        }
        catch (Throwable e) {
            throw new PairingException("Failed to list group", e);
        }
    }

    @Override
    public List<PairedService> lookupServices(String access_code) throws PairingException {
        try {
            URL url = new URL(String.valueOf(SERVICE_URL) + "/remote/listBindings?ac=" + access_code + "&jsoncallback=");
            InputStream is = new ResourceDownloaderFactoryImpl().create(url).download();
            String reply = new String(FileUtil.readInputStreamAsByteArray(is), "UTF-8");
            reply = reply.substring(1, reply.length() - 1);
            Map json = JSONUtils.decodeJSON(reply);
            Map error = (Map)json.get("error");
            if (error != null) {
                throw new PairingException((String)error.get("msg"));
            }
            List list = (List)json.get("result");
            ArrayList<PairedService> result = new ArrayList<PairedService>();
            if (list != null) {
                for (Map m : list) {
                    result.add(new PairedService2Impl((String)m.get("sid"), m));
                }
            }
            return result;
        }
        catch (Throwable e) {
            throw new PairingException("Failed to lookup services", e);
        }
    }

    protected void setStatus(String str) {
        String last_status = this.param_status_info.getValue();
        if (!last_status.equals(str)) {
            this.param_status_info.setValue(str);
            this.fireChanged();
        }
    }

    @Override
    public String getStatus() {
        return this.param_status_info.getValue();
    }

    @Override
    public String getSRPStatus() {
        if (!this.isSRPEnabled()) {
            return "Not enabled";
        }
        if (this.tunnel_handler == null) {
            return "Initialising";
        }
        return this.tunnel_handler.getStatus();
    }

    protected void setLastServerError(String error) {
        String last_error = this.param_last_error.getValue();
        if (error == null) {
            error = "";
        }
        if (!last_error.equals(error)) {
            this.param_last_error.setValue(error);
            if (error.contains("generate a new one")) {
                Logger.log(new LogAlert(true, 1, "The pairing access code is invalid.\n\nCreate a new one via Tools->Options->Connection->Pairing or disable the pairing feature."));
            }
            this.fireChanged();
        }
    }

    @Override
    public String getLastServerError() {
        String last_error = this.param_last_error.getValue();
        if (last_error.length() == 0) {
            last_error = null;
        }
        return last_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasActionOutstanding() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            block4: {
                if (this.isEnabled()) break block4;
                return false;
            }
            return !this.updates_enabled || this.update_outstanding || this.deferred_update_event != null || this.update_in_progress;
        }
    }

    protected String readAccessCode() {
        return COConfigurationManager.getStringParameter("pairing.accesscode", "");
    }

    protected void writeAccessCode(String ac) {
        COConfigurationManager.setParameter("pairing.accesscode", ac);
        COConfigurationManager.save();
        this.param_ac_info.setValue(ac);
        this.param_view.setHyperlink(String.valueOf(SERVICE_URL) + "/web/view?ac=" + ac);
        this.param_view.setEnabled(ac.length() > 0);
    }

    private File receiveQR(String ac, Map<String, Object> response) {
        byte[] bytes;
        block4: {
            try {
                bytes = (byte[])response.get("qr_b");
                if (bytes != null) break block4;
                return null;
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
        long ver = (Long)response.get("qr_v");
        File cache_dir = new File(SystemProperties.getUserPath(), "cache");
        File qr_file = new File(cache_dir, "qr_" + ac + "_" + ver + ".png");
        if (FileUtil.writeBytesAsFile2(qr_file.getAbsolutePath(), bytes)) {
            return qr_file;
        }
        return null;
    }

    @Override
    public File getQRCode() {
        File cache_dir;
        File qr_file;
        String existing = this.readAccessCode();
        if (existing == null) {
            return null;
        }
        if (this.qr_version > 0L && (qr_file = new File(cache_dir = new File(SystemProperties.getUserPath(), "cache"), "qr_" + existing + "_" + this.qr_version + ".png")).exists()) {
            return qr_file;
        }
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        request2.put("ac", existing);
        try {
            Map<String, Object> response = this.sendRequest("get_qr", request2);
            return this.receiveQR(existing, response);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    protected String allocateAccessCode(boolean updating) throws PairingException {
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        String existing = this.readAccessCode();
        request2.put("ac", existing);
        request2.put("qr", 1L);
        Map<String, Object> response = this.sendRequest("allocate", request2);
        try {
            String code = this.getString(response, "ac");
            this.receiveQR(code, response);
            this.writeAccessCode(code);
            if (!updating) {
                this.updateNeeded();
            }
            this.fireChanged();
            return code;
        }
        catch (Throwable e) {
            throw new PairingException("allocation failed", e);
        }
    }

    @Override
    public String peekAccessCode() {
        return this.readAccessCode();
    }

    @Override
    public String getAccessCode() throws PairingException {
        this.waitForInitialisation();
        String ac = this.readAccessCode();
        if (ac == null || ac.length() == 0) {
            ac = this.allocateAccessCode(false);
        }
        return ac;
    }

    public void getAccessCode(final PairingManagerListener listener) throws PairingException {
        new AEThread2("PM:gac", true){

            @Override
            public void run() {
                try {
                    try {
                        PairingManagerImpl.this.getAccessCode();
                    }
                    catch (Throwable throwable) {
                        listener.somethingChanged(PairingManagerImpl.this);
                    }
                }
                finally {
                    listener.somethingChanged(PairingManagerImpl.this);
                }
            }
        }.start();
    }

    @Override
    public String getReplacementAccessCode() throws PairingException {
        this.waitForInitialisation();
        String new_code = this.allocateAccessCode(false);
        return new_code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService addService(String sid, PairedServiceRequestHandler handler) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl result = this.services.get(sid);
            if (result == null) {
                result = new PairedServiceImpl(sid, handler);
                this.services.put(sid, result);
            } else {
                result.setHandler(handler);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedServiceImpl getService(String sid) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl result = this.services.get(sid);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(PairedServiceImpl service) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            String sid = service.getSID();
            if (this.services.remove(sid) != null) {
                // empty if block
            }
        }
        this.updateNeeded();
    }

    protected void sync(PairedServiceImpl service) {
        this.updateNeeded();
    }

    protected InetAddress updateAddress(InetAddress current, InetAddress latest, boolean v6) {
        if (v6 ? latest instanceof Inet4Address : latest instanceof Inet6Address) {
            return current;
        }
        if (current == latest) {
            return current;
        }
        if (current == null || latest == null) {
            return latest;
        }
        if (!current.equals(latest)) {
            return latest;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void updateGlobals(boolean is_updating) {
        final long now = SystemTime.getMonotonousTime();
        NetworkAdmin network_admin = NetworkAdmin.getSingleton();
        InetAddress latest_v4 = this.azureus_core.getInstanceManager().getMyInstance().getExternalAddress();
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            Object sem;
            void var16_20;
            HashSet<String> existing_checked;
            InetAddress temp_v4 = this.updateAddress(this.current_v4, latest_v4, false);
            InetAddress latest_v6 = network_admin.getDefaultPublicAddressV6();
            InetAddress temp_v6 = this.updateAddress(this.current_v6, latest_v6, true);
            final TreeSet<String> latest_v4_locals = new TreeSet<String>();
            final TreeSet<String> latest_v6_locals = new TreeSet<String>();
            NetworkAdminNetworkInterface[] interfaces = network_admin.getInterfaces();
            ArrayList<8> to_do = new ArrayList<8>();
            Map<String, Object[]> map = this.local_address_checks;
            synchronized (map) {
                existing_checked = new HashSet<String>(this.local_address_checks.keySet());
            }
            NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = interfaces;
            int n = interfaces.length;
            boolean n2 = false;
            while (var16_20 < n) {
                NetworkAdminNetworkInterfaceAddress[] addresses;
                NetworkAdminNetworkInterface intf = networkAdminNetworkInterfaceArray[var16_20];
                NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = addresses = intf.getAddresses();
                int n3 = addresses.length;
                int n4 = 0;
                while (n4 < n3) {
                    NetworkAdminNetworkInterfaceAddress address = networkAdminNetworkInterfaceAddressArray[n4];
                    final InetAddress ia = address.getAddress();
                    if (!ia.isLoopbackAddress() && (ia.isLinkLocalAddress() || ia.isSiteLocalAddress())) {
                        boolean run_check;
                        Object[] check;
                        final String a_str = ia.getHostAddress();
                        existing_checked.remove(a_str);
                        Map<String, Object[]> map2 = this.local_address_checks;
                        synchronized (map2) {
                            check = this.local_address_checks.get(a_str);
                        }
                        boolean bl = run_check = check == null || now - (Long)check[0] > 1800000L;
                        if (run_check) {
                            to_do.add(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    String result;
                                    block16: {
                                        Socket socket = new Socket();
                                        result = a_str;
                                        try {
                                            try {
                                                socket.bind(new InetSocketAddress(ia, 0));
                                                socket.connect(new InetSocketAddress("www.google.com", 80), 10000);
                                                result = String.valueOf(result) + "*";
                                            }
                                            catch (Throwable throwable) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Throwable throwable2) {}
                                                break block16;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            try {
                                                socket.close();
                                            }
                                            catch (Throwable throwable3) {
                                                // empty catch block
                                            }
                                            throw throwable;
                                        }
                                        try {
                                            socket.close();
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                    Map map = PairingManagerImpl.this.local_address_checks;
                                    synchronized (map) {
                                        PairingManagerImpl.this.local_address_checks.put(a_str, new Object[]{new Long(now), result});
                                        if (ia instanceof Inet4Address) {
                                            latest_v4_locals.add(result);
                                        } else {
                                            latest_v6_locals.add(result);
                                        }
                                    }
                                }
                            });
                        } else if (ia instanceof Inet4Address) {
                            latest_v4_locals.add((String)check[1]);
                        } else {
                            latest_v6_locals.add((String)check[1]);
                        }
                    }
                    ++n4;
                }
                ++var16_20;
            }
            if (to_do.size() > 0) {
                void var16_23;
                sem = new AESemaphore("PM:check");
                for (Runnable runnable : to_do) {
                    new AEThread2("PM:check:", true, (AESemaphore)sem, runnable){
                        private final /* synthetic */ AESemaphore val$sem;
                        private final /* synthetic */ Runnable val$r;
                        {
                            this.val$sem = aESemaphore;
                            this.val$r = runnable;
                            super($anonymous0, $anonymous1);
                        }

                        @Override
                        public void run() {
                            try {
                                this.val$r.run();
                            }
                            finally {
                                this.val$sem.release();
                            }
                        }
                    }.start();
                }
                boolean bl = false;
                while (var16_23 < to_do.size()) {
                    ((AESemaphore)sem).reserve();
                    ++var16_23;
                }
            }
            sem = this.local_address_checks;
            synchronized (sem) {
                for (String string : existing_checked) {
                    this.local_address_checks.remove(string);
                }
            }
            String v4_locals_str = this.getString(latest_v4_locals);
            String string = this.getString(latest_v6_locals);
            if (temp_v4 != this.current_v4 || temp_v6 != this.current_v6 || !v4_locals_str.equals(this.local_v4) || !string.equals(this.local_v6)) {
                this.current_v4 = temp_v4;
                this.current_v6 = temp_v6;
                this.local_v4 = v4_locals_str;
                this.local_v6 = string;
                if (!is_updating) {
                    this.updateNeeded();
                }
            }
        }
    }

    protected String getString(Set<String> set) {
        String str = "";
        for (String s : set) {
            str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + s;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdates() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.updates_enabled = true;
            if (this.update_outstanding) {
                this.update_outstanding = false;
                this.updateNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNeeded() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.updates_enabled) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        PairingManagerImpl.this.doUpdate();
                    }
                });
            } else {
                this.setStatus(MessageText.getString("pairing.status.initialising"));
                this.update_outstanding = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doUpdate() {
        block74: {
            now = SystemTime.getMonotonousTime();
            var3_2 = this;
            synchronized (var3_2) {
                if (this.deferred_update_event != null) {
                    return;
                }
                time_since_last_update = now - this.last_update_time;
                if (this.last_update_time > 0L && time_since_last_update < (long)this.min_update_period) {
                    this.deferUpdate((long)this.min_update_period - time_since_last_update);
                    return;
                }
                this.update_in_progress = true;
            }
            payload = new HashMap<String, Object>();
            is_enabled = this.param_enable.getValue();
            has_services = false;
            var6_9 = this;
            synchronized (var6_9) {
                block76: {
                    list = new ArrayList<Map<String, String>>();
                    payload.put("s", list);
                    if (this.services.size() <= 0 || !is_enabled) break block76;
                    if (this.global_update_event == null) {
                        this.global_update_event = SimpleTimer.addPeriodicEvent("PM:updater", 60000L, new TimerEventPerformer(){
                            private int tick_count;

                            @Override
                            public void perform(TimerEvent event2) {
                                ++this.tick_count;
                                PairingManagerImpl.this.updateGlobals(false);
                                if (this.tick_count % 1380 == 0) {
                                    PairingManagerImpl.this.updateNeeded();
                                }
                            }
                        });
                        this.updateGlobals(true);
                    }
                    enable_nets = this.param_net_enable.getValue();
                    for (PairedServiceImpl service : this.services.values()) {
                        list.add(service.toMap(enable_nets));
                    }
                    has_services = list.size() > 0;
                    ** GOTO lbl58
                }
                if (this.global_update_event != null) ** break block72
                if (this.consec_update_fails != 0 || this.must_update_once) ** GOTO lbl58
                this.update_in_progress = false;
                this.setStatus(MessageText.getString(is_enabled != false ? "pairing.status.noservices" : "pairing.status.disabled"));
                // MONITOREXIT @DISABLED, blocks:[1, 2, 19] lbl46 : MonitorExitStatement: MONITOREXIT : var6_9
                var21_19 = this;
            }
            synchronized (var21_19) {
                if (this.update_in_progress) {
                    Debug.out("Something didn't clear update_in_progress!!!!");
                    this.update_in_progress = false;
                }
            }
            return;
            {
                try {
                    try {
                        this.global_update_event.cancel();
                        this.global_update_event = null;
lbl58:
                        // 3 sources

                        this.last_update_time = now;
                        // MONITOREXIT @DISABLED, blocks:[19, 4, 5, 6] lbl65 : MonitorExitStatement: MONITOREXIT : var6_9
                        {
                            catch (Throwable v2) {
                                throw v2;
                            }
                        }
                        ac = this.readAccessCode();
                        if (ac.length() == 0) {
                            ac = this.allocateAccessCode(true);
                        }
                        payload.put("ac", ac);
                        gc = this.getGroup();
                        if (gc != null && gc.length() > 0) {
                            payload.put("gc", gc);
                        }
                        if (is_enabled && has_services && this.param_srp_enable.getValue()) {
                            this.tunnel_handler.setActive(true);
                            this.tunnel_handler.updateRegistrationData(payload);
                        } else {
                            this.tunnel_handler.setActive(false);
                        }
                        var8_13 = this;
                        synchronized (var8_13) {
                            block73: {
                                if (this.current_v4 != null) {
                                    payload.put("c_v4", this.current_v4.getHostAddress());
                                }
                                if (this.current_v6 != null) {
                                    payload.put("c_v6", this.current_v6.getHostAddress());
                                }
                                if (this.local_v4.length() > 0) {
                                    payload.put("l_v4", this.local_v4);
                                }
                                if (this.local_v6.length() > 0) {
                                    payload.put("l_v6", this.local_v6);
                                }
                                if (this.param_e_enable.getValue()) {
                                    host = this.param_host.getValue().trim();
                                    if (host.length() > 0) {
                                        payload.put("e_h", host);
                                    }
                                    if ((v4 = this.param_public_ipv4.getValue().trim()).length() > 0) {
                                        payload.put("e_v4", v4);
                                    }
                                    if ((v6 = this.param_public_ipv6.getValue().trim()).length() > 0) {
                                        payload.put("e_v6", v6);
                                    }
                                    if ((l_v4 = this.param_local_ipv4.getValue().trim()).length() > 0) {
                                        payload.put("e_l_v4", l_v4);
                                    }
                                    if ((l_v6 = this.param_local_ipv6.getValue().trim()).length() > 0) {
                                        payload.put("e_l_v6", l_v6);
                                    }
                                }
                                try {
                                    pi_upnp = this.azureus_core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                                    if (pi_upnp == null || !(upnp = (UPnPPlugin)pi_upnp.getPlugin()).isEnabled()) break block73;
                                    upnp_list = new ArrayList<HashMap<K, V>>();
                                    payload.put("upnp", upnp_list);
                                    services = upnp.getServices();
                                    devices = new HashSet<UPnPRootDevice>();
                                    var17_26 = services;
                                    var16_27 = services.length;
                                    var15_28 = 0;
                                    while (var15_28 < var16_27) {
                                        service = var17_26[var15_28];
                                        if (upnp_list.size() <= 10) {
                                            root_device = service.getService().getGenericService().getDevice().getRootDevice();
                                            if (!devices.contains(root_device)) {
                                                devices.add(root_device);
                                                map = new HashMap<String, String>();
                                                upnp_list.add(map);
                                                map.put("i", root_device.getInfo());
                                            }
                                            ++var15_28;
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable pi_upnp) {
                                    // empty catch block
                                }
                            }
                            try {
                                admin = NetworkAdmin.getSingleton();
                                http_proxy = admin.getHTTPProxy();
                                if (http_proxy != null) {
                                    payload.put("hp", http_proxy.getName());
                                }
                                if ((socks_proxies = admin.getSocksProxies()).length > 0) {
                                    payload.put("sp", socks_proxies[0].getName());
                                }
                            }
                            catch (Throwable var9_18) {
                                // empty catch block
                            }
                            payload.put("_enabled", is_enabled != false ? 1L : 0L);
                        }
                        this.sendRequest("update", payload);
                        var8_13 = this;
                        synchronized (var8_13) {
                            this.consec_update_fails = 0;
                            this.must_update_once = false;
                            if (this.deferred_update_event == null) {
                                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                            }
                            this.update_in_progress = false;
                            if (this.global_update_event == null) {
                                this.setStatus(MessageText.getString(is_enabled != false ? "pairing.status.noservices" : "pairing.status.disabled"));
                            } else {
                                this.setStatus(MessageText.getString("pairing.status.registered", new String[]{new SimpleDateFormat().format(new Date(SystemTime.getCurrentTime()))}));
                            }
                            break block74;
                        }
                    }
                    catch (Throwable e) {
                        var4_6 = this;
                        synchronized (var4_6) {
                            try {
                                ++this.consec_update_fails;
                                back_off = this.min_update_period;
                                i = 0;
                                while (i < this.consec_update_fails) {
                                    if ((back_off *= 2L) > (long)this.max_update_period) {
                                        back_off = this.max_update_period;
                                        break;
                                    }
                                    ++i;
                                }
                                this.deferUpdate(back_off);
                            }
                            finally {
                                this.update_in_progress = false;
                            }
                        }
                    }
                    var21_20 = this;
                }
                catch (Throwable var20_32) {
                    var21_21 = this;
                    synchronized (var21_21) {
                        if (this.update_in_progress) {
                            Debug.out("Something didn't clear update_in_progress!!!!");
                            this.update_in_progress = false;
                        }
                    }
                    throw var20_32;
                }
                synchronized (var21_20) {
                    if (this.update_in_progress) {
                        Debug.out("Something didn't clear update_in_progress!!!!");
                        this.update_in_progress = false;
                    }
                }
            }
        }
        var21_22 = this;
        synchronized (var21_22) {
            if (this.update_in_progress) {
                Debug.out("Something didn't clear update_in_progress!!!!");
                this.update_in_progress = false;
            }
        }
    }

    protected void deferUpdate(long millis) {
        long target = SystemTime.getOffsetTime(millis += 5000L);
        this.deferred_update_event = SimpleTimer.addEvent("PM:defer", target, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                synchronized (pairingManagerImpl) {
                    PairingManagerImpl.this.deferred_update_event = null;
                }
                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                PairingManagerImpl.this.updateNeeded();
            }
        });
        this.setStatus(MessageText.getString("pairing.status.pending", new String[]{new SimpleDateFormat().format(new Date(target))}));
        COConfigurationManager.setParameter("pairing.updateoutstanding", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> sendRequest(String command, Map<String, Object> payload) throws PairingException {
        try {
            String error;
            HashMap<String, Map<String, Object>> request2 = new HashMap<String, Map<String, Object>>();
            CryptoManager cman = CryptoManagerFactory.getSingleton();
            String azid = Base32.encode(cman.getSecureID());
            payload.put("_azid", azid);
            try {
                String pk = Base32.encode(cman.getECCHandler().getPublicKey("pairing"));
                payload.put("_pk", pk);
            }
            catch (Throwable pk) {
                // empty catch block
            }
            request2.put("req", payload);
            String request_str = Base32.encode(BEncoder.encode(request2));
            String sig = null;
            try {
                sig = Base32.encode(cman.getECCHandler().sign(request_str.getBytes("UTF-8"), "pairing"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String other_params = "&ver=" + UrlUtils.encode("5.7.3.1_CVS") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
            if (sig != null) {
                other_params = String.valueOf(other_params) + "&sig=" + sig;
            }
            URL target = new URL(String.valueOf(SERVICE_URL) + "/client/" + command + "?request=" + request_str + other_params);
            Properties http_properties = new Properties();
            http_properties.put("URL", target);
            try {
                ClientIDManagerImpl.getSingleton().generateHTTPProperties(null, http_properties);
            }
            catch (ClientIDException e) {
                throw new IOException(e.getMessage());
            }
            target = (URL)http_properties.get("URL");
            HttpURLConnection connection = (HttpURLConnection)target.openConnection();
            connection.setConnectTimeout(30000);
            InputStream is = connection.getInputStream();
            Map<String, Object> response = BDecoder.decode(new BufferedInputStream(is));
            PairingManagerImpl pairingManagerImpl = this;
            synchronized (pairingManagerImpl) {
                Long max_retry;
                Long min_retry = (Long)response.get("min_secs");
                if (min_retry != null) {
                    this.min_update_period = min_retry.intValue() * 1000;
                }
                if ((max_retry = (Long)response.get("max_secs")) != null) {
                    this.max_update_period = max_retry.intValue() * 1000;
                }
            }
            final String message = this.getString(response, "message");
            if (!(message == null || this.last_message != null && this.last_message.equals(message))) {
                this.last_message = message;
                try {
                    byte[] message_sig = (byte[])response.get("message_sig");
                    AEVerifier.verifyData(message, message_sig);
                    new AEThread2("PairMsg", true){

                        @Override
                        public void run() {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            if (ui_manager != null) {
                                ui_manager.showMessageBox("pairing.server.warning.title", "!" + message + "!", 1L);
                            }
                        }
                    }.start();
                }
                catch (Throwable message_sig) {
                    // empty catch block
                }
            }
            if ((error = this.getString(response, "error")) != null) {
                throw new PairingException(error);
            }
            this.setLastServerError(null);
            Map reply = (Map)response.get("rep");
            Long qr_v = (Long)reply.get("qr_v");
            if (qr_v != null && this.qr_version != qr_v) {
                this.qr_version = qr_v;
                COConfigurationManager.setParameter("pairing.qr.ver", this.qr_version);
            }
            return reply;
        }
        catch (Throwable e) {
            this.setLastServerError(Debug.getNestedExceptionMessage(e));
            if (e instanceof PairingException) {
                throw (PairingException)e;
            }
            throw new PairingException("invocation failed", e);
        }
    }

    @Override
    public PairingTest testService(String sid, PairingTestListener listener) throws PairingException {
        return new TestServiceImpl(sid, listener);
    }

    protected void updateSRPState() {
        String text = this.param_srp_enable.getValue() ? (this.tunnel_handler == null ? String.valueOf(MessageText.getString("pairing.status.initialising")) + "..." : this.tunnel_handler.getStatus()) : MessageText.getString("MyTorrentsView.menu.setSpeed.disabled");
        this.param_srp_state.setLabelText(MessageText.getString("pairing.srp.state", new String[]{text}));
    }

    @Override
    public void setSRPPassword(char[] password) {
        this.init_sem.reserve();
        this.tunnel_handler.setSRPPassword(password);
    }

    @Override
    public boolean handleLocalTunnel(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        this.init_sem.reserve();
        return this.tunnel_handler.handleLocalTunnel(request2, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordRequest(String name, String ip, boolean good) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.tests_in_progress > 0) {
                return;
            }
        }
        if (this.ui != null) {
            try {
                this.ui.recordRequest(name, ip, good);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void fireChanged() {
        for (PairingManagerListener l : this.listeners) {
            try {
                l.somethingChanged(this);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void addListener(PairingManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(PairingManagerListener l) {
        this.listeners.remove(l);
    }

    protected String getString(Map<String, Object> map, String name) throws IOException {
        byte[] bytes = (byte[])map.get(name);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Pairing Manager");
        try {
            writer.indent();
            if (this.tunnel_handler != null) {
                this.tunnel_handler.generateEvidence(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    private class PairedNodeImpl
    implements PairedNode {
        private Map map;

        protected PairedNodeImpl(Map _map) {
            this.map = _map;
        }

        @Override
        public String getAccessCode() {
            return (String)this.map.get("ac");
        }

        @Override
        public List<InetAddress> getAddresses() {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            this.addAddress(addresses, "c_v4");
            this.addAddress(addresses, "c_v6");
            this.addAddress(addresses, "l_v4");
            this.addAddress(addresses, "l_v6");
            this.addAddress(addresses, "e_v4");
            this.addAddress(addresses, "e_v6");
            this.addAddress(addresses, "e_l_v4");
            this.addAddress(addresses, "e_l_v6");
            this.addAddress(addresses, "e_h");
            return new ArrayList<InetAddress>(addresses);
        }

        private void addAddress(Set<InetAddress> addresses, String key) {
            String str = (String)this.map.get(key);
            if (str != null) {
                String[] bits;
                String[] stringArray = bits = str.split(",");
                int n = bits.length;
                int n2 = 0;
                while (n2 < n) {
                    String bit = stringArray[n2];
                    if ((bit = bit.trim()).length() != 0) {
                        if (bit.endsWith("*")) {
                            bit = bit.substring(0, bit.length() - 1);
                        }
                        try {
                            addresses.add(InetAddress.getByName(bit));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
        }

        @Override
        public List<PairedService> getServices() {
            Map smap = (Map)this.map.get("services");
            ArrayList<PairedService> services = new ArrayList<PairedService>();
            for (Map.Entry entry : smap.entrySet()) {
                services.add(new PairedService2Impl((String)entry.getKey(), (Map)entry.getValue()));
            }
            return services;
        }
    }

    private class PairedService2Impl
    implements PairedService {
        private String sid;
        private Map map;

        protected PairedService2Impl(String _sid, Map _map) {
            this.sid = _sid;
            this.map = _map;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return new PairingConnectionData2(this.map);
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not supported");
        }
    }

    protected class PairedServiceImpl
    implements PairedService,
    PairingConnectionData {
        private String sid;
        private Map<String, String> attributes = new HashMap<String, String>();
        private PairedServiceRequestHandler request_handler;

        protected PairedServiceImpl(String _sid, PairedServiceRequestHandler _request_handler) {
            this.sid = _sid;
            this.request_handler = _request_handler;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        protected void setHandler(PairedServiceRequestHandler _h) {
            this.request_handler = _h;
        }

        protected PairedServiceRequestHandler getHandler() {
            return this.request_handler;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return this;
        }

        @Override
        public void remove() {
            PairingManagerImpl.this.remove(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(String name, String value) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                if (value == null) {
                    this.attributes.remove(name);
                } else {
                    this.attributes.put(name, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAttribute(String name) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                return this.attributes.get(name);
            }
        }

        @Override
        public void sync() {
            PairingManagerImpl.this.sync(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> toMap(boolean enable_nets) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("sid", this.sid);
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                result.putAll(this.attributes);
            }
            if (!enable_nets) {
                result.remove("I2P");
                result.remove("Tor");
            }
            return result;
        }
    }

    private class PairingConnectionData2
    implements PairingConnectionData {
        private Map map;

        protected PairingConnectionData2(Map _map) {
            this.map = _map;
        }

        @Override
        public void setAttribute(String name, String value) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public String getAttribute(String name) {
            return (String)this.map.get(name);
        }

        @Override
        public void sync() {
            throw new RuntimeException("Not supported");
        }
    }

    protected class TestServiceImpl
    implements PairingTest {
        private final String sid;
        private final PairingTestListener listener;
        private volatile int outcome = 0;
        private volatile String error_message;
        private volatile boolean cancelled;

        protected TestServiceImpl(String _sid, PairingTestListener _listener) {
            this.sid = _sid;
            this.listener = _listener;
            new AEThread2("PM:test"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block56: {
                        block55: {
                            String access_code;
                            block54: {
                                access_code = null;
                                long sid_wait_start = -1L;
                                do {
                                    if (!PairingManagerImpl.this.isEnabled()) {
                                        throw new Exception("Pairing is disabled");
                                    }
                                    access_code = PairingManagerImpl.this.peekAccessCode();
                                    if (access_code != null && !PairingManagerImpl.this.hasActionOutstanding()) {
                                        if (PairingManagerImpl.this.getService(TestServiceImpl.this.sid) != null) break block54;
                                        long now = SystemTime.getMonotonousTime();
                                        if (sid_wait_start == -1L) {
                                            sid_wait_start = now;
                                        } else if (now - sid_wait_start > 5000L) break block54;
                                    }
                                    Thread.sleep(500L);
                                } while (!TestServiceImpl.this.cancelled);
                                TestServiceImpl.this.outcome = 6;
                                try {
                                    TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                }
                                catch (Throwable throwable) {
                                    PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                    synchronized (pairingManagerImpl) {
                                        PairingManagerImpl pairingManagerImpl2 = PairingManagerImpl.this;
                                        pairingManagerImpl2.tests_in_progress = pairingManagerImpl2.tests_in_progress - 1;
                                    }
                                    throw throwable;
                                }
                                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                synchronized (pairingManagerImpl) {
                                    PairingManagerImpl pairingManagerImpl3 = PairingManagerImpl.this;
                                    pairingManagerImpl3.tests_in_progress = pairingManagerImpl3.tests_in_progress - 1;
                                }
                                return;
                            }
                            try {
                                try {
                                    PairedServiceImpl service = PairingManagerImpl.this.getService(TestServiceImpl.this.sid);
                                    if (service == null) {
                                        throw new Exception("Service not found");
                                    }
                                    TestServiceImpl.this.listener.testStarted(TestServiceImpl.this);
                                    String other_params = "&ver=" + UrlUtils.encode("5.7.3.1_CVS") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
                                    URL target = new URL(String.valueOf(SERVICE_URL) + "/web/test?sid=" + TestServiceImpl.this.sid + "&ac=" + access_code + "&format=bencode" + other_params);
                                    HttpURLConnection connection = (HttpURLConnection)target.openConnection();
                                    connection.setConnectTimeout(10000);
                                    try {
                                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                        synchronized (pairingManagerImpl) {
                                            PairingManagerImpl pairingManagerImpl4 = PairingManagerImpl.this;
                                            pairingManagerImpl4.tests_in_progress = pairingManagerImpl4.tests_in_progress + 1;
                                        }
                                        InputStream is = connection.getInputStream();
                                        Map response = BDecoder.decode(new BufferedInputStream(is));
                                        response = BDecoder.decodeStrings(response);
                                        Long code = (Long)response.get("code");
                                        if (code == null) {
                                            throw new Exception("Code missing from reply");
                                        }
                                        TestServiceImpl.this.error_message = (String)response.get("msg");
                                        if (code == 1L) {
                                            TestServiceImpl.this.outcome = 1;
                                            break block55;
                                        }
                                        if (code == 2L) {
                                            TestServiceImpl.this.outcome = 4;
                                            break block55;
                                        }
                                        if (code == 3L) {
                                            TestServiceImpl.this.outcome = 5;
                                            break block55;
                                        }
                                        if (code == 4L) {
                                            TestServiceImpl.this.outcome = 2;
                                            TestServiceImpl.this.error_message = "Connect timeout";
                                            break block55;
                                        }
                                        if (code == 5L) {
                                            TestServiceImpl.this.outcome = 2;
                                            break block55;
                                        }
                                        TestServiceImpl.this.outcome = 5;
                                        TestServiceImpl.this.error_message = "Unknown response code " + code;
                                    }
                                    catch (SocketTimeoutException e) {
                                        TestServiceImpl.this.outcome = 3;
                                        TestServiceImpl.this.error_message = "Connect timeout";
                                    }
                                }
                                catch (Throwable e) {
                                    TestServiceImpl.this.outcome = 3;
                                    TestServiceImpl.this.error_message = Debug.getNestedExceptionMessage(e);
                                    try {
                                        TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                    }
                                    catch (Throwable throwable) {
                                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                        synchronized (pairingManagerImpl) {
                                            PairingManagerImpl pairingManagerImpl5 = PairingManagerImpl.this;
                                            pairingManagerImpl5.tests_in_progress = pairingManagerImpl5.tests_in_progress - 1;
                                        }
                                        throw throwable;
                                    }
                                    PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                    synchronized (pairingManagerImpl) {
                                        PairingManagerImpl pairingManagerImpl6 = PairingManagerImpl.this;
                                        pairingManagerImpl6.tests_in_progress = pairingManagerImpl6.tests_in_progress - 1;
                                        break block56;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                }
                                catch (Throwable throwable2) {
                                    PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                    synchronized (pairingManagerImpl) {
                                        PairingManagerImpl pairingManagerImpl7 = PairingManagerImpl.this;
                                        pairingManagerImpl7.tests_in_progress = pairingManagerImpl7.tests_in_progress - 1;
                                    }
                                    throw throwable2;
                                }
                                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                synchronized (pairingManagerImpl) {
                                    PairingManagerImpl pairingManagerImpl8 = PairingManagerImpl.this;
                                    pairingManagerImpl8.tests_in_progress = pairingManagerImpl8.tests_in_progress - 1;
                                }
                                throw throwable;
                            }
                        }
                        try {
                            TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                        }
                        catch (Throwable throwable) {
                            PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                            synchronized (pairingManagerImpl) {
                                PairingManagerImpl pairingManagerImpl9 = PairingManagerImpl.this;
                                pairingManagerImpl9.tests_in_progress = pairingManagerImpl9.tests_in_progress - 1;
                            }
                            throw throwable;
                        }
                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                        synchronized (pairingManagerImpl) {
                            PairingManagerImpl pairingManagerImpl10 = PairingManagerImpl.this;
                            pairingManagerImpl10.tests_in_progress = pairingManagerImpl10.tests_in_progress - 1;
                        }
                    }
                }
            }.start();
        }

        @Override
        public int getOutcome() {
            return this.outcome;
        }

        @Override
        public String getErrorMessage() {
            return this.error_message;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }
    }

    public static interface UIAdapter {
        public void initialise(PluginInterface var1, BooleanParameter var2);

        public void recordRequest(String var1, String var2, boolean var3);

        public char[] getSRPPassword();
    }
}

