/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.utp;

import java.util.Random;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class UTPUtils {
    static long startPerformanceCounter;
    static long startGetTickCount;
    static long counterPerMicrosecond;
    static long last_micros;
    static long last_counter;
    static long last_tick;
    static long frequency;
    static long monoOffset;
    static boolean bork_logged;
    static Random random;

    static {
        last_micros = 0L;
        last_counter = 0L;
        last_tick = 0L;
        frequency = 0L;
        monoOffset = 0L;
        bork_logged = false;
        random = new Random(RandomUtils.SECURE_RANDOM.nextLong());
        startGetTickCount = System.currentTimeMillis();
        startPerformanceCounter = System.nanoTime();
        counterPerMicrosecond = 1000L;
    }

    static int UTP_Random() {
        return random.nextInt();
    }

    static long UTP_GetMilliseconds() {
        return System.currentTimeMillis();
    }

    static long abs64(long x) {
        return x < 0L ? -x : x;
    }

    static long UTP_GetMicroseconds() {
        long tick;
        long tick_diff;
        long counter = SystemTime.getHighPrecisionCounter();
        long ret = (counter - startPerformanceCounter) / counterPerMicrosecond;
        if (UTPUtils.abs64(ret / 100000L - (tick_diff = (tick = System.currentTimeMillis()) - startGetTickCount) / 100L) > 10L) {
            startPerformanceCounter -= (tick_diff * 1000L - ret) * counterPerMicrosecond;
            ret = (counter - startPerformanceCounter) / counterPerMicrosecond;
            monoOffset = 0L;
        }
        last_counter = counter;
        last_tick = tick;
        if ((ret += monoOffset) < last_micros) {
            monoOffset += last_micros - ret;
            ret = last_micros;
        }
        last_micros = ret;
        return ret;
    }

    public static void main(String[] args) {
        while (true) {
            long milli = UTPUtils.UTP_GetMilliseconds();
            long micro = UTPUtils.UTP_GetMicroseconds();
            System.out.println(String.valueOf(milli) + " / " + micro);
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
            }
        }
    }
}

