/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.proxy.AEProxyAddressMapper;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class TCPTransportHelper
implements TransportHelper {
    public static final int READ_TIMEOUT = 10000;
    public static final int CONNECT_TIMEOUT = 20000;
    private static final AEProxyAddressMapper proxy_address_mapper = AEProxyFactory.getAddressMapper();
    public static final int MAX_PARTIAL_WRITE_RETAIN = 64;
    private long remainingBytesToScatter = 0L;
    private static boolean enable_efficient_io = !Constants.JAVA_VERSION.startsWith("1.4");
    private final SocketChannel channel;
    private ByteBuffer delayed_write;
    private Map user_data;
    private boolean trace;
    private volatile InetSocketAddress tcp_address;
    private volatile boolean closed;
    private static final Random rnd = new Random();

    public TCPTransportHelper(SocketChannel _channel) {
        this.channel = _channel;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.tcp_address != null) {
            return this.tcp_address;
        }
        Socket socket = this.channel.socket();
        AEProxyAddressMapper.AppliedPortMapping applied_mapping = proxy_address_mapper.applyPortMapping(socket.getInetAddress(), socket.getPort());
        InetSocketAddress tcp_address = applied_mapping.getAddress();
        return tcp_address;
    }

    @Override
    public String getName(boolean verbose) {
        if (verbose) {
            return "TCP";
        }
        return "";
    }

    @Override
    public boolean minimiseOverheads() {
        return false;
    }

    @Override
    public int getConnectTimeout() {
        return 20000;
    }

    @Override
    public int getReadTimeout() {
        return 10000;
    }

    @Override
    public boolean delayWrite(ByteBuffer buffer) {
        if (this.delayed_write != null) {
            Debug.out("secondary delayed write");
            return false;
        }
        this.delayed_write = buffer;
        return true;
    }

    @Override
    public boolean hasDelayedWrite() {
        return this.delayed_write != null;
    }

    @Override
    public int write(ByteBuffer buffer, boolean partial_write) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0;
        }
        if (partial_write && this.delayed_write == null && buffer.remaining() < 64) {
            ByteBuffer copy = ByteBuffer.allocate(buffer.remaining());
            copy.put(buffer);
            copy.position(0);
            this.delayed_write = copy;
            return copy.remaining();
        }
        long written = 0L;
        if (this.delayed_write != null) {
            ByteBuffer[] buffers = new ByteBuffer[]{this.delayed_write, buffer};
            int delay_remaining = this.delayed_write.remaining();
            this.delayed_write = null;
            written = this.write(buffers, 0, 2);
            if (buffers[0].hasRemaining()) {
                this.delayed_write = buffers[0];
                written = 0L;
            } else {
                written -= (long)delay_remaining;
            }
        } else {
            written = this.channelWrite(buffer);
        }
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: write " + written);
        }
        return (int)written;
    }

    @Override
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0L;
        }
        long written_sofar = 0L;
        if (this.delayed_write != null) {
            ByteBuffer[] buffers2 = new ByteBuffer[length + 1];
            buffers2[0] = this.delayed_write;
            int pos = 1;
            int i = array_offset;
            while (i < array_offset + length) {
                buffers2[pos++] = buffers[i];
                ++i;
            }
            int delay_remaining = this.delayed_write.remaining();
            this.delayed_write = null;
            written_sofar = this.write(buffers2, 0, buffers2.length);
            if (buffers2[0].hasRemaining()) {
                this.delayed_write = buffers2[0];
                written_sofar = 0L;
            } else {
                written_sofar -= (long)delay_remaining;
            }
        } else if (enable_efficient_io && this.remainingBytesToScatter < 1L) {
            try {
                written_sofar = this.channel.write(buffers, array_offset, length);
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                if (msg != null && msg.equals("A non-blocking socket operation could not be completed immediately")) {
                    enable_efficient_io = false;
                    Logger.log(new LogAlert(false, 1, "WARNING: Multi-buffer socket write failed; switching to single-buffer mode.\nUpgrade to JRE 1.5 (5.0) series to fix this problem!"));
                }
                throw ioe;
            }
        } else {
            int i = array_offset;
            while (i < array_offset + length) {
                int data_length = buffers[i].remaining();
                int written = this.channelWrite(buffers[i]);
                written_sofar += (long)written;
                if (written < data_length) break;
                ++i;
            }
        }
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: write " + written_sofar);
        }
        return written_sofar;
    }

    private int channelWrite(ByteBuffer buf) throws IOException {
        int written = 0;
        while (this.remainingBytesToScatter > 0L && buf.remaining() > 0) {
            int currentWritten = this.channel.write((ByteBuffer)buf.slice().limit(Math.min(50 + rnd.nextInt(100), buf.remaining())));
            if (currentWritten == 0) break;
            buf.position(buf.position() + currentWritten);
            this.remainingBytesToScatter -= (long)currentWritten;
            if (this.remainingBytesToScatter <= 0L) {
                this.remainingBytesToScatter = 0L;
                try {
                    this.channel.socket().setTcpNoDelay(false);
                }
                catch (SocketException e) {
                    Debug.printStackTrace(e);
                }
            }
            written += currentWritten;
        }
        if (buf.remaining() > 0) {
            written += this.channel.write(buf);
        }
        return written;
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0;
        }
        int res = this.channel.read(buffer);
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: read " + res);
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0L;
        }
        if (buffers == null) {
            Debug.out("read: buffers == null");
            return 0L;
        }
        long bytes_read = 0L;
        if (enable_efficient_io) {
            try {
                bytes_read = this.channel.read(buffers, array_offset, length);
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                if (msg != null && msg.equals("A non-blocking socket operation could not be completed immediately")) {
                    enable_efficient_io = false;
                    Logger.log(new LogAlert(false, 1, "WARNING: Multi-buffer socket read failed; switching to single-buffer mode.\nUpgrade to JRE 1.5 (5.0) series to fix this problem!"));
                }
                throw ioe;
            }
        } else {
            int i = array_offset;
            while (i < array_offset + length) {
                int data_length = buffers[i].remaining();
                int read = this.channel.read(buffers[i]);
                bytes_read += (long)read;
                if (read < data_length) break;
                ++i;
            }
        }
        if (bytes_read < 0L) {
            throw new IOException("end of stream on socket read");
        }
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: read " + bytes_read);
        }
        return bytes_read;
    }

    @Override
    public void registerForReadSelects(final TransportHelper.selectListener listener, Object attachment) {
        TCPNetworkManager.getSingleton().getReadSelector().register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){

            @Override
            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                return listener.selectSuccess(TCPTransportHelper.this, attachment);
            }

            @Override
            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                listener.selectFailure(TCPTransportHelper.this, attachment, msg);
            }
        }, attachment);
    }

    @Override
    public void registerForWriteSelects(final TransportHelper.selectListener listener, Object attachment) {
        TCPNetworkManager.getSingleton().getWriteSelector().register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){

            @Override
            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                if (TCPTransportHelper.this.trace) {
                    TimeFormatter.milliTrace("tcp: write select");
                }
                return listener.selectSuccess(TCPTransportHelper.this, attachment);
            }

            @Override
            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                listener.selectFailure(TCPTransportHelper.this, attachment, msg);
            }
        }, attachment);
    }

    @Override
    public void cancelReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().cancel(this.channel);
    }

    @Override
    public void cancelWriteSelects() {
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: cancel write selects");
        }
        TCPNetworkManager.getSingleton().getWriteSelector().cancel(this.channel);
    }

    @Override
    public void resumeReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(this.channel);
    }

    @Override
    public void resumeWriteSelects() {
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: resume write selects");
        }
        TCPNetworkManager.getSingleton().getWriteSelector().resumeSelects(this.channel);
    }

    @Override
    public void pauseReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().pauseSelects(this.channel);
    }

    @Override
    public void pauseWriteSelects() {
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: pause write selects");
        }
        TCPNetworkManager.getSingleton().getWriteSelector().pauseSelects(this.channel);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close(String reason) {
        this.closed = true;
        TCPNetworkManager.getSingleton().getReadSelector().cancel(this.channel);
        TCPNetworkManager.getSingleton().getWriteSelector().cancel(this.channel);
        TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(this.channel);
    }

    @Override
    public void failed(Throwable reason) {
        this.close(Debug.getNestedExceptionMessage(reason));
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    @Override
    public synchronized void setUserData(Object key, Object data) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(key, data);
    }

    @Override
    public synchronized Object getUserData(Object key) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(key);
    }

    @Override
    public void setTrace(boolean on) {
        this.trace = on;
    }

    @Override
    public void setScatteringMode(long forBytes) {
        if (forBytes > 0L) {
            if (this.remainingBytesToScatter == 0L) {
                try {
                    this.channel.socket().setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    Debug.printStackTrace(e);
                }
            }
            this.remainingBytesToScatter = forBytes;
        } else {
            if (this.remainingBytesToScatter > 0L) {
                try {
                    this.channel.socket().setTcpNoDelay(false);
                }
                catch (SocketException e) {
                    Debug.printStackTrace(e);
                }
            }
            this.remainingBytesToScatter = 0L;
        }
    }
}

