/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class HTTPMessage
implements Message {
    public static final String MSG_ID = "HTTP_DATA";
    private static final byte[] MSG_ID_BYTES = "HTTP_DATA".getBytes();
    private static final String MSG_DESC = "HTTP data";
    private DirectByteBuffer[] data;

    protected HTTPMessage(String stuff) {
        this.data = new DirectByteBuffer[]{new DirectByteBuffer(ByteBuffer.wrap(stuff.getBytes()))};
    }

    protected HTTPMessage(byte[] stuff) {
        this.data = new DirectByteBuffer[]{new DirectByteBuffer(ByteBuffer.wrap(stuff))};
    }

    @Override
    public String getID() {
        return MSG_ID;
    }

    @Override
    public byte[] getIDBytes() {
        return MSG_ID_BYTES;
    }

    @Override
    public String getFeatureID() {
        return null;
    }

    @Override
    public int getFeatureSubID() {
        return 0;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public byte getVersion() {
        return 1;
    }

    @Override
    public String getDescription() {
        return MSG_DESC;
    }

    @Override
    public DirectByteBuffer[] getData() {
        return this.data;
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        throw new MessageException("not supported");
    }

    protected RawMessage encode(Message message) {
        return new RawMessageImpl(message, this.data, 2, true, new Message[0]);
    }

    @Override
    public void destroy() {
        this.data[0].returnToPool();
    }
}

