/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public abstract class TransportHelperFilterStream
implements TransportHelperFilter {
    private TransportHelper transport;
    private DirectByteBuffer write_buffer_pending_db;
    private ByteBuffer write_buffer_pending_byte;

    protected TransportHelperFilterStream(TransportHelper _transport) {
        this.transport = _transport;
    }

    @Override
    public boolean hasBufferedWrite() {
        return this.write_buffer_pending_db != null || this.write_buffer_pending_byte != null || this.transport.hasDelayedWrite();
    }

    @Override
    public boolean hasBufferedRead() {
        return false;
    }

    @Override
    public TransportHelper getHelper() {
        return this.transport;
    }

    @Override
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.write_buffer_pending_byte != null) {
            if (this.transport.write(this.write_buffer_pending_byte, false) == 0) {
                return 0L;
            }
            this.write_buffer_pending_byte = null;
        }
        long total_written = 0L;
        if (this.write_buffer_pending_db != null) {
            ByteBuffer write_buffer_pending = this.write_buffer_pending_db.getBuffer((byte)5);
            int max_writable = 0;
            int i = array_offset;
            while (i < array_offset + length) {
                ByteBuffer source_buffer = buffers[i];
                int position = source_buffer.position();
                int limit = source_buffer.limit();
                int size = limit - position;
                max_writable += size;
                ++i;
            }
            int pending_position = write_buffer_pending.position();
            int pending_limit = write_buffer_pending.limit();
            int pending_writable = pending_limit - pending_position;
            if (pending_writable > max_writable) {
                pending_writable = max_writable;
                write_buffer_pending.limit(pending_position + pending_writable);
            }
            int written = this.transport.write(write_buffer_pending, false);
            write_buffer_pending.limit(pending_limit);
            if (written > 0) {
                total_written = written;
                if (write_buffer_pending.remaining() == 0) {
                    this.write_buffer_pending_db.returnToPool();
                    this.write_buffer_pending_db = null;
                }
                int skip = written;
                int i2 = array_offset;
                while (i2 < array_offset + length) {
                    ByteBuffer source_buffer = buffers[i2];
                    int position = source_buffer.position();
                    int limit = source_buffer.limit();
                    int size = limit - position;
                    if (size <= skip) {
                        source_buffer.position(limit);
                        skip -= size;
                    } else {
                        source_buffer.position(position + skip);
                        skip = 0;
                        break;
                    }
                    ++i2;
                }
                if (skip != 0) {
                    throw new IOException("skip inconsistent - " + skip);
                }
            }
            if (total_written < (long)pending_writable || total_written == (long)max_writable) {
                return total_written;
            }
        }
        int i = array_offset;
        while (i < array_offset + length) {
            ByteBuffer source_buffer = buffers[i];
            int position = source_buffer.position();
            int limit = source_buffer.limit();
            int size = limit - position;
            if (size != 0) {
                DirectByteBuffer target_buffer_db = DirectByteBufferPool.getBuffer((byte)26, size);
                try {
                    ByteBuffer target_buffer = target_buffer_db.getBuffer((byte)5);
                    this.cryptoOut(source_buffer, target_buffer);
                    target_buffer.position(0);
                    boolean partial_write = false;
                    int j = i + 1;
                    while (j < array_offset + length) {
                        if (buffers[j].hasRemaining()) {
                            partial_write = true;
                        }
                        ++j;
                    }
                    int written = this.transport.write(target_buffer, partial_write);
                    total_written += (long)written;
                    source_buffer.position(position + written);
                    if (written < size) {
                        this.write_buffer_pending_db = target_buffer_db;
                        target_buffer_db = null;
                        if (written != 0) break;
                        this.write_buffer_pending_byte = ByteBuffer.wrap(new byte[]{target_buffer.get()});
                        source_buffer.get();
                        ++total_written;
                        break;
                    }
                }
                finally {
                    if (target_buffer_db != null) {
                        target_buffer_db.returnToPool();
                    }
                }
            }
            ++i;
        }
        return total_written;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        total_read = 0;
        copy_db = new DirectByteBuffer[buffers.length];
        copy = new ByteBuffer[buffers.length];
        try {
            i = array_offset;
            while (i < array_offset + length) {
                buffer = buffers[i];
                size = buffer.remaining();
                if (size > 0) {
                    copy_db[i] = DirectByteBufferPool.getBuffer((byte)26, size);
                    copy[i] = copy_db[i].getBuffer((byte)5);
                } else {
                    copy[i] = ByteBuffer.allocate(0);
                }
                ++i;
            }
            total_read = (int)((long)total_read + this.transport.read(copy, array_offset, length));
            i = array_offset;
            while (i < array_offset + length) {
                source_buffer = copy[i];
                if (source_buffer != null) {
                    target_buffer = buffers[i];
                    source_position = source_buffer.position();
                    if (source_position > 0) {
                        source_buffer.flip();
                        this.cryptoIn(source_buffer, target_buffer);
                    }
                }
                ++i;
            }
            var12_12 = total_read;
            return var12_12;
        }
        finally {
            i = 0;
            ** while (i < copy_db.length)
        }
lbl-1000:
        // 1 sources

        {
            if (copy_db[i] != null) {
                copy_db[i].returnToPool();
            }
            ++i;
            continue;
        }
lbl38:
        // 1 sources

        return var12_12;
    }

    @Override
    public void setTrace(boolean on) {
        this.transport.setTrace(on);
    }

    protected abstract void cryptoOut(ByteBuffer var1, ByteBuffer var2) throws IOException;

    protected abstract void cryptoIn(ByteBuffer var1, ByteBuffer var2) throws IOException;
}

