/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNImpl;
import com.aelitis.azureus.core.util.DNSUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetworkAdminASNLookupImpl {
    private static final String WHOIS_ADDRESS = "whois.cymru.com";
    private static final int WHOIS_PORT = 43;
    private static final int TIMEOUT = 30000;
    private InetAddress address;

    protected NetworkAdminASNLookupImpl(InetAddress _address) {
        this.address = _address;
    }

    protected NetworkAdminASNImpl lookup() throws NetworkAdminException {
        return this.lookupDNS(this.address);
    }

    protected NetworkAdminASNImpl lookupTCP(InetAddress address) throws NetworkAdminException {
        NetworkAdminASNImpl networkAdminASNImpl;
        Socket socket = new Socket();
        int timeout = 30000;
        long start = SystemTime.getCurrentTime();
        socket.connect(new InetSocketAddress(WHOIS_ADDRESS, 43), timeout);
        long end = SystemTime.getCurrentTime();
        timeout = (int)((long)timeout - (end - start));
        if (timeout <= 0) {
            throw new NetworkAdminException("Timeout on connect");
        }
        if (timeout > 30000) {
            timeout = 30000;
        }
        socket.setSoTimeout(timeout);
        try {
            int len;
            OutputStream os = socket.getOutputStream();
            String command = "-u -p " + address.getHostAddress() + "\r\n";
            os.write(command.getBytes());
            os.flush();
            InputStream is = socket.getInputStream();
            byte[] buffer = new byte[1024];
            String result = "";
            while ((len = is.read(buffer)) > 0) {
                result = String.valueOf(result) + new String(buffer, 0, len);
            }
            networkAdminASNImpl = this.processResult(result);
        }
        catch (Throwable throwable) {
            try {
                socket.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new NetworkAdminException("whois connection failed", e);
            }
        }
        socket.close();
        return networkAdminASNImpl;
    }

    protected NetworkAdminASNImpl lookupDNS(InetAddress address) throws NetworkAdminException {
        byte[] bytes = address.getAddress();
        String ip_query = "origin.asn.cymru.com";
        int i = 0;
        while (i < 4) {
            ip_query = String.valueOf(bytes[i] & 0xFF) + "." + ip_query;
            ++i;
        }
        String ip_result = this.lookupDNS(ip_query);
        NetworkAdminASNImpl result = this.processResult("AS | BGP Prefix | CC | Reg | Date | AS Name\n" + ip_result + " | n/a");
        String as = result.getAS();
        if (as.length() > 0) {
            String asn_query = "AS" + as + ".asn.cymru.com";
            try {
                int pos;
                String asn_result = this.lookupDNS(asn_query);
                if (asn_result != null && (pos = asn_result.lastIndexOf(124)) != -1) {
                    String asn = asn_result.substring(pos + 1).trim();
                    result.setASName(asn);
                }
            }
            catch (Throwable e) {
                Debug.outNoStack("ASN lookup for '" + asn_query + "' failed: " + e.getMessage());
            }
        }
        return result;
    }

    protected String lookupDNS(String query) throws NetworkAdminException {
        DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
        if (dns_utils == null) {
            throw new NetworkAdminException("DNS lookup unavailable");
        }
        try {
            return dns_utils.getTXTRecord(query);
        }
        catch (UnknownHostException e) {
            throw new NetworkAdminException("Query failed for '" + query + "'", e);
        }
    }

    protected NetworkAdminASNImpl processResult(String result) {
        StringTokenizer lines = new StringTokenizer(result, "\n");
        int line_number = 0;
        ArrayList<String> keywords = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        block0: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (++line_number > 2) break;
            StringTokenizer tok = new StringTokenizer(line, "|");
            int token_number = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim();
                if (line_number == 1) {
                    keywords.add(token.toLowerCase(MessageText.LOCALE_ENGLISH));
                } else {
                    if (token_number >= keywords.size()) continue block0;
                    String kw = (String)keywords.get(token_number);
                    map.put(kw, token);
                }
                ++token_number;
            }
        }
        String as = (String)map.get("as");
        String asn = (String)map.get("as name");
        String bgp_prefix = (String)map.get("bgp prefix");
        if (bgp_prefix != null) {
            int pos = bgp_prefix.indexOf(32);
            if (pos != -1) {
                bgp_prefix = bgp_prefix.substring(pos + 1).trim();
            }
            if (bgp_prefix.indexOf(47) == -1) {
                bgp_prefix = null;
            }
        }
        return new NetworkAdminASNImpl(as, asn, bgp_prefix);
    }

    public static void main(String[] args) {
        try {
            NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(InetAddress.getByName("64.71.8.82"));
            System.out.println(lookup.lookup().getString());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

