/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.json;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JSONEngine
extends WebEngine {
    private static final String variablePattern = "\\$\\{[^}]+\\}";
    private static final Pattern patternVariable = Pattern.compile("\\$\\{[^}]+\\}");
    private String resultsEntryPath;
    private String rankDivisorPath;
    private float rankDivisor = 1.0f;

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new JSONEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        return new JSONEngine(meta_search, id, last_updated, rank_bias, name, map);
    }

    public JSONEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, String searchURLFormat, String timeZone, boolean automaticDateFormat, String userDateFormat, String resultsEntryPath, FieldMapping[] mappings, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 2, id, last_updated, rank_bias, name, searchURLFormat, timeZone, automaticDateFormat, userDateFormat, mappings, needs_auth, auth_method, login_url, required_cookies);
        this.resultsEntryPath = resultsEntryPath;
        this.setSource(2);
        this.setSelectionState(2);
    }

    protected JSONEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
        this.resultsEntryPath = ImportExportUtils.importString(map, "json.path");
        this.rankDivisorPath = ImportExportUtils.importString(map, "rank.divisor.path");
    }

    protected JSONEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, 2, id, last_updated, rank_bias, name, map);
        this.resultsEntryPath = ImportExportUtils.importString(map, "json_result_key");
        this.resultsEntryPath = UrlUtils.decode(this.resultsEntryPath);
        this.rankDivisorPath = ImportExportUtils.importString(map, "rank_divisor_key");
    }

    public Map exportToBencodedMap() throws IOException {
        return this.exportToBencodedMap(false);
    }

    public Map exportToBencodedMap(boolean generic) throws IOException {
        HashMap res = new HashMap();
        ImportExportUtils.exportString(res, "json.path", this.resultsEntryPath);
        ImportExportUtils.exportString(res, "rank.divisor.path", this.rankDivisorPath);
        super.exportToBencodedMap(res, generic);
        return res;
    }

    @Override
    protected void exportToJSONObject(JSONObject res) throws IOException {
        res.put("json_result_key", this.resultsEntryPath);
        res.put("rank_divisor_key", this.rankDivisorPath);
        super.exportToJSONObject(res);
    }

    @Override
    protected Result[] searchSupport(SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, int absolute_max_matches, String headers, ResultListener listener) throws SearchException {
        this.debugStart();
        WebEngine.pageDetails page_details = super.getWebPageContent(searchParameters, searchContext, headers, false);
        String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        String searchQuery = null;
        int i = 0;
        while (i < searchParameters.length) {
            if (searchParameters[i].getMatchPattern().equals("s")) {
                searchQuery = searchParameters[i].getValue();
            }
            ++i;
        }
        FieldMapping[] mappings = this.getMappings();
        try {
            Object jsonObject;
            try {
                jsonObject = JSONValue.parse(page);
            }
            catch (Throwable e) {
                String temp_page = page.replaceAll("\\\\\",", "\",");
                try {
                    jsonObject = JSONValue.parse(temp_page);
                }
                catch (Throwable f) {
                    throw e;
                }
            }
            if (this.rankDivisorPath != null) {
                String[] split = this.rankDivisorPath.split("\\.");
                try {
                    if (split.length > 0) {
                        Object jsonRankDivisor = jsonObject;
                        int i2 = 0;
                        while (i2 < split.length - 1) {
                            String key = split[i2];
                            if (!(jsonRankDivisor instanceof JSONObject)) break;
                            jsonRankDivisor = ((JSONObject)jsonRankDivisor).get(key);
                            ++i2;
                        }
                        if (jsonRankDivisor instanceof Map) {
                            jsonRankDivisor = ((Map)jsonRankDivisor).get(split[split.length - 1]);
                        }
                        if (jsonRankDivisor instanceof Number) {
                            this.rankDivisor = ((Number)jsonRankDivisor).floatValue();
                        }
                    }
                }
                catch (Exception jsonRankDivisor) {
                    // empty catch block
                }
            }
            JSONArray resultArray = null;
            if (this.resultsEntryPath != null) {
                JSONArray array;
                String[] split = this.resultsEntryPath.split("\\.");
                if (jsonObject instanceof JSONArray && split.length > 0 && !split[0].startsWith("[") && (array = (JSONArray)jsonObject).size() == 1) {
                    jsonObject = array.get(0);
                }
                String[] stringArray = split;
                int n = split.length;
                int key = 0;
                while (key < n) {
                    String pathEntry = stringArray[key];
                    if (jsonObject == null) {
                        throw new SearchException("Invalid entry path : " + this.resultsEntryPath);
                    }
                    try {
                        if (pathEntry.startsWith("[") && pathEntry.endsWith("]")) {
                            int idx = Integer.parseInt(pathEntry.substring(1, pathEntry.length() - 1));
                            jsonObject = ((JSONArray)jsonObject).get(idx);
                        } else {
                            jsonObject = ((JSONObject)jsonObject).get(pathEntry);
                        }
                    }
                    catch (Throwable t) {
                        throw new SearchException("Invalid entry path : " + this.resultsEntryPath, t);
                    }
                    ++key;
                }
            }
            try {
                resultArray = (JSONArray)jsonObject;
            }
            catch (Throwable t) {
                throw new SearchException("Object is not a result array. Check the JSON service and/or the entry path");
            }
            if (resultArray != null) {
                ArrayList<WebResult> results = new ArrayList<WebResult>();
                Throwable decode_failure = null;
                int i3 = 0;
                while (i3 < resultArray.size()) {
                    Object obj = resultArray.get(i3);
                    if (obj instanceof JSONObject) {
                        JSONObject jsonEntry = (JSONObject)obj;
                        if (absolute_max_matches >= 0 && --absolute_max_matches < 0) break;
                        if (listener != null) {
                            Iterator<Map.Entry<String, Object>> it = new TreeMap<String, Object>(jsonEntry).entrySet().iterator();
                            String[] groups = new String[jsonEntry.size()];
                            int pos = 0;
                            while (it.hasNext()) {
                                Map.Entry<String, Object> entry = it.next();
                                String key = entry.getKey();
                                Object value = entry.getValue();
                                groups[pos++] = key != null && value != null ? String.valueOf(key.toString()) + "=" + UrlUtils.encode(value.toString()) : "";
                            }
                            listener.matchFound(this, groups);
                        }
                        WebResult result = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), searchQuery);
                        try {
                            int j = 0;
                            while (j < mappings.length) {
                                String fieldFrom = mappings[j].getName();
                                if (fieldFrom != null) {
                                    int fieldTo = mappings[j].getField();
                                    String fieldContent = null;
                                    Matcher matcher = patternVariable.matcher(fieldFrom);
                                    if (matcher.find()) {
                                        fieldContent = fieldFrom;
                                        do {
                                            String key = matcher.group();
                                            Object replaceValObject = jsonEntry.get(key = key.substring(2, key.length() - 1));
                                            String replaceVal = replaceValObject == null ? "" : replaceValObject.toString();
                                            fieldContent = fieldContent.replaceFirst(variablePattern, replaceVal);
                                        } while (matcher.find());
                                    } else {
                                        Object fieldContentObj = jsonEntry.get(fieldFrom);
                                        String string = fieldContent = fieldContentObj == null ? "" : fieldContentObj.toString();
                                    }
                                    if (fieldContent != null) {
                                        switch (fieldTo) {
                                            case 1: {
                                                result.setNameFromHTML(fieldContent);
                                                break;
                                            }
                                            case 3: {
                                                result.setSizeFromHTML(fieldContent);
                                                break;
                                            }
                                            case 4: {
                                                result.setNbPeersFromHTML(fieldContent);
                                                break;
                                            }
                                            case 5: {
                                                result.setNbSeedsFromHTML(fieldContent);
                                                break;
                                            }
                                            case 6: {
                                                result.setCategoryFromHTML(fieldContent);
                                                break;
                                            }
                                            case 2: {
                                                result.setPublishedDateFromHTML(fieldContent);
                                                break;
                                            }
                                            case 7: {
                                                result.setCommentsFromHTML(fieldContent);
                                                break;
                                            }
                                            case 103: {
                                                result.setCDPLink(fieldContent);
                                                break;
                                            }
                                            case 102: {
                                                result.setTorrentLink(fieldContent);
                                                break;
                                            }
                                            case 104: {
                                                result.setPlayLink(fieldContent);
                                                break;
                                            }
                                            case 105: {
                                                result.setDownloadButtonLink(fieldContent);
                                                break;
                                            }
                                            case 10: {
                                                result.setVotesFromHTML(fieldContent);
                                                break;
                                            }
                                            case 11: {
                                                result.setNbSuperSeedsFromHTML(fieldContent);
                                                break;
                                            }
                                            case 12: {
                                                result.setPrivateFromHTML(fieldContent);
                                                break;
                                            }
                                            case 13: {
                                                result.setDrmKey(fieldContent);
                                                break;
                                            }
                                            case 14: {
                                                result.setVotesDownFromHTML(fieldContent);
                                                break;
                                            }
                                            case 200: {
                                                result.setHash(fieldContent);
                                                break;
                                            }
                                            case 201: {
                                                result.setRankFromHTML(fieldContent, this.rankDivisor);
                                                break;
                                            }
                                        }
                                    }
                                }
                                ++j;
                            }
                            results.add(result);
                        }
                        catch (Throwable e) {
                            decode_failure = e;
                        }
                    }
                    ++i3;
                }
                if (results.size() == 0 && decode_failure != null) {
                    throw decode_failure;
                }
                Result[] res = results.toArray(new Result[results.size()]);
                this.debugLog("success: found " + res.length + " results");
                return res;
            }
            this.debugLog("success: no result array found so no results");
            return new Result[0];
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            String content_str = page;
            if (content_str.length() > 256) {
                content_str = String.valueOf(content_str.substring(0, 256)) + "...";
            }
            throw new SearchException("JSON matching failed for " + this.getName() + ", content=" + content_str, e);
        }
    }
}

