/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.impl.FieldRemapping;
import java.util.regex.Matcher;

public class FieldRemapper {
    private int inField;
    private int outField;
    private FieldRemapping[] fieldRemappings;

    public FieldRemapper(int inField, int outField, FieldRemapping[] fieldRemappings) {
        this.inField = inField;
        this.outField = outField;
        this.fieldRemappings = fieldRemappings;
    }

    public int getInField() {
        return this.inField;
    }

    public int getOutField() {
        return this.outField;
    }

    public FieldRemapping[] getMappings() {
        return this.fieldRemappings;
    }

    public void remap(Result r) {
        String input = null;
        switch (this.inField) {
            case 6: {
                input = r.getCategory();
            }
        }
        String output = null;
        if (input != null) {
            int i = 0;
            while (i < this.fieldRemappings.length) {
                Matcher matcher;
                if (this.fieldRemappings[i].getMatch() != null && this.fieldRemappings[i].getReplacement() != null && (matcher = this.fieldRemappings[i].getMatch().matcher(input)).matches()) {
                    output = matcher.replaceAll(this.fieldRemappings[i].getReplacement());
                    i = this.fieldRemappings.length;
                }
                ++i;
            }
        }
        if (output != null) {
            switch (this.outField) {
                case 6: {
                    r.setCategory(output);
                    break;
                }
                case 8: {
                    r.setContentType(output);
                }
            }
        }
    }
}

