/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DHTUDPPacketRequestQueryStorage
extends DHTUDPPacketRequest {
    protected static final int SPACE = 1354;
    private int header_length;
    private List<Object[]> keys;

    public DHTUDPPacketRequestQueryStorage(DHTTransportUDPImpl _transport, long _connection_id, DHTTransportUDPContactImpl _local_contact, DHTTransportUDPContactImpl _remote_contact) {
        super(_transport, 1038, _connection_id, _local_contact, _remote_contact);
    }

    protected DHTUDPPacketRequestQueryStorage(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, long con_id, int trans_id) throws IOException {
        super(network_handler, is, 1038, con_id, trans_id);
        this.header_length = is.readByte() & 0xFF;
        int num_keys = is.readShort();
        this.keys = new ArrayList<Object[]>(num_keys);
        int i = 0;
        while (i < num_keys) {
            int prefix_length = is.readByte() & 0xFF;
            byte[] prefix = new byte[prefix_length];
            is.read(prefix);
            int num_suffixes = is.readShort();
            ArrayList<byte[]> suffixes = new ArrayList<byte[]>(num_suffixes);
            this.keys.add(new Object[]{prefix, suffixes});
            int suffix_length = this.header_length - prefix_length;
            int j = 0;
            while (j < num_suffixes) {
                byte[] suffix = new byte[suffix_length];
                is.read(suffix);
                suffixes.add(suffix);
                ++j;
            }
            ++i;
        }
        super.postDeserialise(is);
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeByte(this.header_length & 0xFF);
        os.writeShort(this.keys.size());
        for (Object[] entry : this.keys) {
            byte[] prefix = (byte[])entry[0];
            os.writeByte(prefix.length);
            os.write(prefix);
            List suffixes = (List)entry[1];
            os.writeShort(suffixes.size());
            for (byte[] suffix : suffixes) {
                os.write(suffix);
            }
        }
        super.postSerialise(os);
    }

    protected void setDetails(int _header_length, List<Object[]> _keys) {
        this.header_length = _header_length;
        this.keys = _keys;
    }

    protected int getHeaderLength() {
        return this.header_length;
    }

    protected List<Object[]> getKeys() {
        return this.keys;
    }

    @Override
    public String getString() {
        return super.getString();
    }
}

