/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.VivaldiPositionProvider;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunStateHandler;
import org.gudy.azureus2.core3.util.AESemaphore;

public class DHTTransportUDPContactImpl
implements DHTTransportUDPContact {
    public static final int NODE_STATUS_UNKNOWN = -1;
    public static final int NODE_STATUS_ROUTABLE = 1;
    private DHTTransportUDPImpl transport;
    private InetSocketAddress external_address;
    private InetSocketAddress transport_address;
    private byte[] id;
    private byte protocol_version;
    private int instance_id;
    private long skew;
    private byte generic_flags;
    private int random_id;
    private int node_status = -1;
    private DHTNetworkPosition[] network_positions;

    static {
        AERunStateHandler.addListener(new AERunStateHandler.RunStateChangeListener(){
            private VivaldiPositionProvider provider = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runStateChanged(long run_state) {
                1 var3_2 = this;
                synchronized (var3_2) {
                    if (AERunStateHandler.isDHTSleeping()) {
                        if (this.provider != null) {
                            DHTNetworkPositionManager.unregisterProvider(this.provider);
                            this.provider = null;
                        }
                    } else if (this.provider == null) {
                        this.provider = new VivaldiPositionProvider();
                        DHTNetworkPositionManager.registerProvider(this.provider);
                    }
                }
            }
        }, true);
    }

    protected DHTTransportUDPContactImpl(boolean _is_local, DHTTransportUDPImpl _transport, InetSocketAddress _transport_address, InetSocketAddress _external_address, byte _protocol_version, int _instance_id, long _skew, byte _generic_flags) throws DHTTransportException {
        this.transport = _transport;
        this.transport_address = _transport_address;
        this.external_address = _external_address;
        this.protocol_version = _protocol_version;
        if (this.transport_address.equals(this.external_address)) {
            this.external_address = this.transport_address;
        }
        this.instance_id = _instance_id;
        this.skew = _skew;
        this.generic_flags = _generic_flags;
        if (this.transport_address == this.external_address || this.transport_address.getAddress().equals(this.external_address.getAddress())) {
            this.id = DHTUDPUtils.getNodeID(this.external_address, this.protocol_version);
        }
        this.createNetworkPositions(_is_local);
    }

    @Override
    public DHTTransport getTransport() {
        return this.transport;
    }

    @Override
    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    protected void setProtocolVersion(byte v) {
        this.protocol_version = v;
    }

    @Override
    public long getClockSkew() {
        return this.skew;
    }

    @Override
    public int getRandomIDType() {
        return 1;
    }

    @Override
    public void setRandomID(int _random_id) {
        this.random_id = _random_id;
    }

    @Override
    public int getRandomID() {
        return this.random_id;
    }

    @Override
    public void setRandomID2(byte[] id) {
    }

    @Override
    public byte[] getRandomID2() {
        return null;
    }

    protected int getNodeStatus() {
        return this.node_status;
    }

    protected void setNodeStatus(int ns) {
        this.node_status = ns;
    }

    @Override
    public boolean isValid() {
        return this.addressMatchesID() && !this.transport.invalidExternalAddress(this.external_address.getAddress());
    }

    @Override
    public boolean isSleeping() {
        return (this.generic_flags & 1) != 0;
    }

    protected void setGenericFlags(byte flags) {
        this.generic_flags = flags;
    }

    protected boolean addressMatchesID() {
        return this.id != null;
    }

    @Override
    public InetSocketAddress getTransportAddress() {
        return this.transport_address;
    }

    @Override
    public void setTransportAddress(InetSocketAddress address) {
        this.transport_address = address;
    }

    @Override
    public InetSocketAddress getExternalAddress() {
        return this.external_address;
    }

    @Override
    public String getName() {
        return DHTLog.getString2(this.id);
    }

    @Override
    public byte[] getBloomKey() {
        return this.getAddress().getAddress().getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getExternalAddress();
    }

    @Override
    public int getMaxFailForLiveCount() {
        return this.transport.getMaxFailForLiveCount();
    }

    @Override
    public int getMaxFailForUnknownCount() {
        return this.transport.getMaxFailForUnknownCount();
    }

    @Override
    public int getInstanceID() {
        return this.instance_id;
    }

    protected void setInstanceIDAndVersion(int _instance_id, byte _protocol_version) {
        this.instance_id = _instance_id;
        if (_protocol_version > this.protocol_version) {
            this.protocol_version = _protocol_version;
        }
    }

    @Override
    public boolean isAlive(long timeout) {
        final AESemaphore sem = new AESemaphore("DHTTransportContact:alive");
        final boolean[] alive = new boolean[1];
        try {
            this.sendPing(new DHTTransportReplyHandlerAdapter(){

                @Override
                public void pingReply(DHTTransportContact contact) {
                    alive[0] = true;
                    sem.release();
                }

                @Override
                public void failed(DHTTransportContact contact, Throwable cause) {
                    sem.release();
                }
            });
            sem.reserve(timeout);
            return alive[0];
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void isAlive(DHTTransportReplyHandler handler, long timeout) {
        this.transport.sendPing(this, handler, timeout, 99);
    }

    @Override
    public void sendPing(DHTTransportReplyHandler handler) {
        this.transport.sendPing(this, handler);
    }

    @Override
    public void sendImmediatePing(DHTTransportReplyHandler handler, long timeout) {
        this.transport.sendImmediatePing(this, handler, timeout);
    }

    @Override
    public void sendStats(DHTTransportReplyHandler handler) {
        this.transport.sendStats(this, handler);
    }

    @Override
    public void sendStore(DHTTransportReplyHandler handler, byte[][] keys, DHTTransportValue[][] value_sets, boolean immediate) {
        this.transport.sendStore(this, handler, keys, value_sets, immediate ? 99 : 2);
    }

    @Override
    public void sendQueryStore(DHTTransportReplyHandler handler, int header_length, List<Object[]> key_details) {
        this.transport.sendQueryStore(this, handler, header_length, key_details);
    }

    @Override
    public void sendFindNode(DHTTransportReplyHandler handler, byte[] nid, short flags) {
        this.transport.sendFindNode(this, handler, nid);
    }

    @Override
    public void sendFindValue(DHTTransportReplyHandler handler, byte[] key, int max_values, short flags) {
        this.transport.sendFindValue(this, handler, key, max_values, flags);
    }

    @Override
    public void sendKeyBlock(final DHTTransportReplyHandler handler, final byte[] request2, final byte[] signature) {
        this.sendFindNode(new DHTTransportReplyHandlerAdapter(){

            @Override
            public void findNodeReply(DHTTransportContact contact, DHTTransportContact[] contacts) {
                DHTTransportUDPContactImpl.this.transport.sendKeyBlockRequest(DHTTransportUDPContactImpl.this, handler, request2, signature);
            }

            @Override
            public void failed(DHTTransportContact _contact, Throwable _error) {
                handler.failed(_contact, _error);
            }
        }, new byte[0], (short)0);
    }

    @Override
    public DHTTransportFullStats getStats() {
        return this.transport.getFullStats(this);
    }

    @Override
    public byte[] getID() {
        if (this.id == null) {
            throw new RuntimeException("Invalid contact");
        }
        return this.id;
    }

    @Override
    public void exportContact(DataOutputStream os) throws IOException, DHTTransportException {
        this.transport.exportContact(this, os);
    }

    @Override
    public Map<String, Object> exportContactToMap() {
        return this.transport.exportContactToMap(this);
    }

    @Override
    public void remove() {
        this.transport.removeContact(this);
    }

    protected void setNetworkPositions(DHTNetworkPosition[] positions) {
        this.network_positions = positions;
    }

    @Override
    public void createNetworkPositions(boolean is_local) {
        this.network_positions = DHTNetworkPositionManager.createPositions(this.id == null ? DHTUDPUtils.getBogusNodeID() : this.id, is_local);
    }

    @Override
    public DHTNetworkPosition[] getNetworkPositions() {
        return this.network_positions;
    }

    @Override
    public DHTNetworkPosition getNetworkPosition(byte position_type) {
        int i = 0;
        while (i < this.network_positions.length) {
            if (this.network_positions[i].getPositionType() == position_type) {
                return this.network_positions[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getString() {
        if (this.transport_address.equals(this.external_address)) {
            return String.valueOf(DHTLog.getString2(this.id)) + "[" + this.transport_address.toString() + ",V" + this.getProtocolVersion() + "]";
        }
        return String.valueOf(DHTLog.getString2(this.id)) + "[tran=" + this.transport_address.toString() + ",ext=" + this.external_address + ",V" + this.getProtocolVersion() + "]";
    }
}

